//LIC// FLXLab v2.4 - A program for running psychology experiments.  
//LIC// Copyright (C) 2009 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <flxbase.h>

/*****************************************************************************/

class IncrementEvent : public FlxEvent {
  long *d_counter;
public:
  IncrementEvent(string name,long *counter) : FlxEvent(name), d_counter(counter) {}
  ~IncrementEvent(void) {}
  void execute(void); 
};

void IncrementEvent::execute(void){
  string cur_function="IncrementEvent::execute";

  flx_data->write_message(FLX_DATAEVENT,cur_function,d_name);
  this->do_generic_event_processing();
  (*d_counter)++;
}

/*****************************************************************************/

bool NewIncrementEvent(string *name,long *counter){
  string cur_function="NewIncrementEvent";
  IncrementEvent *iep;

 flx_data->write_message(FLX_DATASCRIPT,cur_function,"Creating new IncrementEvent '"+*name+"'");
  iep=new IncrementEvent(*name,counter);
  flx_add_scalar_source(iep,counter);
  return true;

} /* NewIncrementEvent */

/*****************************************************************************/

void flx_sample_events_init(void){
  string cur_function="flx_sample_events_init";
  
  flx_add_command("IncrementEvent",NewIncrementEvent);

} /* flx_sample_events_init */

/*****************************************************************************/
