//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXSOUND_FLX_SOUND_BUFFER
#define FLXSOUND_FLX_SOUND_BUFFER

using namespace std;

class FlxSoundBuffer {
 public:
  int d_bits;
  int d_channels;
  long d_rate;
  long d_data_bytes;
  char *d_data;
  int d_bytes_per_frame;
  long d_cur_pos;
  int d_stream_type;
 public:
 FlxSoundBuffer(void) : d_data(NULL), d_cur_pos(0) {}
  ~FlxSoundBuffer(void){ if(d_data) delete d_data; }
  void update_bytes_per_frame(void){ d_bytes_per_frame=((d_bits-1)/8+1)*d_channels; }
  void set_bits(int bits){ d_bits=bits; this->update_bytes_per_frame(); }
  int bits(void){ return d_bits; }
  void set_channels(int channels){ d_channels=channels; this->update_bytes_per_frame(); }
  int channels(void){ return d_channels; }
  void set_rate(long rate){ d_rate=rate; }
  long rate(void){ return d_rate; }
  void set_data_bytes(long data_bytes){ d_data_bytes=data_bytes; }
  long data_bytes(void){ return d_data_bytes; }
  char *data(void){ return d_data; }
  void allocate_data(void){ if(d_data) delete d_data; d_data=new char[d_data_bytes]; }
  int bytes_per_frame(void){ return d_bytes_per_frame; }
  void increment_cur_pos(long increment){ d_cur_pos+=increment; }
  long cur_pos(void){ return d_cur_pos; }
  void reset_cur_pos(void){ d_cur_pos=0; }
  void set_stream_type(int stream_type){ d_stream_type=stream_type; }
  int stream_type(void){ return d_stream_type; }
  void set_params(int bits,int channels,long rate,long data_bytes,int stream_type){
    d_bits=bits;
    d_channels=channels;
    d_rate=rate;
    d_data_bytes=data_bytes;
    d_stream_type=stream_type;
    this->reset_cur_pos();
    this->update_bytes_per_frame();
  }
};

#endif
