//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#define FLX_INCLUDE_MODULE_HEADER
#include <flxbase.h>
#include "flxsound/sound_driver.h"

using namespace std;

extern void flx_sound_driver_init(void);
extern void flx_play_sound_init(void);
extern void flx_record_sound_init(void);
extern void flx_voice_key_init(void);

/*****************************************************************************/

void sound_init_callback(void){
  
  flx_sound_driver->initialize();
	
} /* sound_init_callback */

/*****************************************************************************/

void sound_exit_callback(void){

  flx_sound_driver->terminate();

} /* sound_exit_callback */

/*****************************************************************************/

extern "C" {

  FLX_START_MODULE_INIT(sound)
		
  string cur_function="sound_module_init";

  flx_data->write_message(FLX_DATAINFO,cur_function,"Initializing sound module");
  flx_sound_driver_init();
  flx_play_sound_init();
  flx_record_sound_init();
  flx_voice_key_init();

  flx_set_module_post_load_callback(sound_init_callback);
  flx_add_scope_exit_hook("sound_exit_callback",sound_exit_callback);

  FLX_END_MODULE_INIT

}

/*****************************************************************************/


