//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <allegro.h>
#include <flxbase.h>
#include <flxgraphics.h>
#include <flxgui.h>
#include "flxstartscreen\dialog.h"

string *editor_path;

/*****************************************************************************/

void startscreen_new(void){
  string cur_function="startscreen_new";
  string new_filename;

  //*** set a default directory
  if(flx_script_file==flx_default_script_file){
    new_filename=flx_current_working_directory();
  } else {
    new_filename=flx_expand_filename(flx_script_file);
  }

  //*** display the dialog box
  if(!flx_do_new_file_dialog("Enter a name for the new script file:",new_filename)){
    // user chose Cancel in dialog box
    return;
  }

  //*** prompt to overwrite if appropriate
  if(flx_expand_filename(new_filename)!=""){ // file already exists
    if(flx_do_alert_dialog("The file '"+flx_extract_filename(new_filename)+"' already exists. Do you want to overwrite it?","Yes","No")==2){
      // user chooses to not overwrite existing file
      return;
    }
  } 

  //*** create the new file
  if(!flx_create_file(new_filename)){
    flx_do_alert_dialog("Can't create file '"+flx_extract_filename(new_filename)+"'");
  } else {
    flx_script_file=new_filename;
    flx_data->write_message(FLX_DATAINFO,cur_function,"Created new script file '"+flx_script_file+"'");
  }

} /* startscreen_new */

/*****************************************************************************/

void startscreen_select(void){
  string cur_function="startscreen_select";
  string expanded_filename;

  if(flx_script_file==flx_default_script_file){
    expanded_filename=flx_current_working_directory();
  } else {
    expanded_filename=flx_expand_filename(flx_script_file);
  }
  flx_do_file_selector_dialog("Select a script file:",expanded_filename);
  if(flx_extract_filename(expanded_filename)==""){
    flx_script_file=flx_default_script_file;
  } else {
    flx_script_file=expanded_filename;
  }
  flx_data->write_message(FLX_DATAINFO,cur_function,"Selected script file '"+flx_script_file+"'");

} /* startscreen_select */

/*****************************************************************************/

void startscreen_edit(void){
  string cur_function="startscreen_edit";

  //*** check that a script file has been selected
  if(flx_script_file==flx_default_script_file){
    flx_do_alert_dialog("Please select a script file first.");
  } else {
    //*** do the actual editing
    flx_data->write_message(FLX_DATAINFO,cur_function,"Editing script file '"+flx_script_file+"'");
    flx_screen->minimize();
    flx_run_command(*editor_path,flx_script_file);
    flx_screen->display();
  }

} /* startscreen_edit */

/*****************************************************************************/

void startscreen_run(void){
  string cur_function="startscreen_run";

  if(flx_script_file==flx_default_script_file){
    flx_do_alert_dialog("Please select a script file first.");
  } else {
    flx_data->write_message(FLX_DATAINFO,cur_function,"Executing script file '"+flx_script_file+"'");

    /* The script will have its own scope associated with it, which is
       both created and ended by the flx_read_script
       function. However, once that function returns, we don't have a
       way to access the name of that scope, and therefore can't
       explicitly delete it. The workaround is to nest the script
       scope inside another scope. By deleting the outer scope, we
       ensure that the script scope gets deleted, too. */
    flx_begin_scope("startscreen_script");
    flx_read_script();
    flx_delete_scope("startscreen_script");

    /* if a script generated an error, reset the error flag */
    if(abort_flxlab){
      abort_flxlab=false;
    }
  }

} /* startscreen_run */

/*****************************************************************************/

void startscreen_quit(void){
  string cur_function="startscreen_quit";

  flx_data->write_message(FLX_DATAINFO,cur_function,"Quitting FLXLab");
  redisplay=false;

} /* startscreen_quit */

/*****************************************************************************/

bool UseEditor(string *path){

  editor_path=path;
  return true;

} /* UseEditor */

/*****************************************************************************/

void flx_startscreen_actions_init(void){
  string cur_function="startscreen_actions_init";

  //flx_add_command("UseEditor",UseEditor);

  /* buttons will appear in the reverse order of what is seen here */
  flx_add_startscreen_button("Quit",startscreen_quit);
  flx_add_startscreen_button("Run",startscreen_run);
  //  flx_add_startscreen_button("Edit",startscreen_edit);
  flx_add_startscreen_button("Select",startscreen_select);
  //flx_add_startscreen_button("New",startscreen_new);

} /* flx_startscreen_actions_init */

/*****************************************************************************/
