//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include <allegro.h>
#include <flxbase.h>
#include <flxgraphics.h>
#include <flxgui.h>
#include "flxstartscreen\dialog.h"
#include <linkflx.h>

bool redisplay;

FlxDuplexList<string,FlxStartScreenAction> button_list;

/*****************************************************************************/

FLX_LINKAGE void flx_add_startscreen_button(const string &button_text,FlxStartScreenAction button_action){

  button_list.insert_at_beginning(button_text,button_action);

} /* flx_add_startscreen_button */

/*****************************************************************************/

class FlxStartScreen {
  string d_message_text;
  string d_image_file;
  string d_choice;
  FlxDialogEvent *d_dialog;
public:
  FlxStartScreen(void){}
  ~FlxStartScreen(void){}
  void build(void);
  void display(void);
};

/*****************************************************************************/

void FlxStartScreen::build(void){
  FlxDialogBitmap *dbp;
  FlxDialogText *dtp;	
  FlxDialogButtonGroup *dbgp;
  string *button_text;
  
  d_image_file=flxlab_dir+"resources"+flx_path_separator+"startscreen.jpg";
  
  dbp=new FlxDialogBitmap("startscreen_image");
  dbp->set_bitmap_file(flx_string(d_image_file));
  dbp->set_alignment(flx_dialog_alignment_center);
  dbp->update(); // need to do this in order to load bitmap image from file
  dtp=new FlxDialogText("startscreen_text");
  flx_create_scalar_object("startscreen_message",&d_message_text);
  dtp->set_text(&d_message_text);
  dtp->set_alignment(flx_dialog_alignment_center);
  dbgp=new FlxDialogButtonGroup("startscreen_buttons");
  flx_create_scalar_object("startscreen_choice",&d_choice);
  dbgp->set_var_text(&d_choice);
  dbgp->set_type(FLX_DIALOG_BUTTON);
  dbgp->set_group_id(0);
  dbgp->set_alignment(flx_dialog_alignment_center);
  while(button_text=button_list.item()){
    dbgp->add_button(flx_string(*button_text));
    button_list.advance();
  }
  button_list.rewind();
  d_dialog=new FlxDialogEvent("startscreen_dialog");
  d_dialog->add_object(dbp);
  d_dialog->add_object(dtp);
  d_dialog->add_object(dbgp);

} /* FlxStartScreen::build */

/*****************************************************************************/

void FlxStartScreen::display(void){
  string cur_function="FlxStartScreen::display";
  string *button_text;
  FlxStartScreenAction *button_action;

  redisplay=true;
  while(redisplay){
    d_message_text=string("Current script file is \"")+flx_extract_filename(flx_script_file)+"\"";
    d_dialog->update();
    d_dialog->execute();
    
    while(button_text=button_list.item()){
      if(d_choice==*button_text){
	button_action=button_list.item2();
	(*button_action)();
	break;
      }
      button_list.advance();
    }
    button_list.rewind();
  }	
  
} /* FlxStartScreen::display */

/*****************************************************************************/

bool do_startscreen(void){
  FlxStartScreen start_screen;

  flx_begin_scope("flx_startscreen_dialog");

  start_screen.build();
  start_screen.display();

  /* Deleting the scope will automatically free the memory for
     the various dialog objects we created */
  flx_delete_scope("flx_startscreen_dialog");

  return true;

} /* do_startscreen */

/*****************************************************************************/

void startscreen_exit_hook(void){

  clear_to_color(screen,makecol(0,0,0));
  flx_revert_program_hook();

} /* startscreen_exit_hook */

/*****************************************************************************/

void flx_startscreen_dialog_init(void){
  string cur_function="startscreen_dialog_init";

  flx_set_program_hook(do_startscreen);
  flx_add_scope_exit_hook("startscreen_exit_hook",startscreen_exit_hook);

} /* flx_startscreen_dialog_init */

/*****************************************************************************/
