//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#ifndef FLXTEXT_TEXT_OBJECTS
#define FLXTEXT_TEXT_OBJECTS

#include <flxgraphics.h>
#include "flxtext\fonts.h"

#define FLX_TEXT_JUSTIFICATION_LEFT 0
#define FLX_TEXT_JUSTIFICATION_CENTER 1
#define FLX_TEXT_JUSTIFICATION_RIGHT 2

extern string *flx_default_text_font;
extern long *flx_default_text_size;
extern long *flx_default_text_justification;
extern FlxColor *flx_default_text_color;
extern FlxColor *flx_default_text_background_color;
extern bool *flx_default_antialiasing;

class FlxTextObject : public FlxColoredObject {
 protected:
  string *d_text;
  string *d_font;
  long *d_size;
  bool *d_antialiasing;
  FlxColor *d_background_color;
  long d_text_width;
  long d_text_height;
 public:
 FlxTextObject(const string &name,string *text) : FlxGraphicsObject(name), d_text(NULL), d_font(NULL), d_size(NULL), d_antialiasing(NULL), d_background_color(NULL), d_text_width(0), d_text_height(0) {
    flx_suspend_setting_updates();
    this->set_text(text);
    this->set_font(flx_default_text_font);
    this->set_size(flx_default_text_size);
    this->set_antialiasing(flx_default_antialiasing);
    this->set_background_color(flx_default_text_background_color);
    flx_resume_setting_updates();
    this->update();
  }
  ~FlxTextObject() {}
  int x_size(void){ return d_text_width; }
  int y_size(void){ return d_text_height; }
  void set_text(string *text){ flx_change_scalar_setting(this,d_text,text,"FlxTextObject::d_text"); }
  void set_font(string *font){ flx_change_scalar_setting(this,d_font,font,"FlxTextObject::d_font"); }
  void set_size(long *size){ flx_change_scalar_setting(this,d_size,size,"FlxTextObject::d_size"); }
  bool *get_antialiasing(void){ return d_antialiasing; }
  void set_antialiasing(bool *antialiasing){ flx_change_scalar_setting(this,d_antialiasing,antialiasing,"FlxTextObject::d_antialiasing"); }
  void set_background_color(FlxColor *background_color){ flx_change_object_setting(this,d_background_color,background_color,"FlxTextObject::d_background_color"); }
  virtual bool update(void);
  void draw(void);
};

class FlxTextBoxObject : public FlxTextObject, public FlxSizedObject {
 protected:
  long *d_text_justification;
 public:
 FlxTextBoxObject(const string &name,string *text) : FlxGraphicsObject(name), FlxTextObject(name,text), d_text_justification(NULL) {
    set_x_size(flx_length(flx_screen->x_size(),FLX_LENGTH_ABSOLUTE));
    set_y_size(flx_length(flx_screen->y_size(),FLX_LENGTH_ABSOLUTE));
    set_text_justification(flx_default_text_justification);
  } 
  ~FlxTextBoxObject() {}
   /* we need these size functions because they are not provided by
   FlxSizedObject; see the class declaration for an explanation */
  int x_size(void) { return d_x_size->value(FLX_LENGTH_X); }
  int y_size(void) { return d_y_size->value(FLX_LENGTH_Y); }
  long *get_text_justification(void) { return d_text_justification; }
  void set_text_justification(long *text_justification) { flx_change_scalar_setting(this,d_text_justification,text_justification,"FlxTextBoxObject::d_text_justification"); }
  bool update(void){  flx_data->write_message(FLX_DATADDDEBUG,"FlxTextBoxObject::update","FlxTextBoxObject: Nothing to update"); return true; }
  void draw(void);
};

#endif
