//LIC// FLXLab v2.5 - A program for running psychology experiments.  
//LIC// Copyright (C) 2010 Todd R. Haskell (todd.haskell@wwu.edu) 
//LIC// 
//LIC// Use and distribution is governed by the terms of the 
//LIC// GNU General Public License. Certain portions of the 
//LIC// program may be subject to other licenses as well. See 
//LIC// the file LICENSE.TXT for details.
//LIC// 
#include "flxtext\text_objects.h"
#include <flxbase.h>
#include <linkflx.h>

FlxDuplexList <string *,string> anonymous_string_arrays;

/*****************************************************************************/

void remove_anonymous_string_arrays_by_scope(const string &tag){
  string cur_function="remove_anonymous_string_arrays_by_scope";

 flx_data->write_message(FLX_DATADDEBUG,cur_function,"Removing anonymous string arrays with scope '"+tag+"'");
 while(anonymous_string_arrays.advance_to_item2(tag)){
   flx_data->write_message(FLX_DATADDDEBUG,cur_function,"Freeing memory");  
   delete[] (*(anonymous_string_arrays.item()));
   anonymous_string_arrays.remove();
 }
  anonymous_string_arrays.rewind();

} /* remove_anonymous_string_arrays_by_scope */

/*****************************************************************************/

#define is_space(a) a==' ' || a=='\t' || a=='\n' || a=='\r'
#define is_eol(a) a=='\n' || a=='\r'

/* If the <n>th character of <s> is either '\n' or '\r', replace it with 
   a space and return true; otherwise return false. If the character is '\r', 
   and the next character is '\n', erase the second character. */
bool check_for_eol(string &s,unsigned int n){

  if(s[n]=='\n' || s[n]=='\r'){
    if(s[n]=='\r' && s.size()>n+1 && s[n+1]=='\n'){
      s.erase(n+1,1);
    }
    s[n]=' ';
    return true;
  } else {
    return false;
  }

} /* check_for_eol */

/*****************************************************************************/

FLX_LINKAGE int flx_text_wrap(string text,FONT *font,int box_width,string *&lines){
  string cur_function="flx_text_wrap";
  FlxLinkedList<string> line_list;
  unsigned int cur_char=0, last_space=0, num_lines=0, cur_line;
  bool just_got_eol=false;

  // extract all the full lines
  while(cur_char<text.size()){
    /* Look at the current character; depending on what it is, do one of three
       things:

       a) If it is an end-of-line marker, and the previous character was 
          another end-of-line marker, insert two line breaks (this is
	  how the user can "force" a line break)
       b) If it is an end-of-line marker, and the previous character was
          not another end-of-line marker, replace it with a space and
	  then re-process the current character
       c) Otherwise, see if this character causes the line to exceed the
          maximum line length; if so, insert a line break
    */

    /* two end-of-line characters in a row is taken to indicate a forced 
       line break */
    if(!just_got_eol && check_for_eol(text,cur_char)){
      last_space=cur_char;
      just_got_eol=true;
      cur_char++;
    } else if(just_got_eol && check_for_eol(text,cur_char)){
	line_list.insert(text.substr(0,cur_char-1));
	line_list.insert("");
	num_lines+=2;
	text.erase(0,cur_char+1);
	last_space=cur_char=0;
	just_got_eol=false;
    } else {
      // keep track of where the last space was
      if(is_space(text[cur_char])){
	last_space=cur_char;
      }
      
      // check if the line is full
      if(text_length(font,text.substr(0,cur_char).c_str())>box_width){
	line_list.insert(text.substr(0,last_space));
	num_lines++;
	text.erase(0,last_space+1);
	last_space=cur_char=0;
      } else {
	cur_char++;
      }
      just_got_eol=false;
    }
  }

  // put the remainder of the text on the last line
  if(text.size()>0){
    line_list.insert(text);
    num_lines++;
  }

  // convert into a string array
  anonymous_string_arrays.insert(lines=new string[num_lines],flx_cur_scope_tag);
  cur_line=0;
  while(cur_line<num_lines){
    lines[cur_line]=*(line_list.item());
    line_list.advance();
    cur_line++;
  }
  return num_lines;

} /* flx_text_wrap */

/*****************************************************************************/

void flx_text_functions_init(void){

  flx_add_scope_cleanup_hook("remove_anonymous_string_arrays_by_scope",remove_anonymous_string_arrays_by_scope);

} /* flx_text_functions_init */

/*****************************************************************************/


