/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.impl.XMLWriterNamespaceBase;

public class StAXWriter
extends XMLWriterNamespaceBase {
    private XMLStreamWriter m_writer;

    public StAXWriter(String[] uris) {
        super(uris);
    }

    public StAXWriter(String[] uris, XMLStreamWriter wrtr) {
        this(uris);
        this.m_writer = wrtr;
    }

    public void setWriter(XMLStreamWriter wrtr) {
        this.m_writer = wrtr;
    }

    protected void defineNamespace(int index, String prefix) throws IOException {
    }

    protected void undefineNamespace(int index) {
    }

    public void setIndentSpaces(int count, String newline, char indent) {
    }

    public void writeXMLDecl(String version, String encoding, String standalone) throws IOException {
        try {
            this.m_writer.writeStartDocument(version, encoding);
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to stream: " + e.getMessage());
        }
    }

    public void startTagOpen(int index, String name) throws IOException {
        try {
            if (index == 0) {
                this.m_writer.writeStartElement(name);
            } else {
                this.m_writer.writeStartElement(this.getNamespacePrefix(index), name, this.getNamespaceUri(index));
            }
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to stream: " + e.getMessage());
        }
    }

    public void startTagNamespaces(int index, String name, int[] nums, String[] prefs) throws IOException {
        try {
            int[] deltas = this.openNamespaces(nums, prefs);
            this.startTagOpen(index, name);
            for (int i = 0; i < deltas.length; ++i) {
                int slot = deltas[i];
                String prefix = this.getNamespacePrefix(slot);
                String uri = this.getNamespaceUri(slot);
                if (prefix.length() > 0) {
                    this.m_writer.writeNamespace(prefix, uri);
                    continue;
                }
                this.m_writer.writeDefaultNamespace(uri);
            }
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to stream: " + e.getMessage());
        }
    }

    public void addAttribute(int index, String name, String value) throws IOException {
        try {
            if (index == 0) {
                this.m_writer.writeAttribute(name, value);
            } else {
                this.m_writer.writeAttribute(this.getNamespacePrefix(index), this.getNamespaceUri(index), name, value);
            }
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to stream: " + e.getMessage());
        }
    }

    public void closeStartTag() throws IOException {
        this.incrementNesting();
    }

    public void closeEmptyTag() throws IOException {
        try {
            this.m_writer.writeEndElement();
            this.incrementNesting();
            this.decrementNesting();
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to stream: " + e.getMessage());
        }
    }

    public void startTagClosed(int index, String name) throws IOException {
        this.startTagOpen(index, name);
        this.incrementNesting();
    }

    public void endTag(int index, String name) throws IOException {
        this.closeEmptyTag();
        this.decrementNesting();
    }

    public void writeTextContent(String text) throws IOException {
        try {
            this.m_writer.writeCharacters(text);
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to stream: " + e.getMessage());
        }
    }

    public void writeCData(String text) throws IOException {
        try {
            this.m_writer.writeCData(text);
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to stream: " + e.getMessage());
        }
    }

    public void writeComment(String text) throws IOException {
        try {
            this.m_writer.writeComment(text);
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to stream: " + e.getMessage());
        }
    }

    public void writeEntityRef(String name) throws IOException {
        try {
            this.m_writer.writeEntityRef(name);
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to stream: " + e.getMessage());
        }
    }

    public void writeDocType(String name, String sys, String pub, String subset) throws IOException {
        try {
            StringBuffer buff = new StringBuffer();
            buff.append("<!DOCTYPE ");
            buff.append(name);
            buff.append(' ');
            if (sys != null) {
                if (pub == null) {
                    buff.append("SYSTEM \"");
                    buff.append(sys);
                } else {
                    buff.append("PUBLIC \"");
                    buff.append(pub);
                    buff.append("\" \"");
                    buff.append(sys);
                }
                buff.append('\"');
            }
            if (subset != null) {
                buff.append('[');
                buff.append(subset);
                buff.append(']');
            }
            buff.append('>');
            this.m_writer.writeDTD(buff.toString());
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to stream: " + e.getMessage());
        }
    }

    public void writePI(String target, String data) throws IOException {
        try {
            this.m_writer.writeProcessingInstruction(target, data);
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to stream: " + e.getMessage());
        }
    }

    public void indent() throws IOException {
    }

    public void flush() throws IOException {
        try {
            this.m_writer.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException("Error flushing stream: " + e.getMessage());
        }
    }

    public void close() throws IOException {
        try {
            this.m_writer.close();
        }
        catch (XMLStreamException e) {
            throw new IOException("Error closing stream: " + e.getMessage());
        }
    }

    public IXMLWriter createChildWriter(String[] uris) {
        return new StAXWriter(uris, this.m_writer);
    }
}

