/*
 * Decompiled with CFR 0.152.
 */
package org.cloner.shallow;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.cloner.CloneException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShallowCloner {
    public static Object shallowClone(Object bean) {
        Object clone;
        if (bean == null) {
            return null;
        }
        if (bean instanceof Cloneable && (clone = ShallowCloner.cloneCloneable(bean)) != null) {
            return clone;
        }
        try {
            return ShallowCloner.doclone(bean);
        }
        catch (Exception e) {
            throw new CloneException(e);
        }
    }

    private static Object cloneCloneable(Object bean) {
        Class<?> clazz = bean.getClass();
        Method cloneMethod = ShallowCloner.findCloneMethod(clazz);
        cloneMethod.setAccessible(true);
        try {
            return cloneMethod.invoke(bean, new Object[0]);
        }
        catch (Exception e) {
            throw new CloneException(e);
        }
    }

    private static Method findCloneMethod(Class<?> clazz) {
        while (clazz != null) {
            try {
                return clazz.getDeclaredMethod("clone", new Class[0]);
            }
            catch (Exception exception) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    private static Object doclone(Object bean) throws Exception {
        Class<?> clazz;
        if (bean == null) {
            return null;
        }
        if (bean.getClass().isPrimitive()) {
            return bean;
        }
        Object clone = null;
        if (clazz.isArray()) {
            int length = Array.getLength(bean);
            clone = Array.newInstance(clazz.getComponentType(), length);
            System.arraycopy(bean, 0, clone, 0, length);
        } else {
            clone = clazz.newInstance();
            for (clazz = bean.getClass(); clazz != null && !clazz.isInterface() && clazz != Object.class; clazz = clazz.getSuperclass()) {
                ShallowCloner.cloneFields(bean, clone, clazz);
            }
        }
        return clone;
    }

    private static void cloneFields(Object bean, Object clone, Class<?> clazz) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if ((field.getModifiers() & 8) == 8) continue;
            field.setAccessible(true);
            Object v = field.get(bean);
            field.set(clone, v);
        }
    }
}

