/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.analysisView;

import SocLab.core.OrgNew;
import SocLab.tools.Screenshot;
import SocLab.tools.graph.orgBipartiteGraph.BipartiteOrgGraph;
import SocLab.tools.graph.orgBipartiteGraph.OrgRenderer;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.SparseGraph;
import edu.uci.ics.jung.graph.impl.SparseVertex;
import edu.uci.ics.jung.visualization.FRLayout;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.SpringLayout;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.contrib.CircleLayout;
import edu.uci.ics.jung.visualization.contrib.KKLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class QuickOrgGraphView
extends JPanel {
    public static final String ACTORS_AND_RELATIONS_TYPE = "Actors & Relations";
    public static final String ACTORS_TYPE = "Actors";
    public String graphType = "Actors & Relations";
    private JList networkTypeList;
    private JList relationActorEdgeTypeList;
    private JList actorActorEdgeTypeList;
    private JList actorVertexTypeList;
    private JList relationVertexTypeList;
    private SparseGraph SAC;
    private VisualizationViewer vv;
    private OrgRenderer orgRenderer;
    public OrgNew orgNew = null;

    QuickOrgGraphView(OrgNew orgNew) {
        this.orgNew = orgNew;
        this.orgRenderer = new OrgRenderer(this);
        this.SAC = QuickOrgGraphView.getGraph(8);
        this.init();
    }

    public void setOrgNew(OrgNew orgNew) {
        this.orgNew = orgNew;
        this.orgRenderer.setOrgNew(orgNew);
        this.SAC = new BipartiteOrgGraph(orgNew);
        this.vv.setGraphLayout((Layout)new KKLayout((Graph)this.SAC));
    }

    private void init() {
        this.vv = new VisualizationViewer((Layout)new SpringLayout((Graph)this.SAC), (Renderer)this.orgRenderer);
        this.vv.setBackground(Color.white);
        JPanel buttonPanel = new JPanel();
        JLabel blank0 = new JLabel();
        blank0.setPreferredSize(new Dimension(15, 15));
        JLabel blank1 = new JLabel();
        blank1.setPreferredSize(new Dimension(15, 15));
        JLabel blank2 = new JLabel();
        blank2.setPreferredSize(new Dimension(15, 15));
        JLabel blank3 = new JLabel();
        blank3.setPreferredSize(new Dimension(15, 15));
        JLabel blank4 = new JLabel();
        blank4.setPreferredSize(new Dimension(15, 15));
        JLabel blank5 = new JLabel();
        blank5.setPreferredSize(new Dimension(15, 15));
        Border border = BorderFactory.createLoweredBevelBorder();
        JButton ScreenshotButton = new JButton("Graph screenshot");
        ScreenshotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String img_name = "graph_capture_" + QuickOrgGraphView.this.orgNew.scrShtCntr;
                try {
                    Screenshot.export_frame2png(img_name, (JPanel)QuickOrgGraphView.this.vv);
                    ++QuickOrgGraphView.this.orgNew.scrShtCntr;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        });
        JButton springLayoutButton = new JButton("SpringLayout");
        JButton circleLayoutButton = new JButton("CircleLayout");
        JButton kkLayoutButton = new JButton("KKLayout");
        JButton frLayoutButton = new JButton("FRLayout");
        springLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickOrgGraphView.this.vv.setGraphLayout((Layout)new SpringLayout((Graph)QuickOrgGraphView.this.SAC));
                QuickOrgGraphView.this.vv.restart();
            }
        });
        circleLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickOrgGraphView.this.vv.setGraphLayout((Layout)new CircleLayout((Graph)QuickOrgGraphView.this.SAC));
            }
        });
        kkLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickOrgGraphView.this.vv.setGraphLayout((Layout)new KKLayout((Graph)QuickOrgGraphView.this.SAC));
            }
        });
        frLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickOrgGraphView.this.vv.setGraphLayout((Layout)new FRLayout((Graph)QuickOrgGraphView.this.SAC));
            }
        });
        JLabel networkTypeLabel = new JLabel("Network type : ");
        JLabel relActEdgeTypeLabel = new JLabel("Edges R > A : ");
        JLabel actActEdgeTypeLabel = new JLabel("Edges A > A : ");
        JLabel actorVertexTypeLabel = new JLabel("Actor nodes : ");
        JLabel relationVertexTypeLabel = new JLabel("Relation nodes : ");
        this.networkTypeList = new JList<String>(new String[]{ACTORS_AND_RELATIONS_TYPE, ACTORS_TYPE});
        this.relationActorEdgeTypeList = new JList<String>(new String[]{"NONE", "STRENGTH"});
        this.actorActorEdgeTypeList = new JList<String>(new String[]{"NONE", "STRUCTURAL_POWER"});
        this.actorVertexTypeList = new JList<String>(new String[]{"NONE", "AUTONOMY", "SUBORDINATION", "MAX_SATISFACTION", "MIN_SATISFACTION"});
        this.relationVertexTypeList = new JList<String>(new String[]{"NONE", "MAX_POTENTIAL_STRENGTH", "ACCUMULATED_POTENTIAL_STRENGTH", "EFFECTIVE_MAX_STRENGTH", "ACCUMULATED_EFFECTIVE_STRENGTH", "RELEVANCE"});
        this.networkTypeList.setBorder(border);
        this.relationActorEdgeTypeList.setBorder(border);
        this.actorActorEdgeTypeList.setBorder(border);
        this.actorVertexTypeList.setBorder(border);
        this.relationVertexTypeList.setBorder(border);
        this.networkTypeList.setSelectedIndex(0);
        this.relationActorEdgeTypeList.setSelectedIndex(0);
        this.actorActorEdgeTypeList.setSelectedIndex(0);
        this.actorVertexTypeList.setSelectedIndex(0);
        this.relationVertexTypeList.setSelectedIndex(0);
        this.networkTypeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                QuickOrgGraphView.this.graphType = (String)QuickOrgGraphView.this.networkTypeList.getSelectedValue();
                QuickOrgGraphView.this.vv.repaint();
            }
        });
        this.relationActorEdgeTypeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ((QuickOrgGraphView)QuickOrgGraphView.this).orgRenderer.relationActorEdgeType = (String)QuickOrgGraphView.this.relationActorEdgeTypeList.getSelectedValue();
                QuickOrgGraphView.this.vv.repaint();
            }
        });
        this.actorActorEdgeTypeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ((QuickOrgGraphView)QuickOrgGraphView.this).orgRenderer.actorActorEdgeType = (String)QuickOrgGraphView.this.actorActorEdgeTypeList.getSelectedValue();
                QuickOrgGraphView.this.vv.repaint();
            }
        });
        this.actorVertexTypeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ((QuickOrgGraphView)QuickOrgGraphView.this).orgRenderer.actorVertexType = (String)QuickOrgGraphView.this.actorVertexTypeList.getSelectedValue();
                QuickOrgGraphView.this.vv.repaint();
            }
        });
        this.relationVertexTypeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ((QuickOrgGraphView)QuickOrgGraphView.this).orgRenderer.relationVertexType = (String)QuickOrgGraphView.this.relationVertexTypeList.getSelectedValue();
                QuickOrgGraphView.this.vv.repaint();
            }
        });
        buttonPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        buttonPanel.setLayout(gb);
        c.fill = 1;
        c.gridwidth = 0;
        buttonPanel.add((Component)ScreenshotButton, c);
        buttonPanel.add((Component)blank0, c);
        buttonPanel.add((Component)springLayoutButton, c);
        buttonPanel.add((Component)circleLayoutButton, c);
        buttonPanel.add((Component)kkLayoutButton, c);
        buttonPanel.add((Component)frLayoutButton, c);
        buttonPanel.add((Component)blank1, c);
        buttonPanel.add((Component)networkTypeLabel, c);
        buttonPanel.add((Component)this.networkTypeList, c);
        buttonPanel.add((Component)blank2, c);
        buttonPanel.add((Component)relActEdgeTypeLabel, c);
        buttonPanel.add((Component)this.relationActorEdgeTypeList, c);
        buttonPanel.add((Component)blank3, c);
        buttonPanel.add((Component)actActEdgeTypeLabel, c);
        buttonPanel.add((Component)this.actorActorEdgeTypeList, c);
        buttonPanel.add((Component)blank4, c);
        buttonPanel.add((Component)actorVertexTypeLabel, c);
        buttonPanel.add((Component)this.actorVertexTypeList, c);
        buttonPanel.add((Component)blank5, c);
        buttonPanel.add((Component)relationVertexTypeLabel, c);
        buttonPanel.add((Component)this.relationVertexTypeList, c);
        this.vv.setPreferredSize(new Dimension(200, 200));
        this.vv.setMaximumSize(new Dimension(200, 200));
        this.setPreferredSize(new Dimension(300, 300));
        this.setMaximumSize(new Dimension(300, 300));
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(buttonPanel), "West");
        this.add((Component)this.vv, "Center");
    }

    private static SparseGraph getGraph(int l) {
        SparseGraph g = new SparseGraph();
        SparseVertex[] v = new SparseVertex[l];
        DirectedSparseEdge[] e = new DirectedSparseEdge[2 * l];
        SparseVertex c = new SparseVertex();
        g.addVertex((Vertex)c);
        int i = 0;
        while (i < l) {
            v[i] = new SparseVertex();
            g.addVertex((Vertex)v[i]);
            ++i;
        }
        i = 0;
        while (i < l) {
            e[i + l] = i != 0 ? new DirectedSparseEdge((Vertex)v[i], (Vertex)v[i - 1]) : new DirectedSparseEdge((Vertex)v[i], (Vertex)v[l - 1]);
            e[i] = i != l - 1 ? new DirectedSparseEdge((Vertex)v[i], (Vertex)v[i + 1]) : new DirectedSparseEdge((Vertex)v[i], (Vertex)v[0]);
            g.addEdge((Edge)e[i]);
            g.addEdge((Edge)e[i + l]);
            g.addEdge((Edge)new DirectedSparseEdge((Vertex)c, (Vertex)v[i]));
            ++i;
        }
        return g;
    }
}

