/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.effectAction;

import SocLab.GUI.desktop.DesktopFrame;
import SocLab.GUI.effectAction.MiniConstraintViewer;
import SocLab.GUI.effectAction.MyConstraintViewer;
import SocLab.GUI.effectAction.ParamsConstraintSlider;
import SocLab.GUI.effectAction.effectGuiComponents.ConstraintControl;
import SocLab.core.ConstraintsElement;
import SocLab.core.OrgNew;
import SocLab.core.SocLabToolkit;
import SocLab.core.SwitchLanguages;
import SocLab.core.structures.RelationRelation;
import SocLab.tools.functions.AbstractFunction;
import SocLab.tools.functions.ConstanteFunction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ConstraintModellingGUI
extends JDialog {
    private MyConstraintViewer constraintViewer;
    private ConstraintControl constraintControl;
    private JPanel buttonPanel = new JPanel();
    private JButton acceptButton;
    private JButton closeButton;
    public boolean cancelled = true;
    private MiniConstraintViewer miniConstraintViewer;
    private OrgNew orgNew;
    private RelationRelation relationRelation;
    private String relS;
    private String relT;
    private JPanel jFunction = new JPanel();
    public static JLabel funcLab = new JLabel();
    public static JTextArea jtext = new JTextArea();
    private ConstraintsElement source;
    private ConstraintsElement target;

    public ConstraintModellingGUI(Frame owner, OrgNew orgNew, RelationRelation relationRelation) {
        super(owner, "EffectAction", true);
        JDialog.setDefaultLookAndFeelDecorated(false);
        this.orgNew = orgNew;
        this.relationRelation = relationRelation;
        this.relS = relationRelation.getRelationSource().getName();
        this.relT = relationRelation.getRelationTarget().getName();
        this.setTitle(String.valueOf(SwitchLanguages.ConstraintModellingGuiTitle1[SocLabToolkit.idLanguage]) + this.relS + SwitchLanguages.ConstraintModellingGuiTitle2[SocLabToolkit.idLanguage] + this.relT + ".");
        this.init();
    }

    private void init() {
        this.setDefaultCloseOperation(2);
        this.constraintControl = new ConstraintControl(this);
        this.constraintViewer = new MyConstraintViewer();
        this.constraintViewer.relationRelation = this.relationRelation;
        this.acceptButton = new JButton(SwitchLanguages.ConstraintModellingGuiAcceptButton[SocLabToolkit.idLanguage]);
        this.closeButton = new JButton(SwitchLanguages.ConstraintModellingGuiCloseButton[SocLabToolkit.idLanguage]);
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConstraintModellingGUI.this.cancelled = false;
                ConstraintModellingGUI.this.verification();
                ConstraintModellingGUI.this.dispose();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConstraintModellingGUI.this.dispose();
            }
        });
        this.buttonPanel.setLayout(new BorderLayout());
        this.buttonPanel.add((Component)this.acceptButton, "West");
        this.buttonPanel.add((Component)this.closeButton, "East");
        funcLab.setText(ParamsConstraintSlider.control.getFunction().getFormula());
        jtext.setText(ParamsConstraintSlider.control.getFunction().getFormula());
        this.jFunction.add(jtext);
        this.buttonPanel.add((Component)this.jFunction, "South");
        this.acceptButton.setMinimumSize(new Dimension(60, 21));
        this.acceptButton.setMinimumSize(new Dimension(60, 21));
        this.constraintViewer.setPreferredSize(new Dimension(210, 210));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.constraintViewer, c);
        ++c.gridy;
        this.add((Component)new JScrollPane(this.constraintControl), c);
        ++c.gridy;
        this.add((Component)this.buttonPanel, c);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 7, (screenSize.height - this.getHeight()) / 7);
        this.setSize(800, 600);
        this.switchLanguage();
        jtext.setEditable(false);
        this.setVisible(true);
    }

    private void verification() {
        ConstanteFunction bmaxFunction;
        boolean error = false;
        double i = -10.0;
        while (i <= 10.0) {
            if (this.relationRelation.getBminFunction().getF(i) > this.relationRelation.getBmaxFunction().getF(i)) {
                error = true;
            }
            i += 0.5;
        }
        if (error) {
            ConstanteFunction bminFunction = OrgNew.effetMin;
            bmaxFunction = OrgNew.effetMax;
            this.relationRelation.setBminFunction(bminFunction);
            this.relationRelation.setBmaxFunction(bmaxFunction);
            JOptionPane.showMessageDialog(DesktopFrame.desktopPanel, SwitchLanguages.ConstraintModellingGuiMessageIncoherentLabel[SocLabToolkit.idLanguage], SwitchLanguages.ConstraintModellingGuiMessageIncoherentTitle[SocLabToolkit.idLanguage], -1);
            DesktopFrame.statusBar.setText(SwitchLanguages.ConstraintModellingGuiMessageIncoherentLabel[SocLabToolkit.idLanguage]);
        }
        if (this.relationRelation.getBminFunction().getMax() > -10.0 || this.relationRelation.getBmaxFunction().getMin() < 10.0) {
            this.source = this.orgNew.getConstraintsElement(this.relationRelation.getRelationSource());
            this.target = this.orgNew.getConstraintsElement(this.relationRelation.getRelationTarget());
            if (this.source.hadFather(this.source, this.target)) {
                ConstanteFunction bminFunction = OrgNew.effetMin;
                bmaxFunction = OrgNew.effetMax;
                this.relationRelation.setBminFunction(bminFunction);
                this.relationRelation.setBmaxFunction(bmaxFunction);
                JOptionPane.showMessageDialog(DesktopFrame.desktopPanel, "Model incoherent, Constraints have been re-initialized ...", SwitchLanguages.ConstraintModellingGuiMessageIncoherentTitle[SocLabToolkit.idLanguage], -1);
                DesktopFrame.statusBar.setText("Model incoherent, Constraints have been re-initialized ...");
            } else {
                this.source.setSons(this.target);
                if (this.target.getNbFathers() == 1 && this.target.getFather(0).getHim() == null) {
                    this.target.getFather(0).delSons(this.target);
                    this.target.clearFathers();
                }
                this.target.setFather(this.source);
            }
        } else {
            this.source = this.orgNew.getConstraintsElement(this.relationRelation.getRelationSource());
            this.target = this.orgNew.getConstraintsElement(this.relationRelation.getRelationTarget());
            this.source.delSons(this.target);
            this.target.delFather(this.source);
            if (this.target.getFathers().size() == 0) {
                this.target.addFather(SocLabToolkit.currentOrgNew.getConstraintsElementOriginal());
                SocLabToolkit.currentOrgNew.getConstraintsElementOriginal().addSons(this.target);
            }
        }
    }

    public void setMiniConstraintViewer(MiniConstraintViewer miniConstraintViewer) {
        this.miniConstraintViewer = miniConstraintViewer;
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        this.setTitle("Effect : " + this.relationRelation.getRelationSource().getName() + " --> " + this.relationRelation.getRelationTarget().getName());
    }

    public RelationRelation getRelationRelation() {
        return this.relationRelation;
    }

    public void setRelationRelation(RelationRelation relationRelation) {
        this.relationRelation = relationRelation;
        if (relationRelation != null) {
            this.constraintViewer.setRelationRelation(relationRelation);
            this.constraintViewer.repaint();
        }
    }

    public void changedEvent() {
        this.relationRelation.setBminFunction(this.constraintControl.lowerBoundFunctionSelector.getFunction());
        this.relationRelation.setBmaxFunction(this.constraintControl.upperBoundFunctionSelector.getFunction());
        this.paintAll(this.getGraphics());
    }

    public AbstractFunction getFunction() {
        return this.relationRelation.getBminFunction();
    }

    public void updateEffectFunction() {
        this.relationRelation.setBminFunction(this.constraintControl.lowerBoundFunctionSelector.getFunction());
        this.relationRelation.setBmaxFunction(this.constraintControl.upperBoundFunctionSelector.getFunction());
        this.constraintViewer.repaint();
    }

    private void switchLanguage() {
        this.setTitle(String.valueOf(SwitchLanguages.ConstraintModellingGuiTitle1[SocLabToolkit.idLanguage]) + this.relS + SwitchLanguages.ConstraintModellingGuiTitle2[SocLabToolkit.idLanguage] + this.relT + ".");
        this.acceptButton.setText(SwitchLanguages.ConstraintModellingGuiAcceptButton[SocLabToolkit.idLanguage]);
        this.closeButton.setText(SwitchLanguages.ConstraintModellingGuiCloseButton[SocLabToolkit.idLanguage]);
    }
}

