/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.effectAction;

import SocLab.GUI.effectAction.MiniEfmViewer;
import SocLab.GUI.effectAction.MyEffectViewer;
import SocLab.GUI.effectAction.ParamSlider;
import SocLab.GUI.effectAction.effectGuiComponents.RelationControl;
import SocLab.core.EffectNew;
import SocLab.core.OrgNew;
import SocLab.core.SocLabToolkit;
import SocLab.core.SwitchLanguages;
import SocLab.tools.functions.AbstractFunction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class EffectModellingGUI
extends JDialog {
    private MyEffectViewer effectViewer;
    private RelationControl relationControl;
    private JPanel buttonPanel = new JPanel();
    private JButton acceptButton;
    private JButton closeButton;
    public boolean cancelled = true;
    private MiniEfmViewer miniEfmViewer;
    private String actorName;
    private String relationName;
    private EffectNew effectNew;
    private JPanel jFunction = new JPanel();
    public static JLabel funcLab = new JLabel();
    public static JTextArea jtext = new JTextArea();

    public EffectModellingGUI(Frame owner, EffectNew effectNew) {
        super(owner, "EffectAction", true);
        this.effectNew = effectNew;
        this.actorName = this.effectNew.getDepend().getActorNew().getName();
        this.relationName = this.effectNew.getDepend().getRelationNew().getName();
        this.setTitle("Effect of relation " + this.relationName + " on actor " + this.actorName + ".");
        this.init();
    }

    private void init() {
        this.setDefaultCloseOperation(2);
        this.relationControl = new RelationControl(this);
        this.effectViewer = new MyEffectViewer();
        this.effectViewer.effectNew = this.effectNew;
        this.acceptButton = new JButton("accept");
        this.closeButton = new JButton("close");
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EffectModellingGUI.this.cancelled = false;
                EffectModellingGUI.this.dispose();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EffectModellingGUI.this.dispose();
            }
        });
        this.buttonPanel.setLayout(new BorderLayout());
        this.buttonPanel.add((Component)this.acceptButton, "West");
        this.buttonPanel.add((Component)this.closeButton, "East");
        funcLab.setText(ParamSlider.control.getFunction().getFormula());
        jtext.setText(ParamSlider.control.getFunction().getFormula());
        jtext.setEditable(false);
        this.jFunction.add(jtext);
        this.buttonPanel.add((Component)this.jFunction, "South");
        this.effectViewer.setPreferredSize(new Dimension(210, 210));
        this.acceptButton.setMinimumSize(new Dimension(60, 21));
        this.acceptButton.setMinimumSize(new Dimension(60, 21));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.effectViewer, c);
        ++c.gridy;
        this.add((Component)new JScrollPane(this.relationControl), c);
        ++c.gridy;
        this.add((Component)this.buttonPanel, c);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 8, (screenSize.height - this.getHeight()) / 8);
        this.setSize(800, 600);
        this.switchLanguage();
        this.setVisible(true);
    }

    public void setMiniEfmViewer(MiniEfmViewer miniEfmViewer) {
        this.miniEfmViewer = miniEfmViewer;
        if (this.effectNew.getFunction() == null) {
            this.effectNew.setFunction(OrgNew.effetNull);
        }
        this.setEffectNew(this.miniEfmViewer.effectNew);
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        this.setTitle("Effect : " + this.effectNew.getRelationNew().getName() + " > " + this.effectNew.getActorNew().getName());
    }

    public void changeRelationBounds(int infValue, int supValue) {
        this.effectNew.getRelationNew().getRPNInitial().setLowerBound(infValue);
        this.effectNew.getRelationNew().getRPNInitial().setUpperBound(supValue);
        this.effectNew.getFunction().recompute();
        this.effectViewer.repaint();
    }

    public EffectNew getEffectNew() {
        return this.effectNew;
    }

    public void setEffectNew(EffectNew effectNew) {
        this.effectNew = effectNew;
        this.effectNew.setFunction(effectNew.getFunction());
        if (effectNew != null) {
            this.relationControl.setRelationNew(effectNew.getRelationNew());
            this.effectViewer.setEffectNew(effectNew);
            this.effectViewer.repaint();
        }
    }

    public void setFunction(AbstractFunction function) {
        if (this.effectNew.getFunction() != null) {
            this.effectNew.setFunction(function);
            this.repaint();
        }
    }

    public void changedEvent() {
        this.effectNew.setFunction(this.relationControl.functionSelector.getFunction());
        this.paintAll(this.getGraphics());
    }

    public AbstractFunction getFunction() {
        return this.effectNew.getFunction();
    }

    public void updateEffectFunction() {
        this.effectNew.setFunction(this.relationControl.functionSelector.getFunction());
        this.effectViewer.repaint();
    }

    private void switchLanguage() {
        this.setTitle(String.valueOf(SwitchLanguages.EffectModellingGuiTitle1[SocLabToolkit.idLanguage]) + this.relationName + SwitchLanguages.EffectModellingGuiTitle2[SocLabToolkit.idLanguage] + this.actorName + ".");
        this.acceptButton.setText(SwitchLanguages.EffectModellingGuiAcceptButton[SocLabToolkit.idLanguage]);
        this.closeButton.setText(SwitchLanguages.EffectModellingGuiCloseButton[SocLabToolkit.idLanguage]);
    }
}

