/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.effectAction;

import SocLab.GUI.effectAction.MyEffectViewer;
import SocLab.core.EffectNew;
import SocLab.tools.functions.AbstractFunction;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class MiniEfmViewer
extends MyEffectViewer {
    private boolean selected;

    public MiniEfmViewer(EffectNew effectNew) {
        this.effectNew = effectNew;
    }

    @Override
    public void drawDatas(Graphics g, AbstractFunction f, Color c) {
        g.setColor(c);
        double i = this.effectNew.getRelationNew().getRPNInitial().getLowerBound();
        while (i < this.effectNew.getRelationNew().getRPNInitial().getUpperBound()) {
            this.drawALine(g, i);
            i += 0.5;
        }
    }

    @Override
    public void drawValue(Graphics g, double i, double j) {
        int x = new Double(Math.round((i + 10.0) * 2.0)).intValue();
        int y = new Double((10.0 - j) * 2.0).intValue();
        g.fillRect(x, y, 1, 1);
    }

    private void drawALine(Graphics g, double i) {
        double i2 = i + 0.5;
        double j = this.effectNew.getFunction().getF(i);
        double j2 = this.effectNew.getFunction().getF(i + 0.5);
        int x1 = new Double(Math.round((i + 10.0) * 2.0)).intValue();
        int y1 = new Double((10.0 - j) * 2.0).intValue();
        int x2 = new Double(Math.round((i2 + 10.0) * 2.0)).intValue();
        int y2 = new Double((10.0 - j2) * 2.0).intValue();
        g.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void paint(Graphics g) {
        this.drawBackground(g);
        if (this.effectNew != null && this.effectNew.getFunction() != null) {
            this.drawDatas(g, this.effectNew.getFunction(), Color.BLACK);
        }
        if (this.selected) {
            g.setColor(Color.red);
            g.drawRect(0, 0, 40, 40);
        }
    }

    @Override
    public void drawBackground(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, 41, 41);
        g.setColor(Color.lightGray);
        int i = 0;
        while (i < 41) {
            g.fillRect(i, 0, 1, 1);
            g.fillRect(i, 20, 1, 1);
            g.fillRect(i, 40, 1, 1);
            ++i;
        }
        i = 0;
        while (i < 41) {
            int y1 = i++;
            g.fillRect(0, y1, 1, 1);
            g.fillRect(20, y1, 1, 1);
            g.fillRect(40, y1, 1, 1);
        }
    }

    public void saveAsPNG(File png) {
        BufferedImage image = new BufferedImage(41, 41, 1);
        Graphics2D g2d = image.createGraphics();
        this.paint(g2d);
        g2d.dispose();
        try {
            ImageIO.write((RenderedImage)image, "PNG", png);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSelected(boolean b) {
        this.selected = b;
    }
}

