/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.effectAction.effectGuiComponents;

import SocLab.GUI.effectAction.ConstraintModellingGUI;
import SocLab.GUI.effectAction.effectGuiComponents.ConstraintControl;
import SocLab.GUI.effectAction.functionConstraintController.AbsController;
import SocLab.GUI.effectAction.functionConstraintController.ComplexSigmoid2Controller;
import SocLab.GUI.effectAction.functionConstraintController.ComplexSigmoidController;
import SocLab.GUI.effectAction.functionConstraintController.ConstanteController;
import SocLab.GUI.effectAction.functionConstraintController.DefaultController;
import SocLab.GUI.effectAction.functionConstraintController.FunctionController;
import SocLab.GUI.effectAction.functionConstraintController.GaussianController;
import SocLab.GUI.effectAction.functionConstraintController.LinearController;
import SocLab.GUI.effectAction.functionConstraintController.QuadraticController;
import SocLab.GUI.effectAction.functionConstraintController.QuadraticController2;
import SocLab.GUI.effectAction.functionConstraintController.Sigmoid2Controller;
import SocLab.GUI.effectAction.functionConstraintController.SigmoidController;
import SocLab.GUI.effectAction.functionConstraintController.X3Controller;
import SocLab.core.OrgNew;
import SocLab.core.SocLabToolkit;
import SocLab.core.SwitchLanguages;
import SocLab.tools.functions.AbsFunction;
import SocLab.tools.functions.AbstractFunction;
import SocLab.tools.functions.ComplexSigmoid2Function;
import SocLab.tools.functions.ComplexSigmoidFunction;
import SocLab.tools.functions.ConstanteFunction;
import SocLab.tools.functions.GaussianFunction;
import SocLab.tools.functions.LinearFunction;
import SocLab.tools.functions.QuadraticFunction;
import SocLab.tools.functions.QuadraticFunction2;
import SocLab.tools.functions.Sigmoid2Function;
import SocLab.tools.functions.SigmoidFunction;
import SocLab.tools.functions.x3function;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConstraintSelector
extends JPanel {
    private static String DEFAULTMIN;
    private static String DEFAULTMAX;
    private static String CONSTANTE;
    private static String LINEAR;
    private static String ABS_LINEAR;
    private static String QUADRATIC;
    private static String QUADRATIC2;
    private static String X3;
    private static String SIGMOID;
    private static String SIGMOID2;
    private static String COMPLEXSIGMOID;
    private static String COMPLEXSIGMOID2;
    private static String GAUSSIAN;
    private JPanel functionSelectorPanel = new JPanel(new BorderLayout());
    private JLabel className = new JLabel("Function");
    private JComboBox functionClassSelector;
    private FunctionController functionControler;
    private ConstraintModellingGUI effectSelector;
    private AbstractFunction function;
    private ConstraintControl conControl;
    private ActionListener aListener;

    ConstraintSelector(ConstraintControl conControl, AbstractFunction function, int val) {
        DEFAULTMIN = SwitchLanguages.FunctionSelectorDefaultMin[SocLabToolkit.idLanguage];
        DEFAULTMAX = SwitchLanguages.FunctionSelectorDefaultMax[SocLabToolkit.idLanguage];
        CONSTANTE = SwitchLanguages.FunctionSelectorCste[SocLabToolkit.idLanguage];
        LINEAR = SwitchLanguages.FunctionSelectorLinear[SocLabToolkit.idLanguage];
        ABS_LINEAR = SwitchLanguages.FunctionSelectorAbsLinear[SocLabToolkit.idLanguage];
        QUADRATIC = SwitchLanguages.FunctionSelectorQuadratic[SocLabToolkit.idLanguage];
        QUADRATIC2 = SwitchLanguages.FunctionSelectorQuadratic2[SocLabToolkit.idLanguage];
        X3 = SwitchLanguages.FunctionSelectorX3[SocLabToolkit.idLanguage];
        SIGMOID = SwitchLanguages.FunctionSelectorSigmoid[SocLabToolkit.idLanguage];
        SIGMOID2 = SwitchLanguages.FunctionSelectorSigmoid2[SocLabToolkit.idLanguage];
        COMPLEXSIGMOID = SwitchLanguages.FunctionSelectorComplexSigmoid[SocLabToolkit.idLanguage];
        COMPLEXSIGMOID2 = SwitchLanguages.FunctionSelectorComplexSigmoid2[SocLabToolkit.idLanguage];
        GAUSSIAN = SwitchLanguages.FunctionSelectorGaussian[SocLabToolkit.idLanguage];
        this.conControl = conControl;
        this.function = function;
        this.effectSelector = conControl.effectSelector;
        if (val == 0) {
            this.functionClassSelector = new JComboBox<String>(new String[]{DEFAULTMIN, CONSTANTE, LINEAR, ABS_LINEAR, QUADRATIC, QUADRATIC2, X3, SIGMOID, SIGMOID2, COMPLEXSIGMOID2, COMPLEXSIGMOID, GAUSSIAN});
        } else if (val == 1) {
            this.functionClassSelector = new JComboBox<String>(new String[]{DEFAULTMAX, CONSTANTE, LINEAR, ABS_LINEAR, QUADRATIC, QUADRATIC2, X3, SIGMOID, SIGMOID2, COMPLEXSIGMOID2, COMPLEXSIGMOID, GAUSSIAN});
        }
        this.functionClassSelector.setMaximumRowCount(12);
        if (function.getType().equals("DefaultMin") || function.getType().equals("DefaultMax")) {
            this.functionClassSelector.setSelectedIndex(0);
        }
        if (function.getType().equals("Constante")) {
            this.functionClassSelector.setSelectedIndex(1);
        }
        if (function.getType().equals("linear")) {
            this.functionClassSelector.setSelectedIndex(2);
        }
        if (function.getType().equals("abs_linear")) {
            this.functionClassSelector.setSelectedIndex(3);
        }
        if (function.getType().equals("quadratic")) {
            this.functionClassSelector.setSelectedIndex(4);
        }
        if (function.getType().equals("quadratic2")) {
            this.functionClassSelector.setSelectedIndex(5);
        }
        if (function.getType().equals("SF")) {
            this.functionClassSelector.setSelectedIndex(7);
        }
        if (function.getType().equals("S2F")) {
            this.functionClassSelector.setSelectedIndex(8);
        }
        if (function.getType().equals("CSF")) {
            this.functionClassSelector.setSelectedIndex(9);
        }
        if (function.getType().equals("CS2F")) {
            this.functionClassSelector.setSelectedIndex(10);
        }
        if (function.getType().equals("gaussian")) {
            this.functionClassSelector.setSelectedIndex(11);
        }
        if (function.getType().equals("x3")) {
            this.functionClassSelector.setSelectedIndex(6);
        }
        this.aListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConstraintSelector.this.setFunctionType();
            }
        };
        this.functionClassSelector.addActionListener(this.aListener);
        this.className.setPreferredSize(new Dimension(60, 21));
        this.functionSelectorPanel.add((Component)this.className, "West");
        this.functionSelectorPanel.add((Component)this.functionClassSelector, "Center");
        this.setLayout(new GridBagLayout());
        this.switchFunctionControler();
        this.redoLayout();
    }

    private void setFunctionType() {
        String functionType = (String)this.functionClassSelector.getSelectedItem();
        if (functionType.equals("DefaultMin")) {
            this.function = OrgNew.effetMin;
        } else if (functionType.equals("DefaultMax")) {
            this.function = OrgNew.effetMax;
        }
        if (functionType.equals(CONSTANTE)) {
            this.function = new ConstanteFunction("Constante");
        }
        if (functionType.equals(LINEAR)) {
            this.function = new LinearFunction("");
        }
        if (functionType.equals(ABS_LINEAR)) {
            this.function = new AbsFunction("");
        }
        if (functionType.equals(QUADRATIC)) {
            this.function = new QuadraticFunction("");
        }
        if (functionType.equals(QUADRATIC2)) {
            this.function = new QuadraticFunction2("");
        }
        if (functionType.equals(X3)) {
            this.function = new x3function("");
        }
        if (functionType.equals(SIGMOID)) {
            this.function = new SigmoidFunction("");
        }
        if (functionType.equals(SIGMOID2)) {
            this.function = new Sigmoid2Function("");
        }
        if (functionType.equals(COMPLEXSIGMOID)) {
            this.function = new ComplexSigmoidFunction("");
        }
        if (functionType.equals(COMPLEXSIGMOID2)) {
            this.function = new ComplexSigmoid2Function("");
        }
        if (functionType.equals(GAUSSIAN)) {
            this.function = new GaussianFunction("");
        }
        this.switchFunctionControler();
        this.effectSelector.changedEvent();
    }

    private void switchFunctionControler() {
        Class<?> cls;
        this.remove(this.functionSelectorPanel);
        if (this.isAncestorOf(this.functionControler)) {
            this.remove(this.functionControler);
        }
        if (this.function == null) {
            this.function = OrgNew.effetNull;
        }
        if ((cls = this.function.getClass()).equals(ConstanteFunction.class)) {
            this.functionControler = this.function.getType().equals(DEFAULTMIN) || this.function.getType().equals(DEFAULTMAX) ? new DefaultController(this) : new ConstanteController(this);
        }
        if (cls.equals(LinearFunction.class)) {
            this.functionControler = new LinearController(this);
        }
        if (cls.equals(AbsFunction.class)) {
            this.functionControler = new AbsController(this);
        }
        if (cls.equals(QuadraticFunction.class)) {
            this.functionControler = new QuadraticController(this);
        }
        if (cls.equals(x3function.class)) {
            this.functionControler = new X3Controller(this);
        }
        if (cls.equals(QuadraticFunction2.class)) {
            this.functionControler = new QuadraticController2(this);
        }
        if (cls.equals(SigmoidFunction.class)) {
            this.functionControler = new SigmoidController(this);
        }
        if (cls.equals(Sigmoid2Function.class)) {
            this.functionControler = new Sigmoid2Controller(this);
        }
        if (cls.equals(ComplexSigmoidFunction.class)) {
            this.functionControler = new ComplexSigmoidController(this);
        }
        if (cls.equals(ComplexSigmoid2Function.class)) {
            this.functionControler = new ComplexSigmoid2Controller(this);
        }
        if (cls.equals(GaussianFunction.class)) {
            this.functionControler = new GaussianController(this);
        }
        this.effectSelector.repaint();
        this.redoLayout();
    }

    private void redoLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridwidth = 0;
        this.add((Component)this.functionSelectorPanel, gbc);
        this.add((Component)this.functionControler, gbc);
    }

    public AbstractFunction getFunction() {
        return this.function;
    }

    public void update() {
        this.conControl.update();
    }

    public void setFunction(AbstractFunction function) {
        if (function == null) {
            function = OrgNew.effetNull;
        }
        this.functionClassSelector.removeActionListener(this.aListener);
        this.function = function;
        this.updateValues();
        this.functionClassSelector.addActionListener(this.aListener);
    }

    private void updateValues() {
        this.functionClassSelector.setSelectedItem(this.getFunctionType());
        this.switchFunctionControler();
        this.functionControler.setFunction(this.function);
    }

    private Object getFunctionType() {
        if (this.function != null) {
            Class<?> cls = this.function.getClass();
            if (cls.equals(ConstanteFunction.class)) {
                if (this.function.getType().equals(CONSTANTE)) {
                    return CONSTANTE;
                }
                if (this.function.getType().equals(DEFAULTMAX)) {
                    return DEFAULTMAX;
                }
                return DEFAULTMIN;
            }
            if (cls.equals(LinearFunction.class)) {
                return LINEAR;
            }
            if (cls.equals(AbsFunction.class)) {
                return ABS_LINEAR;
            }
            if (cls.equals(QuadraticFunction.class)) {
                return QUADRATIC;
            }
            if (cls.equals(QuadraticFunction2.class)) {
                return QUADRATIC2;
            }
            if (cls.equals(x3function.class)) {
                return X3;
            }
            if (cls.equals(SigmoidFunction.class)) {
                return SIGMOID;
            }
            if (cls.equals(Sigmoid2Function.class)) {
                return SIGMOID2;
            }
            if (cls.equals(ComplexSigmoidFunction.class)) {
                return COMPLEXSIGMOID;
            }
            if (cls.equals(ComplexSigmoid2Function.class)) {
                return COMPLEXSIGMOID2;
            }
            if (cls.equals(GaussianFunction.class)) {
                return GAUSSIAN;
            }
        }
        return null;
    }
}

