/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.evolLauncher;

import SocLab.GUI.desktop.DesktopFrame;
import SocLab.GUI.evolLauncher.GraphicalEvolLauncher;
import SocLab.GUI.evolLauncher.paramsPanels.EvolSimuParamTabbedPane;
import SocLab.GUI.simuLauncher.SimulationProgressBar;
import SocLab.core.ActorNew;
import SocLab.core.OrgNew;
import SocLab.core.RelationNew;
import SocLab.core.Simu;
import SocLab.core.SocLabToolkit;
import SocLab.tools.arrayKit.ArrayKit;
import SocLab.tools.fileKit.FileKit;
import SocLab.tools.fileKit.OrgIOToolkit;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JDesktopPane;
import javax.swing.JOptionPane;
import org.apache.commons.math.stat.StatUtils;

class MyThread
extends Thread {
    private String choosedFile;
    private boolean isFuzzyStakes;
    private boolean isFuzzySolidarities;
    private EvolSimuParamTabbedPane simuTabbedPane;
    private double[][][] valStakes;
    private double[][][] valStakes2;
    private double[][] metaScores;
    private double[][] resultsForAnalysis;
    private int nb_step;
    private double[][] effect_rules;
    private double[][] savedSAT;
    private double[][] savedFinalSAT;
    private double[] savedMeanSAT;
    private double[] savedStandevSAT;
    private double[][] savedTE;
    private double[][] savedFinalTE;
    private double[] savedMeanTE;
    private double[] savedMedianTE;
    private double[] savedStandevTE;
    private double[] savedConv;

    MyThread(JDesktopPane desktop, String cf, boolean ifst, boolean ifso, GraphicalEvolLauncher gs) {
        this.choosedFile = cf;
        this.isFuzzyStakes = ifst;
        this.isFuzzySolidarities = ifso;
        this.simuTabbedPane = gs.simuTabbedPane;
    }

    @Override
    public void run() {
        String simuPath = null;
        int nb_runs = SocLabToolkit.currentOrgNew.getNbRuns();
        this.nb_step = SocLabToolkit.currentOrgNew.getNbSteps();
        OrgNew org0 = SocLabToolkit.currentOrgNew;
        this.savedFinalSAT = new double[org0.getNbActorsNew()][nb_runs];
        this.savedMeanSAT = new double[org0.getNbActorsNew()];
        this.savedStandevSAT = new double[org0.getNbActorsNew()];
        this.savedFinalTE = new double[org0.getNbRelationsNew()][nb_runs];
        this.savedMeanTE = new double[org0.getNbRelationsNew()];
        this.savedMedianTE = new double[org0.getNbRelationsNew()];
        this.savedStandevTE = new double[org0.getNbRelationsNew()];
        this.savedConv = new double[nb_runs];
        File savedOrgNew = null;
        OrgNew org = null;
        try {
            org = SocLabToolkit.currentOrgNew;
            savedOrgNew = new File(String.valueOf(SocLabToolkit.orgFileNew.getAbsolutePath()) + "Temp");
            OrgIOToolkit.saveOrgTempForSimulation(org, savedOrgNew);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.valStakes = new double[org.getNbActorsNew()][org.getNbRelationsNew() + 3][org.nbStructStepMax];
        this.valStakes2 = new double[org.getNbRelationsNew()][org.getNbActorsNew() + 3][org.nbStructStepMax];
        this.resultsForAnalysis = new double[org.getNbActorsNew() * org.getNbRelationsNew() + org.getNbRelationsNew() + org.getNbActorsNew() + org.getNbActorsNew() + 1][org.nbStructStepMax];
        this.metaScores = new double[4][org.nbStructStepMax];
        if (DesktopFrame.smb == null) {
            DesktopFrame.smb = new SimulationProgressBar();
            DesktopFrame.desktopPanel.add(DesktopFrame.smb);
        }
        DesktopFrame.smb.init(nb_runs * org.nbStructStepMax);
        int i = 0;
        while (i < DesktopFrame.getFrames().length) {
            DesktopFrame.getFrames()[i].setEnabled(false);
            ++i;
        }
        int runs = 0;
        while (runs < nb_runs) {
            ActorNew aN;
            int i2;
            String[] aNames;
            try {
                System.out.println("ici je dois recuperer le fichier org");
                String currentSimPath = org.getCurrentSimulationPath();
                org = SocLabToolkit.getAnOrg(savedOrgNew);
                SocLabToolkit.setCurrentOrgNew(org);
                org.setCurrentSimulationPath(currentSimPath);
                SocLabToolkit.currentOrgNew.nbStepConvergence = new String[nb_runs][3];
                SocLabToolkit.currentOrgNew.headNbEtapesNec = 0;
                this.simuTabbedPane.updateParams(org);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.isFuzzyStakes) {
                System.out.println("\tFuzzy Stakes");
                if (org != null) {
                    aNames = org.getActorsNewName();
                    i2 = 0;
                    while (i2 < aNames.length) {
                        aN = org.getActorNew(aNames[i2]);
                        org.initStakesInFuzzyMode(aN);
                        ++i2;
                    }
                }
            }
            if (this.isFuzzySolidarities) {
                System.out.println("\tFuzzy Solidarities");
                if (org != null) {
                    aNames = org.getActorsNewName();
                    i2 = 0;
                    while (i2 < aNames.length) {
                        aN = org.getActorNew(aNames[i2]);
                        org.initSolidaritiesInFuzzyMode(aN);
                        ++i2;
                    }
                }
            }
            this.initialiseActorBeforeSimulation(org);
            simuPath = String.valueOf(this.choosedFile) + File.separatorChar + "run_" + runs + File.separatorChar;
            int nbStructStep = 0;
            while (nbStructStep < org.nbStructStepMax) {
                DesktopFrame.smb.updateCurrentRun(runs * org.nbStructStepMax + nbStructStep);
                System.out.println("--------debut de l iteration de structure " + nbStructStep + "/" + org.nbStructStepMax);
                this.saveStakesActorNewsNewForLogs(org, nbStructStep);
                this.savedSAT = new double[org.getNbActorsNew()][this.nb_step + 1];
                this.effect_rules = new double[org0.getNbActorsNew()][this.nb_step + 1];
                this.savedTE = new double[org.getNbRelationsNew()][this.nb_step + 1];
                ArrayList<Double> moyenneSatis = new ArrayList<Double>();
                int act = 0;
                while (act < org.getNbActorsNew()) {
                    moyenneSatis.add(0.0);
                    ++act;
                }
                int nbSimuMoyenne = org.nbSimuForAStep;
                int step = 0;
                if (org.nbStructStepMax == 1) {
                    nbSimuMoyenne = 1;
                }
                int i3 = 0;
                while (i3 < nbSimuMoyenne) {
                    Simu simu = new Simu(org);
                    this.simuTabbedPane.teParams.reinitParams(org);
                    for (ActorNew an : org.getActorsNew()) {
                        an.reset();
                    }
                    step = this.doSimulation(org, runs, simu);
                    System.out.println("simu " + (i3 + 1) + "/" + nbSimuMoyenne);
                    int ind = 0;
                    for (RelationNew r : org.getRelationsNew()) {
                        this.resultsForAnalysis[org.getNbActorsNew() * org.getNbRelationsNew() + ind][nbStructStep] = r.getRPNCurrent().getState();
                        ++ind;
                    }
                    this.resultsForAnalysis[this.resultsForAnalysis.length - 1][nbStructStep] = step;
                    int actId = 0;
                    while (actId < org.getNbActorsNew()) {
                        this.savedFinalSAT[actId][runs] = this.savedSAT[actId][step];
                        ++actId;
                    }
                    int relId = 0;
                    while (relId < org.getNbRelationsNew()) {
                        double tutu;
                        this.savedFinalTE[relId][runs] = tutu = this.savedTE[relId][step - 1];
                        ++relId;
                    }
                    this.savedConv[runs] = step;
                    int j = 0;
                    for (ActorNew an : org.getActorsNew()) {
                        moyenneSatis.set(j, (Double)moyenneSatis.get(j) + an.getSatisfaction(an, an.getCurrentState()) / (double)nbSimuMoyenne);
                        ++j;
                    }
                    ++i3;
                }
                int act2 = 0;
                while (act2 < org.getNbActorsNew()) {
                    ActorNew actk = org.getActorsNew().get(act2);
                    actk.MoyenneSatisfaction = (Double)moyenneSatis.get(act2);
                    ++act2;
                }
                this.saveRealSatisfactions(org, nbStructStep);
                this.saveMeanEvolution(org, nbStructStep);
                if (nbStructStep != org.nbStructStepMax - 1) {
                    int i4;
                    boolean stable = true;
                    if (org.natureOfModifs == 0) {
                        int actAModif = org.actorToModify;
                        i4 = 0;
                        while (i4 < org.getNbActorsNew()) {
                            if (org.nbOfModif == 0) {
                                actAModif = i4;
                            } else {
                                i4 = org.getNbActorsNew();
                            }
                            Integer decision = org.getActorsNew().get(actAModif).StructuralActs(nbStructStep);
                            this.valStakes[actAModif][org.getNbRelationsNew()][nbStructStep] = new Integer(decision).intValue();
                            if (!org.getActorsNew().get(actAModif).isStrucStable()) {
                                stable = false;
                            }
                            ++i4;
                        }
                    }
                    if (org.natureOfModifs == 1) {
                        int actAModif = org.actorToModify;
                        i4 = 0;
                        while (i4 < org.getNbActorsNew()) {
                            if (org.nbOfModif == 0) {
                                actAModif = i4;
                            } else {
                                i4 = org.getNbActorsNew();
                            }
                            Integer decision = org.getActorsNew().get(actAModif).StructuralActsOnOthers(nbStructStep);
                            this.valStakes[actAModif][org.getNbRelationsNew()][nbStructStep] = new Integer(decision).intValue();
                            if (!org.getActorsNew().get(actAModif).isStrucStable()) {
                                stable = false;
                            }
                            ++i4;
                        }
                    }
                    if (stable) {
                        System.out.println("STRUCTURE STABLE");
                        break;
                    }
                }
                this.savedTE = ArrayKit.reduce(this.savedTE, step);
                this.savedSAT = ArrayKit.reduce(this.savedSAT, step);
                this.effect_rules = ArrayKit.reduce(this.effect_rules, step);
                ++nbStructStep;
            }
            String[] columnNames = this.getColumnNameValStake(org);
            int actId = 0;
            while (actId < org.getNbActorsNew()) {
                FileKit.saveDatasArrayStandard(simuPath, "stakes " + org.getActorsNew().get(actId).getName(), this.valStakes[actId], columnNames);
                ++actId;
            }
            columnNames = this.getColumnNameMetaScore(org);
            FileKit.saveDatasArrayStandard(simuPath, "indicateurs", this.metaScores, columnNames);
            columnNames = this.getColumnNameValStake2(org);
            int relId = 0;
            while (relId < org0.getNbRelationsNew()) {
                FileKit.saveDatasArrayStandard(simuPath, "stakesRel " + org.getRelationsNew().get(relId).getName(), this.valStakes2[relId], columnNames);
                this.savedMeanTE[relId] = StatUtils.mean((double[])this.savedFinalTE[relId]);
                this.savedMedianTE[relId] = StatUtils.percentile((double[])this.savedFinalTE[relId], (double)50.0);
                this.savedStandevTE[relId] = Math.sqrt(StatUtils.variance((double[])this.savedFinalTE[relId]));
                ++relId;
            }
            int step = 0;
            while (step < org.nbStructStepMax) {
                int act = 0;
                while (act < org.getNbActorsNew()) {
                    int rel = 0;
                    while (rel < org.getNbRelationsNew()) {
                        this.resultsForAnalysis[act * org.getNbRelationsNew() + rel][step] = this.valStakes[act][rel][step];
                        ++rel;
                    }
                    ++act;
                }
                int indSatisPow = org.getNbActorsNew() * org.getNbRelationsNew() + org.getNbRelationsNew();
                int i5 = 0;
                while (i5 < org.getNbActorsNew()) {
                    this.resultsForAnalysis[indSatisPow + i5][step] = this.valStakes[i5][org.getNbRelationsNew() + 1][step];
                    this.resultsForAnalysis[indSatisPow + org.getNbActorsNew() + i5][step] = this.valStakes[i5][org.getNbRelationsNew() + 2][step];
                    ++i5;
                }
                columnNames = this.getColumnNameAnalyse(org);
                FileKit.saveDatasArrayStandard(simuPath, "pourAnalyse", this.resultsForAnalysis, columnNames);
                ++step;
            }
            ++runs;
        }
        int actId = 0;
        while (actId < org0.getNbActorsNew()) {
            this.savedMeanSAT[actId] = StatUtils.mean((double[])this.savedFinalSAT[actId]);
            this.savedStandevSAT[actId] = Math.sqrt(StatUtils.variance((double[])this.savedFinalSAT[actId]));
            ++actId;
        }
        simuPath = this.choosedFile;
        org = SocLabToolkit.getAnOrg(savedOrgNew);
        SocLabToolkit.setCurrentOrgNew(org);
        savedOrgNew.delete();
        DesktopFrame.smb.setVisible(false);
        i = 0;
        while (i < DesktopFrame.getFrames().length) {
            DesktopFrame.getFrames()[i].setEnabled(true);
            ++i;
        }
        if (SocLabToolkit.currentOrgNew.incoherent) {
            JOptionPane.showMessageDialog(DesktopFrame.desktopPanel, "Model incoherent, Simulation has been stopped ...", "Error", -1);
        }
    }

    private String[] getColumnNameAnalyse(OrgNew org) {
        String[] temp = new String[this.resultsForAnalysis[0].length];
        int currentIndice = 0;
        int nbActorNewsNew = org.getNbActorsNew();
        int i = 0;
        while (i < nbActorNewsNew) {
            int j = 0;
            while (j < org.getNbRelationsNew()) {
                temp[currentIndice] = "stake " + org.getActorsNew().get(i).getName() + " | " + org.getRelationsNew().get(j).getName();
                ++currentIndice;
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < org.getNbRelationsNew()) {
            temp[currentIndice] = "state " + org.getRelationsNew().get(j).getName();
            ++j;
            ++currentIndice;
        }
        i = 0;
        while (i < nbActorNewsNew) {
            temp[currentIndice] = "sat " + org.getActorsNew().get(i).getName();
            ++i;
            ++currentIndice;
        }
        i = 0;
        while (i < nbActorNewsNew) {
            temp[currentIndice] = "pow " + org.getActorsNew().get(i).getName();
            ++i;
            ++currentIndice;
        }
        temp[currentIndice] = "nbStepRegul";
        return temp;
    }

    private String[] getColumnNameValStake2(OrgNew org) {
        String[] temp = new String[this.valStakes[0].length];
        int nbActorNewsNew = org.getNbActorsNew();
        int i = 0;
        while (i < nbActorNewsNew) {
            temp[i] = org.getActorsNew().get(i).getName();
            ++i;
        }
        temp[nbActorNewsNew] = "0";
        temp[nbActorNewsNew + 1] = "etatFinRegulation";
        return temp;
    }

    private String[] getColumnNameMetaScore(OrgNew org) {
        String[] temp = new String[this.valStakes[0].length];
        temp[0] = "satisfaction moyenne";
        temp[1] = "pouvoir moyen";
        temp[2] = "ecart type satis";
        temp[3] = "ecart type pouvoir";
        return temp;
    }

    private String[] getColumnNameValStake(OrgNew org) {
        String[] temp = new String[this.valStakes[0].length];
        int nbRelationsNew = org.getNbRelationsNew();
        int i = 0;
        while (i < nbRelationsNew) {
            temp[i] = org.getRelationsNew().get(i).getName();
            ++i;
        }
        temp[nbRelationsNew] = "choix";
        temp[nbRelationsNew + 1] = "satisfaction";
        temp[nbRelationsNew + 2] = "pouvoir";
        return temp;
    }

    private void saveRealSatisfactions(OrgNew org, int nbStructStep) {
        int actId = 0;
        for (ActorNew a : org.getActorsNew()) {
            this.valStakes[actId][org.getNbRelationsNew() + 1][nbStructStep] = a.getSatisStruct(false);
            this.valStakes[actId][org.getNbRelationsNew() + 2][nbStructStep] = a.getSatisStruct(true);
            ++actId;
        }
    }

    private void saveMeanEvolution(OrgNew org, int nbStructStep) {
        double sumSatis = 0.0;
        double sumPower = 0.0;
        int i = 0;
        while (i < org.getNbActorsNew()) {
            sumSatis += org.getActorsNew().get(i).getSatisStruct(false);
            sumPower += org.getActorsNew().get(i).getSatisStruct(true);
            ++i;
        }
        this.metaScores[0][nbStructStep] = sumSatis / (double)org.getNbActorsNew();
        this.metaScores[1][nbStructStep] = sumPower / (double)org.getNbActorsNew();
        double ecartTypeSatis = 0.0;
        double ecartTypePower = 0.0;
        int i2 = 0;
        while (i2 < org.getNbActorsNew()) {
            ecartTypeSatis += Math.abs(this.metaScores[0][nbStructStep] - org.getActorsNew().get(i2).getSatisStruct(false));
            ecartTypePower += Math.abs(this.metaScores[1][nbStructStep] - org.getActorsNew().get(i2).getSatisStruct(true));
            ++i2;
        }
        this.metaScores[2][nbStructStep] = ecartTypeSatis / (double)org.getNbActorsNew();
        this.metaScores[3][nbStructStep] = ecartTypePower / (double)org.getNbActorsNew();
    }

    private void saveStakesActorNewsNewForLogs(OrgNew org, int nbStructStep) {
        int actId = 0;
        while (actId < org.getNbActorsNew()) {
            ActorNew a = org.getActorsNew().get(actId);
            int relID = 0;
            while (relID < org.getNbRelationsNew()) {
                double d;
                RelationNew rn = org.getRelationsNew().get(relID);
                this.valStakes[actId][relID][nbStructStep] = d = rn.getDepend(a.getName()).getStake();
                this.valStakes2[relID][actId][nbStructStep] = d;
                this.valStakes2[relID][org.getNbActorsNew() + 1][nbStructStep] = rn.getRPNCurrent().getState();
                ++relID;
            }
            ++actId;
        }
    }

    private void initialiseActorBeforeSimulation(OrgNew org) {
        for (ActorNew a : org.getActorsNew()) {
            double sumControl = a.sumControl();
            if (sumControl < 5.0) {
                a.setMinControlStake(Math.min((double)(10 - org.upLimit), sumControl));
                a.setMaxControlStake(org.upLimit);
                continue;
            }
            a.setMinControlStake(10 - org.upLimit);
            a.setMaxControlStake(Math.max((double)org.upLimit, sumControl));
        }
    }

    private int doSimulation(OrgNew orgNew, int runs, Simu simu) {
        SocLabToolkit.currentOrgNew.incoherent = false;
        int step = 0;
        while (step < this.nb_step) {
            String[] aNames = orgNew.getActorsNewName();
            int actId = 0;
            while (actId < orgNew.getNbActorsNew()) {
                double local_bilan;
                this.savedSAT[actId][step] = local_bilan = orgNew.getActorNew(aNames[actId]).getActualSatisfaction();
                ++actId;
            }
            String[] rNames = orgNew.getRelationsNewName();
            int i = 0;
            while (i < rNames.length) {
                double var;
                RelationNew rN = orgNew.getRelationNew(rNames[i]);
                this.savedTE[i][step] = var = rN.getRPNCurrent().getState();
                ++i;
            }
            if (orgNew.allActorSatisfied()) {
                SocLabToolkit.currentOrgNew.nbStepConvergence[runs][0] = new String(String.valueOf(runs));
                SocLabToolkit.currentOrgNew.nbStepConvergence[runs][1] = "Oui";
                SocLabToolkit.currentOrgNew.nbStepConvergence[runs][2] = new String(String.valueOf(step));
                ++SocLabToolkit.currentOrgNew.headNbEtapesNec;
                break;
            }
            simu.step();
            if (orgNew.incoherent) {
                DesktopFrame.statusBar.setText("Model incoherent, Simulation has been stopped ...");
                step = this.nb_step;
                break;
            }
            if (step == this.nb_step - 2) {
                SocLabToolkit.currentOrgNew.nbStepConvergence[runs][0] = new String(String.valueOf(runs));
                SocLabToolkit.currentOrgNew.nbStepConvergence[runs][1] = "Non";
                SocLabToolkit.currentOrgNew.nbStepConvergence[runs][2] = "-";
                ++SocLabToolkit.currentOrgNew.headNbEtapesNec;
            }
            ++step;
        }
        return step;
    }
}

