/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.modelEditor.ParamsPanels;

import SocLab.core.OrgNew;
import SocLab.core.structures.Control;
import javax.swing.table.AbstractTableModel;

class OrgTableModel
extends AbstractTableModel {
    private OrgNew orgNew;
    private String param;
    private Boolean editMode = false;

    OrgTableModel(String param) {
        this.param = param;
    }

    @Override
    public int getColumnCount() {
        if (this.orgNew != null) {
            if (this.param.equals("control")) {
                return this.orgNew.getNbActorsNew() + 4;
            }
            if (this.param.equals("constraint")) {
                return this.orgNew.getNbRelationsNew() + 1;
            }
            return this.orgNew.getNbActorsNew() + 1;
        }
        return 0;
    }

    @Override
    public int getRowCount() {
        if (this.orgNew != null) {
            if (this.param.equals("solidarity") || this.param.equals("fuzzyAltruism")) {
                return this.orgNew.getNbActorsNew() + 1;
            }
            return this.orgNew.getNbRelationsNew() + 1;
        }
        return 0;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.orgNew != null) {
            String[] actorNames = this.orgNew.getActorsNewName();
            String[] relationNames = this.orgNew.getRelationsNewName();
            if (row == 0 && col == actorNames.length + 1 && this.param.equals("control")) {
                return "<html><b><u><font color=blue>Frequency</font></u></b></html>";
            }
            if (row == 0 && col == actorNames.length + 2 && this.param.equals("control")) {
                return "<html><b><u><font color=blue>Bmin</font></u></b></html>";
            }
            if (row == 0 && col == actorNames.length + 3 && this.param.equals("control")) {
                return "<html><b><u><font color=blue>Bmax</font></u></b></html>";
            }
            if (row > 0 && col == 0) {
                if (this.param.equals("solidarity") || this.param.equals("fuzzyAltruism")) {
                    return "<html><b><u><font color=blue>" + actorNames[row - 1] + "</font></u></b></html>";
                }
                return "<html><b><u><font color=blue>" + relationNames[row - 1] + "</font></u></b></html>";
            }
            if (row == 0 && col == 0 && (this.param.equals("solidarity") || this.param.equals("fuzzyAltruism") || this.param.equals("constraint"))) {
                return "     -->    ";
            }
            if (row == 0 && col > 0) {
                if (this.param.equals("constraint")) {
                    return "<html><b><u><font color=blue>" + relationNames[col - 1] + "</font></u></b></html>";
                }
                return "<html><b><u><font color=blue>" + actorNames[col - 1] + "</font></u></b></html>";
            }
            if (row > 0 && col > 0) {
                if (this.param.equals("stake")) {
                    String actorName = actorNames[col - 1];
                    String relationName = relationNames[row - 1];
                    return this.shiftDecimal(this.orgNew.getActorNew(actorName).getDepend(relationName).getStake(), 2);
                }
                if (this.param.equals("control")) {
                    if (col == actorNames.length + 1) {
                        String relationName = relationNames[row - 1];
                        return this.shiftDecimal(this.orgNew.getRelationNew(relationName).getRPNInitial().getFrequency(), 2);
                    }
                    if (col == actorNames.length + 2) {
                        String relationName = relationNames[row - 1];
                        return this.shiftDecimal(this.orgNew.getRelationNew(relationName).getRPNInitial().getLowerBound(), 2);
                    }
                    if (col == actorNames.length + 3) {
                        String relationName = relationNames[row - 1];
                        return this.shiftDecimal(this.orgNew.getRelationNew(relationName).getRPNInitial().getUpperBound(), 2);
                    }
                    String relationName = relationNames[row - 1];
                    String actorName = actorNames[col - 1];
                    if (this.orgNew.getRelationNew(relationName).getControlActor().getActorNew() == null) {
                        return false;
                    }
                    if (this.orgNew.getRelationNew(relationName).getControlActor().getActorNew().getName().equals(actorName)) {
                        return true;
                    }
                    return false;
                }
                if (this.param.equals("solidarity")) {
                    String actorName = actorNames[col - 1];
                    String actorNameS = actorNames[row - 1];
                    return this.shiftDecimal(this.orgNew.getActorNew(actorName).getSource(actorNameS).getSolidarity(), 2);
                }
                if (this.param.equals("effect")) {
                    String actorName = actorNames[col - 1];
                    String relationName = relationNames[row - 1];
                    return this.orgNew.getActorNew(actorName).getDepend(relationName).getEffectNew();
                }
                if (this.param.equals("constraint")) {
                    String relationTName = relationNames[col - 1];
                    String relationName = relationNames[row - 1];
                    return this.orgNew.getRelationNew(relationName).getTarget(relationTName);
                }
                if (this.param.equals("fuzzyAltruism")) {
                    double[] val = new double[2];
                    String actorNameS = actorNames[row - 1];
                    String actorName = actorNames[col - 1];
                    val[0] = this.orgNew.getActorNew(actorName).getSource(actorNameS).getFuzzySolidarityMin();
                    val[1] = this.orgNew.getActorNew(actorName).getSource(actorNameS).getFuzzySolidarityMax();
                    return val;
                }
                if (this.param.equals("fuzzyStake")) {
                    double[] val = new double[2];
                    String actorName = actorNames[col - 1];
                    String relationName = relationNames[row - 1];
                    val[0] = this.orgNew.getActorNew(actorName).getDepend(relationName).getFuzzyStakeMin();
                    val[1] = this.orgNew.getActorNew(actorName).getDepend(relationName).getFuzzyStakeMax();
                    return val;
                }
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int col) {
        return " ";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col > 0 && row > 0 && this.editMode != false && !this.param.equals("effect") && !this.param.equals("constraint");
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        String actorNameS;
        double[] val;
        String actorName;
        String relationName;
        String[] actorNames = this.orgNew.getActorsNewName();
        String[] relationNames = this.orgNew.getRelationsNewName();
        if (this.param.equals("control")) {
            if (col == actorNames.length + 1) {
                relationName = relationNames[row - 1];
                this.orgNew.getRelationNew(relationName).getRPNInitial().setFrequency(new Double((String)value));
            } else if (col == actorNames.length + 2) {
                relationName = relationNames[row - 1];
                this.orgNew.getRelationNew(relationName).getRPNInitial().setLowerBound(new Double((String)value));
            } else if (col == actorNames.length + 3) {
                relationName = relationNames[row - 1];
                this.orgNew.getRelationNew(relationName).getRPNInitial().setUpperBound(new Double((String)value));
            } else if (((Boolean)value).booleanValue()) {
                actorName = actorNames[col - 1];
                relationName = relationNames[row - 1];
                Control c = new Control(this.orgNew.getActorNew(actorName), this.orgNew.getRelationNew(relationName));
                if (this.orgNew.getRelationNew(relationName).getControlActor().getActorNew() != null) {
                    String oldController = this.orgNew.getRelationNew(relationName).getControlActor().getActorNew().getName();
                    this.orgNew.getActorNew(oldController).delControl(this.orgNew.getRelationNew(relationName).getControlActor());
                }
                this.orgNew.getActorNew(actorName).setControl(c);
                this.orgNew.getRelationNew(relationName).setControlActor(c);
            }
        }
        if (this.param.equals("stake")) {
            actorName = actorNames[col - 1];
            relationName = relationNames[row - 1];
            this.orgNew.getActorNew(actorName).getDepend(relationName).setStake(new Double((String)value));
        }
        if (this.param.equals("fuzzyStake")) {
            actorName = actorNames[col - 1];
            relationName = relationNames[row - 1];
            val = (double[])value;
            this.orgNew.getActorNew(actorName).getDepend(relationName).setFuzzyStakeMin(val[0]);
            this.orgNew.getActorNew(actorName).getDepend(relationName).setFuzzyStakeMax(val[1]);
        }
        if (this.param.equals("solidarity")) {
            actorName = actorNames[col - 1];
            actorNameS = actorNames[row - 1];
            this.orgNew.getActorNew(actorName).getSource(actorNameS).setSolidarity(new Double((String)value));
        }
        if (this.param.equals("fuzzyAltruism")) {
            actorName = actorNames[col - 1];
            val = (double[])value;
            actorNameS = actorNames[row - 1];
            this.orgNew.getActorNew(actorName).getSource(actorNameS).setFuzzySolidarityMin(val[0]);
            this.orgNew.getActorNew(actorName).getSource(actorNameS).setFuzzySolidarityMax(val[1]);
        }
    }

    void orgNewUpdate(OrgNew orgNew) {
        this.orgNew = orgNew;
        this.fireTableDataChanged();
        this.fireTableStructureChanged();
    }

    void cellUpdate(int row, int col) {
        this.fireTableCellUpdated(row, col);
    }

    public Boolean getEditMode() {
        return this.editMode;
    }

    public void setEditMode(Boolean editMode) {
        this.editMode = editMode;
    }

    private double shiftDecimal(double d, int decay) {
        double coef = Math.pow(10.0, decay);
        double result = d * coef;
        return (double)Math.round(result) / coef;
    }
}

