/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.sensiLauncher.paramsPanels;

import SocLab.GUI.desktop.DesktopFrame;
import SocLab.GUI.sensiLauncher.GraphicalSensiLauncher;
import SocLab.GUI.sensiLauncher.paramsPanels.ExpParams;
import SocLab.GUI.sensiLauncher.paramsPanels.SensitivityDescEditor;
import SocLab.GUI.simuLauncher.paramsPanels.AgentParams;
import SocLab.GUI.simuLauncher.paramsPanels.TEParams;
import SocLab.core.SocLabToolkit;
import SocLab.core.SwitchLanguages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class SensiParamTabbedPane
extends JPanel {
    private GraphicalSensiLauncher project;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private TEParams teParams;
    public AgentParams agentParams;
    private ExpParams expParams;
    private SensitivityDescEditor sensiDescEditor;
    private JButton validate = new JButton("Accept");

    public SensiParamTabbedPane(GraphicalSensiLauncher project, JDesktopPane desktop) {
        this.project = project;
        this.validate.setIcon(DesktopFrame.okIcon);
        this.validate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SensiParamTabbedPane.this.updateParams();
            }
        });
        this.teParams = new TEParams();
        this.agentParams = new AgentParams();
        this.expParams = new ExpParams(project);
        this.sensiDescEditor = new SensitivityDescEditor();
        this.tabbedPane.add((Component)this.teParams, "Initial States");
        this.tabbedPane.add((Component)this.agentParams, "Actors Parameters");
        this.tabbedPane.add((Component)this.expParams, "Experiences Parameters");
        this.tabbedPane.add((Component)this.sensiDescEditor, "Sensitivity Description");
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)this.validate, "South");
        this.setVisible(true);
    }

    private void updateParams() {
        this.project.sensiParams.updateParams();
        this.teParams.updateParams();
        this.agentParams.updateParams();
        this.expParams.updateParams();
        this.sensiDescEditor.updateParams();
    }

    public void initValues() {
        this.project.sensiParams.initValues();
        this.teParams.initValues(this.project.getGraphics());
        this.agentParams.initValues(this.project.getGraphics());
        this.expParams.initValues();
        this.sensiDescEditor.initValues();
        this.switchLanguage();
    }

    public void switchLanguage() {
        this.validate.setText(SwitchLanguages.SensiParamsTabbedPaneButtonValidate[SocLabToolkit.idLanguage]);
        if (this.tabbedPane != null) {
            this.tabbedPane.setTitleAt(0, SwitchLanguages.SensiParamsTabbedPaneButtonTabbedPaneInitialState[SocLabToolkit.idLanguage]);
            this.tabbedPane.setTitleAt(1, SwitchLanguages.SensiParamsTabbedPaneButtonTabbedPaneAgentParameters[SocLabToolkit.idLanguage]);
            this.tabbedPane.setTitleAt(2, SwitchLanguages.SensiParamsTabbedPaneButtonTabbedPaneExperiencesParameters[SocLabToolkit.idLanguage]);
            this.tabbedPane.setTitleAt(3, SwitchLanguages.SensiParamsTabbedPaneButtonTabbedPaneSensitivityDescription[SocLabToolkit.idLanguage]);
        }
        this.project.sensiParams.switchLanguage();
        this.teParams.switchLanguage();
        this.agentParams.switchLanguage();
        this.sensiDescEditor.switchLanguage();
    }
}

