/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.simuLauncher;

import SocLab.GUI.desktop.DesktopFrame;
import SocLab.GUI.simuLauncher.MyThread;
import SocLab.GUI.simuLauncher.paramsPanels.SimuParamTabbedPane;
import SocLab.GUI.simuLauncher.paramsPanels.SimuParams;
import SocLab.core.ActorNew;
import SocLab.core.OrgNew;
import SocLab.core.RelationNew;
import SocLab.core.SocLabToolkit;
import SocLab.core.SwitchLanguages;
import SocLab.tools.RTFReports;
import controller.simuSynthesis.AnyObservationIsConvergingException;
import controller.simuSynthesis.ControllerImpl;
import input.WrongFormException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.border.Border;

public class GraphicalSimuLauncher
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    private JComponent currentParamPanel = null;
    public SimuParams simuParams = new SimuParams(this);
    private JDesktopPane desktop;
    private JPanel orgPanel = new JPanel();
    private JSplitPane listPanel;
    private JPanel controlPanel = new JPanel();
    private SimuParamTabbedPane simuTabbedPane;
    private JPanel radioPanel = new JPanel(new GridBagLayout());
    private JButton openSimu = new JButton("Open Previous Simulations");
    private JButton runButton = new JButton("Run!");
    private JButton resultButton = new JButton("View Results");
    private JButton synthesesButton = new JButton("Synthesis of result");
    private JButton stateAnalysisButton = new JButton("State Analysis");
    private JButton reportButton = new JButton("Save report");
    private JButton clearReportButton = new JButton("Clear report");
    private JRadioButton firstButton;
    private JRadioButton secondButton;
    private JRadioButton thirdButton;
    private JRadioButton fourthButton;
    private JCheckBox withConstraints;
    private static String first = "Normal Stakes";
    private static String second = "Fuzzy Stakes";
    private static String third = "Normal Solidarities";
    private static String fourth = "Fuzzy Solidarities";
    private static boolean isFuzzyStakes = false;
    private static boolean isFuzzySolidarities = false;
    private String choosedFile;

    public GraphicalSimuLauncher(JDesktopPane desktop) {
        super("Simu explorer", true, true, true, true);
        this.setName("Simu explorer");
        this.setDefaultCloseOperation(1);
        this.setFrameIcon(DesktopFrame.runModelIcon);
        this.desktop = desktop;
        this.simuTabbedPane = new SimuParamTabbedPane(this, desktop);
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        orgNew.minMaxAims(orgNew.getActorsNew());
        this.controlPanel.setPreferredSize(new Dimension(400, 400));
        this.controlPanel.setLayout(new BorderLayout());
        this.openSimu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopFrame.preSimFileChooser.init("Open a Previous Simulation ...", "Select", false);
                int returnVal = DesktopFrame.preSimFileChooser.showOpenDialog(GraphicalSimuLauncher.this.desktop);
                if (returnVal == 0) {
                    RTFReports.simuSynImages.clear();
                    GraphicalSimuLauncher.this.openPreviousSimulation(DesktopFrame.preSimFileChooser.getSelectedFile());
                    GraphicalSimuLauncher.this.generateSummaryFile();
                }
            }
        });
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopFrame.preSimFileChooser.init("choose the folder where you want to save the simulations", "Select", true);
                int returnVal = DesktopFrame.preSimFileChooser.showOpenDialog(GraphicalSimuLauncher.this.desktop);
                if (returnVal == 0) {
                    RTFReports.simuSynImages.clear();
                    GraphicalSimuLauncher.this.choosedFile = DesktopFrame.preSimFileChooser.getSelectedFile().getPath();
                    File f1 = new File(GraphicalSimuLauncher.this.choosedFile);
                    if (!f1.exists()) {
                        f1.mkdirs();
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd_HH.mm");
                    File f2 = new File(String.valueOf(GraphicalSimuLauncher.this.choosedFile) + File.separatorChar + SocLabToolkit.currentOrgNew.getName() + "_Simulation_" + sdf.format(new Date()));
                    if (!f2.exists()) {
                        f2.mkdir();
                    }
                    GraphicalSimuLauncher.this.choosedFile = f2.getPath();
                    SocLabToolkit.currentOrgNew.setCurrentSimulationPath(GraphicalSimuLauncher.this.choosedFile);
                    GraphicalSimuLauncher.this.temporaryRun();
                    DesktopFrame.menuBar.updateMenuVisibility();
                }
            }
        });
        this.synthesesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopFrame.menuBar.simuResultsSynthesis();
            }
        });
        this.resultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopFrame.menuBar.simuResultView();
            }
        });
        this.stateAnalysisButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopFrame.menuBar.newStateAnalysis();
            }
        });
        this.reportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopFrame.menuBar.newRtfReport();
                RTFReports.simuSynImages.clear();
            }
        });
        this.clearReportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RTFReports.simuSynImages.clear();
            }
        });
        this.firstButton = new JRadioButton(first);
        this.secondButton = new JRadioButton(second);
        this.thirdButton = new JRadioButton(third);
        this.fourthButton = new JRadioButton(fourth);
        this.withConstraints = new JCheckBox("with Constraints");
        this.firstButton.setActionCommand(first);
        this.secondButton.setActionCommand(second);
        this.thirdButton.setActionCommand(third);
        this.fourthButton.setActionCommand(fourth);
        this.firstButton.setSelected(true);
        this.thirdButton.setSelected(true);
        this.runButton.setIcon(DesktopFrame.runModelIcon);
        this.resultButton.setIcon(DesktopFrame.synthesisIcon);
        this.synthesesButton.setIcon(DesktopFrame.numbersIcon);
        this.stateAnalysisButton.setIcon(DesktopFrame.stateAnalysisIcon);
        this.runButton.setToolTipText("Run simulations");
        this.resultButton.setToolTipText("Synthesis of Simulation Results");
        this.stateAnalysisButton.setToolTipText("Analysis of notable states of the game (and the mean converging state)");
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.firstButton);
        group1.add(this.secondButton);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.thirdButton);
        group2.add(this.fourthButton);
        this.firstButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(first)) {
                    isFuzzyStakes = false;
                } else {
                    isFuzzyStakes = true;
                }
            }
        });
        this.secondButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(second)) {
                    isFuzzyStakes = true;
                } else {
                    isFuzzyStakes = false;
                }
            }
        });
        this.thirdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(third)) {
                    isFuzzySolidarities = false;
                } else {
                    isFuzzySolidarities = true;
                }
            }
        });
        this.fourthButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(fourth)) {
                    isFuzzySolidarities = true;
                } else {
                    isFuzzySolidarities = false;
                }
            }
        });
        this.withConstraints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SocLabToolkit.currentOrgNew.setSimuWithConstraints(GraphicalSimuLauncher.this.withConstraints.isSelected());
                ((GraphicalSimuLauncher)GraphicalSimuLauncher.this).simuTabbedPane.agentParams.calculDistance();
            }
        });
        JPanel p1 = new JPanel(new GridBagLayout());
        GridBagConstraints cc = new GridBagConstraints();
        cc.fill = 2;
        cc.anchor = 10;
        cc.gridx = 0;
        cc.gridy = 0;
        p1.add((Component)this.firstButton, cc);
        ++cc.gridy;
        p1.add((Component)this.secondButton, cc);
        ++cc.gridy;
        p1.add((Component)this.thirdButton, cc);
        ++cc.gridy;
        p1.add((Component)this.fourthButton, cc);
        ++cc.gridy;
        p1.add((Component)this.withConstraints, cc);
        Border border = BorderFactory.createLineBorder(Color.gray, 3);
        p1.setBorder(border);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(10, 5, 10, 5);
        c.ipadx = 5;
        c.ipady = 5;
        this.radioPanel.add((Component)p1, c);
        ++c.gridy;
        this.radioPanel.add((Component)this.simuParams, c);
        ++c.gridy;
        c.insets = new Insets(1, 5, 1, 5);
        this.radioPanel.add((Component)this.openSimu, c);
        ++c.gridy;
        this.radioPanel.add((Component)this.runButton, c);
        ++c.gridy;
        this.radioPanel.add((Component)this.resultButton, c);
        ++c.gridy;
        this.radioPanel.add((Component)this.synthesesButton, c);
        ++c.gridy;
        this.radioPanel.add((Component)this.stateAnalysisButton, c);
        ++c.gridy;
        ++c.gridy;
        this.radioPanel.add((Component)this.reportButton, c);
        ++c.gridy;
        this.radioPanel.add((Component)this.clearReportButton, c);
        ++c.gridy;
        this.orgPanel.setLayout(new BorderLayout());
        this.orgPanel.add((Component)this.radioPanel, "North");
        this.listPanel = new JSplitPane(1, this.orgPanel, this.controlPanel);
        this.listPanel.setResizeWeight(0.5);
        this.listPanel.setOneTouchExpandable(true);
        this.listPanel.setContinuousLayout(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.orgPanel, "West");
        this.add((Component)this.controlPanel, "Center");
        this.setSize(1150, 550);
    }

    private void openPreviousSimulation(File file) {
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        try {
            BufferedReader in = new BufferedReader(new FileReader(file.getAbsoluteFile()));
            String str = in.readLine();
            String[] tab = new String[7];
            tab = str.split("\t");
            if (tab[0].equals("true")) {
                this.firstButton.setSelected(true);
                this.secondButton.setSelected(false);
            } else {
                this.firstButton.setSelected(false);
                this.secondButton.setSelected(true);
            }
            if (tab[1].equals("true")) {
                this.thirdButton.setSelected(true);
                this.fourthButton.setSelected(false);
            } else {
                this.thirdButton.setSelected(false);
                this.fourthButton.setSelected(true);
            }
            if (tab[2].equals("true")) {
                orgNew.setSimuWithConstraints(true);
            } else {
                orgNew.setSimuWithConstraints(false);
            }
            orgNew.setNbSteps(Integer.parseInt(tab[3]));
            orgNew.setNbRuns(Integer.parseInt(tab[4]));
            int nbActors = Integer.parseInt(tab[5]);
            int nbRelations = Integer.parseInt(tab[6]);
            if (orgNew.getNbActorsNew() == nbActors && orgNew.getNbRelationsNew() == nbRelations) {
                int j;
                boolean exist;
                boolean error = false;
                tab = new String[nbActors];
                str = in.readLine();
                str = in.readLine();
                tab = str.split("\t");
                int i = 0;
                while (i < nbActors) {
                    exist = false;
                    j = 0;
                    while (j < nbActors && !exist) {
                        if (tab[i].equals(orgNew.getActorsNewName()[j])) {
                            exist = true;
                        }
                        ++j;
                    }
                    error = !exist;
                    ++i;
                }
                tab = new String[nbRelations];
                str = in.readLine();
                str = in.readLine();
                tab = str.split("\t");
                if (!error) {
                    i = 0;
                    while (i < nbRelations) {
                        exist = false;
                        j = 0;
                        while (j < nbRelations && !exist) {
                            if (tab[i].equals(orgNew.getRelationsNewName()[j])) {
                                exist = true;
                            }
                            ++j;
                        }
                        error = !exist;
                        ++i;
                    }
                }
                if (!error) {
                    str = in.readLine();
                    str = in.readLine();
                    i = 0;
                    while (i < nbActors) {
                        str = in.readLine();
                        tab = new String[10];
                        tab = str.split("\t");
                        String actorName = tab[0];
                        ActorNew aN = orgNew.getActorNew(actorName);
                        aN.getAPNInitial().setOblivion(Double.valueOf(tab[1]));
                        aN.getAPNInitial().setReward(Double.valueOf(tab[2]));
                        aN.getAPNInitial().setScope(Double.valueOf(tab[3]));
                        aN.getAPNInitial().setTenacity(Double.valueOf(tab[4]));
                        aN.getAPNInitial().setReactivity(Double.valueOf(tab[5]));
                        aN.getAPNInitial().setMoralSensibility(Double.valueOf(tab[6]));
                        aN.getAPNInitial().setActionRange(Double.valueOf(tab[7]));
                        aN.getAPNInitial().setTypeOfRules(Double.valueOf(tab[9]));
                        aN.getAPNInitial().setRepartitionPourcentage(Double.valueOf(tab[10]));
                        ++i;
                    }
                    str = in.readLine();
                    str = in.readLine();
                    i = 0;
                    while (i < nbRelations) {
                        str = in.readLine();
                        tab = new String[4];
                        tab = str.split("\t");
                        String relationName = tab[0];
                        RelationNew rN = orgNew.getRelationNew(relationName);
                        rN.getRPNInitial().setState(Double.valueOf(tab[1]));
                        rN.getRPNInitial().setLowerBound(Double.valueOf(tab[2]));
                        rN.getRPNInitial().setUpperBound(Double.valueOf(tab[3]));
                        ++i;
                    }
                    str = in.readLine();
                    str = in.readLine();
                    String description = "";
                    while (!str.equals(" - - - - - - - - - - ")) {
                        description = String.valueOf(description) + str;
                        str = in.readLine();
                    }
                    orgNew.setSimuDescription(description);
                    orgNew.setCurrentSimulationPath(file.getParent());
                    DesktopFrame.simuLauncher.update();
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void generateSummaryFile() {
        String simulationsPath = SocLabToolkit.currentOrgNew.getCurrentSimulationPath();
        ControllerImpl c = new ControllerImpl();
        if (simulationsPath != null && new File(simulationsPath).exists()) {
            try {
                c.loadResults(simulationsPath);
                c.createSummaryFiles(simulationsPath, "synthesis." + SocLabToolkit.orgFileNew.getName() + ".txt");
            }
            catch (WrongFormException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (AnyObservationIsConvergingException anyObservationIsConvergingException) {
                // empty catch block
            }
        }
    }

    private void temporaryRun() {
        MyThread mt = new MyThread(this.desktop, isFuzzyStakes, isFuzzySolidarities);
        mt.start();
    }

    private void switchPanel(JComponent component) {
        if (this.currentParamPanel != null) {
            this.controlPanel.remove(this.currentParamPanel);
        }
        this.currentParamPanel = component;
        this.controlPanel.add((Component)this.currentParamPanel, "Center");
        this.currentParamPanel.paintAll(this.currentParamPanel.getGraphics());
    }

    public void update() {
        if (SocLabToolkit.currentOrgNew != null) {
            this.simuTabbedPane.initValues();
            this.withConstraints.setSelected(SocLabToolkit.currentOrgNew.getSimuWithConstraints());
            OrgNew orgNew = SocLabToolkit.currentOrgNew;
            this.setTitle("Model > " + orgNew.getName());
            this.switchPanel(this.simuTabbedPane);
            this.switchLanguage();
            orgNew.minMaxAims(orgNew.getActorsNew());
        }
    }

    public void switchLanguage() {
        this.runButton.setText(SwitchLanguages.GraphicalSimuLauncherButtonRun[SocLabToolkit.idLanguage]);
        this.runButton.setToolTipText(SwitchLanguages.GraphicalSimuLauncherButtonRunTooltip[SocLabToolkit.idLanguage]);
        this.resultButton.setText(SwitchLanguages.GraphicalSimuLauncherButtonSynthesis[SocLabToolkit.idLanguage]);
        this.resultButton.setToolTipText(SwitchLanguages.GraphicalSimuLauncherButtonSynthesisTooltip[SocLabToolkit.idLanguage]);
        this.synthesesButton.setText(SwitchLanguages.GraphicalSimuLauncherButtonResult[SocLabToolkit.idLanguage]);
        this.stateAnalysisButton.setText(SwitchLanguages.GraphicalSimuLauncherButtonStateAnalysis[SocLabToolkit.idLanguage]);
        this.stateAnalysisButton.setToolTipText(SwitchLanguages.GraphicalSimuLauncherButtonStateAnalysisTooltip[SocLabToolkit.idLanguage]);
        this.reportButton.setText(SwitchLanguages.GraphicalSimuLauncherButtonReport[SocLabToolkit.idLanguage]);
        this.firstButton.setText(SwitchLanguages.GraphicalSimuLauncherRadioButtonfirst[SocLabToolkit.idLanguage]);
        this.secondButton.setText(SwitchLanguages.GraphicalSimuLauncherRadioButtonsecond[SocLabToolkit.idLanguage]);
        this.thirdButton.setText(SwitchLanguages.GraphicalSimuLauncherRadioButtonthird[SocLabToolkit.idLanguage]);
        this.fourthButton.setText(SwitchLanguages.GraphicalSimuLauncherRadioButtonfourth[SocLabToolkit.idLanguage]);
        this.setTitle(SwitchLanguages.GraphicalSimuLauncherTitle[SocLabToolkit.idLanguage]);
        this.setName(SwitchLanguages.GraphicalSimuLauncherTitle[SocLabToolkit.idLanguage]);
        this.simuTabbedPane.switchLanguage();
    }
}

