/*
 * Decompiled with CFR 0.152.
 */
package SocLab.GUI.stateInterpreter.tableModel;

import SocLab.core.ActorNew;
import SocLab.core.OrgNew;
import SocLab.core.RelationNew;
import SocLab.core.SocialGameState;
import SocLab.tools.interval.Interval;
import SocLab.tools.interval.QualitativeScale;
import javax.swing.table.AbstractTableModel;

public class StateValueInterpretationTableModel
extends AbstractTableModel {
    private OrgNew orgNew;
    private SocialGameState state;
    private boolean edit_mode;
    private ActorNew controller;

    public StateValueInterpretationTableModel(OrgNew orgNew, boolean mode) {
        this.edit_mode = mode;
        this.orgNew = orgNew;
        this.state = new SocialGameState();
        this.state.initState(orgNew);
        this.controller = null;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.orgNew.getNbRelationsNew();
    }

    public boolean getMode() {
        return this.edit_mode;
    }

    @Override
    public Object getValueAt(int row, int col) {
        String[] rNames = this.orgNew.getRelationsNewName();
        RelationNew rN = this.orgNew.getRelationNew(rNames[row]);
        QualitativeScale scale = new QualitativeScale();
        if (rN.getNbInterpretations() == 0) {
            scale = null;
        } else {
            int i = 0;
            while (i < rN.getNbInterpretations()) {
                double stateBegin = rN.getInterpretations().elementAt(i).getStateBegin();
                double stateEnd = rN.getInterpretations().elementAt(i).getStateEnd();
                boolean inBegin = rN.getInterpretations().elementAt(i).getIncludeBegin();
                boolean inEnd = rN.getInterpretations().elementAt(i).getIncludeEnd();
                String desc = rN.getInterpretations().elementAt(i).getDescription();
                Interval interval = new Interval(stateBegin, stateEnd, inBegin, inEnd);
                scale.addInterval(interval);
                scale.putInterpretation(interval, desc);
                ++i;
            }
        }
        Double relState = this.state.getRelationState(rN);
        String interpretation = "NO INTERPRETATION";
        if (scale != null) {
            interpretation = scale.getQuality(relState);
        }
        if (col == 0) {
            if (this.controller != null) {
                if (rN.getControlActor().getActorNew() != null && rN.getControlActor().getActorNew().getName().equals(this.controller.getName())) {
                    return "(C) " + rN.getName();
                }
                if (this.controller.getDepend(rN.getName()).getStrength() == 0.0) {
                    return "(X) " + rN.getName();
                }
                return "(D) " + rN.getName();
            }
            return rN.getName();
        }
        if (col == 1) {
            if (relState.isNaN()) {
                return (rN.getRPNCurrent().getUpperBound() + rN.getRPNCurrent().getLowerBound()) / 2.0;
            }
            return relState;
        }
        if (col == 2) {
            return interpretation;
        }
        return null;
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "Relation";
        }
        if (col == 1) {
            return "State";
        }
        return "Interpretation ";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 1 && this.edit_mode;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        String[] rNames = this.orgNew.getRelationsNewName();
        RelationNew rN = this.orgNew.getRelationNew(rNames[row]);
        if (col == 1) {
            this.state.put(rN, new Double((String)value));
            this.fireTableCellUpdated(row, 1);
            this.fireTableCellUpdated(row, 2);
        }
    }

    public void setState(SocialGameState state, ActorNew aN) {
        this.state = state;
        this.controller = aN;
        this.fireTableDataChanged();
    }

    public void setMode(boolean b) {
        this.edit_mode = b;
    }
}

