/*
 * Decompiled with CFR 0.152.
 */
package SocLab.core.actors.lcs;

import SocLab.core.ActorNew;
import SocLab.core.OrgNew;
import SocLab.core.RelationNew;
import SocLab.core.SocLabToolkit;
import SocLab.core.actors.lcs.Rule;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

public class CS
implements Serializable,
PropertyChangeListener {
    private ActorNew actorNew;
    private Vector<Rule> P;
    private Vector<Rule> M;
    public int nbOfRulesCreated = 0;
    public int nbOfRulesDeleted = 0;
    private int max_number_of_rules = 100;
    private Rule A;
    private Rule A_prec;
    private int initial_persistance = 2;

    public CS() {
    }

    public CS(ActorNew actorNew) {
        this.actorNew = actorNew;
        this.P = new Vector();
        this.M = new Vector();
    }

    public void reset() {
        this.P.clear();
        this.nbOfRulesCreated = 0;
        this.nbOfRulesDeleted = 0;
    }

    public void updateOblivion() {
        double satis = this.actorNew.getActualSatisfaction();
        double seuil_sat = this.actorNew.getAmbition();
        double sm = this.actorNew.getMinSatisfaction();
        double ob = this.actorNew.getAPNInitial().getOblivion();
        if (satis < seuil_sat) {
            ob += this.actorNew.getAPNCurrent().getReward() * Math.sqrt((seuil_sat - satis) / (seuil_sat - sm));
        }
        this.actorNew.getAPNCurrent().setOblivion(ob);
    }

    public void updateForceSelfLearningRule() {
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        if (orgNew.getSimu().getCurrentStep() > 0) {
            double tx = this.actorNew.tx;
            double pd = this.actorNew.getAPNCurrent().getRepartitionPourcentage();
            double deltaA = this.actorNew.getDeltaAim();
            if (this.A_prec != null) {
                this.A_prec.force += tx * (1.0 - pd) * deltaA;
                if (this.A_prec.force <= 0.0) {
                    this.P.remove(this.A_prec);
                    ++this.nbOfRulesDeleted;
                }
            }
            this.A.force = (1.0 - tx) * this.A.force + tx * pd * deltaA;
        }
    }

    public void updateRulesForfait() {
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        int nstep = orgNew.getSimu().getCurrentStep();
        if (nstep != 0) {
            this.retributeRule();
            this.forgetRule();
            this.cleanRules();
        }
    }

    private void retributeRule() {
        boolean isSatisOverThreshold = this.actorNew.getActualSatisfaction() >= this.actorNew.getAmbition();
        double pd = this.actorNew.getAPNCurrent().getRepartitionPourcentage();
        double reward_pd = pd * this.actorNew.getAPNCurrent().getReward();
        double reward_pad = (1.0 - pd) * this.actorNew.getAPNCurrent().getReward();
        double crit = this.actorNew.getDeltaAim();
        if (crit > 0.0) {
            this.A.addForce(reward_pd);
            if (this.A_prec != null) {
                this.A_prec.addForce(reward_pad);
            }
        }
        if (crit < 0.0) {
            this.A.minusForce(reward_pd);
            if (this.A_prec != null) {
                this.A_prec.minusForce(reward_pad);
            }
        }
        if (crit == 0.0) {
            if (isSatisOverThreshold) {
                this.A.addForce(reward_pd);
                if (this.A_prec != null) {
                    this.A_prec.addForce(reward_pad);
                }
            } else {
                this.A.minusForce(reward_pd);
                if (this.A_prec != null) {
                    this.A_prec.minusForce(reward_pad);
                }
            }
        }
    }

    private void forgetRule() {
        int j = 0;
        while (j < this.P.size()) {
            Rule c = this.P.elementAt(j);
            c.minusForce(this.actorNew.getAPNCurrent().getOblivion());
            ++j;
        }
    }

    private void cleanRules() {
        int j = 0;
        while (j < this.P.size()) {
            Rule c = this.P.elementAt(j);
            if (c.force <= 0.0 && !c.equals(this.A)) {
                this.P.remove(c);
                continue;
            }
            ++j;
        }
    }

    public HashMap selectAction() {
        this.A_prec = null;
        this.A_prec = this.A;
        this.A = null;
        this.match();
        this.A = this.getMatchingRule();
        return this.A.actions;
    }

    private void match() {
        this.M.clear();
        int i = 0;
        while (i < this.P.size()) {
            double distanceMax;
            Rule regleComparee = this.P.elementAt(i);
            HashMap<RelationNew, Double> situationComparee = regleComparee.situation;
            double d = this.Distance(situationComparee);
            if (d <= (distanceMax = this.actorNew.distanceMaxScope / this.actorNew.getAPNCurrent().getScope()) && regleComparee.force >= 0.0) {
                int j = 0;
                while (j < this.M.size()) {
                    Rule regleCorrespondante = this.M.elementAt(j);
                    if (Math.abs(regleComparee.force) > Math.abs(regleCorrespondante.force)) break;
                    ++j;
                }
                this.M.add(j, regleComparee);
                if (this.M.size() > 3) {
                    this.M.remove(3);
                }
            }
            ++i;
        }
    }

    private double Distance(HashMap situation) {
        double distance = 0.0;
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String[] rNames = orgNew.getRelationsNewName();
        int i = 0;
        while (i < rNames.length) {
            RelationNew rN = orgNew.getRelationNew(rNames[i]);
            double solde = rN.getDepend(this.actorNew.getName()).getEffectNew().getFunction().effectFunction(rN.getRPNCurrent().getState());
            if (rN.getDepend(this.actorNew.getName()).getStake() != 0.0) {
                distance += Math.pow(((Double)situation.get(rN) - solde) * rN.getDepend(this.actorNew.getName()).getStake(), 2.0);
            }
            ++i;
        }
        return Math.sqrt(distance);
    }

    private Rule getMatchingRule() {
        Rule rule = null;
        if (this.M.size() > 0) {
            double choice = Math.random() * (double)this.M.size();
            rule = this.M.elementAt((int)choice);
        } else {
            rule = this.cover();
        }
        return rule;
    }

    private Rule cover() {
        HashMap<RelationNew, Double> action = new HashMap<RelationNew, Double>();
        OrgNew orgNew = SocLabToolkit.currentOrgNew;
        String[] rNames = orgNew.getRelationsNewName();
        int i = 0;
        while (i < rNames.length) {
            RelationNew rN = orgNew.getRelationNew(rNames[i]);
            if (rN.getControlActor().getActorNew() != null) {
                if (rN.getControlActor().getActorNew().getName().equals(this.actorNew.getName())) {
                    double _action = this.getNewAction();
                    action.put(rN, _action);
                } else {
                    action.put(rN, 0.0);
                }
            } else {
                action.put(rN, 0.0);
            }
            ++i;
        }
        HashMap<RelationNew, Double> situation = new HashMap<RelationNew, Double>();
        int i2 = 0;
        while (i2 < rNames.length) {
            RelationNew rN = orgNew.getRelationNew(rNames[i2]);
            double solde = rN.getDepend(this.actorNew.getName()).getEffectNew().getFunction().effectFunction(rN.getRPNCurrent().getState());
            situation.put(rN, solde);
            ++i2;
        }
        Rule rule = this.actorNew.getAPNCurrent().getTypeOfRules() == 0.0 ? new Rule(situation, "l'action", (double)this.initial_persistance * this.actorNew.getAPNCurrent().getReward(), "R" + this.nbOfRulesCreated, action) : new Rule(situation, "l'action", 0.0, "R" + this.nbOfRulesCreated, action);
        this.addRule(rule);
        return rule;
    }

    public double getNewAction() {
        double action = 0.0;
        action = Math.random() * 0.8 - 0.4;
        if (0.0 < action) {
            if ((action += this.actorNew.tx / 2.0) < 0.1) {
                action = 0.1;
            }
        } else if ((action -= this.actorNew.tx / 2.0) > -0.1) {
            action = -0.1;
        }
        action = Math.rint(action * 10.0) / 10.0;
        return action;
    }

    private void addRule(Rule c) {
        ++this.nbOfRulesCreated;
        if (this.P.size() >= this.max_number_of_rules) {
            double weakest = 100000.0;
            int indexWeak = 0;
            int i = 0;
            while (i < this.P.size()) {
                Rule c1 = this.P.elementAt(i);
                if (c1.force < weakest) {
                    weakest = c1.force;
                    indexWeak = i;
                }
                ++i;
            }
            Rule cweak = this.P.elementAt(indexWeak);
            this.P.remove(cweak);
        }
        this.P.add(c);
    }

    public ActorNew getActorNew() {
        return this.actorNew;
    }

    public void setActorNew(ActorNew actorNew) {
        this.actorNew = actorNew;
    }

    public int getInitial_persistance() {
        return this.initial_persistance;
    }

    public void setInitial_persistance(int initial_persistance) {
        this.initial_persistance = initial_persistance;
    }

    public Vector getP() {
        return this.P;
    }

    public Vector getM() {
        return this.M;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }
}

