/*
 * Decompiled with CFR 0.152.
 */
package SocLab.tools;

import SocLab.GUI.desktop.DesktopFrame;
import SocLab.GUI.effectAction.MiniConstraintViewer;
import SocLab.GUI.effectAction.MiniEfmViewer;
import SocLab.GUI.simuLauncher.simuResultSynth.simuResultSynthesis;
import SocLab.core.ActorNew;
import SocLab.core.EffectNew;
import SocLab.core.OrgNew;
import SocLab.core.RelationNew;
import SocLab.core.SocLabToolkit;
import SocLab.core.SocialGameState;
import SocLab.core.structures.RelationRelation;
import SocLab.tools.interval.Interval;
import SocLab.tools.interval.QualitativeScale;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.ChapterAutoNumber;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Section;
import com.lowagie.text.Table;
import com.lowagie.text.rtf.RtfWriter2;
import com.lowagie.text.rtf.style.RtfFont;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import com.lowagie.text.rtf.table.RtfBorderGroup;
import com.lowagie.text.rtf.table.RtfCell;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class RTFReports {
    private static final int ACTOR_ACTOR_PARAM = 0;
    private static final int RELATION_ACTOR_PARAM = 1;
    private static final int ACTOR_ACTOR_VARIABLE = 2;
    private static final int RELATION_ACTOR_VARIABLE = 3;
    private static RtfFont paramFont = new RtfFont("Arial", 12.0f, 3);
    private static RtfFont nameFont = new RtfFont("Times New Roman", 10.0f, 1);
    private static RtfFont valueFont = new RtfFont("Times New Roman", 10.0f, 0);
    private static RtfFont underlignedFont = new RtfFont("Times New Roman", 12.0f, 4);
    private static RtfFont hackFont = new RtfFont("Times New Roman", 1.0f, 0, Color.white);
    private static RtfBorderGroup border = new RtfBorderGroup(15, 1, 0.5f, Color.black);
    private static RtfBorderGroup border2 = new RtfBorderGroup(15, 1, 2.0f, Color.black);
    public static Collection<Object[]> images = new Vector<Object[]>();
    public static HashMap<String, Object[]> etat_inclus = new HashMap();
    public static Collection<Object[]> simuSynImages = new Vector<Object[]>();
    public static Collection<Object[]> sensiSynImages = new Vector<Object[]>();

    public static final void makeModelReport(OrgNew orgNew) {
        String[] actors = orgNew.getActorsNewName();
        String[] relations = orgNew.getRelationsNewName();
        RtfParagraphStyle tocLevel1Style = new RtfParagraphStyle("toc 1", "Times New Roman", 13, 1, Color.BLACK);
        tocLevel1Style.setSpacingAfter(0);
        tocLevel1Style.setSpacingBefore(0);
        RtfParagraphStyle tocLevel2Style = new RtfParagraphStyle("toc 2", "Times New Roman", 12, 1, Color.BLACK);
        tocLevel2Style.setSpacingAfter(0);
        tocLevel2Style.setSpacingBefore(0);
        RtfParagraphStyle tocLevel3Style = new RtfParagraphStyle("toc 3", "Times New Roman", 12, 1, Color.BLACK);
        tocLevel3Style.setSpacingAfter(0);
        tocLevel3Style.setSpacingBefore(0);
        RtfParagraphStyle.STYLE_NORMAL.setFontName("Times New Roman");
        RtfParagraphStyle.STYLE_NORMAL.setAlignment(3);
        RtfParagraphStyle.STYLE_NORMAL.setSpacingAfter(0);
        RtfParagraphStyle tableLegend = new RtfParagraphStyle("toc 4", "Times New Roman", 10, 2, Color.BLACK);
        tableLegend.setAlignment(1);
        tableLegend.setSpacingAfter(0);
        tableLegend.setSpacingBefore(0);
        Document document = new Document();
        String fileName = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd__HH.mm");
            File file = new File(String.valueOf(SocLabToolkit.currentOrgNew.getCurrentModelEditorPath()) + File.separatorChar + orgNew.getName() + "_" + sdf.format(new Date()) + "_Structure.rtf");
            fileName = file.getPath();
            FileOutputStream os = new FileOutputStream(file);
            RtfWriter2 rtfWriter2 = RtfWriter2.getInstance((Document)document, (OutputStream)os);
            rtfWriter2.getDocumentSettings().registerParagraphStyle(tocLevel1Style);
            rtfWriter2.getDocumentSettings().registerParagraphStyle(tocLevel2Style);
            rtfWriter2.getDocumentSettings().registerParagraphStyle(tocLevel3Style);
            rtfWriter2.getDocumentSettings().registerParagraphStyle(tableLegend);
            document.setHeader(new HeaderFooter(new Phrase("Generated by SocLab - Model Editor of: " + orgNew.getName()), false));
            document.setFooter(new HeaderFooter(new Phrase(sdf.format(new Date())), false));
            document.addAuthor("SocLab");
            document.open();
            ChapterAutoNumber chapter0 = new ChapterAutoNumber(new Paragraph("Description du Mod\u00e8le", (Font)tocLevel1Style));
            String modeldesc = orgNew.getDescription();
            if (!modeldesc.equals("")) {
                Paragraph pa = new Paragraph(modeldesc);
                chapter0.add((Object)pa);
                document.add((Element)chapter0);
            }
            ChapterAutoNumber chapter1 = new ChapterAutoNumber(new Paragraph("Acteurs et solidarit\u017ds", (Font)tocLevel1Style));
            Section section1_1 = chapter1.addSection(new Paragraph("Identification des acteurs", (Font)tocLevel2Style), 2);
            int i = 0;
            while (i < actors.length) {
                ActorNew aN = orgNew.getActorNew(actors[i]);
                Section section1_1_1 = section1_1.addSection(new Paragraph(aN.getName(), (Font)tocLevel3Style), 3);
                String actorDescTxt = aN.getDescription();
                if (!actorDescTxt.equals("")) {
                    Chunk chunk = new Chunk("Description", (Font)underlignedFont);
                    Paragraph paragraph = new Paragraph("\t", (Font)RtfParagraphStyle.STYLE_NORMAL);
                    paragraph.add((Object)chunk);
                    paragraph.add((Object)(" : " + actorDescTxt));
                    section1_1_1.add((Object)paragraph);
                }
                ++i;
            }
            Section section1_2 = chapter1.addSection(new Paragraph("Solidarit\u00e9s", (Font)tocLevel2Style), 2);
            section1_2.add((Object)RTFReports.getTable(orgNew, "solidarity", 0));
            section1_2.add((Object)new Paragraph("Matrices des solidarit\u00e9s entre acteurs. Chaque cellule repr\u00e9sente la solidarit\u00e9 qu'un acteur (en ligne) accorde \u00e0 un autre (en colonne). La valeur absolue indique l'intensit\u00e9 de la solidarit\u00e9, elle peut \u00eatre positive ou n\u00e9gative.", (Font)tableLegend));
            int i2 = 0;
            while (i2 < actors.length) {
                ActorNew to;
                ActorNew from = orgNew.getActorNew(actors[i2]);
                boolean exist = false;
                int j = 0;
                while (j < actors.length) {
                    to = orgNew.getActorNew(actors[j]);
                    String solidarityTxt = from.getTarget(to.getName()).getSolidarityDesc();
                    if (!solidarityTxt.equals("")) {
                        exist = true;
                    }
                    ++j;
                }
                if (exist) {
                    Section section1_2_n = section1_2.addSection(new Paragraph("Solidarit\u00e9 de " + from.getName(), (Font)tocLevel3Style), 3);
                    j = 0;
                    while (j < actors.length) {
                        to = orgNew.getActorNew(actors[j]);
                        String solidarityTxt = from.getTarget(to.getName()).getSolidarityDesc();
                        if (!solidarityTxt.equals("")) {
                            Chunk chunk = new Chunk("\t Pour " + to.getName() + " : ");
                            Paragraph paragraph = new Paragraph("", (Font)RtfParagraphStyle.STYLE_NORMAL);
                            paragraph.add((Object)chunk);
                            paragraph.add((Object)solidarityTxt);
                            section1_2_n.add((Object)paragraph);
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            document.add((Element)chapter1);
            ChapterAutoNumber chapter2 = new ChapterAutoNumber(new Paragraph("Relations et d\u00e9pendances", (Font)tocLevel1Style));
            chapter2.add((Object)RTFReports.getController(orgNew));
            chapter2.add((Object)new Paragraph("Liste des relations de l'organisation.", (Font)tableLegend));
            chapter2.add((Object)RTFReports.getEffectTable(orgNew));
            chapter2.add((Object)new Paragraph("Matrice r\u00e9capitulative des fonctions d'effet et enjeux des acteurs sur les relations. La somme de la distribution des enjeux pour chaque acteur est normalis\u00e9e \u00e0 10.", (Font)tableLegend));
            HashMap<RelationNew, Image[]> TEImages = RTFReports.getTEImages(orgNew);
            int i3 = 0;
            while (i3 < relations.length) {
                RelationNew rN = orgNew.getRelationNew(relations[i3]);
                Section section2_1 = chapter2.addSection(new Paragraph(rN.getName(), (Font)tocLevel3Style), 3);
                String relDescTxt = rN.getDescription();
                if (!relDescTxt.equals("")) {
                    Chunk chunk = new Chunk("Description", (Font)underlignedFont);
                    Paragraph paragraph = new Paragraph("\t", (Font)RtfParagraphStyle.STYLE_NORMAL);
                    paragraph.add((Object)chunk);
                    paragraph.add((Object)(" : " + relDescTxt));
                    section2_1.add((Object)paragraph);
                }
                QualitativeScale scale = null;
                if (rN.getNbInterpretations() != 0) {
                    scale = new QualitativeScale();
                }
                int j = 0;
                while (j < rN.getNbInterpretations()) {
                    double stateBegin = rN.getInterpretations().elementAt(j).getStateBegin();
                    double stateEnd = rN.getInterpretations().elementAt(j).getStateEnd();
                    boolean inBegin = rN.getInterpretations().elementAt(j).getIncludeBegin();
                    boolean inEnd = rN.getInterpretations().elementAt(j).getIncludeEnd();
                    String desc = rN.getInterpretations().elementAt(j).getDescription();
                    Interval interval = new Interval(stateBegin, stateEnd, inBegin, inEnd);
                    scale.addInterval(interval);
                    scale.putInterpretation(interval, desc);
                    ++j;
                }
                section2_1.add((Object)RTFReports.getRelationIntroductiveTable(orgNew, rN, TEImages.get(rN)));
                section2_1.add((Object)new Paragraph("Fonctions d'effet de la relation \"" + rN.getName() + "\".", (Font)tableLegend));
                if (scale != null) {
                    section2_1.add((Object)RTFReports.getRelationScaleTable(orgNew, scale));
                    section2_1.add((Object)new Paragraph("Interpr\u00e9tation de l'\u00e9chelle de valeur de la relation \"" + rN.getName(), (Font)tableLegend));
                }
                j = 0;
                while (j < actors.length) {
                    ActorNew aN = orgNew.getActorNew(actors[j]);
                    String effectDesc = rN.getDepend(aN.getName()).getEffectNewDesc();
                    String enjeuDesc = rN.getDepend(aN.getName()).getStakeDesc();
                    if (!effectDesc.equals("") | !enjeuDesc.equals("")) {
                        Paragraph paragraph = new Paragraph("\n \t");
                        paragraph.add((Object)TEImages.get(rN)[j]);
                        section2_1.add((Object)paragraph);
                        if (!effectDesc.equals("")) {
                            paragraph = new Paragraph("", (Font)RtfParagraphStyle.STYLE_NORMAL);
                            paragraph.add((Object)new Chunk(" Effet sur " + aN.getName() + " : ", (Font)underlignedFont));
                            paragraph.add((Object)new Chunk(effectDesc));
                            section2_1.add((Object)paragraph);
                        }
                        if (!enjeuDesc.equals("")) {
                            paragraph = new Paragraph("", (Font)RtfParagraphStyle.STYLE_NORMAL);
                            paragraph.add((Object)new Chunk("Enjeu de " + aN.getName() + " : ", (Font)underlignedFont));
                            paragraph.add((Object)new Chunk(enjeuDesc));
                            section2_1.add((Object)paragraph);
                        }
                    }
                    ++j;
                }
                ++i3;
            }
            document.add((Element)chapter2);
            ChapterAutoNumber chapter4 = new ChapterAutoNumber(new Paragraph("Constraints", (Font)tocLevel1Style));
            chapter4.add((Object)RTFReports.getContraintesTable(orgNew));
            chapter4.add((Object)new Paragraph("Matrice r\u00e9capitulative de l'ensemble des fonctions de contraintes.", (Font)tableLegend));
            int i4 = 0;
            while (i4 < relations.length) {
                String solidarityTxt;
                RelationNew to;
                RelationNew from = orgNew.getRelationNew(relations[i4]);
                boolean exist = false;
                int j = 0;
                while (j < relations.length) {
                    to = orgNew.getRelationNew(relations[j]);
                    solidarityTxt = from.getTarget(to.getName()).getDescription();
                    if (!solidarityTxt.equals("")) {
                        exist = true;
                    }
                    ++j;
                }
                if (exist) {
                    Section section4_2_n = section1_2.addSection(new Paragraph("Contraintes de la relation " + from.getName(), (Font)tocLevel3Style), 3);
                    j = 0;
                    while (j < relations.length) {
                        to = orgNew.getRelationNew(relations[j]);
                        solidarityTxt = from.getTarget(to.getName()).getDescription();
                        if (!solidarityTxt.equals("")) {
                            Chunk chunk = new Chunk("\t Sur " + to.getName() + " : ");
                            Paragraph paragraph = new Paragraph("", (Font)RtfParagraphStyle.STYLE_NORMAL);
                            paragraph.add((Object)chunk);
                            paragraph.add((Object)solidarityTxt);
                            section4_2_n.add((Object)paragraph);
                        }
                        ++j;
                    }
                    chapter4.add((Object)section4_2_n);
                }
                ++i4;
            }
            document.add((Element)chapter4);
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        document.close();
        DesktopFrame.statusBar.setText("Model Editor's Report " + fileName + " Created Successfully ...");
    }

    private static final Table getRelationIntroductiveTable(OrgNew orgNew, RelationNew rN, Image[] images) {
        String[] actors = orgNew.getActorsNewName();
        Table table = null;
        try {
            table = new Table(actors.length + 1);
            table.setBorderWidth(1.0f);
            table.setBorderColor(Color.black);
            table.setAlignment(1);
            table.setPadding(5.0f);
            table.addCell((Cell)new RtfCell());
            int i = 0;
            while (i < actors.length) {
                Chunk chunk = new Chunk(actors[i], (Font)nameFont);
                RtfCell cell = new RtfCell((Element)chunk);
                cell.setBorders(border);
                cell.setBackgroundColor(Color.lightGray);
                table.addCell((Cell)cell);
                ++i;
            }
            Chunk chunk = new Chunk(rN.getName(), (Font)nameFont);
            RtfCell cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            table.addCell((Cell)cell);
            int i2 = 0;
            while (i2 < actors.length) {
                Paragraph paragraph = new Paragraph(new Chunk(".", (Font)hackFont));
                paragraph.add((Object)new Chunk(images[i2], 0.0f, 0.0f, false));
                paragraph.setAlignment(1);
                cell = new RtfCell((Element)paragraph);
                cell.setVerticalAlignment(5);
                cell.setBorders(border);
                if (rN.getControlActor().getActorNew() != null && rN.getControlActor().getActorNew().getName().equals(actors[i2])) {
                    cell.setBackgroundColor(new Color(240, 240, 255));
                }
                table.addCell((Cell)cell);
                ++i2;
            }
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
        return table;
    }

    private static final Table getController(OrgNew orgNew) {
        String[] relations = orgNew.getRelationsNewName();
        Table table = null;
        try {
            table = new Table(5);
            table.setBorderWidth(1.0f);
            table.setBorderColor(Color.black);
            table.setAlignment(1);
            table.setPadding(5.0f);
            Chunk chunk = new Chunk("Relation", (Font)nameFont);
            RtfCell cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            table.addCell((Cell)cell);
            chunk = new Chunk("Controller", (Font)nameFont);
            cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            table.addCell((Cell)cell);
            chunk = new Chunk("Bmin", (Font)nameFont);
            cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            table.addCell((Cell)cell);
            chunk = new Chunk("Bmax", (Font)nameFont);
            cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            table.addCell((Cell)cell);
            chunk = new Chunk("Frequence", (Font)nameFont);
            cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            table.addCell((Cell)cell);
            int i = 0;
            while (i < relations.length) {
                RelationNew rN = orgNew.getRelationNew(relations[i]);
                chunk = new Chunk(relations[i], (Font)valueFont);
                cell = new RtfCell((Element)chunk);
                cell.setBorders(border);
                table.addCell((Cell)cell);
                chunk = rN.getControlActor().getActorNew() != null ? new Chunk(rN.getControlActor().getActorNew().getName(), (Font)valueFont) : new Chunk("", (Font)valueFont);
                cell = new RtfCell((Element)chunk);
                cell.setBorders(border);
                table.addCell((Cell)cell);
                chunk = new Chunk("" + rN.getRPNInitial().getLowerBound(), (Font)valueFont);
                cell = new RtfCell((Element)chunk);
                cell.setBorders(border);
                table.addCell((Cell)cell);
                chunk = new Chunk("" + rN.getRPNInitial().getUpperBound(), (Font)valueFont);
                cell = new RtfCell((Element)chunk);
                cell.setBorders(border);
                table.addCell((Cell)cell);
                chunk = new Chunk("" + rN.getRPNInitial().getFrequency(), (Font)valueFont);
                cell = new RtfCell((Element)chunk);
                cell.setBorders(border);
                table.addCell((Cell)cell);
                ++i;
            }
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
        return table;
    }

    private static final String[][] getValueArrayFromParam(OrgNew orgNew, String param, int paramType) {
        int j;
        int i;
        String[] actors = orgNew.getActorsNewName();
        String[] relations = orgNew.getRelationsNewName();
        String[][] array = null;
        if (paramType == 0 || paramType == 2) {
            array = new String[actors.length + 1][actors.length + 1];
            array[0][0] = param;
            System.arraycopy(actors, 0, array[0], 1, actors.length);
            i = 0;
            while (i < actors.length) {
                array[i + 1][0] = actors[i];
                ++i;
            }
            if (paramType == 0) {
                i = 0;
                while (i < actors.length) {
                    j = 0;
                    while (j < actors.length) {
                        if (param.equals("solidarity")) {
                            array[i + 1][j + 1] = "" + orgNew.getActorNew(actors[i]).getTarget(actors[j]).getSolidarity();
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        if (paramType == 1 || paramType == 3) {
            array = new String[relations.length + 1][actors.length + 1];
            array[0][0] = param;
            System.arraycopy(actors, 0, array[0], 1, actors.length);
            i = 0;
            while (i < relations.length) {
                array[i + 1][0] = relations[i];
                ++i;
            }
            if (paramType == 1) {
                i = 0;
                while (i < relations.length) {
                    j = 0;
                    while (j < actors.length) {
                        if (param.equals("stake")) {
                            array[i + 1][j + 1] = "" + orgNew.getRelationNew(relations[i]).getDepend(actors[j]).getStake();
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return array;
    }

    private static final Table getTable(OrgNew orgNew, String param, int paramType) {
        String[][] datas = RTFReports.getValueArrayFromParam(orgNew, param, paramType);
        Table table = null;
        try {
            table = new Table(datas[0].length);
            table.setBorderWidth(1.0f);
            table.setBorderColor(Color.black);
            table.setAlignment(1);
            table.setPadding(5.0f);
            int row = 0;
            while (row < datas.length) {
                int col = 0;
                while (col < datas[0].length) {
                    Chunk chunk = new Chunk(datas[row][col]);
                    RtfCell cell = new RtfCell((Element)chunk);
                    if (col == 0 && row == 0) {
                        chunk.setFont((Font)paramFont);
                    } else if (col == 0 || row == 0) {
                        chunk.setFont((Font)nameFont);
                        cell.setBorders(border);
                        cell.setBackgroundColor(Color.lightGray);
                    } else {
                        chunk.setFont((Font)valueFont);
                        cell.setBorders(border);
                        cell.setHorizontalAlignment(2);
                    }
                    table.addCell((Cell)cell);
                    ++col;
                }
                ++row;
            }
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
        return table;
    }

    private static final Table getEffectTable(OrgNew orgNew) {
        String[] actors = orgNew.getActorsNewName();
        String[] relations = orgNew.getRelationsNewName();
        String[][] datas = RTFReports.getValueArrayFromParam(orgNew, "stake", 1);
        Table table = null;
        String param = "effect";
        try {
            RtfCell cell;
            table = new Table(actors.length + 1);
            table.setBorderWidth(1.0f);
            table.setBorderColor(Color.black);
            table.setAlignment(1);
            table.setPadding(5.0f);
            Chunk chunk = new Chunk(param);
            chunk.setFont((Font)paramFont);
            table.addCell((Cell)new RtfCell((Element)chunk));
            int i = 0;
            while (i < actors.length) {
                chunk = new Chunk(actors[i]);
                cell = new RtfCell((Element)chunk);
                chunk.setFont((Font)nameFont);
                cell.setBorders(border);
                cell.setBackgroundColor(Color.lightGray);
                table.addCell((Cell)cell);
                ++i;
            }
            i = 0;
            while (i < relations.length) {
                chunk = new Chunk(relations[i]);
                cell = new RtfCell((Element)chunk);
                chunk.setFont((Font)nameFont);
                cell.setBorders(border);
                cell.setBackgroundColor(Color.lightGray);
                table.addCell((Cell)cell);
                int j = 0;
                while (j < actors.length) {
                    EffectNew effect = orgNew.getActorNew(actors[j]).getDepend(relations[i]).getEffectNew();
                    MiniEfmViewer view = new MiniEfmViewer(effect);
                    view.setVisible(true);
                    File file = new File(String.valueOf(SocLabToolkit.currentOrgNew.getCurrentModelEditorPath()) + File.separatorChar + "images" + File.separatorChar);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    String imagePath = String.valueOf(file.getPath()) + File.separatorChar + "tmp_" + relations[i] + actors[j] + ".png";
                    file = null;
                    view.saveAsPNG(new File(imagePath));
                    Image image = Image.getInstance((String)imagePath);
                    Paragraph paragraph = new Paragraph(new Chunk(".", (Font)hackFont));
                    chunk = new Chunk(image, 5.0f, -5.0f, false);
                    paragraph.add((Object)chunk);
                    paragraph.setAlignment(1);
                    cell = new RtfCell((Element)paragraph);
                    cell.addElement((Element)new Chunk(datas[i + 1][j + 1]));
                    cell.setBorders(border);
                    cell.setVerticalAlignment(5);
                    if (orgNew.getRelationNew(relations[j]).getControlActor().getActorNew() != null && orgNew.getRelationNew(relations[j]).getControlActor().getActorNew().getName().equals(actors[j])) {
                        cell.setBorders(border2);
                    }
                    table.addCell((Cell)cell);
                    image = null;
                    ++j;
                }
                ++i;
            }
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return table;
    }

    private static final Table getContraintesTable(OrgNew orgNew) {
        String[] relations = orgNew.getRelationsNewName();
        Table table = null;
        String param = "Contraintes";
        try {
            RtfCell cell;
            table = new Table(relations.length + 1);
            table.setBorderWidth(1.0f);
            table.setBorderColor(Color.black);
            table.setAlignment(1);
            table.setPadding(5.0f);
            Chunk chunk = new Chunk(param);
            chunk.setFont((Font)paramFont);
            table.addCell((Cell)new RtfCell((Element)chunk));
            int i = 0;
            while (i < relations.length) {
                chunk = new Chunk(relations[i]);
                cell = new RtfCell((Element)chunk);
                chunk.setFont((Font)nameFont);
                cell.setBorders(border);
                cell.setBackgroundColor(Color.lightGray);
                table.addCell((Cell)cell);
                ++i;
            }
            i = 0;
            while (i < relations.length) {
                chunk = new Chunk(relations[i]);
                cell = new RtfCell((Element)chunk);
                chunk.setFont((Font)nameFont);
                cell.setBorders(border);
                cell.setBackgroundColor(Color.lightGray);
                table.addCell((Cell)cell);
                int j = 0;
                while (j < relations.length) {
                    RelationRelation relationRelation = orgNew.getRelationNew(relations[i]).getTarget(relations[j]);
                    MiniConstraintViewer view = new MiniConstraintViewer(relationRelation);
                    view.setVisible(true);
                    File file = new File(String.valueOf(SocLabToolkit.currentOrgNew.getCurrentModelEditorPath()) + File.separatorChar + "images" + File.separatorChar);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    String imagePath = String.valueOf(file.getPath()) + File.separatorChar + "tmp_" + relations[i] + relations[j] + ".png";
                    file = null;
                    view.saveAsPNG(new File(imagePath));
                    Image image = Image.getInstance((String)imagePath);
                    Paragraph paragraph = new Paragraph(new Chunk(".", (Font)hackFont));
                    paragraph.add((Object)new Chunk(image, 5.0f, -5.0f, false));
                    paragraph.setAlignment(1);
                    cell = new RtfCell((Element)paragraph);
                    cell.setBorders(border);
                    cell.setVerticalAlignment(5);
                    table.addCell((Cell)cell);
                    image = null;
                    ++j;
                }
                ++i;
            }
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return table;
    }

    private static final HashMap<RelationNew, Image[]> getTEImages(OrgNew orgNew) {
        String[] actors = orgNew.getActorsNewName();
        String[] relations = orgNew.getRelationsNewName();
        HashMap<RelationNew, Image[]> imageMap = new HashMap<RelationNew, Image[]>();
        try {
            int i = 0;
            while (i < relations.length) {
                Image[] images = new Image[actors.length];
                imageMap.put(orgNew.getRelationNew(relations[i]), images);
                int j = 0;
                while (j < actors.length) {
                    EffectNew effect = orgNew.getActorNew(actors[j]).getDepend(relations[i]).getEffectNew();
                    MiniEfmViewer view = new MiniEfmViewer(effect);
                    view.setVisible(true);
                    File file = new File(String.valueOf(SocLabToolkit.currentOrgNew.getCurrentModelEditorPath()) + File.separatorChar + "images");
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    String imagePath = String.valueOf(file.getPath()) + File.separatorChar + "tmp_" + relations[i] + actors[j] + ".png";
                    file = null;
                    view.saveAsPNG(new File(imagePath));
                    images[j] = Image.getInstance((String)imagePath);
                    ++j;
                }
                ++i;
            }
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return imageMap;
    }

    private static final Table getRelationScaleTable(OrgNew orgNew, QualitativeScale scale) {
        Table table = null;
        try {
            table = new Table(scale.getInterpretationsSize() + 1);
            table.setBorderWidth(1.0f);
            table.setBorderColor(Color.black);
            table.setAlignment(1);
            table.setPadding(5.0f);
            Chunk chunk = new Chunk("Intervalle", (Font)nameFont);
            RtfCell cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            table.addCell((Cell)cell);
            int n = 0;
            while (n < scale.getInterpretationsSize()) {
                chunk = n == 0 ? new Chunk("Interpretation", (Font)nameFont) : new Chunk("Interpretation " + n, (Font)nameFont);
                cell = new RtfCell((Element)chunk);
                cell.setBorders(border);
                cell.setBackgroundColor(Color.lightGray);
                table.addCell((Cell)cell);
                ++n;
            }
            int i = 0;
            while (i < scale.getIntervalSerieSize()) {
                String value = scale.getIntervalAt(i).toString();
                chunk = new Chunk(value, (Font)valueFont);
                cell = new RtfCell((Element)chunk);
                cell.setBorders(border);
                cell.setHorizontalAlignment(1);
                table.addCell((Cell)cell);
                int n2 = 0;
                while (n2 < scale.getInterpretationsSize()) {
                    value = scale.getNthInterpretationAt(n2, i);
                    chunk = new Chunk(value, (Font)valueFont);
                    cell = new RtfCell((Element)chunk);
                    cell.setBorders(border);
                    table.addCell((Cell)cell);
                    ++n2;
                }
                ++i;
            }
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
        return table;
    }

    public static final void makeSensiSynthesisReport(OrgNew orgNew) {
        RtfParagraphStyle tocLevel1Style = new RtfParagraphStyle("toc 1", "Times New Roman", 13, 1, Color.BLACK);
        tocLevel1Style.setSpacingAfter(0);
        tocLevel1Style.setSpacingBefore(0);
        RtfParagraphStyle tocLevel2Style = new RtfParagraphStyle("toc 2", "Times New Roman", 12, 1, Color.BLACK);
        tocLevel2Style.setSpacingAfter(0);
        tocLevel2Style.setSpacingBefore(0);
        RtfParagraphStyle tocLevel3Style = new RtfParagraphStyle("toc 3", "Times New Roman", 12, 1, Color.BLACK);
        tocLevel3Style.setSpacingAfter(0);
        tocLevel3Style.setSpacingBefore(0);
        RtfParagraphStyle.STYLE_NORMAL.setFontName("Times New Roman");
        RtfParagraphStyle.STYLE_NORMAL.setAlignment(3);
        RtfParagraphStyle.STYLE_NORMAL.setSpacingAfter(0);
        RtfParagraphStyle tableLegend = new RtfParagraphStyle("toc 4", "Times New Roman", 10, 2, Color.BLACK);
        tableLegend.setAlignment(1);
        tableLegend.setSpacingAfter(0);
        tableLegend.setSpacingBefore(0);
        Document document = new Document();
        String fileName = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
            String sensiPath = SocLabToolkit.currentOrgNew.getCurrentSensitivityPath();
            File file = new File(String.valueOf(sensiPath) + File.separatorChar + orgNew.getName() + "_" + sdf.format(new Date()) + "_SensiSynthesis.rtf");
            fileName = file.getPath();
            FileOutputStream os = new FileOutputStream(file);
            RtfWriter2 rtfWriter2 = RtfWriter2.getInstance((Document)document, (OutputStream)os);
            rtfWriter2.getDocumentSettings().registerParagraphStyle(tocLevel1Style);
            rtfWriter2.getDocumentSettings().registerParagraphStyle(tocLevel2Style);
            rtfWriter2.getDocumentSettings().registerParagraphStyle(tocLevel3Style);
            rtfWriter2.getDocumentSettings().registerParagraphStyle(tableLegend);
            document.setHeader(new HeaderFooter(new Phrase("Generated by SocLab - Sensitivity's Synthesis of: " + orgNew.getName() + " \n"), false));
            document.setFooter(new HeaderFooter(new Phrase("\n" + sdf.format(new Date())), false));
            document.addAuthor("SocLab");
            document.open();
            ChapterAutoNumber chapter1 = new ChapterAutoNumber(new Paragraph("Initial Parameters", (Font)tocLevel1Style));
            Section section1_1 = chapter1.addSection(new Paragraph("Sensitivity Analaysis parameters", (Font)tocLevel2Style), 2);
            Chunk chunk_param_simu = new Chunk("nb runs: " + orgNew.getNbRuns() + ".\nNb steps: " + orgNew.getNbSteps() + ".\nNb experiences: " + orgNew.getNbExperiences() + ".\n");
            section1_1.add((Object)chunk_param_simu);
            Section section1_2 = chapter1.addSection(new Paragraph("Relations parameters", (Font)tocLevel2Style), 2);
            try {
                Table table_simu_param = new Table(5, orgNew.getNbRelationsNew() + 1);
                table_simu_param.setBorderWidth(1.0f);
                table_simu_param.setBorderColor(Color.black);
                table_simu_param.setAlignment(1);
                table_simu_param.setPadding(5.0f);
                Chunk chunk_rel = new Chunk("Relations");
                chunk_rel.setFont((Font)nameFont);
                RtfCell cell_rel = new RtfCell((Element)chunk_rel);
                cell_rel.setBorders(border);
                cell_rel.setBackgroundColor(Color.lightGray);
                Chunk chunk_term1 = new Chunk("states");
                chunk_term1.setFont((Font)nameFont);
                RtfCell cell_term1 = new RtfCell((Element)chunk_term1);
                cell_term1.setBorders(border);
                cell_term1.setBackgroundColor(Color.lightGray);
                Chunk chunk_term2 = new Chunk("LowerBound");
                chunk_term2.setFont((Font)nameFont);
                RtfCell cell_term2 = new RtfCell((Element)chunk_term2);
                cell_term2.setBorders(border);
                cell_term2.setBackgroundColor(Color.lightGray);
                Chunk chunk_term3 = new Chunk("UpperBound");
                chunk_term3.setFont((Font)nameFont);
                RtfCell cell_term3 = new RtfCell((Element)chunk_term3);
                cell_term3.setBorders(border);
                cell_term3.setBackgroundColor(Color.lightGray);
                Chunk chunk_term4 = new Chunk("Frequency");
                chunk_term4.setFont((Font)nameFont);
                RtfCell cell_term4 = new RtfCell((Element)chunk_term4);
                cell_term4.setBorders(border);
                cell_term4.setBackgroundColor(Color.lightGray);
                table_simu_param.addCell((Cell)cell_rel, 0, 0);
                table_simu_param.addCell((Cell)cell_term1, 0, 1);
                table_simu_param.addCell((Cell)cell_term2, 0, 2);
                table_simu_param.addCell((Cell)cell_term3, 0, 3);
                table_simu_param.addCell((Cell)cell_term4, 0, 4);
                int row = 0;
                while (row < orgNew.getNbRelationsNew()) {
                    String rel_name = orgNew.getRelationsNewName()[row];
                    Chunk chunk = new Chunk(rel_name);
                    Double val = new Double(orgNew.getRelationNew(rel_name).getRPNInitial().getState());
                    Chunk chunk_val1 = new Chunk(val.toString());
                    val = new Double(orgNew.getRelationNew(rel_name).getRPNInitial().getLowerBound());
                    Chunk chunk_val2 = new Chunk(val.toString());
                    val = new Double(orgNew.getRelationNew(rel_name).getRPNInitial().getUpperBound());
                    Chunk chunk_val3 = new Chunk(val.toString());
                    val = new Double(orgNew.getRelationNew(rel_name).getRPNInitial().getFrequency());
                    Chunk chunk_val4 = new Chunk(val.toString());
                    chunk.setFont((Font)paramFont);
                    chunk_val1.setFont((Font)paramFont);
                    chunk_val2.setFont((Font)paramFont);
                    chunk_val3.setFont((Font)paramFont);
                    chunk_val4.setFont((Font)paramFont);
                    RtfCell cell_nom = new RtfCell((Element)chunk);
                    RtfCell cell_val1 = new RtfCell((Element)chunk_val1);
                    RtfCell cell_val2 = new RtfCell((Element)chunk_val2);
                    RtfCell cell_val3 = new RtfCell((Element)chunk_val3);
                    RtfCell cell_val4 = new RtfCell((Element)chunk_val4);
                    cell_nom.setBorders(border);
                    cell_nom.setBackgroundColor(Color.white);
                    cell_val1.setBorders(border);
                    cell_val1.setBackgroundColor(Color.white);
                    cell_val2.setBorders(border);
                    cell_val2.setBackgroundColor(Color.white);
                    cell_val3.setBorders(border);
                    cell_val3.setBackgroundColor(Color.white);
                    cell_val4.setBorders(border);
                    cell_val4.setBackgroundColor(Color.white);
                    table_simu_param.addCell((Cell)cell_nom, row + 1, 0);
                    table_simu_param.addCell((Cell)cell_val1, row + 1, 1);
                    table_simu_param.addCell((Cell)cell_val2, row + 1, 2);
                    table_simu_param.addCell((Cell)cell_val3, row + 1, 3);
                    table_simu_param.addCell((Cell)cell_val4, row + 1, 4);
                    ++row;
                }
                section1_2.add((Object)table_simu_param);
            }
            catch (BadElementException e) {
                e.printStackTrace();
            }
            Section section1_3 = chapter1.addSection(new Paragraph("Actors parameters", (Font)tocLevel2Style), 2);
            try {
                Table table_rationality_param = new Table(9, orgNew.getNbActorsNew() + 1);
                table_rationality_param.setBorderWidth(1.0f);
                table_rationality_param.setBorderColor(Color.black);
                table_rationality_param.setAlignment(1);
                table_rationality_param.setPadding(5.0f);
                Chunk chunk_actor_titre = new Chunk("Actors");
                chunk_actor_titre.setFont((Font)nameFont);
                RtfCell cell_actor_titre = new RtfCell((Element)chunk_actor_titre);
                cell_actor_titre.setBorders(border);
                cell_actor_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_oblivion_titre = new Chunk("Oblivion");
                chunk_oblivion_titre.setFont((Font)nameFont);
                RtfCell cell_oblivion_titre = new RtfCell((Element)chunk_oblivion_titre);
                cell_oblivion_titre.setBorders(border);
                cell_oblivion_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_reward_titre = new Chunk("Reward");
                chunk_reward_titre.setFont((Font)nameFont);
                RtfCell cell_reward_titre = new RtfCell((Element)chunk_reward_titre);
                cell_reward_titre.setBorders(border);
                cell_reward_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_scope_titre = new Chunk("Scope");
                chunk_scope_titre.setFont((Font)nameFont);
                RtfCell cell_scope_titre = new RtfCell((Element)chunk_scope_titre);
                cell_scope_titre.setBorders(border);
                cell_scope_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_tenacity_titre = new Chunk("Tenacity");
                chunk_tenacity_titre.setFont((Font)nameFont);
                RtfCell cell_tenacity_titre = new RtfCell((Element)chunk_tenacity_titre);
                cell_tenacity_titre.setBorders(border);
                cell_tenacity_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_actionrange_titre = new Chunk("ActionRange");
                chunk_actionrange_titre.setFont((Font)nameFont);
                RtfCell cell_actionrange_titre = new RtfCell((Element)chunk_actionrange_titre);
                cell_actionrange_titre.setBorders(border);
                cell_actionrange_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_evaluation_titre = new Chunk("Evaluation");
                chunk_evaluation_titre.setFont((Font)nameFont);
                RtfCell cell_evaluation_titre = new RtfCell((Element)chunk_evaluation_titre);
                cell_evaluation_titre.setBorders(border);
                cell_evaluation_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_typeofrules_titre = new Chunk("TypesOfRules");
                chunk_typeofrules_titre.setFont((Font)nameFont);
                RtfCell cell_typeofrules_titre = new RtfCell((Element)chunk_typeofrules_titre);
                cell_typeofrules_titre.setBorders(border);
                cell_typeofrules_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_percentage_titre = new Chunk("Percentage");
                chunk_percentage_titre.setFont((Font)nameFont);
                RtfCell cell_percentage_titre = new RtfCell((Element)chunk_percentage_titre);
                cell_percentage_titre.setBorders(border);
                cell_percentage_titre.setBackgroundColor(Color.lightGray);
                table_rationality_param.addCell((Cell)cell_actor_titre, 0, 0);
                table_rationality_param.addCell((Cell)cell_oblivion_titre, 0, 1);
                table_rationality_param.addCell((Cell)cell_reward_titre, 0, 2);
                table_rationality_param.addCell((Cell)cell_scope_titre, 0, 3);
                table_rationality_param.addCell((Cell)cell_tenacity_titre, 0, 4);
                table_rationality_param.addCell((Cell)cell_actionrange_titre, 0, 5);
                table_rationality_param.addCell((Cell)cell_evaluation_titre, 0, 6);
                table_rationality_param.addCell((Cell)cell_typeofrules_titre, 0, 7);
                table_rationality_param.addCell((Cell)cell_percentage_titre, 0, 8);
                int row = 0;
                while (row < orgNew.getNbActorsNew()) {
                    String actor_name = orgNew.getActorsNewName()[row];
                    Chunk chunk_actor = new Chunk(actor_name);
                    Double val_oblivion = orgNew.getActorNew(actor_name).getAPNInitial().getOblivion();
                    Chunk chunk_oblivion = new Chunk(val_oblivion.toString());
                    Double val_reward = orgNew.getActorNew(actor_name).getAPNInitial().getReward();
                    Chunk chunk_reward = new Chunk(val_reward.toString());
                    Double val_scope = orgNew.getActorNew(actor_name).getAPNInitial().getScope();
                    Chunk chunk_scope = new Chunk(val_scope.toString());
                    Double val_tenacity = orgNew.getActorNew(actor_name).getAPNInitial().getTenacity();
                    Chunk chunk_tenacity = new Chunk(val_tenacity.toString());
                    Double val_actionrange = orgNew.getActorNew(actor_name).getAPNInitial().getActionRange();
                    Chunk chunk_actionrange = new Chunk(val_actionrange.toString());
                    double actor_crit = orgNew.getActorNew(actor_name).getAPNInitial().getEvaluationCriterium();
                    Chunk chunk_crit = new Chunk("");
                    if (actor_crit == 0.0) {
                        chunk_crit = new Chunk("Satisfaction");
                    } else if (actor_crit == 1.0) {
                        chunk_crit = new Chunk("Power");
                    } else if (actor_crit == 2.0) {
                        chunk_crit = new Chunk("Capacity");
                    } else if (actor_crit == 3.0) {
                        chunk_crit = new Chunk("Influence");
                    }
                    double rules_type = orgNew.getActorNew(actor_name).getAPNInitial().getTypeOfRules();
                    Chunk chunk_type = new Chunk("");
                    chunk_type = rules_type == 0.0 ? new Chunk("Simple Rules") : new Chunk("Self Learning Rules");
                    Double val_percentage = orgNew.getActorNew(actor_name).getAPNInitial().getRepartitionPourcentage();
                    String percentage = "last rule: " + (int)(val_percentage * 100.0) + "%, penultimate: " + (int)((1.0 - val_percentage) * 100.0) + "%";
                    Chunk chunk_percentage = new Chunk(percentage);
                    chunk_actor.setFont((Font)paramFont);
                    chunk_oblivion.setFont((Font)paramFont);
                    chunk_reward.setFont((Font)paramFont);
                    chunk_scope.setFont((Font)paramFont);
                    chunk_tenacity.setFont((Font)paramFont);
                    chunk_actionrange.setFont((Font)paramFont);
                    chunk_crit.setFont((Font)paramFont);
                    chunk_type.setFont((Font)paramFont);
                    chunk_percentage.setFont((Font)paramFont);
                    RtfCell cell_actor = new RtfCell((Element)chunk_actor);
                    RtfCell cell_oblivion = new RtfCell((Element)chunk_oblivion);
                    RtfCell cell_reward = new RtfCell((Element)chunk_reward);
                    RtfCell cell_scope = new RtfCell((Element)chunk_scope);
                    RtfCell cell_tenacity = new RtfCell((Element)chunk_tenacity);
                    RtfCell cell_actionrange = new RtfCell((Element)chunk_actionrange);
                    RtfCell cell_crit = new RtfCell((Element)chunk_crit);
                    RtfCell cell_type = new RtfCell((Element)chunk_type);
                    RtfCell cell_percentage = new RtfCell((Element)chunk_percentage);
                    cell_actor.setBorders(border);
                    cell_actor.setBackgroundColor(Color.white);
                    cell_oblivion.setBorders(border);
                    cell_oblivion.setBackgroundColor(Color.white);
                    cell_reward.setBorders(border);
                    cell_reward.setBackgroundColor(Color.white);
                    cell_scope.setBorders(border);
                    cell_scope.setBackgroundColor(Color.white);
                    cell_tenacity.setBorders(border);
                    cell_tenacity.setBackgroundColor(Color.white);
                    cell_actionrange.setBorders(border);
                    cell_actionrange.setBackgroundColor(Color.white);
                    cell_crit.setBorders(border);
                    cell_crit.setBackgroundColor(Color.white);
                    cell_type.setBorders(border);
                    cell_type.setBackgroundColor(Color.white);
                    cell_percentage.setBorders(border);
                    cell_percentage.setBackgroundColor(Color.white);
                    table_rationality_param.addCell((Cell)cell_actor, row + 1, 0);
                    table_rationality_param.addCell((Cell)cell_oblivion, row + 1, 1);
                    table_rationality_param.addCell((Cell)cell_reward, row + 1, 2);
                    table_rationality_param.addCell((Cell)cell_scope, row + 1, 3);
                    table_rationality_param.addCell((Cell)cell_tenacity, row + 1, 4);
                    table_rationality_param.addCell((Cell)cell_actionrange, row + 1, 5);
                    table_rationality_param.addCell((Cell)cell_crit, row + 1, 6);
                    table_rationality_param.addCell((Cell)cell_type, row + 1, 7);
                    table_rationality_param.addCell((Cell)cell_percentage, row + 1, 8);
                    ++row;
                }
                section1_3.add((Object)table_rationality_param);
            }
            catch (BadElementException e) {
                e.printStackTrace();
            }
            Section section1_4 = chapter1.addSection(new Paragraph("Exp\u00e9riences Parameters", (Font)tocLevel2Style), 2);
            try {
                Table table_exp_param = new Table(3, orgNew.getSensitivityParameters().length + 1);
                table_exp_param.setBorderWidth(1.0f);
                table_exp_param.setBorderColor(Color.black);
                table_exp_param.setAlignment(1);
                table_exp_param.setPadding(5.0f);
                Chunk chunk_params_titre = new Chunk("Parameters");
                chunk_params_titre.setFont((Font)nameFont);
                RtfCell cell_param_titre = new RtfCell((Element)chunk_params_titre);
                cell_param_titre.setBorders(border);
                cell_param_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_min_titre = new Chunk("Min");
                chunk_min_titre.setFont((Font)nameFont);
                RtfCell cell_min_titre = new RtfCell((Element)chunk_min_titre);
                cell_min_titre.setBorders(border);
                cell_min_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_max_titre = new Chunk("Max");
                chunk_max_titre.setFont((Font)nameFont);
                RtfCell cell_max_titre = new RtfCell((Element)chunk_max_titre);
                cell_max_titre.setBorders(border);
                cell_max_titre.setBackgroundColor(Color.lightGray);
                table_exp_param.addCell((Cell)cell_param_titre, 0, 0);
                table_exp_param.addCell((Cell)cell_min_titre, 0, 1);
                table_exp_param.addCell((Cell)cell_max_titre, 0, 2);
                int row = 0;
                while (row < orgNew.getSensitivityParameters().length) {
                    ActorNew aN;
                    String param_name = orgNew.getSensitivityParameters()[row];
                    Chunk chunk_param = new Chunk(param_name);
                    char category = param_name.charAt(0);
                    String temp = param_name.substring(2);
                    String actorName = temp.substring(0, temp.indexOf("."));
                    String parametre = temp.substring(temp.indexOf(".") + 1);
                    String min = "";
                    String max = "";
                    if (category == '1') {
                        aN = actorName.equals("whole") ? orgNew.getActorsNew().elementAt(0) : orgNew.getActorNew(actorName);
                        if (actorName.equals("whole") || aN.getName().equals(actorName)) {
                            if (parametre.equals("Oblivion")) {
                                min = String.valueOf(aN.getAPNCurrentMin().getOblivion());
                                max = String.valueOf(aN.getAPNCurrentMax().getOblivion());
                            } else if (parametre.equals("Reward")) {
                                min = String.valueOf(aN.getAPNCurrentMin().getReward());
                                max = String.valueOf(aN.getAPNCurrentMax().getReward());
                            } else if (parametre.equals("Scope")) {
                                min = String.valueOf(aN.getAPNCurrentMin().getScope());
                                max = String.valueOf(aN.getAPNCurrentMax().getScope());
                            } else if (parametre.equals("Tenacity")) {
                                min = String.valueOf(aN.getAPNCurrentMin().getTenacity());
                                max = String.valueOf(aN.getAPNCurrentMax().getTenacity());
                            } else if (parametre.equals("ActionRange")) {
                                min = String.valueOf(aN.getAPNCurrentMin().getActionRange());
                                max = String.valueOf(aN.getAPNCurrentMax().getActionRange());
                            } else if (parametre.equals("GroupIdentif")) {
                                min = String.valueOf(aN.getAPNCurrentMax().getActionRange());
                                max = String.valueOf(aN.getAPNCurrentMax().getMoralSensibility());
                            } else if (parametre.equals("Percentage")) {
                                min = String.valueOf((int)(aN.getAPNCurrentMin().getRepartitionPourcentage() * 100.0));
                                max = String.valueOf((int)(aN.getAPNCurrentMax().getRepartitionPourcentage() * 100.0));
                            }
                        }
                    } else if (category == '2') {
                        aN = orgNew.getActorNew(actorName);
                        min = String.valueOf(aN.getDepend(parametre).getSensibilityAnalysisStakeMin());
                        max = String.valueOf(aN.getDepend(parametre).getSensibilityAnalysisStakeMax());
                    } else if (category == '3') {
                        aN = orgNew.getActorNew(actorName);
                        min = String.valueOf("" + aN.getTarget(parametre).getSensibilityAnalysisSolidarityMin());
                        max = String.valueOf("" + aN.getTarget(parametre).getSensibilityAnalysisSolidarityMax());
                    }
                    Chunk chunk_min = new Chunk(min);
                    Chunk chunk_max = new Chunk(max);
                    chunk_param.setFont((Font)paramFont);
                    chunk_min.setFont((Font)paramFont);
                    chunk_max.setFont((Font)paramFont);
                    RtfCell cell_param = new RtfCell((Element)chunk_param);
                    RtfCell cell_min = new RtfCell((Element)chunk_min);
                    RtfCell cell_max = new RtfCell((Element)chunk_max);
                    cell_param.setBorders(border);
                    cell_param.setBackgroundColor(Color.white);
                    cell_min.setBorders(border);
                    cell_min.setBackgroundColor(Color.white);
                    cell_max.setBorders(border);
                    cell_max.setBackgroundColor(Color.white);
                    table_exp_param.addCell((Cell)cell_param, row + 1, 0);
                    table_exp_param.addCell((Cell)cell_min, row + 1, 1);
                    table_exp_param.addCell((Cell)cell_max, row + 1, 2);
                    ++row;
                }
                section1_4.add((Object)table_exp_param);
            }
            catch (BadElementException e) {
                e.printStackTrace();
            }
            ChapterAutoNumber chapter2 = new ChapterAutoNumber(new Paragraph("Panels section", (Font)tocLevel1Style));
            for (Object[] img : sensiSynImages) {
                File jpeg = File.createTempFile("img_", "_rtfGeneration");
                BufferedImage Bimage = (BufferedImage)img[0];
                ImageIO.write((RenderedImage)Bimage, "JPEG", jpeg);
                Image image = Image.getInstance((String)jpeg.getAbsolutePath());
                image.scaleAbsoluteHeight(300.0f);
                image.scaleAbsoluteWidth(450.0f);
                Paragraph paragraph = new Paragraph(new Chunk(".", (Font)hackFont));
                paragraph.add((Object)new Chunk(image, 1.0f, -1.0f, false));
                Section section = chapter2.addSection(new Paragraph((String)img[1], (Font)tocLevel2Style), 2);
                section.add((Object)paragraph);
                section.add((Object)new Paragraph("\n"));
                jpeg.deleteOnExit();
            }
            try {
                document.add((Element)chapter1);
                if (!sensiSynImages.isEmpty()) {
                    document.add((Element)chapter2);
                }
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
            document.close();
            DesktopFrame.statusBar.setText("Model Editor's Report " + fileName + " Created Successfully ...");
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
    }

    public static final void makeSimuSynthesisReport(OrgNew orgNew) {
        RtfParagraphStyle tocLevel1Style = new RtfParagraphStyle("toc 1", "Times New Roman", 13, 1, Color.BLACK);
        tocLevel1Style.setSpacingAfter(0);
        tocLevel1Style.setSpacingBefore(0);
        RtfParagraphStyle tocLevel2Style = new RtfParagraphStyle("toc 2", "Times New Roman", 12, 1, Color.BLACK);
        tocLevel2Style.setSpacingAfter(0);
        tocLevel2Style.setSpacingBefore(0);
        RtfParagraphStyle tocLevel3Style = new RtfParagraphStyle("toc 3", "Times New Roman", 12, 1, Color.BLACK);
        tocLevel3Style.setSpacingAfter(0);
        tocLevel3Style.setSpacingBefore(0);
        RtfParagraphStyle.STYLE_NORMAL.setFontName("Times New Roman");
        RtfParagraphStyle.STYLE_NORMAL.setAlignment(3);
        RtfParagraphStyle.STYLE_NORMAL.setSpacingAfter(0);
        RtfParagraphStyle tableLegend = new RtfParagraphStyle("toc 4", "Times New Roman", 10, 2, Color.BLACK);
        tableLegend.setAlignment(1);
        tableLegend.setSpacingAfter(0);
        tableLegend.setSpacingBefore(0);
        Document document = new Document();
        String fileName = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd_HH.mm");
            String simuPath = SocLabToolkit.currentOrgNew.getCurrentSimulationPath();
            File file = new File(String.valueOf(simuPath) + File.separatorChar + orgNew.getName() + "_" + sdf.format(new Date()) + "_Synthesis.rtf");
            fileName = file.getPath();
            FileOutputStream os = new FileOutputStream(file);
            RtfWriter2 rtfWriter2 = RtfWriter2.getInstance((Document)document, (OutputStream)os);
            rtfWriter2.getDocumentSettings().registerParagraphStyle(tocLevel1Style);
            rtfWriter2.getDocumentSettings().registerParagraphStyle(tocLevel2Style);
            rtfWriter2.getDocumentSettings().registerParagraphStyle(tocLevel3Style);
            rtfWriter2.getDocumentSettings().registerParagraphStyle(tableLegend);
            document.setHeader(new HeaderFooter(new Phrase("Generated by SocLab - Simulation Synthesis of: " + orgNew.getName() + " \n"), false));
            document.setFooter(new HeaderFooter(new Phrase("\n" + sdf.format(new Date())), false));
            document.addAuthor("SocLab");
            document.open();
            ChapterAutoNumber chapter1 = new ChapterAutoNumber(new Paragraph("Initial Parameters", (Font)tocLevel1Style));
            Section section1_1 = chapter1.addSection(new Paragraph("Simulation parameters", (Font)tocLevel2Style), 2);
            Chunk chunk_param_simu = new Chunk("nb runs: " + orgNew.getNbRuns() + ".\nNb steps: " + orgNew.getNbSteps() + ".\n");
            section1_1.add((Object)chunk_param_simu);
            Section section1_2 = chapter1.addSection(new Paragraph("Relations parameters", (Font)tocLevel2Style), 2);
            try {
                Table table_simu_param = new Table(5, orgNew.getNbRelationsNew() + 1);
                table_simu_param.setBorderWidth(1.0f);
                table_simu_param.setBorderColor(Color.black);
                table_simu_param.setAlignment(1);
                table_simu_param.setPadding(5.0f);
                Chunk chunk_rel = new Chunk("Relations");
                chunk_rel.setFont((Font)nameFont);
                RtfCell cell_rel = new RtfCell((Element)chunk_rel);
                cell_rel.setBorders(border);
                cell_rel.setBackgroundColor(Color.lightGray);
                Chunk chunk_term1 = new Chunk("Init states");
                chunk_term1.setFont((Font)nameFont);
                RtfCell cell_term1 = new RtfCell((Element)chunk_term1);
                cell_term1.setBorders(border);
                cell_term1.setBackgroundColor(Color.lightGray);
                Chunk chunk_term2 = new Chunk("LowerBound");
                chunk_term2.setFont((Font)nameFont);
                RtfCell cell_term2 = new RtfCell((Element)chunk_term2);
                cell_term2.setBorders(border);
                cell_term2.setBackgroundColor(Color.lightGray);
                Chunk chunk_term3 = new Chunk("UpperBound");
                chunk_term3.setFont((Font)nameFont);
                RtfCell cell_term3 = new RtfCell((Element)chunk_term3);
                cell_term3.setBorders(border);
                cell_term3.setBackgroundColor(Color.lightGray);
                Chunk chunk_term4 = new Chunk("Frequency");
                chunk_term4.setFont((Font)nameFont);
                RtfCell cell_term4 = new RtfCell((Element)chunk_term4);
                cell_term4.setBorders(border);
                cell_term4.setBackgroundColor(Color.lightGray);
                table_simu_param.addCell((Cell)cell_rel, 0, 0);
                table_simu_param.addCell((Cell)cell_term1, 0, 1);
                table_simu_param.addCell((Cell)cell_term2, 0, 2);
                table_simu_param.addCell((Cell)cell_term3, 0, 3);
                table_simu_param.addCell((Cell)cell_term4, 0, 4);
                int row = 0;
                while (row < orgNew.getNbRelationsNew()) {
                    String rel_name = orgNew.getRelationsNewName()[row];
                    Chunk chunk = new Chunk(rel_name);
                    Double val = new Double(orgNew.getRelationNew(rel_name).getRPNInitial().getState());
                    Chunk chunk_val1 = new Chunk(val.toString());
                    val = new Double(orgNew.getRelationNew(rel_name).getRPNInitial().getLowerBound());
                    Chunk chunk_val2 = new Chunk(val.toString());
                    val = new Double(orgNew.getRelationNew(rel_name).getRPNInitial().getUpperBound());
                    Chunk chunk_val3 = new Chunk(val.toString());
                    val = new Double(orgNew.getRelationNew(rel_name).getRPNInitial().getFrequency());
                    Chunk chunk_val4 = new Chunk(val.toString());
                    chunk.setFont((Font)paramFont);
                    chunk_val1.setFont((Font)paramFont);
                    chunk_val2.setFont((Font)paramFont);
                    chunk_val3.setFont((Font)paramFont);
                    chunk_val4.setFont((Font)paramFont);
                    RtfCell cell_nom = new RtfCell((Element)chunk);
                    RtfCell cell_val1 = new RtfCell((Element)chunk_val1);
                    RtfCell cell_val2 = new RtfCell((Element)chunk_val2);
                    RtfCell cell_val3 = new RtfCell((Element)chunk_val3);
                    RtfCell cell_val4 = new RtfCell((Element)chunk_val4);
                    cell_nom.setBorders(border);
                    cell_nom.setBackgroundColor(Color.white);
                    cell_val1.setBorders(border);
                    cell_val1.setBackgroundColor(Color.white);
                    cell_val2.setBorders(border);
                    cell_val2.setBackgroundColor(Color.white);
                    cell_val3.setBorders(border);
                    cell_val3.setBackgroundColor(Color.white);
                    cell_val4.setBorders(border);
                    cell_val4.setBackgroundColor(Color.white);
                    table_simu_param.addCell((Cell)cell_nom, row + 1, 0);
                    table_simu_param.addCell((Cell)cell_val1, row + 1, 1);
                    table_simu_param.addCell((Cell)cell_val2, row + 1, 2);
                    table_simu_param.addCell((Cell)cell_val3, row + 1, 3);
                    table_simu_param.addCell((Cell)cell_val4, row + 1, 4);
                    ++row;
                }
                section1_2.add((Object)table_simu_param);
            }
            catch (BadElementException e) {
                e.printStackTrace();
            }
            Section section1_3 = chapter1.addSection(new Paragraph("Actors parameters", (Font)tocLevel2Style), 2);
            try {
                Table table_rationality_param = new Table(6, orgNew.getNbActorsNew() + 1);
                table_rationality_param.setBorderWidth(1.0f);
                table_rationality_param.setBorderColor(Color.black);
                table_rationality_param.setAlignment(1);
                table_rationality_param.setPadding(5.0f);
                Chunk chunk_actor_titre = new Chunk("Actors");
                chunk_actor_titre.setFont((Font)nameFont);
                RtfCell cell_actor_titre = new RtfCell((Element)chunk_actor_titre);
                cell_actor_titre.setBorders(border);
                cell_actor_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_reward_titre = new Chunk("Tenacity");
                chunk_reward_titre.setFont((Font)nameFont);
                RtfCell cell_reward_titre = new RtfCell((Element)chunk_reward_titre);
                cell_reward_titre.setBorders(border);
                cell_reward_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_scope_titre = new Chunk("Scope");
                chunk_scope_titre.setFont((Font)nameFont);
                RtfCell cell_scope_titre = new RtfCell((Element)chunk_scope_titre);
                cell_scope_titre.setBorders(border);
                cell_scope_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_GroupIdent_titre = new Chunk("Group Ident.");
                chunk_GroupIdent_titre.setFont((Font)nameFont);
                RtfCell cell_GroupIdent_titre = new RtfCell((Element)chunk_GroupIdent_titre);
                cell_GroupIdent_titre.setBorders(border);
                cell_GroupIdent_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_typeofrules_titre = new Chunk("TypesOfRules");
                chunk_typeofrules_titre.setFont((Font)nameFont);
                RtfCell cell_typeofrules_titre = new RtfCell((Element)chunk_typeofrules_titre);
                cell_typeofrules_titre.setBorders(border);
                cell_typeofrules_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_percentage_titre = new Chunk("Percentage");
                chunk_percentage_titre.setFont((Font)nameFont);
                RtfCell cell_percentage_titre = new RtfCell((Element)chunk_percentage_titre);
                cell_percentage_titre.setBorders(border);
                cell_percentage_titre.setBackgroundColor(Color.lightGray);
                table_rationality_param.addCell((Cell)cell_actor_titre, 0, 0);
                table_rationality_param.addCell((Cell)cell_reward_titre, 0, 1);
                table_rationality_param.addCell((Cell)cell_scope_titre, 0, 2);
                table_rationality_param.addCell((Cell)cell_GroupIdent_titre, 0, 3);
                table_rationality_param.addCell((Cell)cell_typeofrules_titre, 0, 4);
                table_rationality_param.addCell((Cell)cell_percentage_titre, 0, 5);
                int row = 0;
                while (row < orgNew.getNbActorsNew()) {
                    String actor_name = orgNew.getActorsNewName()[row];
                    Chunk chunk_actor = new Chunk(actor_name);
                    Double val_tenacity = orgNew.getActorNew(actor_name).getAPNInitial().getTenacity();
                    Chunk chunk_tenacity = new Chunk(val_tenacity.toString());
                    Double val_scope = orgNew.getActorNew(actor_name).getAPNInitial().getScope();
                    Chunk chunk_scope = new Chunk(val_scope.toString());
                    Double val_MS = orgNew.getActorNew(actor_name).getAPNInitial().getMoralSensibility();
                    Chunk chunk_MS = new Chunk(val_MS.toString());
                    double rules_type = orgNew.getActorNew(actor_name).getAPNInitial().getTypeOfRules();
                    Chunk chunk_type = new Chunk("");
                    chunk_type = rules_type == 0.0 ? new Chunk("Simple Rules") : new Chunk("Self Learning");
                    Double val_percentage = orgNew.getActorNew(actor_name).getAPNInitial().getRepartitionPourcentage();
                    String percentage = "last rule: " + (int)(val_percentage * 100.0) + "% penult: " + (int)((1.0 - val_percentage) * 100.0) + "%";
                    Chunk chunk_percentage = new Chunk(percentage);
                    chunk_actor.setFont((Font)paramFont);
                    chunk_tenacity.setFont((Font)paramFont);
                    chunk_scope.setFont((Font)paramFont);
                    chunk_MS.setFont((Font)paramFont);
                    chunk_type.setFont((Font)paramFont);
                    RtfCell cell_actor = new RtfCell((Element)chunk_actor);
                    RtfCell cell_MS = new RtfCell((Element)chunk_MS);
                    RtfCell cell_scope = new RtfCell((Element)chunk_scope);
                    RtfCell cell_tenacity = new RtfCell((Element)chunk_tenacity);
                    RtfCell cell_type = new RtfCell((Element)chunk_type);
                    RtfCell cell_percentage = new RtfCell((Element)chunk_percentage);
                    cell_actor.setBorders(border);
                    cell_actor.setBackgroundColor(Color.white);
                    cell_MS.setBorders(border);
                    cell_MS.setBackgroundColor(Color.white);
                    cell_scope.setBorders(border);
                    cell_scope.setBackgroundColor(Color.white);
                    cell_tenacity.setBorders(border);
                    cell_tenacity.setBackgroundColor(Color.white);
                    cell_type.setBorders(border);
                    cell_type.setBackgroundColor(Color.white);
                    cell_percentage.setBorders(border);
                    cell_percentage.setBackgroundColor(Color.white);
                    table_rationality_param.addCell((Cell)cell_actor, row + 1, 0);
                    table_rationality_param.addCell((Cell)cell_tenacity, row + 1, 1);
                    table_rationality_param.addCell((Cell)cell_scope, row + 1, 2);
                    table_rationality_param.addCell((Cell)cell_MS, row + 1, 3);
                    table_rationality_param.addCell((Cell)cell_type, row + 1, 4);
                    table_rationality_param.addCell((Cell)cell_percentage, row + 1, 5);
                    ++row;
                }
                section1_3.add((Object)table_rationality_param);
            }
            catch (BadElementException e) {
                e.printStackTrace();
            }
            Chunk chunk_description = new Chunk(".\nDescription: " + orgNew.getSimuDescription() + ".\n");
            section1_3.add((Object)chunk_description);
            ChapterAutoNumber chapter2 = new ChapterAutoNumber(new Paragraph("Results", (Font)tocLevel1Style));
            if (orgNew.headNbEtapesNec == 0) {
                chapter2.add((Object)new Chunk("\nNumber of steps not available.\n"));
            } else {
                int min = Integer.MAX_VALUE;
                int max = Integer.MIN_VALUE;
                double mean = 0.0;
                int Converge = 0;
                int i = 0;
                while (i < orgNew.headNbEtapesNec) {
                    int value;
                    if (orgNew.nbStepConvergence[i][2].equals("-")) {
                        value = SocLabToolkit.currentOrgNew.getNbSteps();
                    } else {
                        value = Integer.valueOf(orgNew.nbStepConvergence[i][2]);
                        ++Converge;
                    }
                    mean += (double)value;
                    if (value < min) {
                        min = value;
                    }
                    if (value > max) {
                        max = value;
                    }
                    ++i;
                }
                Chunk chunk_simu = new Chunk("\nAverage number of steps before the convergence is reached: " + (mean /= (double)orgNew.headNbEtapesNec) + ".\nMin: " + min + ".\nMax: " + max + ".\nnumber of converging simulations: " + Converge + ".\n");
                chapter2.add((Object)chunk_simu);
            }
            Section section2_1 = chapter2.addSection(new Paragraph("Averages and Deviations of Actors Situations", (Font)tocLevel2Style), 2);
            try {
                Table table_satis = new Table(7, orgNew.getNbActorsNew() + 1);
                table_satis.setBorderWidth(1.0f);
                table_satis.setBorderColor(Color.black);
                table_satis.setAlignment(1);
                table_satis.setPadding(5.0f);
                Chunk chunk_actor_titre = new Chunk("Actors");
                chunk_actor_titre.setFont((Font)nameFont);
                RtfCell cell_actor_titre = new RtfCell((Element)chunk_actor_titre);
                cell_actor_titre.setBorders(border);
                cell_actor_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_Smean_titre = new Chunk("Satisf Averages");
                chunk_Smean_titre.setFont((Font)nameFont);
                RtfCell cell_Smean_titre = new RtfCell((Element)chunk_Smean_titre);
                cell_Smean_titre.setBorders(border);
                cell_Smean_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_Sstdd_titre = new Chunk("Satisf Deviations");
                chunk_Sstdd_titre.setFont((Font)nameFont);
                RtfCell cell_Sstdd_titre = new RtfCell((Element)chunk_Sstdd_titre);
                cell_Sstdd_titre.setBorders(border);
                cell_Sstdd_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_Imean_titre = new Chunk("Influence Averages");
                chunk_Imean_titre.setFont((Font)nameFont);
                RtfCell cell_Imean_titre = new RtfCell((Element)chunk_Imean_titre);
                cell_Imean_titre.setBorders(border);
                cell_Imean_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_Istdd_titre = new Chunk("Influence Deviations");
                chunk_Istdd_titre.setFont((Font)nameFont);
                RtfCell cell_Istdd_titre = new RtfCell((Element)chunk_Istdd_titre);
                cell_Istdd_titre.setBorders(border);
                cell_Istdd_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_Amean_titre = new Chunk("Aim Averages");
                chunk_Amean_titre.setFont((Font)nameFont);
                RtfCell cell_Amean_titre = new RtfCell((Element)chunk_Amean_titre);
                cell_Amean_titre.setBorders(border);
                cell_Amean_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_Astdd_titre = new Chunk("Aim Deviations");
                chunk_Astdd_titre.setFont((Font)nameFont);
                RtfCell cell_Astdd_titre = new RtfCell((Element)chunk_Astdd_titre);
                cell_Astdd_titre.setBorders(border);
                cell_Astdd_titre.setBackgroundColor(Color.lightGray);
                table_satis.addCell((Cell)cell_actor_titre, 0, 0);
                table_satis.addCell((Cell)cell_Smean_titre, 0, 1);
                table_satis.addCell((Cell)cell_Sstdd_titre, 0, 2);
                table_satis.addCell((Cell)cell_Imean_titre, 0, 3);
                table_satis.addCell((Cell)cell_Istdd_titre, 0, 4);
                table_satis.addCell((Cell)cell_Amean_titre, 0, 5);
                table_satis.addCell((Cell)cell_Astdd_titre, 0, 6);
                int row = 0;
                while (row < orgNew.getNbActorsNew()) {
                    String actor_name = orgNew.getActorsNewName()[row];
                    Chunk chunk_actor = new Chunk(actor_name);
                    simuResultSynthesis simuResults = orgNew.getSimuResults();
                    Double val_mean = RTFReports.shiftDecimal(simuResults.array3DVarActor[0][row][0], 2);
                    Chunk chunk_Smean = new Chunk(val_mean.toString());
                    Double val_stdd = RTFReports.shiftDecimal(simuResults.array3DVarActor[0][row][1], 2);
                    Chunk chunk_Sstdd = new Chunk(val_stdd.toString());
                    val_mean = RTFReports.shiftDecimal(simuResults.array3DVarActor[1][row][0], 2);
                    Chunk chunk_Imean = new Chunk(val_mean.toString());
                    val_stdd = RTFReports.shiftDecimal(simuResults.array3DVarActor[1][row][1], 2);
                    Chunk chunk_Istdd = new Chunk(val_stdd.toString());
                    val_mean = RTFReports.shiftDecimal(simuResults.array3DVarActor[2][row][0], 2);
                    Chunk chunk_Amean = new Chunk(val_mean.toString());
                    val_stdd = RTFReports.shiftDecimal(simuResults.array3DVarActor[2][row][1], 2);
                    Chunk chunk_Astdd = new Chunk(val_stdd.toString());
                    chunk_actor.setFont((Font)paramFont);
                    chunk_Smean.setFont((Font)paramFont);
                    chunk_Sstdd.setFont((Font)paramFont);
                    chunk_Imean.setFont((Font)paramFont);
                    chunk_Istdd.setFont((Font)paramFont);
                    chunk_Amean.setFont((Font)paramFont);
                    chunk_Astdd.setFont((Font)paramFont);
                    RtfCell cell_actor = new RtfCell((Element)chunk_actor);
                    RtfCell cell_Smean = new RtfCell((Element)chunk_Smean);
                    RtfCell cell_Sstdd = new RtfCell((Element)chunk_Sstdd);
                    RtfCell cell_Imean = new RtfCell((Element)chunk_Imean);
                    RtfCell cell_Istdd = new RtfCell((Element)chunk_Istdd);
                    RtfCell cell_Amean = new RtfCell((Element)chunk_Amean);
                    RtfCell cell_Astdd = new RtfCell((Element)chunk_Astdd);
                    cell_actor.setBorders(border);
                    cell_actor.setBackgroundColor(Color.white);
                    cell_Smean.setBorders(border);
                    cell_Smean.setBackgroundColor(Color.white);
                    cell_Sstdd.setBorders(border);
                    cell_Sstdd.setBackgroundColor(Color.white);
                    cell_Imean.setBorders(border);
                    cell_Imean.setBackgroundColor(Color.white);
                    cell_Istdd.setBorders(border);
                    cell_Istdd.setBackgroundColor(Color.white);
                    cell_Amean.setBorders(border);
                    cell_Amean.setBackgroundColor(Color.white);
                    cell_Astdd.setBorders(border);
                    cell_Astdd.setBackgroundColor(Color.white);
                    table_satis.addCell((Cell)cell_actor, row + 1, 0);
                    table_satis.addCell((Cell)cell_Smean, row + 1, 1);
                    table_satis.addCell((Cell)cell_Sstdd, row + 1, 2);
                    table_satis.addCell((Cell)cell_Imean, row + 1, 3);
                    table_satis.addCell((Cell)cell_Istdd, row + 1, 4);
                    table_satis.addCell((Cell)cell_Amean, row + 1, 5);
                    table_satis.addCell((Cell)cell_Astdd, row + 1, 6);
                    ++row;
                }
                section2_1.add((Object)table_satis);
            }
            catch (BadElementException e) {
                e.printStackTrace();
            }
            Section section2_2 = chapter2.addSection(new Paragraph("Averages, Deviations and Interpretations of States of Relations", (Font)tocLevel2Style), 2);
            try {
                Table table_term = new Table(4, orgNew.getNbRelationsNew() + 1);
                table_term.setBorderWidth(1.0f);
                table_term.setBorderColor(Color.black);
                table_term.setAlignment(1);
                table_term.setPadding(5.0f);
                Chunk chunk_relation_titre = new Chunk("Relations");
                chunk_relation_titre.setFont((Font)nameFont);
                RtfCell cell_relation_titre = new RtfCell((Element)chunk_relation_titre);
                cell_relation_titre.setBorders(border);
                cell_relation_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_mean_titre = new Chunk("Averages");
                chunk_mean_titre.setFont((Font)nameFont);
                RtfCell cell_mean_titre = new RtfCell((Element)chunk_mean_titre);
                cell_mean_titre.setBorders(border);
                cell_mean_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_stdd_titre = new Chunk("Deviations");
                chunk_stdd_titre.setFont((Font)nameFont);
                RtfCell cell_stdd_titre = new RtfCell((Element)chunk_stdd_titre);
                cell_stdd_titre.setBorders(border);
                cell_stdd_titre.setBackgroundColor(Color.lightGray);
                Chunk chunk_stdd_interpretations = new Chunk("Interpretations");
                chunk_stdd_interpretations.setFont((Font)nameFont);
                RtfCell cell_stdd_interpretations = new RtfCell((Element)chunk_stdd_interpretations);
                cell_stdd_interpretations.setBorders(border);
                cell_stdd_interpretations.setBackgroundColor(Color.lightGray);
                table_term.addCell((Cell)cell_relation_titre, 0, 0);
                table_term.addCell((Cell)cell_mean_titre, 0, 1);
                table_term.addCell((Cell)cell_stdd_titre, 0, 2);
                table_term.addCell((Cell)cell_stdd_interpretations, 0, 3);
                int row = 0;
                while (row < orgNew.getNbRelationsNew()) {
                    String relation_name = orgNew.getRelationsNewName()[row];
                    Chunk chunk_relation = new Chunk(relation_name);
                    simuResultSynthesis simuResults = orgNew.getSimuResults();
                    Double val_mean = RTFReports.shiftDecimal(simuResults.matrixStateRel[row][0], 2);
                    Chunk chunk_mean = new Chunk(val_mean.toString());
                    Double val_stdd = RTFReports.shiftDecimal(simuResults.matrixStateRel[row][1], 2);
                    Chunk chunk_stdd = new Chunk(val_stdd.toString());
                    RelationNew rN = orgNew.getRelationNew(relation_name);
                    QualitativeScale scale = new QualitativeScale();
                    if (rN.getNbInterpretations() == 0) {
                        scale = null;
                    } else {
                        int i = 0;
                        while (i < rN.getNbInterpretations()) {
                            double stateBegin = rN.getInterpretations().elementAt(i).getStateBegin();
                            double stateEnd = rN.getInterpretations().elementAt(i).getStateEnd();
                            boolean inBegin = rN.getInterpretations().elementAt(i).getIncludeBegin();
                            boolean inEnd = rN.getInterpretations().elementAt(i).getIncludeEnd();
                            String desc = rN.getInterpretations().elementAt(i).getDescription();
                            Interval interval = new Interval(stateBegin, stateEnd, inBegin, inEnd);
                            scale.addInterval(interval);
                            scale.putInterpretation(interval, desc);
                            ++i;
                        }
                    }
                    Double relState = val_mean;
                    String interpretation = " ";
                    if (scale != null) {
                        interpretation = scale.getQuality(relState);
                    }
                    Chunk chunk_inter = new Chunk(interpretation);
                    chunk_relation.setFont((Font)paramFont);
                    chunk_mean.setFont((Font)paramFont);
                    chunk_stdd.setFont((Font)paramFont);
                    chunk_inter.setFont((Font)paramFont);
                    RtfCell cell_relation = new RtfCell((Element)chunk_relation);
                    RtfCell cell_mean = new RtfCell((Element)chunk_mean);
                    RtfCell cell_stdd = new RtfCell((Element)chunk_stdd);
                    RtfCell cell_inter = new RtfCell((Element)chunk_inter);
                    cell_relation.setBorders(border);
                    cell_relation.setBackgroundColor(Color.white);
                    cell_mean.setBorders(border);
                    cell_mean.setBackgroundColor(Color.white);
                    cell_stdd.setBorders(border);
                    cell_stdd.setBackgroundColor(Color.white);
                    cell_inter.setBorders(border);
                    cell_inter.setBackgroundColor(Color.white);
                    table_term.addCell((Cell)cell_relation, row + 1, 0);
                    table_term.addCell((Cell)cell_mean, row + 1, 1);
                    table_term.addCell((Cell)cell_stdd, row + 1, 2);
                    table_term.addCell((Cell)cell_inter, row + 1, 3);
                    ++row;
                }
                section2_2.add((Object)table_term);
            }
            catch (BadElementException e) {
                e.printStackTrace();
            }
            ChapterAutoNumber chapter3 = new ChapterAutoNumber(new Paragraph("Panels section", (Font)tocLevel1Style));
            for (Object[] img : simuSynImages) {
                File jpeg = File.createTempFile("img_", "_rtfGeneration");
                BufferedImage Bimage = (BufferedImage)img[0];
                ImageIO.write((RenderedImage)Bimage, "JPEG", jpeg);
                Image image = Image.getInstance((String)jpeg.getAbsolutePath());
                image.scaleAbsoluteHeight(300.0f);
                image.scaleAbsoluteWidth(450.0f);
                Paragraph paragraph = new Paragraph(new Chunk(".", (Font)hackFont));
                paragraph.add((Object)new Chunk(image, 1.0f, -1.0f, false));
                Section section = chapter3.addSection(new Paragraph((String)img[1], (Font)tocLevel2Style), 2);
                section.add((Object)paragraph);
                section.add((Object)new Paragraph("\n"));
                jpeg.deleteOnExit();
            }
            try {
                document.add((Element)chapter1);
                document.add((Element)chapter2);
                if (!simuSynImages.isEmpty()) {
                    document.add((Element)chapter3);
                }
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
            document.close();
            DesktopFrame.statusBar.setText("Simu result Report " + fileName + " Created Successfully ...");
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
    }

    private static Object create_Cell(Double val) {
        RTFReports.shiftDecimal(val, 2);
        Chunk chunk_val = new Chunk(val.toString());
        chunk_val.setFont((Font)paramFont);
        try {
            RtfCell cell_val = new RtfCell((Element)chunk_val);
            cell_val.setBorders(border);
            cell_val.setBackgroundColor(Color.white);
            return cell_val;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Object();
        }
    }

    private static Object create_Cell(String val) {
        Chunk chunk_val = new Chunk(val);
        chunk_val.setFont((Font)paramFont);
        try {
            RtfCell cell_val = new RtfCell((Element)chunk_val);
            cell_val.setBorders(border);
            cell_val.setBackgroundColor(Color.white);
            return cell_val;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Object();
        }
    }

    private static void fill_power(Table tab, OrgNew orgNew, SocialGameState state) {
        int nbActors = orgNew.getNbActorsNew();
        String[] aNames = orgNew.getActorsNewName();
        try {
            int row = 0;
            while (row < nbActors + 3) {
                int col = 0;
                while (col < nbActors + 1) {
                    Double val_sol_inf;
                    ActorNew a;
                    if (row < nbActors && col == nbActors) {
                        a = orgNew.getActorNew(aNames[row]);
                        Double val_satis = RTFReports.shiftDecimal(a.getActionCapacity(a, state), 2);
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(val_satis)), row + 1, col + 1);
                    } else if (row == nbActors && col == nbActors) {
                        double sum = 0.0;
                        int i = 0;
                        while (i < orgNew.getNbActorsNew()) {
                            ActorNew aN = orgNew.getActorNew(aNames[i]);
                            sum += aN.getActionCapacity(aN, state);
                            ++i;
                        }
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(RTFReports.shiftDecimal(sum /= (double)orgNew.getNbActorsNew(), 1))), row + 1, col + 1);
                    } else if (row < nbActors && col < nbActors) {
                        a = orgNew.getActorNew(aNames[row]);
                        ActorNew b = orgNew.getActorNew(aNames[col]);
                        Double val_sol_inf2 = RTFReports.shiftDecimal(b.getTarget(a.getName()).getActualPower(b, a, state), 1);
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(val_sol_inf2)), row + 1, col + 1);
                    } else if (row == nbActors && col < nbActors) {
                        a = orgNew.getActorNew(aNames[col]);
                        val_sol_inf = RTFReports.shiftDecimal(a.getAccumulatedActualPowerBrut(a, state), 1);
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(val_sol_inf)), row + 1, col + 1);
                    } else if (row == nbActors + 1 && col < nbActors) {
                        a = orgNew.getActorNew(aNames[col]);
                        val_sol_inf = RTFReports.shiftDecimal(a.getAccumulatedAbsoluteActualPower(a, state), 1);
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(val_sol_inf)), row + 1, col + 1);
                    } else if (row == nbActors + 2 && col < nbActors) {
                        a = orgNew.getActorNew(aNames[col]);
                        val_sol_inf = RTFReports.shiftDecimal(a.getAccumulatedCooperativeActualPowerBrut(a, state), 1);
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(val_sol_inf)), row + 1, col + 1);
                    }
                    ++col;
                }
                ++row;
            }
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
    }

    private static void fill_sol(Table tab, OrgNew orgNew, SocialGameState state) {
        int nbActors = orgNew.getNbActorsNew();
        String[] aNames = orgNew.getActorsNewName();
        try {
            int row = 0;
            while (row < nbActors + 3) {
                int col = 0;
                while (col < nbActors + 1) {
                    Double val_sol_inf;
                    ActorNew a;
                    if (row < nbActors && col == nbActors) {
                        a = orgNew.getActorNew(aNames[row]);
                        Double val_satis = RTFReports.shiftDecimal(a.getSatisfaction(a, state), 2);
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(val_satis)), row + 1, col + 1);
                    } else if (row == nbActors && col == nbActors) {
                        double sum = 0.0;
                        int i = 0;
                        while (i < orgNew.getNbActorsNew()) {
                            ActorNew aN = orgNew.getActorNew(aNames[i]);
                            sum += aN.getSatisfaction(aN, state);
                            ++i;
                        }
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(RTFReports.shiftDecimal(sum /= (double)orgNew.getNbActorsNew(), 1))), row + 1, col + 1);
                    } else if (row < nbActors && col < nbActors) {
                        a = orgNew.getActorNew(aNames[row]);
                        ActorNew b = orgNew.getActorNew(aNames[col]);
                        Double val_sol_inf2 = RTFReports.shiftDecimal(b.getTarget(a.getName()).getActualInfluence(b, a, state), 1);
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(val_sol_inf2)), row + 1, col + 1);
                    } else if (row == nbActors && col < nbActors) {
                        a = orgNew.getActorNew(aNames[col]);
                        val_sol_inf = RTFReports.shiftDecimal(a.getAccumulatedActualInfluence(state), 1);
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(val_sol_inf)), row + 1, col + 1);
                    } else if (row == nbActors + 1 && col < nbActors) {
                        a = orgNew.getActorNew(aNames[col]);
                        val_sol_inf = RTFReports.shiftDecimal(a.getAccumulatedAbsoluteActualInfluence(a, state), 1);
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(val_sol_inf)), row + 1, col + 1);
                    } else if (row == nbActors + 2 && col < nbActors) {
                        a = orgNew.getActorNew(aNames[col]);
                        val_sol_inf = RTFReports.shiftDecimal(a.getAccumulatedCooperativeActualInfluence(a, state), 1);
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(val_sol_inf)), row + 1, col + 1);
                    }
                    ++col;
                }
                ++row;
            }
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
    }

    private static void fill_power_P(Table tab, OrgNew orgNew, SocialGameState state) {
        int nbActors = orgNew.getNbActorsNew();
        String[] aNames = orgNew.getActorsNewName();
        try {
            int row = 0;
            while (row < nbActors + 3) {
                int col = 0;
                while (col < nbActors + 1) {
                    String val_sol_inf;
                    double min;
                    double max;
                    double val;
                    ActorNew a;
                    if (row < nbActors && col == nbActors) {
                        a = orgNew.getActorNew(aNames[row]);
                        val = a.getActionCapacity(a, state);
                        max = a.getMaxActionCap();
                        min = a.getMinActionCap();
                        String val_satis = String.valueOf(String.valueOf(RTFReports.shiftDecimal((val - min) / (max - min) * 100.0, 1))) + " %";
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(val_satis)), row + 1, col + 1);
                    } else if (row < nbActors && col < nbActors) {
                        a = orgNew.getActorNew(aNames[row]);
                        ActorNew b = orgNew.getActorNew(aNames[col]);
                        double val2 = b.getTarget(a.getName()).getActualPower(b, a, state);
                        double max2 = b.getTarget(a.getName()).getMaxActualPowerBrut();
                        double min2 = b.getTarget(a.getName()).getMinActualPower();
                        String val_sol_inf2 = String.valueOf(String.valueOf(RTFReports.shiftDecimal((val2 - min2) / (max2 - min2) * 100.0, 1))) + " %";
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(val_sol_inf2)), row + 1, col + 1);
                    } else if (row == nbActors && col < nbActors) {
                        a = orgNew.getActorNew(aNames[col]);
                        val = a.getAccumulatedActualPowerBrut(a, state);
                        max = a.getMaxSitPowerBrut();
                        min = a.getMinSitPowerBrut();
                        val_sol_inf = String.valueOf(String.valueOf(RTFReports.shiftDecimal((val - min) / (max - min) * 100.0, 1))) + " %";
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(val_sol_inf)), row + 1, col + 1);
                    } else if (row == nbActors + 1 && col < nbActors) {
                        a = orgNew.getActorNew(aNames[col]);
                        val = a.getAccumulatedAbsoluteActualPower(a, state);
                        max = a.getMaxSitAbsolutePowerBrut();
                        min = a.getMinSitAbsolutePowerBrut();
                        val_sol_inf = String.valueOf(String.valueOf(RTFReports.shiftDecimal((val - min) / (max - min) * 100.0, 1))) + " %";
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(val_sol_inf)), row + 1, col + 1);
                    } else if (row == nbActors + 2 && col < nbActors) {
                        a = orgNew.getActorNew(aNames[col]);
                        val = a.getAccumulatedCooperativeActualPowerBrut(a, state);
                        max = a.getMaxSitCooperativePowerBrut();
                        min = a.getMinSitCooperativePowerBrut();
                        val_sol_inf = String.valueOf(String.valueOf(RTFReports.shiftDecimal((val - min) / (max - min) * 100.0, 1))) + " %";
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(val_sol_inf)), row + 1, col + 1);
                    }
                    ++col;
                }
                ++row;
            }
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
    }

    private static void fillSatisInfTabPercent(Table tab, OrgNew orgNew, SocialGameState state) {
        int nbActors = orgNew.getNbActorsNew();
        String[] aNames = orgNew.getActorsNewName();
        try {
            int row = 0;
            while (row < nbActors + 3) {
                int col = 0;
                while (col < nbActors + 2) {
                    double val;
                    double min;
                    double max;
                    ActorNew a;
                    if (row < nbActors && col == nbActors) {
                        a = orgNew.getActorNew(aNames[row]);
                        double val2 = a.getSatisfaction(a, state);
                        max = a.getMaxSatis();
                        min = a.getMinSatis();
                        String val_satis = String.valueOf(String.valueOf(RTFReports.shiftDecimal((val2 - min) / (max - min) * 100.0, 1))) + " %";
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(val_satis)), row + 1, col + 1);
                    } else if (row < nbActors && col == nbActors + 1) {
                        a = orgNew.getActorNew(aNames[row]);
                        double val3 = a.getTarget(a.getName()).getActualInfluence(a, a, state);
                        double min2 = a.getTarget(a.getName()).getMinActualInfluence();
                        double sat = a.getSatisfaction(a, state);
                        double minsat = a.getMinSatis();
                        String val_satis = String.valueOf(String.valueOf(RTFReports.shiftDecimal((val3 - min2) / (sat - minsat) * 100.0, 1))) + " %";
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(val_satis)), row + 1, col + 1);
                    } else if (row < nbActors && col < nbActors) {
                        a = orgNew.getActorNew(aNames[row]);
                        ActorNew b = orgNew.getActorNew(aNames[col]);
                        val = b.getTarget(a.getName()).getActualInfluence(b, a, state);
                        double max2 = b.getTarget(a.getName()).getMaxActualInfluence();
                        double min3 = b.getTarget(a.getName()).getMinActualInfluence();
                        String val_sol_inf = String.valueOf(String.valueOf(RTFReports.shiftDecimal((val - min3) / (max2 - min3) * 100.0, 1))) + " %";
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(val_sol_inf)), row + 1, col + 1);
                    } else if (row == nbActors && col < nbActors) {
                        a = orgNew.getActorNew(aNames[col]);
                        double val4 = a.getAccumulatedActualInfluence(state);
                        max = a.getMaxSitInfluence();
                        min = a.getMinSitInfluence();
                        String val_sol_inf = String.valueOf(String.valueOf(RTFReports.shiftDecimal((val4 - min) / (max - min) * 100.0, 1))) + " %";
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(val_sol_inf)), row + 1, col + 1);
                    } else if (row == nbActors + 1 && col < nbActors) {
                        a = orgNew.getActorNew(aNames[col]);
                        double val5 = 0.0;
                        max = 0.0;
                        int i = 0;
                        while (i < nbActors) {
                            ActorNew b = orgNew.getActorNew(aNames[i]);
                            double v = a.getTarget(b.getName()).getActualInfluence(a, b, state);
                            if (v >= 0.0) {
                                val5 += v;
                                max += a.getTarget(b.getName()).getMaxActualInfluence();
                            } else {
                                val5 -= v;
                                max -= a.getTarget(b.getName()).getMinActualInfluence();
                            }
                            ++i;
                        }
                        String val_sol_inf = String.valueOf(String.valueOf(RTFReports.shiftDecimal(val5 / max * 100.0, 1))) + " %";
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(val_sol_inf)), row + 1, col + 1);
                    } else if (row == nbActors + 2 && col < nbActors) {
                        double mininfl;
                        a = orgNew.getActorNew(aNames[col]);
                        val = a.getTarget(a.getName()).getActualInfluence(a, a, state);
                        double min4 = a.getTarget(a.getName()).getMinActualInfluence();
                        double infl = a.getAccumulatedActualInfluence(state);
                        String res = infl > (mininfl = a.getMinSitInfluence()) ? String.valueOf(String.valueOf(RTFReports.shiftDecimal((val - min4) / (infl - mininfl) * 100.0, 1))) + " %" : "--";
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(res)), row + 1, col + 1);
                    }
                    ++col;
                }
                ++row;
            }
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
    }

    private static void fillStateTab(Table tab, OrgNew orgNew, SocialGameState state) {
        int nbRelations = orgNew.getNbRelationsNew();
        String[] rNames = orgNew.getRelationsNewName();
        try {
            int row = 0;
            while (row < nbRelations) {
                int col = 0;
                while (col < 3) {
                    RelationNew rN;
                    if (col == 0) {
                        rN = orgNew.getRelationNew(rNames[row]);
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(rN.getName())), row + 1, col);
                    } else if (col == 1) {
                        rN = orgNew.getRelationNew(rNames[row]);
                        Double val_state = state.getRelationState(rN);
                        val_state = RTFReports.shiftDecimal(val_state, 2);
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(val_state)), row + 1, col);
                    } else if (col == 2) {
                        rN = orgNew.getRelationNew(rNames[row]);
                        QualitativeScale scale = new QualitativeScale();
                        if (rN.getNbInterpretations() == 0) {
                            scale = null;
                        } else {
                            int i = 0;
                            while (i < rN.getNbInterpretations()) {
                                double stateBegin = rN.getInterpretations().elementAt(i).getStateBegin();
                                double stateEnd = rN.getInterpretations().elementAt(i).getStateEnd();
                                boolean inBegin = rN.getInterpretations().elementAt(i).getIncludeBegin();
                                boolean inEnd = rN.getInterpretations().elementAt(i).getIncludeEnd();
                                String desc = rN.getInterpretations().elementAt(i).getDescription();
                                Interval interval = new Interval(stateBegin, stateEnd, inBegin, inEnd);
                                scale.addInterval(interval);
                                scale.putInterpretation(interval, desc);
                                ++i;
                            }
                        }
                        String inter = "NO INTERPRETATION";
                        if (scale != null) {
                            inter = scale.getQuality(state.getRelationState(rN));
                        }
                        tab.addCell((Cell)((RtfCell)RTFReports.create_Cell(inter)), row + 1, col);
                    }
                    ++col;
                }
                ++row;
            }
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
    }

    private static void fillStateTabTitres(Table tab, OrgNew orgNew, SocialGameState s) {
        try {
            Chunk chunk = new Chunk("Relations", (Font)nameFont);
            RtfCell cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            tab.addCell((Cell)cell, 0, 0);
            chunk = new Chunk("States", (Font)nameFont);
            cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            tab.addCell((Cell)cell, 0, 1);
            chunk = new Chunk("Interpretations", (Font)nameFont);
            cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            tab.addCell((Cell)cell, 0, 2);
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
    }

    private static void fillSatisInfTabTitres(Table tab, OrgNew orgNew) {
        try {
            Chunk chunk = new Chunk("Satisfaction", (Font)nameFont);
            RtfCell cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            tab.addCell((Cell)cell, 0, orgNew.getNbActorsNew() + 1);
            int row = 0;
            while (row < orgNew.getNbActorsNew()) {
                String actor_name = orgNew.getActorsNewName()[row];
                chunk = new Chunk(actor_name, (Font)nameFont);
                cell = new RtfCell((Element)chunk);
                cell.setBorders(border);
                cell.setBackgroundColor(Color.lightGray);
                tab.addCell((Cell)cell, row + 1, 0);
                tab.addCell((Cell)cell, 0, row + 1);
                ++row;
            }
            chunk = new Chunk("Influence", (Font)nameFont);
            cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            tab.addCell((Cell)cell, orgNew.getNbActorsNew() + 1, 0);
            chunk = new Chunk("Absolute Influence", (Font)nameFont);
            cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            tab.addCell((Cell)cell, orgNew.getNbActorsNew() + 2, 0);
            chunk = new Chunk("Cooperative Influence", (Font)nameFont);
            cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            tab.addCell((Cell)cell, orgNew.getNbActorsNew() + 3, 0);
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
    }

    private static void fill_power_titres(Table tab, OrgNew orgNew) {
        try {
            Chunk chunk = new Chunk("Action Capacity", (Font)nameFont);
            RtfCell cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            tab.addCell((Cell)cell, 0, orgNew.getNbActorsNew() + 1);
            int row = 0;
            while (row < orgNew.getNbActorsNew()) {
                String actor_name = orgNew.getActorsNewName()[row];
                chunk = new Chunk(actor_name, (Font)nameFont);
                cell = new RtfCell((Element)chunk);
                cell.setBorders(border);
                cell.setBackgroundColor(Color.lightGray);
                tab.addCell((Cell)cell, row + 1, 0);
                tab.addCell((Cell)cell, 0, row + 1);
                ++row;
            }
            chunk = new Chunk("Power", (Font)nameFont);
            cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            tab.addCell((Cell)cell, orgNew.getNbActorsNew() + 1, 0);
            chunk = new Chunk("Absolute Power", (Font)nameFont);
            cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            tab.addCell((Cell)cell, orgNew.getNbActorsNew() + 2, 0);
            chunk = new Chunk("Cooperative Power", (Font)nameFont);
            cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            tab.addCell((Cell)cell, orgNew.getNbActorsNew() + 3, 0);
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
    }

    private static void fillSatisInfPercentTabTitres(Table tab, OrgNew orgNew) {
        try {
            Chunk chunk = new Chunk("Satisfaction", (Font)nameFont);
            RtfCell cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            tab.addCell((Cell)cell, 0, orgNew.getNbActorsNew() + 1);
            chunk = new Chunk("Auto Satisfaction", (Font)nameFont);
            cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            tab.addCell((Cell)cell, 0, orgNew.getNbActorsNew() + 2);
            int row = 0;
            while (row < orgNew.getNbActorsNew()) {
                String actor_name = orgNew.getActorsNewName()[row];
                chunk = new Chunk(actor_name, (Font)nameFont);
                cell = new RtfCell((Element)chunk);
                cell.setBorders(border);
                cell.setBackgroundColor(Color.lightGray);
                tab.addCell((Cell)cell, row + 1, 0);
                tab.addCell((Cell)cell, 0, row + 1);
                ++row;
            }
            chunk = new Chunk("Influence", (Font)nameFont);
            cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            tab.addCell((Cell)cell, orgNew.getNbActorsNew() + 1, 0);
            chunk = new Chunk("Absolute Influence", (Font)nameFont);
            cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            tab.addCell((Cell)cell, orgNew.getNbActorsNew() + 2, 0);
            chunk = new Chunk("Auto Influence", (Font)nameFont);
            cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            tab.addCell((Cell)cell, orgNew.getNbActorsNew() + 3, 0);
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
    }

    private static void fill_power_P_titres(Table tab, OrgNew orgNew) {
        try {
            Chunk chunk = new Chunk("Action Capacity", (Font)nameFont);
            RtfCell cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            tab.addCell((Cell)cell, 0, orgNew.getNbActorsNew() + 1);
            int row = 0;
            while (row < orgNew.getNbActorsNew()) {
                String actor_name = orgNew.getActorsNewName()[row];
                chunk = new Chunk(actor_name, (Font)nameFont);
                cell = new RtfCell((Element)chunk);
                cell.setBorders(border);
                cell.setBackgroundColor(Color.lightGray);
                tab.addCell((Cell)cell, row + 1, 0);
                tab.addCell((Cell)cell, 0, row + 1);
                ++row;
            }
            chunk = new Chunk("Power", (Font)nameFont);
            cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            tab.addCell((Cell)cell, orgNew.getNbActorsNew() + 1, 0);
            chunk = new Chunk("Absolute Power", (Font)nameFont);
            cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            tab.addCell((Cell)cell, orgNew.getNbActorsNew() + 2, 0);
            chunk = new Chunk("Cooperative Power", (Font)nameFont);
            cell = new RtfCell((Element)chunk);
            cell.setBorders(border);
            cell.setBackgroundColor(Color.lightGray);
            tab.addCell((Cell)cell, orgNew.getNbActorsNew() + 3, 0);
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
    }

    private static Object getTabType_Onglet(String onglet, OrgNew orgNew, SocialGameState state) {
        try {
            Table tab_res = new Table(1, 1);
            if (onglet.equals("Interpretation")) {
                tab_res = new Table(3, orgNew.getNbRelationsNew() + 1);
                RTFReports.fillStateTab(tab_res, orgNew, state);
                RTFReports.fillStateTabTitres(tab_res, orgNew, state);
            }
            if (onglet.equals("Influence / Satisfaction")) {
                tab_res = new Table(orgNew.getNbActorsNew() + 2, orgNew.getNbActorsNew() + 4);
                RTFReports.fill_sol(tab_res, orgNew, state);
                RTFReports.fillSatisInfTabTitres(tab_res, orgNew);
            }
            if (onglet.equals("Power / Actions Capacity")) {
                tab_res = new Table(orgNew.getNbActorsNew() + 2, orgNew.getNbActorsNew() + 4);
                RTFReports.fill_power(tab_res, orgNew, state);
                RTFReports.fill_power_titres(tab_res, orgNew);
            }
            if (onglet.equals("Influence / Satisfaction %")) {
                tab_res = new Table(orgNew.getNbActorsNew() + 3, orgNew.getNbActorsNew() + 4);
                RTFReports.fillSatisInfTabPercent(tab_res, orgNew, state);
                RTFReports.fillSatisInfPercentTabTitres(tab_res, orgNew);
            }
            if (onglet.equals("Power / Actions Capacity %")) {
                tab_res = new Table(orgNew.getNbActorsNew() + 2, orgNew.getNbActorsNew() + 4);
                RTFReports.fill_power_P(tab_res, orgNew, state);
                RTFReports.fill_power_P_titres(tab_res, orgNew);
            }
            return tab_res;
        }
        catch (BadElementException e) {
            e.printStackTrace();
            return new Object();
        }
    }

    public static void makeAnalysisReport(OrgNew orgNew) {
        RtfParagraphStyle tocLevel1Style = new RtfParagraphStyle("toc 1", "Times New Roman", 13, 1, Color.BLACK);
        tocLevel1Style.setSpacingAfter(0);
        tocLevel1Style.setSpacingBefore(0);
        RtfParagraphStyle tocLevel2Style = new RtfParagraphStyle("toc 2", "Times New Roman", 12, 1, Color.BLACK);
        tocLevel2Style.setSpacingAfter(0);
        tocLevel2Style.setSpacingBefore(0);
        RtfParagraphStyle tocLevel3Style = new RtfParagraphStyle("toc 3", "Times New Roman", 12, 1, Color.BLACK);
        tocLevel3Style.setSpacingAfter(0);
        tocLevel3Style.setSpacingBefore(0);
        RtfParagraphStyle.STYLE_NORMAL.setFontName("Times New Roman");
        RtfParagraphStyle.STYLE_NORMAL.setAlignment(3);
        RtfParagraphStyle.STYLE_NORMAL.setSpacingAfter(0);
        RtfParagraphStyle tableLegend = new RtfParagraphStyle("toc 4", "Times New Roman", 10, 2, Color.BLACK);
        tableLegend.setAlignment(1);
        tableLegend.setSpacingAfter(0);
        tableLegend.setSpacingBefore(0);
        Document document = new Document();
        try {
            Section section;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd_HH.mm.ss");
            File file = new File(String.valueOf(SocLabToolkit.currentOrgNew.getCurrentModelEditorPath()) + File.separatorChar + orgNew.getName() + "_" + sdf.format(new Date()) + "_StatesAnalysis.rtf");
            FileOutputStream os = new FileOutputStream(file);
            RtfWriter2 rtfWriter2 = RtfWriter2.getInstance((Document)document, (OutputStream)os);
            rtfWriter2.getDocumentSettings().registerParagraphStyle(tocLevel1Style);
            rtfWriter2.getDocumentSettings().registerParagraphStyle(tocLevel2Style);
            rtfWriter2.getDocumentSettings().registerParagraphStyle(tocLevel3Style);
            rtfWriter2.getDocumentSettings().registerParagraphStyle(tableLegend);
            document.setHeader(new HeaderFooter(new Phrase("Generated by SocLab - State Analysis of: " + orgNew.getName() + " \n"), false));
            document.setFooter(new HeaderFooter(new Phrase("\n" + sdf.format(new Date())), false));
            document.addAuthor("SocLab");
            document.open();
            ChapterAutoNumber chapter1 = new ChapterAutoNumber("Tables section");
            for (String s : etat_inclus.keySet()) {
                section = chapter1.addSection(new Paragraph(s));
                Table tab = (Table)RTFReports.getTabType_Onglet((String)etat_inclus.get(s)[0], orgNew, (SocialGameState)etat_inclus.get(s)[1]);
                section.add((Object)tab);
            }
            document.add((Element)chapter1);
            ChapterAutoNumber chapter2 = new ChapterAutoNumber("Panels section");
            for (Object[] img : images) {
                File jpeg = File.createTempFile("img_", "_rtfGeneration");
                BufferedImage Bimage = (BufferedImage)img[0];
                ImageIO.write((RenderedImage)Bimage, "JPEG", jpeg);
                Image image = Image.getInstance((String)jpeg.getAbsolutePath());
                if (img[1].toString().endsWith("sliders")) {
                    image.scaleAbsoluteHeight(70.0f);
                } else {
                    image.scaleAbsoluteHeight(300.0f);
                }
                image.scaleAbsoluteWidth(450.0f);
                Paragraph paragraph = new Paragraph(new Chunk(".", (Font)hackFont));
                paragraph.add((Object)new Chunk(image, 1.0f, -1.0f, false));
                section = chapter2.addSection(new Paragraph((String)img[1]));
                section.add((Object)paragraph);
                jpeg.deleteOnExit();
            }
            document.add((Element)chapter2);
            etat_inclus.clear();
            images.clear();
            document.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void addPanelToReport(JPanel panel, String title, String comment) {
        Object[] temp = new Object[]{RTFReports.getImage(panel), title, comment};
        images.add(temp);
    }

    private static BufferedImage getImage(Component comp) {
        if (comp == null) {
            return null;
        }
        int width = comp.getWidth();
        int height = comp.getHeight();
        BufferedImage img = new BufferedImage(width, height, 5);
        Graphics2D g = img.createGraphics();
        comp.paint(g);
        g.dispose();
        return img;
    }

    public static void addTable_to_Report(SocialGameState etat, String onglet, OrgNew orgNew) {
        String nom_etat = new String(String.valueOf(etat.getName()) + ": " + onglet);
        if (!etat_inclus.containsKey(nom_etat)) {
            Object[] carac = new Object[]{onglet, etat};
            etat_inclus.put(nom_etat, carac);
        }
    }

    private static double shiftDecimal(double d, int decay) {
        double coef = Math.pow(10.0, decay);
        double result = d * coef;
        return (double)Math.round(result) / coef;
    }

    public String shiftDecimal_(double d, int decay) {
        return String.format("%.2f", d);
    }
}

