/*
 * Decompiled with CFR 0.152.
 */
package SocLab.tools.fileKit;

import SocLab.core.ActorNew;
import SocLab.core.ConstraintsElement;
import SocLab.core.EffectNew;
import SocLab.core.OrgNew;
import SocLab.core.RelationNew;
import SocLab.core.SocLabToolkit;
import SocLab.core.SocialGameState;
import SocLab.core.structures.ActorActor;
import SocLab.core.structures.Control;
import SocLab.core.structures.Depend;
import SocLab.core.structures.Interpretation;
import SocLab.core.structures.RelationRelation;
import SocLab.tools.functions.AbsFunction;
import SocLab.tools.functions.AbstractFunction;
import SocLab.tools.functions.ComplexSigmoid2Function;
import SocLab.tools.functions.ComplexSigmoidFunction;
import SocLab.tools.functions.ConstanteFunction;
import SocLab.tools.functions.GaussianFunction;
import SocLab.tools.functions.LinearFunction;
import SocLab.tools.functions.QuadraticFunction;
import SocLab.tools.functions.QuadraticFunction2;
import SocLab.tools.functions.Sigmoid2Function;
import SocLab.tools.functions.SigmoidFunction;
import SocLab.tools.functions.x3function;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class OrgIOToolkit {
    public static String orgExt = ".org";

    public static String saveObjectNew(OrgNew orgNew) {
        int j;
        ActorNew aa;
        int i;
        String xmlNew = "";
        if (orgNew == null) {
            return "";
        }
        xmlNew = "<Organisation name=\"";
        xmlNew = String.valueOf(xmlNew) + orgNew.getName();
        xmlNew = String.valueOf(xmlNew) + "\" description=\"";
        xmlNew = String.valueOf(xmlNew) + orgNew.getDescription();
        SimpleDateFormat datef = new SimpleDateFormat("yyyy-MM-dd");
        xmlNew = String.valueOf(xmlNew) + "\" date=\"" + datef.format(new Date());
        xmlNew = String.valueOf(xmlNew) + "\">\n";
        xmlNew = String.valueOf(xmlNew) + "\t<SimulationParams>\n";
        xmlNew = String.valueOf(xmlNew) + "\t\t<nbRuns>" + orgNew.getNbRuns() + "</nbRuns>\n";
        xmlNew = String.valueOf(xmlNew) + "\t\t<nbSteps>" + orgNew.getNbSteps() + "</nbSteps>\n";
        xmlNew = String.valueOf(xmlNew) + "\t\t<simulationDescription>" + orgNew.getSimuDescription() + "</simulationDescription>\n";
        xmlNew = String.valueOf(xmlNew) + "\t\t<lastSimuPath>" + orgNew.getCurrentSimulationPath() + "</lastSimuPath>\n";
        xmlNew = String.valueOf(xmlNew) + "\t</SimulationParams>\n";
        xmlNew = String.valueOf(xmlNew) + "\t<SensitivityParams>\n";
        xmlNew = String.valueOf(xmlNew) + "\t\t<nbExperiences>" + orgNew.getNbExperiences() + "</nbExperiences>\n";
        xmlNew = String.valueOf(xmlNew) + "\t\t<sensitivityDescription>" + orgNew.getSensiDescription() + "</sensitivityDescription>\n";
        xmlNew = String.valueOf(xmlNew) + "\t\t<lastSensiPath>" + orgNew.getCurrentSensitivityPath() + "</lastSensiPath>\n";
        xmlNew = String.valueOf(xmlNew) + "\t\t<parameters>\n";
        if (orgNew.getSensitivityParameters() != null) {
            i = 0;
            while (i < orgNew.getSensitivityParameters().length) {
                xmlNew = String.valueOf(xmlNew) + "\t\t\t<param>" + orgNew.getSensitivityParameters()[i] + "</param>\n";
                ++i;
            }
        }
        xmlNew = String.valueOf(xmlNew) + "\t\t</parameters>\n";
        xmlNew = String.valueOf(xmlNew) + "\t</SensitivityParams>\n";
        xmlNew = String.valueOf(xmlNew) + "\t<Actors>\n";
        i = 0;
        while (i < orgNew.getActorsNew().size()) {
            aa = orgNew.getActorsNew().elementAt(i);
            xmlNew = String.valueOf(xmlNew) + "\t\t<Actor name=\"";
            xmlNew = String.valueOf(xmlNew) + aa.getName();
            xmlNew = String.valueOf(xmlNew) + "\" description=\"";
            xmlNew = String.valueOf(xmlNew) + aa.getDescription();
            xmlNew = String.valueOf(xmlNew) + "\">\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t<Initial>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<scope>" + aa.getAPNInitial().getScope() + "</scope>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<oblivion>" + aa.getAPNInitial().getOblivion() + "</oblivion>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<reward>" + aa.getAPNInitial().getReward() + "</reward>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<typeOfRules>" + aa.getAPNInitial().getTypeOfRules() + "</typeOfRules>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<repartitionPourcentage>" + aa.getAPNInitial().getRepartitionPourcentage() + "</repartitionPourcentage>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<tenacity>" + aa.getAPNInitial().getTenacity() + "</tenacity>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<reactivity>" + aa.getAPNInitial().getReactivity() + "</reactivity>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<MoralSensibility>" + aa.getAPNInitial().getMoralSensibility() + "</MoralSensibility>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<actionRange>" + aa.getAPNInitial().getActionRange() + "</actionRange>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<evaluationCriterium>" + aa.getAPNInitial().getEvaluationCriterium() + "</evaluationCriterium>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t</Initial>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t<Current>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<scope>" + aa.getAPNCurrent().getScope() + "</scope>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<oblivion>" + aa.getAPNCurrent().getOblivion() + "</oblivion>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<reward>" + aa.getAPNCurrent().getReward() + "</reward>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<typeOfRules>" + aa.getAPNCurrent().getTypeOfRules() + "</typeOfRules>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<repartitionPourcentage>" + aa.getAPNCurrent().getRepartitionPourcentage() + "</repartitionPourcentage>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<tenacity>" + aa.getAPNCurrent().getTenacity() + "</tenacity>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<reactivity>" + aa.getAPNCurrent().getReactivity() + "</reactivity>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<MoralSensibility>" + aa.getAPNCurrent().getMoralSensibility() + "</MoralSensibility>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<actionRange>" + aa.getAPNCurrent().getActionRange() + "</actionRange>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<evaluationCriterium>" + aa.getAPNCurrent().getEvaluationCriterium() + "</evaluationCriterium>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t</Current>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t<CurrentMin>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<scope>" + aa.getAPNCurrentMin().getScope() + "</scope>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<oblivion>" + aa.getAPNCurrentMin().getOblivion() + "</oblivion>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<reward>" + aa.getAPNCurrentMin().getReward() + "</reward>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<typeOfRules>" + aa.getAPNCurrentMin().getTypeOfRules() + "</typeOfRules>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<repartitionPourcentage>" + aa.getAPNCurrentMin().getRepartitionPourcentage() + "</repartitionPourcentage>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<tenacity>" + aa.getAPNCurrentMin().getTenacity() + "</tenacity>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<reactivity>" + aa.getAPNCurrentMin().getReactivity() + "</reactivity>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<MoralSensibility>" + aa.getAPNCurrentMin().getMoralSensibility() + "</MoralSensibility>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<actionRange>" + aa.getAPNCurrentMin().getActionRange() + "</actionRange>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<evaluationCriterium>" + aa.getAPNCurrentMin().getEvaluationCriterium() + "</evaluationCriterium>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t</CurrentMin>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t<CurrentMax>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<scope>" + aa.getAPNCurrentMax().getScope() + "</scope>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<oblivion>" + aa.getAPNCurrentMax().getOblivion() + "</oblivion>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<reward>" + aa.getAPNCurrentMax().getReward() + "</reward>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<typeOfRules>" + aa.getAPNCurrentMax().getTypeOfRules() + "</typeOfRules>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<repartitionPourcentage>" + aa.getAPNCurrentMax().getRepartitionPourcentage() + "</repartitionPourcentage>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<tenacity>" + aa.getAPNCurrentMax().getTenacity() + "</tenacity>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<reactivity>" + aa.getAPNCurrentMax().getReactivity() + "</reactivity>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<MoralSensibility>" + aa.getAPNCurrentMax().getMoralSensibility() + "</MoralSensibility>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<actionRange>" + aa.getAPNCurrentMax().getActionRange() + "</actionRange>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<evaluationCriterium>" + aa.getAPNCurrentMax().getEvaluationCriterium() + "</evaluationCriterium>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t</CurrentMax>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t</Actor>\n";
            ++i;
        }
        xmlNew = String.valueOf(xmlNew) + "\t</Actors>\n";
        xmlNew = String.valueOf(xmlNew) + "\t<Relations>\n";
        i = 0;
        while (i < orgNew.getRelationsNew().size()) {
            RelationNew rr = orgNew.getRelationsNew().elementAt(i);
            xmlNew = String.valueOf(xmlNew) + "\t\t<Relation name=\"";
            xmlNew = String.valueOf(xmlNew) + rr.getName();
            xmlNew = String.valueOf(xmlNew) + "\" description=\"";
            xmlNew = String.valueOf(xmlNew) + rr.getDescription();
            xmlNew = String.valueOf(xmlNew) + "\" controller=\"";
            xmlNew = rr.getControlActor().getActorNew() == null ? String.valueOf(xmlNew) : String.valueOf(xmlNew) + rr.getControlActor().getActorNew().getName();
            xmlNew = String.valueOf(xmlNew) + "\">\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t<Initial>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<termsOfExchange>" + rr.getRPNInitial().getState() + "</termsOfExchange>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<lowerBound>" + rr.getRPNInitial().getLowerBound() + "</lowerBound>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<upperBound>" + rr.getRPNInitial().getUpperBound() + "</upperBound>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<frequency>" + rr.getRPNInitial().getFrequency() + "</frequency>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t</Initial>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t<Current>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<termsOfExchange>" + rr.getRPNCurrent().getState() + "</termsOfExchange>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<lowerBound>" + rr.getRPNCurrent().getLowerBound() + "</lowerBound>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<upperBound>" + rr.getRPNCurrent().getUpperBound() + "</upperBound>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<frequency>" + rr.getRPNCurrent().getFrequency() + "</frequency>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t</Current>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t\t<Interpretations>\n";
            j = 0;
            while (j < rr.getNbInterpretations()) {
                Interpretation in = rr.getInterpretations().elementAt(j);
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<Interpretation>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t\t<min>" + in.getStateBegin() + "</min>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t\t<max>" + in.getStateEnd() + "</max>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t\t<includeBegin>" + in.getIncludeBegin() + "</includeBegin>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t\t<includeEnd>" + in.getIncludeEnd() + "</includeEnd>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t\t<description>" + in.getDescription() + "</description>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t</Interpretation>\n";
                ++j;
            }
            xmlNew = String.valueOf(xmlNew) + "\t\t\t</Interpretations>\n";
            xmlNew = String.valueOf(xmlNew) + "\t\t</Relation>\n";
            ++i;
        }
        xmlNew = String.valueOf(xmlNew) + "\t</Relations>\n";
        xmlNew = String.valueOf(xmlNew) + "\t<Depends>\n";
        i = 0;
        while (i < orgNew.getActorsNew().size()) {
            aa = orgNew.getActorsNew().elementAt(i);
            j = 0;
            while (j < aa.getNbDependRelations()) {
                Depend d = aa.getDependRelations().elementAt(j);
                xmlNew = String.valueOf(xmlNew) + "\t\t<Depend Actor=\"";
                xmlNew = String.valueOf(xmlNew) + d.getActorNew().getName();
                xmlNew = String.valueOf(xmlNew) + "\" Relation=\"";
                xmlNew = String.valueOf(xmlNew) + d.getRelationNew().getName();
                xmlNew = String.valueOf(xmlNew) + "\">\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t<stake description=\"" + d.getStakeDesc() + "\">" + d.getStake() + "</stake>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t<fuzzyStake description=\"" + d.getFuzzyStakeDesc() + "\">\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<min>" + d.getFuzzyStakeMin() + "</min>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<max>" + d.getFuzzyStakeMax() + "</max>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t</fuzzyStake>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t<sensibilityAnalysis>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<min>" + d.getSensibilityAnalysisStakeMin() + "</min>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<max>" + d.getSensibilityAnalysisStakeMax() + "</max>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t</sensibilityAnalysis>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t<effect description=\"" + d.getEffectNewDesc() + "\">\n";
                EffectNew e = d.getEffectNew();
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<type>" + e.getFunction().getType() + "</type>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<params>\n";
                int k = 0;
                while (k < e.getFunction().getParamNames().length) {
                    String pN = e.getFunction().getParamNames()[k];
                    Double pV = e.getFunction().getParam(pN);
                    xmlNew = String.valueOf(xmlNew) + "\t\t\t\t\t<" + pN + ">" + pV.toString() + "</" + pN + ">\n";
                    ++k;
                }
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t</params>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<lowerBound>" + e.getFunction().getLowerBound() + "</lowerBound>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<upperBound>" + e.getFunction().getUpperBound() + "</upperBound>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<step>" + e.getFunction().getStep() + "</step>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<maxValue>" + e.getFunction().getMax() + "</maxValue>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<minValue>" + e.getFunction().getMin() + "</minValue>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<maxValueTE>" + e.getFunction().getMaxTE() + "</maxValueTE>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<minValueTE>" + e.getFunction().getMinTE() + "</minValueTE>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<name>" + e.getFunction().getName() + "</name>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t</effect>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t</Depend>\n";
                ++j;
            }
            ++i;
        }
        xmlNew = String.valueOf(xmlNew) + "\t</Depends>\n";
        xmlNew = String.valueOf(xmlNew) + "\t<ActorActors>\n";
        i = 0;
        while (i < orgNew.getActorsNew().size()) {
            ActorNew as = orgNew.getActorsNew().elementAt(i);
            j = 0;
            while (j < as.getTargets().size()) {
                ActorActor aa2 = as.getTargets().elementAt(j);
                xmlNew = String.valueOf(xmlNew) + "\t\t<ActorActor  ActorSource=\"";
                xmlNew = String.valueOf(xmlNew) + aa2.getActorSource().getName();
                xmlNew = String.valueOf(xmlNew) + "\" ActorTarget=\"";
                xmlNew = String.valueOf(xmlNew) + aa2.getActorTarget().getName();
                xmlNew = String.valueOf(xmlNew) + "\">\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t<solidarity description=\"" + aa2.getSolidarityDesc() + "\">" + aa2.getSolidarity() + "</solidarity>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t<fuzzySolidarity description=\"" + aa2.getFuzzySolidarityDesc() + "\">\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<min>" + aa2.getFuzzySolidarityMin() + "</min>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<max>" + aa2.getFuzzySolidarityMax() + "</max>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t</fuzzySolidarity>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t<sensibilityAnalysis>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<min>" + aa2.getSensibilityAnalysisSolidarityMin() + "</min>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<max>" + aa2.getSensibilityAnalysisSolidarityMax() + "</max>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t</sensibilityAnalysis>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t</ActorActor>\n";
                ++j;
            }
            ++i;
        }
        xmlNew = String.valueOf(xmlNew) + "\t</ActorActors>\n";
        xmlNew = String.valueOf(xmlNew) + "\t<RelationRelations>\n";
        i = 0;
        while (i < orgNew.getRelationsNew().size()) {
            RelationNew rs = orgNew.getRelationsNew().elementAt(i);
            j = 0;
            while (j < rs.getTargets().size()) {
                Double pV;
                String pN;
                RelationRelation rrs = rs.getTargets().elementAt(j);
                xmlNew = String.valueOf(xmlNew) + "\t\t<RelationRelation RelationSource=\"";
                xmlNew = String.valueOf(xmlNew) + rrs.getRelationSource().getName();
                xmlNew = String.valueOf(xmlNew) + "\" RelationTarget=\"";
                xmlNew = String.valueOf(xmlNew) + rrs.getRelationTarget().getName();
                xmlNew = String.valueOf(xmlNew) + "\" Description=\"";
                xmlNew = String.valueOf(xmlNew) + rrs.getDescription();
                xmlNew = String.valueOf(xmlNew) + "\">\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t<bminFunction>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<type>" + rrs.getBminFunction().getType() + "</type>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<params>\n";
                int k = 0;
                while (k < rrs.getBminFunction().getParamNames().length) {
                    pN = rrs.getBminFunction().getParamNames()[k];
                    pV = rrs.getBminFunction().getParam(pN);
                    xmlNew = String.valueOf(xmlNew) + "\t\t\t\t\t<" + pN + ">" + pV.toString() + "</" + pN + ">\n";
                    ++k;
                }
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t</params>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<name>" + rrs.getBminFunction().getName() + "</name>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t</bminFunction>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t<bmaxFunction>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<type>" + rrs.getBmaxFunction().getType() + "</type>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<params>\n";
                k = 0;
                while (k < rrs.getBmaxFunction().getParamNames().length) {
                    pN = rrs.getBmaxFunction().getParamNames()[k];
                    pV = rrs.getBmaxFunction().getParam(pN);
                    xmlNew = String.valueOf(xmlNew) + "\t\t\t\t\t<" + pN + ">" + pV.toString() + "</" + pN + ">\n";
                    ++k;
                }
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t</params>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<name>" + rrs.getBmaxFunction().getName() + "</name>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t\t</bmaxFunction>\n";
                xmlNew = String.valueOf(xmlNew) + "\t\t</RelationRelation>\n";
                ++j;
            }
            ++i;
        }
        xmlNew = String.valueOf(xmlNew) + "\t</RelationRelations>\n";
        xmlNew = String.valueOf(xmlNew) + "\t<StateAnalysis>\n";
        xmlNew = String.valueOf(xmlNew) + "\t\t<UserStates>\n";
        i = 0;
        while (i < orgNew.getNbUserSGS()) {
            xmlNew = String.valueOf(xmlNew) + "\t\t\t<" + orgNew.getUserSGS(i).getName() + ">\n";
            for (RelationNew rN : orgNew.getUserSGS(i).keySet()) {
                double val = orgNew.getUserSGS(i).getRelationState(rN);
                xmlNew = String.valueOf(xmlNew) + "\t\t\t\t<" + rN.getName() + ">" + val + "</" + rN.getName() + ">\n";
            }
            xmlNew = String.valueOf(xmlNew) + "\t\t\t</" + orgNew.getUserSGS(i).getName() + ">\n";
            ++i;
        }
        xmlNew = String.valueOf(xmlNew) + "\t\t</UserStates>\n";
        xmlNew = String.valueOf(xmlNew) + "\t</StateAnalysis>\n";
        xmlNew = String.valueOf(xmlNew) + "</Organisation>";
        return xmlNew;
    }

    public static OrgNew loadOrgNewStruct(File orgFile) throws Exception {
        String actorName;
        OrgNew orgNew = new OrgNew();
        String xmlNew = "";
        String fileName = String.valueOf(orgFile.getParent()) + File.separatorChar + orgFile.getName();
        FileInputStream myStream = new FileInputStream(fileName);
        xmlNew = IOUtils.toString((InputStream)myStream).trim();
        if (xmlNew.equals("")) {
            return null;
        }
        Document document = DocumentHelper.parseText((String)xmlNew);
        Element root = document.getRootElement();
        orgNew.setName(root.attributeValue("name"));
        orgNew.setDescription(root.attributeValue("description"));
        orgNew.setNbRuns(new Integer(root.element("SimulationParams").element("nbRuns").getText()));
        orgNew.setNbSteps(new Integer(root.element("SimulationParams").element("nbSteps").getText()));
        orgNew.setSimuDescription(root.element("SimulationParams").element("simulationDescription").getText());
        orgNew.setCurrentSimulationPath(root.element("SimulationParams").element("lastSimuPath").getText());
        orgNew.setNbExperiences(new Integer(root.element("SensitivityParams").element("nbExperiences").getText()));
        orgNew.setSimuDescription(root.element("SensitivityParams").element("sensitivityDescription").getText());
        orgNew.setCurrentSensitivityPath(root.element("SensitivityParams").element("lastSensiPath").getText());
        if (root.element("SensitivityParams").element("parameters").elements().size() > 0) {
            String[] params = new String[root.element("SensitivityParams").element("parameters").elements().size()];
            int j = 0;
            Iterator i = root.element("SensitivityParams").element("parameters").elementIterator("param");
            while (i.hasNext()) {
                Element param = (Element)i.next();
                params[j] = param.getText();
                ++j;
            }
            orgNew.setSensitivityParameters(params);
        }
        Iterator i = root.element("Actors").elementIterator("Actor");
        while (i.hasNext()) {
            Element actorsElement = (Element)i.next();
            actorName = actorsElement.attributeValue("name");
            String actorDescription = actorsElement.attributeValue("description");
            orgNew.addActorNew(actorName, actorDescription, orgNew);
            double scope = Double.valueOf(actorsElement.element("Initial").element("scope").getText());
            double oblivion = Double.valueOf(actorsElement.element("Initial").element("oblivion").getText());
            double reward = Double.valueOf(actorsElement.element("Initial").element("reward").getText());
            double typeOfRules = Double.valueOf(actorsElement.element("Initial").element("typeOfRules").getText());
            double repartitionPourcentage = Double.valueOf(actorsElement.element("Initial").element("repartitionPourcentage").getText());
            double evaluationCriterium = Double.valueOf(actorsElement.element("Initial").element("evaluationCriterium").getText());
            double tenacity = Double.valueOf(actorsElement.element("Initial").element("tenacity").getText());
            double reactivity = Double.valueOf(actorsElement.element("Initial").element("reactivity").getText());
            double moralSensibility = 0.0;
            try {
                moralSensibility = Double.valueOf(actorsElement.element("Initial").element("MoralSensibility").getText());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            double actionRange = Double.valueOf(actorsElement.element("Initial").element("actionRange").getText());
            orgNew.getActorNew(actorName).getAPNInitial().setScope(scope);
            orgNew.getActorNew(actorName).getAPNInitial().setOblivion(oblivion);
            orgNew.getActorNew(actorName).getAPNInitial().setReward(reward);
            orgNew.getActorNew(actorName).getAPNInitial().setTypeOfRules(typeOfRules);
            orgNew.getActorNew(actorName).getAPNInitial().setRepartitionPourcentage(repartitionPourcentage);
            orgNew.getActorNew(actorName).getAPNInitial().setEvaluationCriterium(evaluationCriterium);
            orgNew.getActorNew(actorName).getAPNInitial().setTenacity(tenacity);
            orgNew.getActorNew(actorName).getAPNInitial().setReactivity(reactivity);
            orgNew.getActorNew(actorName).getAPNInitial().setMoralSensibility(moralSensibility);
            orgNew.getActorNew(actorName).getAPNInitial().setActionRange(actionRange);
            scope = Double.valueOf(actorsElement.element("Current").element("scope").getText());
            oblivion = Double.valueOf(actorsElement.element("Current").element("oblivion").getText());
            reward = Double.valueOf(actorsElement.element("Current").element("reward").getText());
            typeOfRules = Double.valueOf(actorsElement.element("Current").element("typeOfRules").getText());
            repartitionPourcentage = Double.valueOf(actorsElement.element("Current").element("repartitionPourcentage").getText());
            evaluationCriterium = Double.valueOf(actorsElement.element("Current").element("evaluationCriterium").getText());
            tenacity = Double.valueOf(actorsElement.element("Current").element("tenacity").getText());
            reactivity = Double.valueOf(actorsElement.element("Current").element("reactivity").getText());
            try {
                moralSensibility = Double.valueOf(actorsElement.element("Current").element("MoralSensibility").getText());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            actionRange = Double.valueOf(actorsElement.element("Current").element("actionRange").getText());
            orgNew.getActorNew(actorName).getAPNCurrent().setScope(scope);
            orgNew.getActorNew(actorName).getAPNCurrent().setOblivion(oblivion);
            orgNew.getActorNew(actorName).getAPNCurrent().setReward(reward);
            orgNew.getActorNew(actorName).getAPNCurrent().setTypeOfRules(typeOfRules);
            orgNew.getActorNew(actorName).getAPNCurrent().setRepartitionPourcentage(repartitionPourcentage);
            orgNew.getActorNew(actorName).getAPNCurrent().setEvaluationCriterium(evaluationCriterium);
            orgNew.getActorNew(actorName).getAPNCurrent().setTenacity(tenacity);
            orgNew.getActorNew(actorName).getAPNCurrent().setReactivity(reactivity);
            orgNew.getActorNew(actorName).getAPNCurrent().setMoralSensibility(moralSensibility);
            orgNew.getActorNew(actorName).getAPNCurrent().setActionRange(actionRange);
            scope = Double.valueOf(actorsElement.element("CurrentMin").element("scope").getText());
            oblivion = Double.valueOf(actorsElement.element("CurrentMin").element("oblivion").getText());
            reward = Double.valueOf(actorsElement.element("CurrentMin").element("reward").getText());
            typeOfRules = Double.valueOf(actorsElement.element("CurrentMin").element("typeOfRules").getText());
            repartitionPourcentage = Double.valueOf(actorsElement.element("CurrentMin").element("repartitionPourcentage").getText());
            evaluationCriterium = Double.valueOf(actorsElement.element("CurrentMin").element("evaluationCriterium").getText());
            tenacity = Double.valueOf(actorsElement.element("CurrentMin").element("tenacity").getText());
            reactivity = Double.valueOf(actorsElement.element("CurrentMin").element("reactivity").getText());
            try {
                moralSensibility = Double.valueOf(actorsElement.element("CurrentMin").element("MoralSensibility").getText());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            actionRange = Double.valueOf(actorsElement.element("CurrentMin").element("actionRange").getText());
            orgNew.getActorNew(actorName).getAPNCurrentMin().setScope(scope);
            orgNew.getActorNew(actorName).getAPNCurrentMin().setOblivion(oblivion);
            orgNew.getActorNew(actorName).getAPNCurrentMin().setReward(reward);
            orgNew.getActorNew(actorName).getAPNCurrentMin().setTypeOfRules(typeOfRules);
            orgNew.getActorNew(actorName).getAPNCurrentMin().setRepartitionPourcentage(repartitionPourcentage);
            orgNew.getActorNew(actorName).getAPNCurrentMin().setEvaluationCriterium(evaluationCriterium);
            orgNew.getActorNew(actorName).getAPNCurrentMin().setTenacity(tenacity);
            orgNew.getActorNew(actorName).getAPNCurrentMin().setReactivity(reactivity);
            orgNew.getActorNew(actorName).getAPNCurrentMin().setMoralSensibility(moralSensibility);
            orgNew.getActorNew(actorName).getAPNCurrentMin().setActionRange(actionRange);
            scope = Double.valueOf(actorsElement.element("CurrentMax").element("scope").getText());
            oblivion = Double.valueOf(actorsElement.element("CurrentMax").element("oblivion").getText());
            reward = Double.valueOf(actorsElement.element("CurrentMax").element("reward").getText());
            typeOfRules = Double.valueOf(actorsElement.element("CurrentMax").element("typeOfRules").getText());
            repartitionPourcentage = Double.valueOf(actorsElement.element("CurrentMax").element("repartitionPourcentage").getText());
            evaluationCriterium = Double.valueOf(actorsElement.element("CurrentMax").element("evaluationCriterium").getText());
            tenacity = Double.valueOf(actorsElement.element("CurrentMax").element("tenacity").getText());
            reactivity = Double.valueOf(actorsElement.element("CurrentMax").element("reactivity").getText());
            try {
                moralSensibility = Double.valueOf(actorsElement.element("CurrentMax").element("MoralSensibility").getText());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            actionRange = Double.valueOf(actorsElement.element("CurrentMax").element("actionRange").getText());
            orgNew.getActorNew(actorName).getAPNCurrentMax().setScope(scope);
            orgNew.getActorNew(actorName).getAPNCurrentMax().setOblivion(oblivion);
            orgNew.getActorNew(actorName).getAPNCurrentMax().setReward(reward);
            orgNew.getActorNew(actorName).getAPNCurrentMax().setTypeOfRules(typeOfRules);
            orgNew.getActorNew(actorName).getAPNCurrentMax().setRepartitionPourcentage(repartitionPourcentage);
            orgNew.getActorNew(actorName).getAPNCurrentMax().setEvaluationCriterium(evaluationCriterium);
            orgNew.getActorNew(actorName).getAPNCurrentMax().setTenacity(tenacity);
            orgNew.getActorNew(actorName).getAPNCurrentMax().setReactivity(reactivity);
            orgNew.getActorNew(actorName).getAPNCurrentMax().setMoralSensibility(moralSensibility);
            orgNew.getActorNew(actorName).getAPNCurrentMax().setActionRange(actionRange);
        }
        i = root.element("Relations").elementIterator("Relation");
        while (i.hasNext()) {
            Element relationsElement = (Element)i.next();
            String relationName = relationsElement.attributeValue("name");
            String relationDescription = relationsElement.attributeValue("description");
            orgNew.addRelationNew(relationName, relationDescription);
            String controller = relationsElement.attributeValue("controller");
            if (controller.equals("")) {
                orgNew.getRelationNew(relationName).setControlActor(new Control(null, orgNew.getRelationNew(relationName)));
            } else {
                Control co = new Control(orgNew.getActorNew(controller), orgNew.getRelationNew(relationName));
                orgNew.getRelationNew(relationName).setControlActor(co);
                orgNew.getActorNew(controller).addControl(co);
            }
            double state = Double.valueOf(relationsElement.element("Initial").element("termsOfExchange").getText());
            double frequency = Double.valueOf(relationsElement.element("Initial").element("frequency").getText());
            double lowerBound = Double.valueOf(relationsElement.element("Initial").element("lowerBound").getText());
            double upperBound = Double.valueOf(relationsElement.element("Initial").element("upperBound").getText());
            orgNew.getRelationNew(relationName).getRPNInitial().setState(state);
            orgNew.getRelationNew(relationName).getRPNInitial().setFrequency(frequency);
            orgNew.getRelationNew(relationName).getRPNInitial().setLowerBound(lowerBound);
            orgNew.getRelationNew(relationName).getRPNInitial().setUpperBound(upperBound);
            state = Double.valueOf(relationsElement.element("Current").element("termsOfExchange").getText());
            frequency = Double.valueOf(relationsElement.element("Current").element("frequency").getText());
            lowerBound = Double.valueOf(relationsElement.element("Current").element("lowerBound").getText());
            upperBound = Double.valueOf(relationsElement.element("Current").element("upperBound").getText());
            orgNew.getRelationNew(relationName).getRPNCurrent().setState(state);
            orgNew.getRelationNew(relationName).getRPNCurrent().setFrequency(frequency);
            orgNew.getRelationNew(relationName).getRPNCurrent().setLowerBound(lowerBound);
            orgNew.getRelationNew(relationName).getRPNCurrent().setUpperBound(upperBound);
            Iterator j = relationsElement.element("Interpretations").elementIterator("Interpretation");
            while (j.hasNext()) {
                Element interpretationElement = (Element)j.next();
                double stateBegin = Double.valueOf(interpretationElement.element("min").getText());
                double stateEnd = Double.valueOf(interpretationElement.element("max").getText());
                boolean includeBegin = Boolean.valueOf(interpretationElement.element("includeBegin").getText());
                boolean includeEnd = Boolean.valueOf(interpretationElement.element("includeEnd").getText());
                String description = interpretationElement.element("description").getText();
                orgNew.getRelationNew(relationName).addInterpretation(new Interpretation(stateBegin, stateEnd, includeBegin, includeEnd, description));
            }
        }
        i = root.element("Depends").elementIterator("Depend");
        while (i.hasNext()) {
            Element dependElement = (Element)i.next();
            actorName = dependElement.attributeValue("Actor");
            String relationName = dependElement.attributeValue("Relation");
            double stake = Double.valueOf(dependElement.element("stake").getText());
            String stakeDesc = "";
            if (dependElement.element("stake").attributes().size() > 0) {
                stakeDesc = dependElement.element("stake").attributeValue("description");
            }
            double fuzzyStakeMin = Double.valueOf(dependElement.element("fuzzyStake").element("min").getText());
            double fuzzyStakeMax = Double.valueOf(dependElement.element("fuzzyStake").element("max").getText());
            double sensibilityAnalysisStakeMin = 0.0;
            double sensibilityAnalysisStakeMax = 0.0;
            if (dependElement.elements().toString().contains("sensibilityAnalysis")) {
                sensibilityAnalysisStakeMin = Double.valueOf(dependElement.element("sensibilityAnalysis").element("min").getText());
                sensibilityAnalysisStakeMax = Double.valueOf(dependElement.element("sensibilityAnalysis").element("max").getText());
            }
            String fuzzyStakeDesc = "";
            if (dependElement.element("fuzzyStake").attributes().size() > 0) {
                fuzzyStakeDesc = dependElement.element("fuzzyStake").attributeValue("description");
            }
            String effectDesc = "";
            if (dependElement.element("effect").attributes().size() > 0) {
                effectDesc = dependElement.element("effect").attributeValue("description");
            }
            String effectType = dependElement.element("effect").element("type").getText();
            int len = dependElement.element("effect").element("params").elements().size();
            String[] effectParams = new String[len];
            Double[] effectParamsValues = new Double[len];
            int z = 0;
            Iterator j = dependElement.element("effect").element("params").elementIterator();
            while (j.hasNext()) {
                Element paramsElement = (Element)j.next();
                effectParams[z] = new String(paramsElement.getName());
                effectParamsValues[z] = Double.valueOf(paramsElement.getText());
                ++z;
            }
            double effectLowerBound = Double.valueOf(dependElement.element("effect").element("lowerBound").getText());
            double effectUpperBound = Double.valueOf(dependElement.element("effect").element("upperBound").getText());
            double effectStep = Double.valueOf(dependElement.element("effect").element("step").getText());
            double effectMaxValue = Double.valueOf(dependElement.element("effect").element("maxValue").getText());
            double effectMinValue = Double.valueOf(dependElement.element("effect").element("minValue").getText());
            double effectMaxTE = Double.valueOf(dependElement.element("effect").element("maxValueTE").getText());
            double effectMinTE = Double.valueOf(dependElement.element("effect").element("minValueTE").getText());
            String effectName = dependElement.element("effect").element("name").getText();
            AbstractFunction ab = null;
            if (effectType.equals("Default")) {
                ab = OrgNew.effetNull;
            }
            if (effectType.equals("Constante")) {
                ab = new ConstanteFunction(effectName);
            }
            if (effectType.equals("linear")) {
                ab = new LinearFunction(effectName);
            }
            if (effectType.equals("abs_linear")) {
                ab = new AbsFunction(effectName);
            }
            if (effectType.equals("CS2F")) {
                ab = new ComplexSigmoid2Function(effectName);
            }
            if (effectType.equals("CSF")) {
                ab = new ComplexSigmoidFunction(effectName);
            }
            if (effectType.equals("gaussian")) {
                ab = new GaussianFunction(effectName);
            }
            if (effectType.equals("quadratic")) {
                ab = new QuadraticFunction(effectName);
            }
            if (effectType.equals("quadratic2")) {
                ab = new QuadraticFunction2(effectName);
            }
            if (effectType.equals("x3")) {
                ab = new x3function(effectName);
            }
            if (effectType.equals("S2F")) {
                ab = new Sigmoid2Function(effectName);
            }
            if (effectType.equals("SF")) {
                ab = new SigmoidFunction(effectName);
            }
            ab.setLowerBound(effectLowerBound);
            ab.setUpperBound(effectUpperBound);
            ab.setStep(effectStep);
            ab.setMax(effectMaxValue);
            ab.setMin(effectMinValue);
            ab.setMaxTE(effectMaxTE);
            ab.setMinTE(effectMinTE);
            ab.setName(effectName);
            z = 0;
            while (z < len) {
                ab.setParam(effectParams[z], effectParamsValues[z]);
                ++z;
            }
            ab.setType(effectType);
            ab.recompute();
            EffectNew ef = new EffectNew(null, ab);
            Depend de = new Depend(orgNew.getActorNew(actorName), orgNew.getRelationNew(relationName), stake, fuzzyStakeMin, fuzzyStakeMax, ef);
            de.setSensibilityAnalysisStakeMin(sensibilityAnalysisStakeMin);
            de.setSensibilityAnalysisStakeMax(sensibilityAnalysisStakeMax);
            de.setStakeDesc(stakeDesc);
            de.setFuzzyStakeDesc(fuzzyStakeDesc);
            de.setEffectNewDesc(effectDesc);
            ef.setDepend(de);
            de.setEffectNew(ef);
            orgNew.getActorNew(actorName).setDepend(de);
            orgNew.getRelationNew(relationName).setDepend(de);
        }
        i = root.element("ActorActors").elementIterator("ActorActor");
        while (i.hasNext()) {
            Element ActorActorElement = (Element)i.next();
            String actorSourceName = ActorActorElement.attributeValue("ActorSource");
            String actorTargetName = ActorActorElement.attributeValue("ActorTarget");
            double famin = Double.valueOf(ActorActorElement.element("fuzzySolidarity").element("min").getText());
            double famax = Double.valueOf(ActorActorElement.element("fuzzySolidarity").element("max").getText());
            double sAmin = 0.0;
            double sAmax = 0.0;
            if (ActorActorElement.elements().toString().contains("sensibilityAnalysis")) {
                sAmin = Double.valueOf(ActorActorElement.element("sensibilityAnalysis").element("min").getText());
                sAmax = Double.valueOf(ActorActorElement.element("sensibilityAnalysis").element("max").getText());
            }
            String fuzzySolidarityDesc = "";
            if (ActorActorElement.element("fuzzySolidarity").attributes().size() > 0) {
                fuzzySolidarityDesc = ActorActorElement.element("fuzzySolidarity").attributeValue("description");
            }
            double solidarity = Double.valueOf(ActorActorElement.element("solidarity").getText());
            String solidarityDesc = "";
            if (ActorActorElement.element("solidarity").attributes().size() > 0) {
                solidarityDesc = ActorActorElement.element("solidarity").attributeValue("description");
            }
            ActorActor aa = new ActorActor(solidarity, famin, famax, orgNew.getActorNew(actorSourceName), orgNew.getActorNew(actorTargetName));
            aa.setSensibilityAnalysisSolidarityMin(sAmin);
            aa.setSensibilityAnalysisSolidarityMax(sAmax);
            aa.setSolidarityDesc(solidarityDesc);
            aa.setFuzzySolidarityDesc(fuzzySolidarityDesc);
            orgNew.getActorNew(actorSourceName).setTarget(aa);
            orgNew.getActorNew(actorTargetName).setSource(aa);
        }
        i = root.element("RelationRelations").elementIterator("RelationRelation");
        while (i.hasNext()) {
            Element RelationRelationElement = (Element)i.next();
            String relationSourceName = RelationRelationElement.attributeValue("RelationSource");
            String relationTargetName = RelationRelationElement.attributeValue("RelationTarget");
            String desc = RelationRelationElement.attributeValue("Description");
            String bminType = RelationRelationElement.element("bminFunction").element("type").getText();
            int bminLen = RelationRelationElement.element("bminFunction").element("params").elements().size();
            String[] bminEffectParams = new String[bminLen];
            Double[] bminEffectParamsValues = new Double[bminLen];
            int z = 0;
            Iterator j = RelationRelationElement.element("bminFunction").element("params").elementIterator();
            while (j.hasNext()) {
                Element paramsElement = (Element)j.next();
                bminEffectParams[z] = new String(paramsElement.getName());
                bminEffectParamsValues[z] = Double.valueOf(paramsElement.getText());
                ++z;
            }
            String bminName = RelationRelationElement.element("bminFunction").element("name").getText();
            AbstractFunction bminFunction = null;
            if (bminType.equals("DefaultMin")) {
                bminFunction = OrgNew.effetMin;
            }
            if (bminType.equals("Constante")) {
                bminFunction = new ConstanteFunction(bminType);
            }
            if (bminType.equals("linear")) {
                bminFunction = new LinearFunction(bminType);
            }
            if (bminType.equals("abs_linear")) {
                bminFunction = new AbsFunction(bminType);
            }
            if (bminType.equals("CS2F")) {
                bminFunction = new ComplexSigmoid2Function(bminType);
            }
            if (bminType.equals("CSF")) {
                bminFunction = new ComplexSigmoidFunction(bminType);
            }
            if (bminType.equals("gaussian")) {
                bminFunction = new GaussianFunction(bminType);
            }
            if (bminType.equals("quadratic")) {
                bminFunction = new QuadraticFunction(bminType);
            }
            if (bminType.equals("quadratic2")) {
                bminFunction = new QuadraticFunction2(bminType);
            }
            if (bminType.equals("x3")) {
                bminFunction = new x3function(bminType);
            }
            if (bminType.equals("S2F")) {
                bminFunction = new Sigmoid2Function(bminType);
            }
            if (bminType.equals("SF")) {
                bminFunction = new SigmoidFunction(bminType);
            }
            bminFunction.setName(bminName);
            z = 0;
            while (z < bminLen) {
                bminFunction.setParam(bminEffectParams[z], bminEffectParamsValues[z]);
                ++z;
            }
            bminFunction.setType(bminType);
            bminFunction.recompute();
            String bmaxType = RelationRelationElement.element("bmaxFunction").element("type").getText();
            int bmaxLen = RelationRelationElement.element("bmaxFunction").element("params").elements().size();
            String[] bmaxEffectParams = new String[bmaxLen];
            Double[] bmaxEffectParamsValues = new Double[bmaxLen];
            z = 0;
            Iterator j2 = RelationRelationElement.element("bmaxFunction").element("params").elementIterator();
            while (j2.hasNext()) {
                Element paramsElement = (Element)j2.next();
                bmaxEffectParams[z] = new String(paramsElement.getName());
                bmaxEffectParamsValues[z] = Double.valueOf(paramsElement.getText());
                ++z;
            }
            String bmaxName = RelationRelationElement.element("bmaxFunction").element("name").getText();
            AbstractFunction bmaxFunction = null;
            if (bmaxType.equals("DefaultMax")) {
                bmaxFunction = OrgNew.effetMax;
            }
            if (bmaxType.equals("Constante")) {
                bmaxFunction = new ConstanteFunction(bmaxType);
            }
            if (bmaxType.equals("linear")) {
                bmaxFunction = new LinearFunction(bmaxType);
            }
            if (bmaxType.equals("abs_linear")) {
                bmaxFunction = new AbsFunction(bmaxType);
            }
            if (bmaxType.equals("CS2F")) {
                bmaxFunction = new ComplexSigmoid2Function(bmaxType);
            }
            if (bmaxType.equals("CSF")) {
                bmaxFunction = new ComplexSigmoidFunction(bmaxType);
            }
            if (bmaxType.equals("gaussian")) {
                bmaxFunction = new GaussianFunction(bmaxType);
            }
            if (bmaxType.equals("quadratic")) {
                bmaxFunction = new QuadraticFunction(bmaxType);
            }
            if (bmaxType.equals("quadratic2")) {
                bmaxFunction = new QuadraticFunction2(bmaxType);
            }
            if (bmaxType.equals("x3")) {
                bmaxFunction = new x3function(bmaxType);
            }
            if (bmaxType.equals("S2F")) {
                bmaxFunction = new Sigmoid2Function(bmaxType);
            }
            if (bmaxType.equals("SF")) {
                bmaxFunction = new SigmoidFunction(bmaxType);
            }
            bmaxFunction.setName(bmaxName);
            z = 0;
            while (z < bmaxLen) {
                bmaxFunction.setParam(bmaxEffectParams[z], bmaxEffectParamsValues[z]);
                ++z;
            }
            bmaxFunction.setType(bmaxType);
            bmaxFunction.recompute();
            RelationRelation rr = new RelationRelation(orgNew.getRelationNew(relationSourceName), orgNew.getRelationNew(relationTargetName), bminFunction, bmaxFunction);
            rr.setDescription(desc);
            orgNew.getRelationNew(relationSourceName).setTarget(rr);
            orgNew.getRelationNew(relationTargetName).setSource(rr);
        }
        ConstraintsElement temp = new ConstraintsElement(null);
        ConstraintsElement[] constraintsElementTemp = new ConstraintsElement[orgNew.getNbRelationsNew()];
        int i2 = 0;
        while (i2 < orgNew.getNbRelationsNew()) {
            constraintsElementTemp[i2] = new ConstraintsElement(orgNew.getRelationNew(orgNew.getRelationsNewName()[i2]));
            temp.addSons(constraintsElementTemp[i2]);
            constraintsElementTemp[i2].addFather(temp);
            ++i2;
        }
        orgNew.setConstraintsElementOriginal(temp);
        i2 = 0;
        while (i2 < orgNew.getNbRelationsNew()) {
            RelationNew rN = orgNew.getRelationNew(orgNew.getRelationsNewName()[i2]);
            int j = 0;
            while (j < rN.getNbTargets()) {
                RelationRelation rr = rN.getTargets().elementAt(j);
                if (rr.getBminFunction().getMax() > -10.0 || rr.getBmaxFunction().getMin() < 10.0) {
                    ConstraintsElement target;
                    ConstraintsElement source = orgNew.getConstraintsElement(rr.getRelationSource());
                    if (source.hadFather(source, target = orgNew.getConstraintsElement(rr.getRelationTarget())) || target.hadson(target, source)) {
                        ConstanteFunction bminFunction = OrgNew.effetMin;
                        ConstanteFunction bmaxFunction = OrgNew.effetMax;
                        rr.setBminFunction(bminFunction);
                        rr.setBmaxFunction(bmaxFunction);
                    } else {
                        source.addSons(target);
                        if (target.getNbFathers() == 1 && target.getFather(0).getHim() == null) {
                            target.getFather(0).delSons(target);
                            target.clearFathers();
                        }
                        target.addFather(source);
                    }
                }
                ++j;
            }
            ++i2;
        }
        if (root.elements().toString().contains("StateAnalysis")) {
            Iterator i3 = root.element("StateAnalysis").element("UserStates").elementIterator();
            while (i3.hasNext()) {
                Element UserStateElement = (Element)i3.next();
                String name = UserStateElement.getName();
                SocialGameState s = new SocialGameState();
                s.initState(orgNew);
                Iterator j = UserStateElement.elementIterator();
                while (j.hasNext()) {
                    Element UserStateRelationElement = (Element)j.next();
                    String relationName = UserStateRelationElement.getName();
                    double val = Double.valueOf(UserStateRelationElement.getStringValue());
                    s.setRelationState(orgNew.getRelationNew(relationName), val);
                }
                s.setName(name);
                orgNew.addStateToUserSGS(s);
            }
        }
        return orgNew;
    }

    public static void saveOrgNew(OrgNew orgNew, File orgFileNew) throws Exception {
        if (orgNew != null) {
            String xml = OrgIOToolkit.saveObjectNew(SocLabToolkit.currentOrgNew);
            String path = String.valueOf(orgFileNew.getParent()) + File.separatorChar;
            String fileName = String.valueOf(orgNew.getName()) + orgExt;
            File dir = new File(String.valueOf(path) + File.separatorChar);
            if (!dir.exists()) {
                dir.mkdir();
            }
            FileOutputStream fos = new FileOutputStream(String.valueOf(path) + fileName);
            fos.write(xml.getBytes());
            fos.flush();
            fos.close();
        }
    }

    public static void saveOrgNewTemp(OrgNew orgNew, File orgFileNew) throws Exception {
        if (orgNew != null) {
            String xml = OrgIOToolkit.saveObjectNew(SocLabToolkit.currentOrgNew);
            String path = String.valueOf(orgFileNew.getParent()) + File.separatorChar;
            String fileName = String.valueOf(orgNew.getName()) + "Temp" + orgExt;
            File dir = new File(String.valueOf(path) + File.separatorChar);
            if (!dir.exists()) {
                dir.mkdir();
            }
            FileOutputStream fos = new FileOutputStream(String.valueOf(path) + fileName);
            fos.write(xml.getBytes());
            fos.flush();
            fos.close();
        }
    }

    public static void saveOrgTempForSimulation(OrgNew orgNew, File orgFileNew) throws Exception {
        if (orgNew != null) {
            String xml = OrgIOToolkit.saveObjectNew(SocLabToolkit.currentOrgNew);
            FileOutputStream fos = new FileOutputStream(orgFileNew);
            fos.write(xml.getBytes());
            fos.flush();
            fos.close();
        }
    }
}

