/*
 * Decompiled with CFR 0.152.
 */
package SocLab.tools.functions;

import SocLab.tools.functions.AbstractFunction;

public class AbsFunction
extends AbstractFunction {
    private String type = "abs_linear";

    public AbsFunction(String name) {
        super(name);
        this.initParam();
        this.recompute();
    }

    @Override
    public void initParam() {
        this.setType("abs_linear");
        this.paramNames = new String[]{"a", "b", "c"};
        this.setParam("a", 0.0);
        this.setParam("b", 0.0);
        this.setParam("c", 0.0);
    }

    @Override
    public double effectFunction(double x) {
        double a = this.getParam("a") / 10.0;
        double b = this.getParam("b");
        double c = this.getParam("c");
        double val = a * Math.abs(x - c) + b;
        if (val < -10.0) {
            val = -10.0;
        }
        if (val > 10.0) {
            val = 10.0;
        }
        return val;
    }

    @Override
    public String getFormula() {
        return "f(x)=" + this.getParam("a") / 10.0 + "* |x - " + this.getParam("c") + "| + " + this.getParam("b");
    }

    @Override
    public String getType() {
        return this.type;
    }
}

