/*
 * Decompiled with CFR 0.152.
 */
package SocLab.tools.functions;

import SocLab.tools.functions.AbstractFunction;

public class ComplexSigmoid2Function
extends AbstractFunction {
    private String type = "CS2F";

    public ComplexSigmoid2Function(String name) {
        super(name);
        this.setType("CS2F");
        this.initParam();
        this.recompute();
    }

    @Override
    public void initParam() {
        this.paramNames = new String[]{"amplitude", "y_position", "slope", "x_position"};
        this.setParam("amplitude", 1.0);
        this.setParam("y_position", 0.0);
        this.setParam("slope", 0.0);
        this.setParam("x_position", 0.0);
    }

    @Override
    public double effectFunction(double x) {
        double exp2;
        double d;
        double a = this.getParam("amplitude");
        double b = this.getParam("y_position");
        double c = this.getParam("slope") / 10.0;
        double exp = Math.pow(Math.E, c * (x + (d = this.getParam("x_position"))));
        double val = a * (1.0 / (1.0 + exp) - 1.0 / (1.0 + (exp2 = Math.pow(Math.E, -c * (x + d))))) + b;
        if (val < -10.0) {
            val = -10.0;
        }
        if (val > 10.0) {
            val = 10.0;
        }
        return val;
    }

    @Override
    public String getFormula() {
        double a = this.getParam("amplitude");
        double b = this.getParam("y_position");
        double c = this.getParam("slope") / 10.0;
        double d = this.getParam("x_position");
        return "f(x) = " + a + "*(1/(1+E^" + c + "*(x+" + d + ")) - 1/(1+E^-" + c + "(*x+" + d + "))) + " + b;
    }

    @Override
    public String getType() {
        return this.type;
    }
}

