/*
 * Decompiled with CFR 0.152.
 */
package SocLab.tools.functions;

import SocLab.tools.functions.AbstractFunction;

public class QuadraticFunction2
extends AbstractFunction {
    private String type = "quadratic2";
    private double a = 1.0;
    private double b = 0.0;
    private double c = 0.0;

    public QuadraticFunction2(String name) {
        super(name);
        this.setType("quadratic2");
        this.initParam();
        this.recompute();
    }

    @Override
    public void initParam() {
        this.setType("quadratic2");
        this.paramNames = new String[]{"a", "b", "c"};
        this.setParam("a", 1.0);
        this.setParam("b", 0.0);
        this.setParam("c", 0.0);
    }

    @Override
    public double effectFunction(double x) {
        double r;
        this.a = this.getParam("a");
        this.b = this.getParam("b");
        this.c = this.getParam("c");
        if (this.a != 90.0 && this.a != -90.0) {
            double alpha = this.a * Math.PI / 180.0;
            r = Math.cos(alpha) / Math.sin(alpha);
        } else {
            r = 0.0;
        }
        double val = r * (x + this.b) * (x + this.b) + this.c;
        if (val < -10.0) {
            val = -10.0;
        }
        if (val > 10.0) {
            val = 10.0;
        }
        return val;
    }

    @Override
    public String getFormula() {
        return "f(x)=" + this.a + " * x^2 + " + this.b + " * x + " + this.c;
    }

    @Override
    public String getType() {
        return this.type;
    }
}

