/*
 * Decompiled with CFR 0.152.
 */
package SocLab.tools.functions;

import SocLab.tools.functions.AbstractFunction;

public class x3function
extends AbstractFunction {
    private String type = "x3";

    public x3function(String name) {
        super(name);
        this.setType("x3");
        this.initParam();
        this.recompute();
    }

    @Override
    public void initParam() {
        this.setType("x3");
        this.paramNames = new String[]{"a", "b", "c", "d"};
        this.setParam("a", 1.0);
        this.setParam("b", 0.0);
        this.setParam("c", 0.0);
        this.setParam("d", 0.0);
    }

    @Override
    public double effectFunction(double x) {
        double a = this.getParam("a") / 200.0;
        double b = this.getParam("b") / 10.0;
        double c = this.getParam("c") / 10.0;
        double d = this.getParam("d");
        double val = a * Math.pow(x, 3.0) + b * x * x + c * x + d;
        if (val < -10.0) {
            val = -10.0;
        }
        if (val > 10.0) {
            val = 10.0;
        }
        return val;
    }

    @Override
    public String getFormula() {
        double a = this.getParam("a") / 200.0;
        double b = this.getParam("b") / 10.0;
        double c = this.getParam("c") / 10.0;
        double d = this.getParam("d");
        return "f(x)=" + a + "* x^3 + " + b + "*x^2 + " + c + "*x +" + d;
    }

    @Override
    public String getType() {
        return this.type;
    }
}

