/*
 * Decompiled with CFR 0.152.
 */
package SocLab.tools.interval;

import SocLab.tools.interval.Interval;
import SocLab.tools.interval.IntervalSerie;
import java.util.HashMap;
import java.util.Vector;

public class QualitativeScale {
    private IntervalSerie intervalSerie = new IntervalSerie();
    private Vector<HashMap<Interval, String>> interpretations = new Vector();

    public QualitativeScale() {
        this.interpretations.add(new HashMap());
    }

    public String getQuality(double value) {
        int i = 0;
        while (i < this.getIntervalSerieSize()) {
            if (this.getIntervalAt(i).isIn(value)) {
                return this.getInterpretation(this.getIntervalAt(i));
            }
            ++i;
        }
        return "NO INTERPRETATION";
    }

    private String getInterpretation(Interval interval) {
        String s = this.interpretations.elementAt(0).get(interval);
        if (s == null) {
            s = "";
        }
        return s;
    }

    public String getInterpretationAt(int i) {
        Interval interval = this.intervalSerie.getIntervalAt(i);
        String s = this.interpretations.elementAt(0).get(interval);
        if (s == null) {
            s = "";
        }
        return s;
    }

    public String getNthInterpretationAt(int n, int i) {
        Interval interval = this.intervalSerie.getIntervalAt(i);
        String s = this.interpretations.elementAt(n).get(interval);
        if (s == null) {
            s = "";
        }
        return s;
    }

    public void addInterval(Interval interval) {
        this.intervalSerie.addInterval(interval);
    }

    public void removeIntervalAt(int at) {
        Interval interval = this.intervalSerie.removeIntervalAt(at);
        int i = 0;
        while (i < this.interpretations.size()) {
            this.interpretations.elementAt(i).remove(interval);
            ++i;
        }
    }

    public Interval getIntervalAt(int at) {
        return this.intervalSerie.getIntervalAt(at);
    }

    public void putInterpretation(Interval interval, String interpretation) {
        this.interpretations.elementAt(0).put(interval, interpretation);
    }

    public void putNthInterpretation(int n, int intervalIndex, String interpretation) {
        Interval interval = this.intervalSerie.getIntervalAt(intervalIndex);
        this.interpretations.elementAt(n).put(interval, interpretation);
    }

    public int getInterpretationsSize() {
        return this.interpretations.size();
    }

    public int getIntervalSerieSize() {
        return this.intervalSerie.intervals.size();
    }

    public String toString() {
        String result = "";
        int i = 0;
        while (i < this.getIntervalSerieSize()) {
            result = String.valueOf(result) + "( " + this.getIntervalAt(i) + " = " + this.getInterpretationAt(i) + " )";
            if (i < this.getIntervalSerieSize() - 1) {
                result = String.valueOf(result) + " // ";
            }
            ++i;
        }
        return result;
    }
}

