/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.CircleDrawer;
import chart.GraphicGenerator;
import chart.ResultCloud;
import chart.StandardPieItemLabelGenerator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYDrawableAnnotation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StatisticalBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.Drawable;
import org.jfree.ui.TextAnchor;
import statistic.StatImpl;

class JFreeChartGraphicGenerator
implements GraphicGenerator {
    JFreeChartGraphicGenerator() {
    }

    private JFreeChart getBarChartCompute(String title, String[] titles, double[] values) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        int i = 0;
        while (i < Math.min(titles.length, values.length)) {
            dataset.addValue(values[i], (Comparable)((Object)""), (Comparable)((Object)titles[i]));
            ++i;
        }
        JFreeChart chart = ChartFactory.createBarChart((String)title, null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        CategoryPlot plot = chart.getCategoryPlot();
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        renderer.setItemLabelsVisible(true);
        ItemLabelPosition p = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 0.0);
        renderer.setPositiveItemLabelPosition(p);
        plot.setRenderer(renderer);
        return chart;
    }

    private JFreeChart getBarChartWithDerivationCompute(String title, String[] titles, double[] values, double[] deviations) {
        DefaultStatisticalCategoryDataset dataset = new DefaultStatisticalCategoryDataset();
        int i = 0;
        while (i < Math.min(titles.length, Math.min(values.length, deviations.length))) {
            dataset.add(values[i], deviations[i], (Comparable)((Object)""), (Comparable)((Object)titles[i]));
            ++i;
        }
        CategoryAxis xAxis = new CategoryAxis("");
        NumberAxis yAxis = new NumberAxis("");
        StatisticalBarRenderer renderer = new StatisticalBarRenderer();
        CategoryPlot plot = new CategoryPlot((CategoryDataset)dataset, xAxis, (ValueAxis)yAxis, (CategoryItemRenderer)renderer);
        renderer.setItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        renderer.setItemLabelsVisible(true);
        ItemLabelPosition p = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 0.0);
        renderer.setPositiveItemLabelPosition(p);
        plot.setRenderer((CategoryItemRenderer)renderer);
        JFreeChart chart = new JFreeChart(title, (Plot)plot);
        chart.removeLegend();
        return chart;
    }

    private JFreeChart getBarChartHorizontalCompute(String title, String[] titles, double[] values) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        int i = 0;
        while (i < Math.min(titles.length, values.length)) {
            dataset.addValue(values[i], (Comparable)((Object)""), (Comparable)((Object)titles[i]));
            ++i;
        }
        JFreeChart chart = ChartFactory.createBarChart((String)title, null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)true, (boolean)false);
        CategoryPlot plot = chart.getCategoryPlot();
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        renderer.setItemLabelsVisible(true);
        ItemLabelPosition p = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 0.0);
        renderer.setPositiveItemLabelPosition(p);
        plot.setRenderer(renderer);
        return chart;
    }

    private JFreeChart getCurveCompute(String title, String courbeName, Point2D.Double[] values) {
        XYSeriesCollection dataset = new XYSeriesCollection();
        XYSeries series = new XYSeries((Comparable)((Object)courbeName));
        int i = 0;
        while (i < values.length) {
            series.add(values[i].getX(), values[i].getY());
            ++i;
        }
        dataset.addSeries(series);
        return ChartFactory.createXYLineChart((String)title, null, null, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
    }

    private JFreeChart getCurvesCompute(String title, Collection<String> courbeNames, Collection<Point2D.Double[]> values) {
        Vector<Point2D.Double> endCurve = new Vector<Point2D.Double>();
        XYSeriesCollection dataset = new XYSeriesCollection();
        Iterator<String> iteCourbeName = courbeNames.iterator();
        Iterator<Point2D.Double[]> iteValues = values.iterator();
        while (iteCourbeName.hasNext() && iteValues.hasNext()) {
            XYSeries series = new XYSeries((Comparable)((Object)iteCourbeName.next()));
            Point2D.Double[] val = iteValues.next();
            Point2D.Double end = val[0];
            int i = 0;
            while (i < val.length) {
                series.add(val[i].getX(), val[i].getY());
                if (end.getX() < val[i].getX()) {
                    end = val[i];
                }
                ++i;
            }
            dataset.addSeries(series);
            endCurve.add(end);
        }
        JFreeChart chart = ChartFactory.createXYLineChart((String)title, null, null, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        for (Point2D.Double end : endCurve) {
            CircleDrawer d = new CircleDrawer(Color.BLACK, new BasicStroke(1.0f), null);
            XYDrawableAnnotation bestBid = new XYDrawableAnnotation(end.getX(), end.getY(), 6.0, 6.0, (Drawable)d);
            plot.addAnnotation((XYAnnotation)bestBid);
        }
        return chart;
    }

    private JFreeChart getPieCompute(String title, String[] titles, double[] values) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        int i = 0;
        while (i < Math.min(titles.length, values.length)) {
            dataset.setValue((Comparable)((Object)titles[i]), values[i]);
            ++i;
        }
        JFreeChart chart = ChartFactory.createPieChart((String)title, (PieDataset)dataset, (boolean)false, (boolean)true, (boolean)false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieItemLabelGenerator("{0} = {2}", NumberFormat.getNumberInstance(), NumberFormat.getPercentInstance()));
        return chart;
    }

    private ResultCloud getCloudAndRegressionCompute(String title, String cloudName, Point2D.Double[] values, boolean isNormalize) {
        double normalizeX = 1.0;
        double normalizeY = 1.0;
        if (isNormalize) {
            normalizeX = 0.0;
            normalizeY = 0.0;
            Point2D.Double[] doubleArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Point2D.Double pt = doubleArray[n2];
                if (Math.abs(pt.getX()) > normalizeX) {
                    normalizeX = Math.abs(pt.getX());
                }
                if (Math.abs(pt.getY()) > normalizeY) {
                    normalizeY = Math.abs(pt.getY());
                }
                ++n2;
            }
        }
        double sigmaYX = 0.0;
        double sigmaX = 0.0;
        double sigmaY = 0.0;
        double sigmaX2 = 0.0;
        int n = values.length;
        double minAbs = values[0].getX();
        double maxAbs = values[0].getX();
        HashMap<Double, Integer> nbApparition = new HashMap<Double, Integer>();
        HashMap<Double, Double> meanValue = new HashMap<Double, Double>();
        XYSeriesCollection dataset = new XYSeriesCollection();
        XYSeries series = new XYSeries((Comparable)((Object)cloudName));
        int i = 0;
        while (i < values.length) {
            double xNorm = values[i].getX() / normalizeX;
            double yNorm = values[i].getY() / normalizeY;
            double x = values[i].getX();
            series.add(xNorm, yNorm);
            sigmaX += xNorm;
            sigmaX2 += Math.pow(xNorm, 2.0);
            sigmaY += yNorm;
            sigmaYX += xNorm * yNorm;
            if (x < minAbs) {
                minAbs = x;
            }
            if (x > maxAbs) {
                maxAbs = x;
            }
            if (meanValue.containsKey(xNorm)) {
                int nbApp = (Integer)nbApparition.get(xNorm);
                double value = (Double)meanValue.get(xNorm);
                meanValue.put(xNorm, ((double)nbApp * value + yNorm) / (double)(nbApp + 1));
                nbApparition.put(xNorm, nbApp + 1);
            } else {
                meanValue.put(xNorm, yNorm);
                nbApparition.put(xNorm, 1);
            }
            ++i;
        }
        if (isNormalize) {
            minAbs /= normalizeX;
            maxAbs /= normalizeX;
        }
        dataset.addSeries(series);
        double b = ((double)n * sigmaYX - sigmaX * sigmaY) / ((double)n * sigmaX2 - Math.pow(sigmaX, 2.0));
        double a = sigmaY / (double)n - b * sigmaX / (double)n;
        XYSeries lineRegression = new XYSeries((Comparable)((Object)"Regression line"));
        lineRegression.add(minAbs, b * minAbs + a);
        lineRegression.add(maxAbs, b * maxAbs + a);
        dataset.addSeries(lineRegression);
        double regSlode = b;
        XYSeries curveMean = new XYSeries((Comparable)((Object)"Mean"));
        Set set = meanValue.entrySet();
        Point2D.Double[] ptMean = new Point2D.Double[set.size()];
        int i2 = 0;
        for (Map.Entry val : set) {
            double x = (Double)val.getKey();
            double y = (Double)val.getValue();
            curveMean.add(x, y);
            ptMean[i2] = new Point2D.Double(x, y);
            ++i2;
        }
        dataset.addSeries(curveMean);
        Double[][] toComputeCorrelation = new Double[2][values.length];
        i2 = 0;
        Point2D.Double[] y = values;
        int n3 = values.length;
        int x = 0;
        while (x < n3) {
            Point2D.Double val = y[x];
            toComputeCorrelation[0][i2] = val.getY();
            toComputeCorrelation[1][i2] = b * val.getX() + a;
            ++i2;
            ++x;
        }
        JFreeChart chart = ChartFactory.createXYLineChart((String)title, null, null, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesLinesVisible(0, false);
        renderer.setSeriesShapesVisible(1, false);
        plot.setRenderer((XYItemRenderer)renderer);
        ChartPanel panel = new ChartPanel(chart);
        StatImpl stat = new StatImpl();
        double correlation = stat.correlation(toComputeCorrelation[0], toComputeCorrelation[1]);
        return new ResultCloud((JPanel)panel, ptMean, correlation, regSlode);
    }

    @Override
    public JPanel getCurve(String title, String courbeName, Point2D.Double[] values) {
        return new ChartPanel(this.getCurveCompute(null, courbeName, values));
    }

    @Override
    public void saveCurve(String fileName, String extension, int width, int height, String title, String courbeName, Point2D.Double[] values) throws IOException {
        BufferedImage buf = this.getCurveCompute(title, courbeName, values).createBufferedImage(width, height);
        File f = new File(String.valueOf(fileName) + "." + extension);
        ImageIO.write((RenderedImage)buf, extension, f);
    }

    @Override
    public JPanel getCurves(String title, Collection<String> courbeNames, Collection<Point2D.Double[]> values) {
        return new ChartPanel(this.getCurvesCompute(null, courbeNames, values));
    }

    @Override
    public void saveCurves(String fileName, String extension, int width, int height, String title, Collection<String> courbeNames, Collection<Point2D.Double[]> values) throws IOException {
        BufferedImage buf = this.getCurvesCompute(title, courbeNames, values).createBufferedImage(width, height);
        File f = new File(String.valueOf(fileName) + "." + extension);
        ImageIO.write((RenderedImage)buf, extension, f);
    }

    @Override
    public JPanel getBarChart(String title, String[] titles, double[] values) {
        return new ChartPanel(this.getBarChartCompute(null, titles, values));
    }

    @Override
    public void saveBarChart(String fileName, String extension, int width, int height, String title, String[] titles, double[] values) throws IOException {
        BufferedImage buf = this.getBarChartCompute(title, titles, values).createBufferedImage(width, height);
        File f = new File(String.valueOf(fileName) + "." + extension);
        ImageIO.write((RenderedImage)buf, extension, f);
    }

    @Override
    public JPanel getBarChartHorizontal(String title, String[] titles, double[] values) {
        return new ChartPanel(this.getBarChartHorizontalCompute(null, titles, values));
    }

    @Override
    public void saveBarChartHorizontal(String fileName, String extension, int width, int height, String title, String[] titles, double[] values) throws IOException {
        BufferedImage buf = this.getBarChartHorizontalCompute(title, titles, values).createBufferedImage(width, height);
        File f = new File(String.valueOf(fileName) + "." + extension);
        ImageIO.write((RenderedImage)buf, extension, f);
    }

    @Override
    public JPanel getBarChartWithDerivation(String title, String[] titles, double[] values, double[] deviations) {
        return new ChartPanel(this.getBarChartWithDerivationCompute(null, titles, values, deviations));
    }

    @Override
    public void saveBarChartWithDerivation(String fileName, String extension, int width, int height, String title, String[] titles, double[] values, double[] deviations) throws IOException {
        BufferedImage buf = this.getBarChartWithDerivationCompute(title, titles, values, deviations).createBufferedImage(width, height);
        File f = new File(String.valueOf(fileName) + "." + extension);
        ImageIO.write((RenderedImage)buf, extension, f);
    }

    @Override
    public JPanel getPie(String title, String[] titles, double[] values) {
        return new ChartPanel(this.getPieCompute(null, titles, values));
    }

    @Override
    public void savePie(String fileName, String extension, int width, int height, String title, String[] titles, double[] values) throws IOException {
        BufferedImage buf = this.getPieCompute(title, titles, values).createBufferedImage(width, height);
        File f = new File(String.valueOf(fileName) + "." + extension);
        ImageIO.write((RenderedImage)buf, extension, f);
    }

    @Override
    public ResultCloud getCloudWithRegression(String title, String cloudName, Point2D.Double[] values, boolean isNormalize) {
        return this.getCloudAndRegressionCompute(null, cloudName, values, isNormalize);
    }

    @Override
    public void saveCloudAndRegression(String fileName, String extension, int width, int height, String title, String cloudName, Point2D.Double[] values, boolean isNormalize) throws IOException {
        JPanel comp = this.getCloudAndRegressionCompute(title, cloudName, values, isNormalize).getGraph();
        BufferedImage img = new BufferedImage(width, height, 5);
        Graphics2D g = img.createGraphics();
        ((Component)comp).paint(g);
        g.dispose();
        File f = new File(String.valueOf(fileName) + "." + extension);
        ImageIO.write((RenderedImage)img, extension, f);
    }
}

