/*
 * Decompiled with CFR 0.152.
 */
package chart;

import java.io.Serializable;
import java.text.AttributedString;
import java.text.MessageFormat;
import java.text.NumberFormat;
import org.jfree.chart.labels.AbstractPieItemLabelGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.data.general.PieDataset;
import org.jfree.util.PublicCloneable;

class StandardPieItemLabelGenerator
extends AbstractPieItemLabelGenerator
implements PieToolTipGenerator,
PieSectionLabelGenerator,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_TOOLTIP_FORMAT = "{0}: ({1}, {2})";
    public static final String DEFAULT_SECTION_LABEL_FORMAT = "{0} = {1}";

    public StandardPieItemLabelGenerator() {
        this(DEFAULT_SECTION_LABEL_FORMAT, NumberFormat.getNumberInstance(), NumberFormat.getPercentInstance());
    }

    public StandardPieItemLabelGenerator(String labelFormat) {
        this(labelFormat, NumberFormat.getNumberInstance(), NumberFormat.getPercentInstance());
    }

    public StandardPieItemLabelGenerator(String labelFormat, NumberFormat numberFormat, NumberFormat percentFormat) {
        super(labelFormat, numberFormat, percentFormat);
    }

    public String generateSectionLabel(PieDataset dataset, Comparable key) {
        String result = null;
        if (dataset != null) {
            Object[] items = this.createItemArray(dataset, key);
            result = MessageFormat.format(this.getLabelFormat(), items);
        }
        return result;
    }

    public String generateToolTip(PieDataset dataset, Comparable key) {
        return this.generateSectionLabel(dataset, key);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public AttributedString generateAttributedSectionLabel(PieDataset arg0, Comparable arg1) {
        return null;
    }
}

