/*
 * Decompiled with CFR 0.152.
 */
package gui.staticAnalysis;

import controller.staticAnalysis.Controller;
import gui.staticAnalysis.TableModelCellNotEditable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import staticParameters.RelationAndExchangeTermPair;
import staticParameters.Satisfaction;
import staticParameters.SatisfactionByRelation;

public class BalancesJSP {
    private Controller controller;
    private JPanel jPBalances = null;
    private static final int NBDIGITS = 2;

    public BalancesJSP(Controller controller_) {
        this.controller = controller_;
    }

    private String[][] getNashTable() {
        Collection<RelationAndExchangeTermPair> nash = this.controller.getNashBalance();
        Vector<String> relationsName = this.controller.getRelationsName();
        Vector<String> actorsName = this.controller.getActorsName();
        int nbRelations = relationsName.size();
        int nbActors = actorsName.size();
        int nbLinesHeader = 2;
        int nbLines = nbRelations + nbActors + nbLinesHeader + 1;
        Vector<Collection<Float>> teToSort = new Vector<Collection<Float>>();
        for (RelationAndExchangeTermPair paretoState : nash) {
            Collection<Float> exchangeTerms = paretoState.getExchangeTerm();
            teToSort.add(exchangeTerms);
        }
        Collection<Collection<Float>> teSorted = this.controller.sort(teToSort);
        int nbColumns = teSorted.size();
        String[][] data = new String[nbLines][nbColumns];
        data[0][0] = "Nash";
        data[nbLines - 1][0] = "Total satisfaction";
        int j = 0;
        for (Collection<Float> teSet : teSorted) {
            int i = nbLinesHeader;
            for (Float te : teSet) {
                data[i++][j] = te.toString();
            }
            float sumSatisf = 0.0f;
            for (String actor : actorsName) {
                float satisf = this.controller.getSatisfaction(actor, teSet);
                sumSatisf += satisf;
                data[i++][j] = Float.toString(satisf);
            }
            sumSatisf = this.controller.keepOnlyNDigits(sumSatisf, 2);
            data[i++][j] = Float.toString(sumSatisf);
            ++j;
        }
        return data;
    }

    private String[][] getParetoTable() {
        Collection<RelationAndExchangeTermPair> pareto = this.controller.getParetoOptimum();
        Vector<String> relationsName = this.controller.getRelationsName();
        Vector<String> actorsName = this.controller.getActorsName();
        int nbRelations = relationsName.size();
        int nbActors = actorsName.size();
        int nbLinesHeader = 2;
        int nbLines = nbRelations + nbActors + nbLinesHeader + 1;
        Vector<Collection<Float>> teToSort = new Vector<Collection<Float>>();
        for (RelationAndExchangeTermPair paretoState : pareto) {
            Collection<Float> exchangeTerms = paretoState.getExchangeTerm();
            teToSort.add(exchangeTerms);
        }
        Collection<Collection<Float>> teSorted = this.controller.sort(teToSort);
        int nbColumns = teSorted.size();
        String[][] data = new String[nbLines][nbColumns];
        data[0][0] = "Pareto";
        data[nbLines - 1][0] = "Total satisfaction";
        int j = 0;
        for (Collection<Float> teSet : teSorted) {
            int i = nbLinesHeader;
            for (Float te : teSet) {
                data[i++][j] = te.toString();
            }
            float sumSatisf = 0.0f;
            for (String actor : actorsName) {
                float satisf = this.controller.getSatisfaction(actor, teSet);
                sumSatisf += satisf;
                data[i++][j] = Float.toString(satisf);
            }
            sumSatisf = this.controller.keepOnlyNDigits(sumSatisf, 2);
            data[i++][j] = Float.toString(sumSatisf);
            ++j;
        }
        return data;
    }

    private String[][] getGlobalSatisfactionMaxTable() {
        Satisfaction globalMaxSatisf = this.controller.getGlobalSatisfactionMax();
        Vector<String> relationsName = this.controller.getRelationsName();
        Vector<String> actorsName = this.controller.getActorsName();
        int nbRelations = relationsName.size();
        int nbActors = actorsName.size();
        int nbLinesHeader = 2;
        int nbLines = nbRelations + nbActors + nbLinesHeader + 1;
        Vector<Collection<Float>> teToSort = new Vector<Collection<Float>>();
        for (SatisfactionByRelation satByR : globalMaxSatisf.getSatisfactions()) {
            Vector<Float> exchangeTerms = satByR.getExchangeTerm();
            teToSort.add(exchangeTerms);
        }
        Collection<Collection<Float>> teSorted = this.controller.sort(teToSort);
        int nbColumns = teSorted.size();
        String[][] data = new String[nbLines][nbColumns];
        data[0][0] = "Maximum global";
        data[nbLines - 1][0] = "Total satisfaction";
        int j = 0;
        for (Collection<Float> teSet : teSorted) {
            int i = nbLinesHeader;
            for (Float te : teSet) {
                data[i++][j] = te.toString();
            }
            float sumSatisf = 0.0f;
            for (String actor : actorsName) {
                float satisf = this.controller.getSatisfaction(actor, teSet);
                sumSatisf += satisf;
                data[i++][j] = Float.toString(satisf);
            }
            sumSatisf = this.controller.keepOnlyNDigits(sumSatisf, 2);
            data[i++][j] = Float.toString(sumSatisf);
            ++j;
        }
        return data;
    }

    private String[][] getGlobalSatisfactionMinTable() {
        Satisfaction globalMinSatisf = this.controller.getGlobalSatisfactionMin();
        Vector<String> relationsName = this.controller.getRelationsName();
        Vector<String> actorsName = this.controller.getActorsName();
        int nbRelations = relationsName.size();
        int nbActors = actorsName.size();
        int nbLinesHeader = 2;
        int nbLines = nbRelations + nbActors + nbLinesHeader + 1;
        Vector<Collection<Float>> teToSort = new Vector<Collection<Float>>();
        for (SatisfactionByRelation satByR : globalMinSatisf.getSatisfactions()) {
            Vector<Float> exchangeTerms = satByR.getExchangeTerm();
            teToSort.add(exchangeTerms);
        }
        Collection<Collection<Float>> teSorted = this.controller.sort(teToSort);
        int nbColumns = teSorted.size();
        String[][] data = new String[nbLines][nbColumns];
        data[0][0] = "Minimum global";
        data[nbLines - 1][0] = "Total satisfaction";
        int j = 0;
        for (Collection<Float> teSet : teSorted) {
            int i = nbLinesHeader;
            for (Float te : teSet) {
                data[i++][j] = te.toString();
            }
            float sumSatisf = 0.0f;
            for (String actor : actorsName) {
                float satisf = this.controller.getSatisfaction(actor, teSet);
                sumSatisf += satisf;
                data[i++][j] = Float.toString(satisf);
            }
            sumSatisf = this.controller.keepOnlyNDigits(sumSatisf, 2);
            data[i++][j] = Float.toString(sumSatisf);
            ++j;
        }
        return data;
    }

    private String[][] getSatisfactionMinTable(String actorName) {
        String[][] data;
        int nbColumns;
        int nbLinesHeader = 2;
        Satisfaction actorMinSatisf = this.controller.getSatisfactionMin(actorName);
        Vector<String> relationsName = this.controller.getRelationsName();
        Vector<String> relationsNameInvolved = this.controller.getRelationsNameInvolved(actorName);
        Vector<String> actorsName = this.controller.getActorsName();
        int nbRelations = relationsName.size();
        int nbRelationsInvolved = relationsNameInvolved.size();
        int nbActors = actorsName.size();
        int nbLines = nbRelations + nbActors + nbLinesHeader + 1;
        HashMap<Integer, Integer> relNamesInvolvedPos = new HashMap<Integer, Integer>();
        if (nbRelationsInvolved < nbRelations) {
            int i = 0;
            for (String relationNameInv : relationsNameInvolved) {
                int index = relationsName.indexOf(relationNameInv);
                relNamesInvolvedPos.put(new Integer(i), new Integer(index));
                ++i;
            }
        }
        Vector<Collection<Float>> teToSort = new Vector<Collection<Float>>();
        for (SatisfactionByRelation satByR : actorMinSatisf.getSatisfactions()) {
            Vector<Float> exchangeTerms = satByR.getExchangeTerm();
            teToSort.add(exchangeTerms);
        }
        Collection<Collection<Float>> teSorted = this.controller.sort(teToSort);
        int nbColumnsTotal = nbColumns = teSorted.size();
        if (nbRelationsInvolved < nbRelations) {
            nbColumnsTotal = 2 * nbColumns;
            data = new String[nbLines][nbColumns * 2];
            data[1][0] = "Best";
            data[1][nbColumns] = "Worst";
            Satisfaction globalSatMax = this.controller.getGlobalSatisfactionMax();
            Satisfaction globalSatMin = this.controller.getGlobalSatisfactionMin();
            Float[] listTeMax = new Float[nbRelations];
            int l = 0;
            for (SatisfactionByRelation satByR : globalSatMax.getSatisfactions()) {
                Vector<Float> exchangeTerms = satByR.getExchangeTerm();
                Iterator teIt = exchangeTerms.iterator();
                boolean go = true;
                while (go && teIt.hasNext()) {
                    listTeMax[l] = (Float)teIt.next();
                    ++l;
                    go = false;
                }
            }
            Float[] listTeMin = new Float[nbRelations];
            l = 0;
            for (SatisfactionByRelation satByR : globalSatMin.getSatisfactions()) {
                Vector<Float> exchangeTerms = satByR.getExchangeTerm();
                Iterator teIt = exchangeTerms.iterator();
                boolean go = true;
                while (go && teIt.hasNext()) {
                    listTeMin[l] = (Float)teIt.next();
                    ++l;
                    go = false;
                }
            }
            int i = 0;
            while (i < nbRelations) {
                int j = 0;
                while (j < nbColumns) {
                    data[i + nbLinesHeader][j] = listTeMax[i].toString();
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < nbRelations) {
                int j = nbColumns;
                while (j < nbColumnsTotal) {
                    data[i + nbLinesHeader][j] = listTeMin[i].toString();
                    ++j;
                }
                ++i;
            }
        } else {
            data = new String[nbLines][nbColumns];
        }
        data[0][0] = "Min " + actorName;
        int j = 0;
        for (Collection<Float> teSet : teSorted) {
            int i = 0;
            for (Float te : teSet) {
                if (nbRelationsInvolved < nbRelations) {
                    int position = (Integer)relNamesInvolvedPos.get(new Integer(i));
                    data[position + nbLinesHeader][j] = te.toString();
                    data[position + nbLinesHeader][j + nbColumns] = te.toString();
                    continue;
                }
                data[i + nbLinesHeader][j] = te.toString();
                ++i;
            }
            if (nbRelationsInvolved == nbRelations) {
                float sumSatisf = 0.0f;
                for (String actor : actorsName) {
                    float satisf = this.controller.getSatisfaction(actor, teSet);
                    sumSatisf += satisf;
                    data[i + nbLinesHeader][j] = Float.toString(satisf);
                    ++i;
                }
                sumSatisf = this.controller.keepOnlyNDigits(sumSatisf, 2);
                data[i + nbLinesHeader][j] = Float.toString(sumSatisf);
                ++i;
            }
            ++j;
        }
        if (nbRelationsInvolved < nbRelations) {
            int j2 = 0;
            while (j2 < nbColumnsTotal) {
                Vector<Float> oneColumnTe = new Vector<Float>();
                int i = 0;
                while (i < nbRelations) {
                    oneColumnTe.add(new Float(data[i + nbLinesHeader][j2]));
                    ++i;
                }
                float sumSatisf = 0.0f;
                int cptActor = 0;
                for (String actor : actorsName) {
                    float satisf = this.controller.getSatisfaction(actor, oneColumnTe);
                    sumSatisf += satisf;
                    data[nbRelations + nbLinesHeader + cptActor][j2] = Float.toString(satisf);
                    ++cptActor;
                }
                sumSatisf = this.controller.keepOnlyNDigits(sumSatisf, 2);
                data[nbLines - 1][j2] = Float.toString(sumSatisf);
                ++j2;
            }
        }
        return data;
    }

    private String[][] getSatisfactionMaxTable(String actorName) {
        String[][] data;
        int nbColumns;
        int nbLinesHeader = 2;
        Satisfaction actorMaxSatisf = this.controller.getSatisfactionMax(actorName);
        Vector<String> relationsName = this.controller.getRelationsName();
        Vector<String> relationsNameInvolved = this.controller.getRelationsNameInvolved(actorName);
        Vector<String> actorsName = this.controller.getActorsName();
        int nbRelations = relationsName.size();
        int nbRelationsInvolved = relationsNameInvolved.size();
        int nbActors = actorsName.size();
        int nbLines = nbRelations + nbActors + nbLinesHeader + 1;
        HashMap<Integer, Integer> relNamesInvolvedPos = new HashMap<Integer, Integer>();
        if (nbRelationsInvolved < nbRelations) {
            int i = 0;
            for (String relationNameInv : relationsNameInvolved) {
                int index = relationsName.indexOf(relationNameInv);
                relNamesInvolvedPos.put(new Integer(i), new Integer(index));
                ++i;
            }
        }
        Vector<Collection<Float>> teToSort = new Vector<Collection<Float>>();
        for (SatisfactionByRelation satByR : actorMaxSatisf.getSatisfactions()) {
            Vector<Float> exchangeTerms = satByR.getExchangeTerm();
            teToSort.add(exchangeTerms);
        }
        Collection<Collection<Float>> teSorted = this.controller.sort(teToSort);
        int nbColumnsTotal = nbColumns = teSorted.size();
        if (nbRelationsInvolved < nbRelations) {
            nbColumnsTotal = 2 * nbColumns;
            data = new String[nbLines][nbColumns * 2];
            data[1][0] = "Best";
            data[1][nbColumns] = "Worst";
            Satisfaction globalSatMax = this.controller.getGlobalSatisfactionMax();
            Satisfaction globalSatMin = this.controller.getGlobalSatisfactionMin();
            Float[] listTeMax = new Float[nbRelations];
            int l = 0;
            for (SatisfactionByRelation satByR : globalSatMax.getSatisfactions()) {
                Vector<Float> exchangeTerms = satByR.getExchangeTerm();
                Iterator teIt = exchangeTerms.iterator();
                boolean go = true;
                while (go && teIt.hasNext()) {
                    listTeMax[l] = (Float)teIt.next();
                    ++l;
                    go = false;
                }
            }
            Float[] listTeMin = new Float[nbRelations];
            l = 0;
            for (SatisfactionByRelation satByR : globalSatMin.getSatisfactions()) {
                Vector<Float> exchangeTerms = satByR.getExchangeTerm();
                Iterator teIt = exchangeTerms.iterator();
                boolean go = true;
                while (go && teIt.hasNext()) {
                    listTeMin[l] = (Float)teIt.next();
                    ++l;
                    go = false;
                }
            }
            int i = 0;
            while (i < nbRelations) {
                int j = 0;
                while (j < nbColumns) {
                    data[i + nbLinesHeader][j] = listTeMax[i].toString();
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < nbRelations) {
                int j = nbColumns;
                while (j < nbColumnsTotal) {
                    data[i + nbLinesHeader][j] = listTeMin[i].toString();
                    ++j;
                }
                ++i;
            }
        } else {
            data = new String[nbLines][nbColumns];
        }
        data[0][0] = "Max " + actorName;
        int j = 0;
        for (Collection<Float> teSet : teSorted) {
            int i = 0;
            for (Float te : teSet) {
                if (nbRelationsInvolved < nbRelations) {
                    int position = (Integer)relNamesInvolvedPos.get(new Integer(i));
                    data[position + nbLinesHeader][j] = te.toString();
                    data[position + nbLinesHeader][j + nbColumns] = te.toString();
                    continue;
                }
                data[i + nbLinesHeader][j] = te.toString();
                ++i;
            }
            if (nbRelationsInvolved == nbRelations) {
                float sumSatisf = 0.0f;
                for (String actor : actorsName) {
                    float satisf = this.controller.getSatisfaction(actor, teSet);
                    sumSatisf += satisf;
                    data[i + nbLinesHeader][j] = Float.toString(satisf);
                    ++i;
                }
                sumSatisf = this.controller.keepOnlyNDigits(sumSatisf, 2);
                data[i + nbLinesHeader][j] = Float.toString(sumSatisf);
                ++i;
            }
            ++j;
        }
        if (nbRelationsInvolved < nbRelations) {
            int j2 = 0;
            while (j2 < nbColumnsTotal) {
                Vector<Float> oneColumnTe = new Vector<Float>();
                int i = 0;
                while (i < nbRelations) {
                    oneColumnTe.add(new Float(data[i + nbLinesHeader][j2]));
                    ++i;
                }
                float sumSatisf = 0.0f;
                int cptActor = 0;
                for (String actor : actorsName) {
                    float satisf = this.controller.getSatisfaction(actor, oneColumnTe);
                    sumSatisf += satisf;
                    data[nbRelations + nbLinesHeader + cptActor][j2] = Float.toString(satisf);
                    ++cptActor;
                }
                data[nbLines - 1][j2] = Float.toString(sumSatisf);
                ++j2;
            }
        }
        return data;
    }

    public JPanel getSignificantStatesJSP() {
        if (this.jPBalances == null) {
            int nbLinesHeader = 2;
            Vector<String> relationsName = this.controller.getRelationsName();
            Vector<String> actorsName = this.controller.getActorsName();
            int nbRelations = relationsName.size();
            int nbActors = actorsName.size();
            String[][] dataNash = this.getNashTable();
            String[][] dataPareto = this.getParetoTable();
            String[][] globalMax = this.getGlobalSatisfactionMaxTable();
            String[][] globalMin = this.getGlobalSatisfactionMinTable();
            int nbLines = dataNash.length;
            int nashNbColumns = dataNash[1].length;
            int paretoNbColumns = dataPareto[1].length;
            int globalMaxNbColumns = globalMax[1].length;
            int globalMinNbColumns = globalMin[1].length;
            int nbColumnsActorsMinMax = 0;
            Vector<String[][]> saveSatisfMinActors = new Vector<String[][]>();
            Vector<String[][]> saveSatisfMaxActors = new Vector<String[][]>();
            for (String actorName : actorsName) {
                String[][] globalMinActor = this.getSatisfactionMinTable(actorName);
                String[][] globalMaxActor = this.getSatisfactionMaxTable(actorName);
                saveSatisfMinActors.add(globalMinActor);
                saveSatisfMaxActors.add(globalMaxActor);
                nbColumnsActorsMinMax += globalMinActor[1].length + globalMaxActor[1].length;
            }
            String[][] dataAll = new String[nbLines][nashNbColumns + paretoNbColumns + globalMaxNbColumns + globalMinNbColumns + nbColumnsActorsMinMax + 1];
            int i = 0;
            while (i < nbRelations) {
                dataAll[i + nbLinesHeader][0] = "Te: " + relationsName.get(i);
                ++i;
            }
            i = 0;
            while (i < nbActors) {
                dataAll[i + nbRelations + nbLinesHeader][0] = "Satisfaction: " + actorsName.get(i);
                ++i;
            }
            dataAll[nbLines - 1][0] = "Total satisfaction";
            int j = 0;
            while (j < nashNbColumns) {
                int i2 = 0;
                while (i2 < nbLines) {
                    dataAll[i2][j + 1] = dataNash[i2][j];
                    ++i2;
                }
                ++j;
            }
            j = 0;
            while (j < paretoNbColumns) {
                int i3 = 0;
                while (i3 < nbLines) {
                    dataAll[i3][j + 1 + nashNbColumns] = dataPareto[i3][j];
                    ++i3;
                }
                ++j;
            }
            j = 0;
            while (j < globalMaxNbColumns) {
                int i4 = 0;
                while (i4 < nbLines) {
                    dataAll[i4][j + 1 + nashNbColumns + paretoNbColumns] = globalMax[i4][j];
                    ++i4;
                }
                ++j;
            }
            j = 0;
            while (j < globalMinNbColumns) {
                int i5 = 0;
                while (i5 < nbLines) {
                    dataAll[i5][j + 1 + nashNbColumns + paretoNbColumns + globalMaxNbColumns] = globalMin[i5][j];
                    ++i5;
                }
                ++j;
            }
            int positionColumn = 1 + nashNbColumns + paretoNbColumns + globalMaxNbColumns + globalMinNbColumns;
            int cpt = 0;
            while (cpt < actorsName.size()) {
                int i6;
                String[][] minActor = (String[][])saveSatisfMinActors.get(cpt);
                String[][] maxActor = (String[][])saveSatisfMaxActors.get(cpt);
                int minNbColumnsActor = minActor[1].length;
                int maxNbColumnsActor = maxActor[1].length;
                int j2 = 0;
                while (j2 < minNbColumnsActor) {
                    i6 = 0;
                    while (i6 < nbLines) {
                        dataAll[i6][j2 + positionColumn] = minActor[i6][j2];
                        ++i6;
                    }
                    ++j2;
                }
                positionColumn += minNbColumnsActor;
                j2 = 0;
                while (j2 < maxNbColumnsActor) {
                    i6 = 0;
                    while (i6 < nbLines) {
                        dataAll[i6][j2 + positionColumn] = maxActor[i6][j2];
                        ++i6;
                    }
                    ++j2;
                }
                positionColumn += maxNbColumnsActor;
                ++cpt;
            }
            String[] parameters = new String[nashNbColumns + paretoNbColumns + globalMaxNbColumns + globalMinNbColumns + nbColumnsActorsMinMax + 1];
            int l = 0;
            while (l < parameters.length) {
                parameters[l] = "";
                ++l;
            }
            TableModelCellNotEditable dataModel = new TableModelCellNotEditable(dataAll, parameters);
            JTable finalTable = new JTable(dataModel);
            TableColumn column = null;
            column = finalTable.getColumnModel().getColumn(0);
            int actorLengthMax = 0;
            for (String actor : this.controller.getActorsName()) {
                int actorLength = actor.length();
                if (actorLengthMax >= actorLength) continue;
                actorLengthMax = actorLength;
            }
            int relLengthMax = 0;
            for (String rel : this.controller.getRelationsName()) {
                int relLength = rel.length();
                if (relLengthMax >= relLength) continue;
                relLengthMax = relLength;
            }
            int actorAndRelMax = Math.max(relLengthMax, actorLengthMax);
            column.setPreferredWidth(Math.max(110, actorAndRelMax * 7 + 60));
            int i7 = 1;
            while (i7 < positionColumn) {
                column = finalTable.getColumnModel().getColumn(i7);
                String headerForLength = dataAll[0][i7];
                int nbPixelsPerChar = 7;
                int headerLength = 0;
                if (headerForLength != null) {
                    headerLength = headerForLength.length();
                }
                column.setPreferredWidth(Math.max(50, nbPixelsPerChar * headerLength));
                ++i7;
            }
            this.jPBalances = new JPanel();
            this.jPBalances.add(finalTable);
        }
        return this.jPBalances;
    }
}

