/*
 * Decompiled with CFR 0.152.
 */
package gui.staticAnalysis;

import controller.staticAnalysis.Controller;
import gui.staticAnalysis.FileFilterByExt;
import input.unmarshalling.UnmarshallException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ChooseXMLPanel {
    private Controller ctrl;
    private String currentDirectory = null;
    private String resultName;
    private JPanel jPanel = null;
    private JLabel jLabelOrg = null;
    private JLabel jLabelParam = null;
    private JTextField jTextFieldOrg = null;
    private JTextField jTextFieldParam = null;
    private JButton jButtonOrg = null;
    private JButton jButtonParam = null;
    private JButton jButtonOk = null;
    private JInternalFrame jFrame = null;
    private JLabel jLabelResults = null;
    private JTextField jTextFieldResults = null;
    private JButton jButtonResults = null;

    public ChooseXMLPanel(Controller sctrl) {
        this.ctrl = sctrl;
        this.getJInternalFrame().setVisible(true);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints51 = new GridBagConstraints();
            gridBagConstraints51.gridx = 2;
            gridBagConstraints51.gridy = 2;
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.fill = 2;
            gridBagConstraints41.gridy = 2;
            gridBagConstraints41.weightx = 1.0;
            gridBagConstraints41.insets = new Insets(0, 20, 0, 20);
            gridBagConstraints41.gridx = 1;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.gridy = 2;
            this.jLabelResults = new JLabel();
            this.jLabelResults.setText("Results file : ");
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 1;
            gridBagConstraints11.gridy = 3;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.gridy = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 2;
            gridBagConstraints4.anchor = 10;
            gridBagConstraints4.fill = 0;
            gridBagConstraints4.ipadx = 0;
            gridBagConstraints4.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints4.gridwidth = 0;
            gridBagConstraints4.gridheight = 1;
            gridBagConstraints4.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.weightx = 0.0;
            gridBagConstraints3.insets = new Insets(0, 20, 0, 20);
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(0, 20, 0, 20);
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            this.jLabelParam = new JLabel();
            this.jLabelParam.setText("Parameters XML file : ");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.jLabelOrg = new JLabel();
            this.jLabelOrg.setText("Organization XML file : ");
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.jLabelOrg, gridBagConstraints);
            this.jPanel.add((Component)this.jLabelParam, gridBagConstraints1);
            this.jPanel.add((Component)this.getJTextFieldOrg(), gridBagConstraints2);
            this.jPanel.add((Component)this.getJTextFieldParam(), gridBagConstraints3);
            this.jPanel.add((Component)this.getJButtonOrg(), gridBagConstraints4);
            this.jPanel.add((Component)this.getJButtonParam(), gridBagConstraints5);
            this.jPanel.add((Component)this.getJButtonOk(), gridBagConstraints11);
            this.jPanel.add((Component)this.jLabelResults, gridBagConstraints21);
            this.jPanel.add((Component)this.getJTextFieldResults(), gridBagConstraints41);
            this.jPanel.add((Component)this.getJButtonResults(), gridBagConstraints51);
        }
        return this.jPanel;
    }

    private JTextField getJTextFieldOrg() {
        if (this.jTextFieldOrg == null) {
            this.jTextFieldOrg = new JTextField();
        }
        return this.jTextFieldOrg;
    }

    private JTextField getJTextFieldParam() {
        if (this.jTextFieldParam == null) {
            this.jTextFieldParam = new JTextField();
        }
        return this.jTextFieldParam;
    }

    private JButton getJButtonOrg() {
        if (this.jButtonOrg == null) {
            this.jButtonOrg = new JButton();
            this.jButtonOrg.setText("Browse");
            this.jButtonOrg.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser(ChooseXMLPanel.this.currentDirectory);
                    chooser.setDialogTitle("Choice of Organization XML file");
                    int returnVal = chooser.showOpenDialog(null);
                    if (returnVal == 0) {
                        File f = chooser.getSelectedFile();
                        String orgFile = f.getAbsolutePath();
                        ChooseXMLPanel.this.jTextFieldOrg.setText(orgFile);
                        ChooseXMLPanel.this.currentDirectory = orgFile;
                    }
                }
            });
        }
        return this.jButtonOrg;
    }

    private JButton getJButtonParam() {
        if (this.jButtonParam == null) {
            this.jButtonParam = new JButton();
            this.jButtonParam.setText("Browse");
            this.jButtonParam.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser(ChooseXMLPanel.this.currentDirectory);
                    chooser.setDialogTitle("Choice of Parameters XML file");
                    chooser.setFileFilter(new FileFilterByExt("xml"));
                    int returnVal = chooser.showOpenDialog(null);
                    if (returnVal == 0) {
                        File f = chooser.getSelectedFile();
                        String paramFile = f.getAbsolutePath();
                        ChooseXMLPanel.this.jTextFieldParam.setText(paramFile);
                        ChooseXMLPanel.this.currentDirectory = paramFile;
                    }
                }
            });
        }
        return this.jButtonParam;
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setText("Ok");
            this.jButtonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String orgXML = ChooseXMLPanel.this.jTextFieldOrg.getText();
                    String paramXML = ChooseXMLPanel.this.jTextFieldParam.getText();
                    String results = ChooseXMLPanel.this.jTextFieldResults.getText();
                    if (orgXML.equals("") || paramXML.equals("") || results.equals("")) {
                        JOptionPane.showMessageDialog(ChooseXMLPanel.this.jFrame, "You must fill the empty location(s)", "Error", 0);
                    } else {
                        try {
                            ChooseXMLPanel.this.ctrl.loadResults(orgXML, paramXML, results, ChooseXMLPanel.this.resultName);
                            ChooseXMLPanel.this.jFrame.dispose();
                        }
                        catch (UnmarshallException ue) {
                            JOptionPane.showMessageDialog(ChooseXMLPanel.this.jFrame, ue.getMessage(), "Error", 0);
                        }
                    }
                }
            });
        }
        return this.jButtonOk;
    }

    public JInternalFrame getJInternalFrame() {
        if (this.jFrame == null) {
            this.jFrame = new JInternalFrame();
            this.jFrame.setSize(new Dimension(470, 158));
            this.jFrame.setTitle("Choice of XML files");
            this.jFrame.setContentPane(this.getJPanel());
        }
        return this.jFrame;
    }

    private JTextField getJTextFieldResults() {
        if (this.jTextFieldResults == null) {
            this.jTextFieldResults = new JTextField();
        }
        return this.jTextFieldResults;
    }

    private JButton getJButtonResults() {
        if (this.jButtonResults == null) {
            this.jButtonResults = new JButton();
            this.jButtonResults.setText("Browse");
            this.jButtonResults.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser(ChooseXMLPanel.this.currentDirectory);
                    chooser.setDialogTitle("Choice of results file");
                    chooser.setFileFilter(new FileFilterByExt("rtf"));
                    chooser.setLocale(Locale.ENGLISH);
                    chooser.setFileSelectionMode(0);
                    chooser.setMultiSelectionEnabled(false);
                    int returnVal = chooser.showOpenDialog(null);
                    if (returnVal == 0) {
                        File f = chooser.getSelectedFile();
                        String resultDir = chooser.getCurrentDirectory().getAbsolutePath();
                        ChooseXMLPanel.this.jTextFieldResults.setText(resultDir);
                        ChooseXMLPanel.this.currentDirectory = resultDir;
                        ChooseXMLPanel.this.resultName = f.getName();
                    }
                }
            });
        }
        return this.jButtonResults;
    }
}

