/*
 * Decompiled with CFR 0.152.
 */
package input.sensitiveness;

import input.unmarshalling.FrequencyFake;
import input.unmarshalling.InitExchTermFake;
import input.unmarshalling.LowerBoundFake;
import input.unmarshalling.ParametersSetFake;
import input.unmarshalling.PerseveranceFake;
import input.unmarshalling.SolidarityFake;
import input.unmarshalling.StakeFake;
import input.unmarshalling.UpperBoundFake;
import input.unmarshalling.ValidatorXML;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Vector;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public class Parameters {
    private HashMap<String, Double> parameters = new HashMap();

    public HashMap<String, Double> getParameters() {
        return this.parameters;
    }

    public void loadParameters(String path) throws JiBXException, IOException {
        ValidatorXML validator = new ValidatorXML(path);
        if (validator.isValid()) {
            Vector<UpperBoundFake> upBounds;
            Vector<LowerBoundFake> lowBounds;
            Vector<InitExchTermFake> initExchTerms;
            Vector<PerseveranceFake> perseverances;
            Vector<SolidarityFake> solidarities;
            IBindingFactory paramfact = BindingDirectory.getFactory(ParametersSetFake.class);
            IUnmarshallingContext paramUnm = paramfact.createUnmarshallingContext();
            ParametersSetFake param = (ParametersSetFake)paramUnm.unmarshalDocument((InputStream)new FileInputStream(path), null);
            Vector<StakeFake> stakes = param.getStakes();
            if (stakes != null) {
                int i = 0;
                while (i < stakes.size()) {
                    StakeFake stake = stakes.get(i);
                    this.parameters.put("stake" + stake.getRelationName() + stake.getActorName(), new Double(stake.getValue()));
                    ++i;
                }
            }
            if ((solidarities = param.getSolidarities()) != null) {
                int i = 0;
                while (i < solidarities.size()) {
                    SolidarityFake solidarity = solidarities.get(i);
                    this.parameters.put("solidarity" + solidarity.getActorFrom() + solidarity.getActorTo(), new Double(solidarity.getValue()));
                    ++i;
                }
            }
            if ((perseverances = param.getPerseverances()) != null) {
                int i = 0;
                while (i < perseverances.size()) {
                    PerseveranceFake perseverance = perseverances.get(i);
                    this.parameters.put("perseverance" + perseverance.getActorName(), new Double(perseverance.getValue()));
                    ++i;
                }
            }
            float bonus = param.getBonus();
            this.parameters.put("bonus", new Double(bonus));
            float discrimination = param.getDiscrimination();
            this.parameters.put("discrimination", new Double(discrimination));
            float initialStrength = param.getInitialStrength();
            this.parameters.put("initialStrength", new Double(initialStrength));
            Vector<FrequencyFake> frequencies = param.getFrequencies();
            if (frequencies != null) {
                int i = 0;
                while (i < frequencies.size()) {
                    FrequencyFake frequency = frequencies.get(i);
                    this.parameters.put("frequency" + frequency.getRelationName(), new Double(frequency.getValue()));
                    ++i;
                }
            }
            if ((initExchTerms = param.getInitExchTerms()) != null) {
                int i = 0;
                while (i < initExchTerms.size()) {
                    InitExchTermFake initExchTerm = initExchTerms.get(i);
                    this.parameters.put("initExchTerm" + initExchTerm.getRelationName(), new Double(initExchTerm.getValue()));
                    ++i;
                }
            }
            if ((lowBounds = param.getLowBounds()) != null) {
                int i = 0;
                while (i < lowBounds.size()) {
                    LowerBoundFake lowBound = lowBounds.get(i);
                    this.parameters.put("lowBound" + lowBound.getRelationName(), new Double(lowBound.getValue()));
                    ++i;
                }
            }
            if ((upBounds = param.getUpBounds()) != null) {
                int i = 0;
                while (i < upBounds.size()) {
                    UpperBoundFake upBound = upBounds.get(i);
                    this.parameters.put("upBound" + upBound.getRelationName(), new Double(upBound.getValue()));
                    ++i;
                }
            }
        }
    }

    public double getValue(String param) throws Exception {
        Double value = this.parameters.get(param);
        if (value != null) {
            return value;
        }
        throw new Exception(String.valueOf(param) + " is not a parameter name");
    }
}

