/*
 * Decompiled with CFR 0.152.
 */
package input.unmarshalling;

import input.unmarshalling.FrequencyFake;
import input.unmarshalling.InitExchTermFake;
import input.unmarshalling.LowerBoundFake;
import input.unmarshalling.ParametersSetFake;
import input.unmarshalling.PerseveranceFake;
import input.unmarshalling.SolidarityFake;
import input.unmarshalling.StakeFake;
import input.unmarshalling.UnmarshallException;
import input.unmarshalling.UpperBoundFake;
import input.unmarshalling.ValidatorXML;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import organization.Actor;
import organization.ActorImpl;
import organization.OrganizationImpl;
import organization.ParametersSetImpl;
import organization.Relation;
import organization.RelationImpl;
import organization.Solidarity;
import organization.SolidarityImpl;
import organization.Stake;
import organization.StakeImpl;

public class Unmarshaller {
    public static ParametersSetImpl unmarshallOrgParam(String orgXMLFilename, String paramXMLFilename) throws UnmarshallException {
        try {
            ValidatorXML orgValidator = new ValidatorXML(orgXMLFilename);
            ValidatorXML paramValidator = new ValidatorXML(orgXMLFilename);
            if (!orgValidator.isValid()) {
                throw new UnmarshallException("The org file provided (" + orgXMLFilename + ") is not valid because of these errors:\n" + orgValidator.getErrorHandler().toString());
            }
            if (!paramValidator.isValid()) {
                throw new UnmarshallException("The param file provided (" + paramXMLFilename + ") is not valid because of these errors:\n" + paramValidator.getErrorHandler().toString());
            }
        }
        catch (IOException e1) {
            throw new UnmarshallException("<FileNotFoundException> : An exception occured trying to read the org file (" + orgXMLFilename + ") for validation:\n" + e1.getMessage(), e1);
        }
        try {
            RelationImpl rel;
            Object relationName;
            IBindingFactory orgFact = BindingDirectory.getFactory(OrganizationImpl.class);
            IUnmarshallingContext orgUnm = orgFact.createUnmarshallingContext();
            OrganizationImpl org = (OrganizationImpl)orgUnm.unmarshalDocument((InputStream)new FileInputStream(orgXMLFilename), null);
            IBindingFactory paramFact = BindingDirectory.getFactory(ParametersSetFake.class);
            IUnmarshallingContext paramUnm = paramFact.createUnmarshallingContext();
            ParametersSetFake param = (ParametersSetFake)paramUnm.unmarshalDocument((InputStream)new FileInputStream(paramXMLFilename), null);
            if (!org.getName().equals(param.getOrgName())) {
                throw new UnmarshallException("Correlation problem between the selected org and param files :\nThe organisation's name (" + org.getName() + ") in " + orgXMLFilename + " is different from the same in " + paramXMLFilename + " (" + param.getOrgName() + ")");
            }
            if (org.getNbActors() != param.getNbActors()) {
                throw new UnmarshallException("Correlation problem between the selected org and param files :\nThe number of actors (" + org.getNbActors() + ") in " + orgXMLFilename + " is different from the same in " + paramXMLFilename + " (" + param.getNbActors() + ")");
            }
            if (org.getNbRelations() != param.getNbRelations()) {
                throw new UnmarshallException("Correlation problem between the selected org and param files :\nThe number of relations (" + org.getNbRelations() + ") in " + orgXMLFilename + " is different from the same in " + paramXMLFilename + " (" + param.getNbRelations() + ")");
            }
            for (String relName : param.getRelationsName()) {
                RelationImpl rel2 = (RelationImpl)org.getRelation(relName);
                if (rel2 != null) continue;
                throw new UnmarshallException("Correlation problem between the selected org and param files :\nA relation in " + paramXMLFilename + " (" + relName + ") does not appear in " + orgXMLFilename);
            }
            for (String actName : param.getActorsName()) {
                ActorImpl act = (ActorImpl)org.getActor(actName);
                if (act != null) continue;
                throw new UnmarshallException("Correlation problem between the selected org and param files :\nAn actor in " + paramXMLFilename + " (" + actName + ") does not appear in " + orgXMLFilename);
            }
            if (((Vector)org.getRelations()).size() != param.getRelationsName().size()) {
                throw new UnmarshallException("Correlation problem between the selected org and param files :\nThe number of relations (" + ((Vector)org.getRelations()).size() + ") in " + orgXMLFilename + " is different from the one in " + paramXMLFilename + " (" + param.getRelationsName().size() + ")");
            }
            if (((Vector)org.getActors()).size() != param.getActorsName().size()) {
                throw new UnmarshallException("Correlation problem between the selected org and param files :\nThe number of actors (" + ((Vector)org.getActors()).size() + ") in " + orgXMLFilename + " is different from the one in " + paramXMLFilename + " (" + param.getActorsName().size() + ")");
            }
            if (org.getNbRelations() != ((Vector)org.getRelations()).size()) {
                throw new UnmarshallException("Correlation problem between the selected org and param files :\nThe number of relations in " + orgXMLFilename + " (" + ((Vector)org.getRelations()).size() + ") is different from the number given (" + org.getNbRelations() + ")");
            }
            if (org.getNbActors() != ((Vector)org.getActors()).size()) {
                throw new UnmarshallException("Correlation problem between the selected org and param files :\nThe number of actors in " + orgXMLFilename + " (" + ((Vector)org.getActors()).size() + ") is different from the number given (" + org.getNbActors() + ")");
            }
            if (param.getNbRelations() != param.getRelationsName().size()) {
                throw new UnmarshallException("Correlation problem between the selected org and param files :\nThe number of relations in " + paramXMLFilename + " (" + param.getRelationsName().size() + ") is different from the number given (" + param.getNbRelations() + ")");
            }
            if (param.getNbActors() != param.getActorsName().size()) {
                throw new UnmarshallException("Correlation problem between the selected org and param files :\nThe number of actors in " + paramXMLFilename + " (" + param.getActorsName().size() + ") is different from the number given (" + param.getNbActors() + ")");
            }
            for (PerseveranceFake pers : param.getPerseverances()) {
                String actorName = pers.getActorName();
                ActorImpl act = (ActorImpl)org.getActor(actorName);
                if (act != null) {
                    act.setPerseverance(pers.getValue());
                    continue;
                }
                throw new UnmarshallException("A perseverance defined in the param XML file reference an actor (" + actorName + ") which is not defined in the org XML file");
            }
            org.setBonus(param.getBonus());
            org.setDiscrimination(param.getDiscrimination());
            org.setInitialStrength(param.getInitialStrength());
            for (FrequencyFake freq : param.getFrequencies()) {
                relationName = freq.getRelationName();
                rel = (RelationImpl)org.getRelation((String)relationName);
                if (rel != null) {
                    rel.setFrequency(freq.getValue());
                    continue;
                }
                throw new UnmarshallException("A frequency defined in the param XML file reference a relation (" + (String)relationName + ") which is not defined in the org XML file");
            }
            for (InitExchTermFake exch : param.getInitExchTerms()) {
                relationName = exch.getRelationName();
                rel = (RelationImpl)org.getRelation((String)relationName);
                if (rel != null) {
                    rel.setInitExchTerm(exch.getValue());
                    continue;
                }
                throw new UnmarshallException("An initial exchange term defined in the param XML file reference a relation (" + (String)relationName + ") which is not defined in the org XML file");
            }
            for (LowerBoundFake low : param.getLowBounds()) {
                relationName = low.getRelationName();
                rel = (RelationImpl)org.getRelation((String)relationName);
                if (rel != null) {
                    rel.setLowerBound(low.getValue());
                    continue;
                }
                throw new UnmarshallException("A lower bound defined in the param XML file reference a relation (" + (String)relationName + ") which is not defined in the org XML file");
            }
            for (UpperBoundFake up : param.getUpBounds()) {
                relationName = up.getRelationName();
                rel = (RelationImpl)org.getRelation((String)relationName);
                if (rel != null) {
                    rel.setUpperBound(up.getValue());
                    continue;
                }
                throw new UnmarshallException("An upper bound defined in the param XML file reference a relation (" + (String)relationName + ") which is not defined in the org XML file");
            }
            Vector<Solidarity> solidarities = new Vector<Solidarity>();
            for (SolidarityFake solid : param.getSolidarities()) {
                Actor actorFrom = org.getActor(solid.getActorFrom());
                Actor actorTo = org.getActor(solid.getActorTo());
                if (actorFrom != null && actorTo != null) {
                    solidarities.add(new SolidarityImpl(actorFrom, actorTo, solid.getValue()));
                    continue;
                }
                if (actorFrom == null) {
                    throw new UnmarshallException("A solidarity defined in the param XML file reference an actor (" + solid.getActorFrom() + ") which is not defined in the org XML file");
                }
                throw new UnmarshallException("A solidarity defined in the param XML file reference an actor (" + solid.getActorTo() + ") which is not defined in the org XML file");
            }
            org.setSolidarities(solidarities);
            Vector<Stake> stakes = new Vector<Stake>();
            for (StakeFake stk : param.getStakes()) {
                Relation relation = org.getRelation(stk.getRelationName());
                Actor actor = org.getActor(stk.getActorName());
                if (relation != null && actor != null) {
                    stakes.add(new StakeImpl(relation, actor, stk.getValue()));
                    continue;
                }
                if (relation == null) {
                    throw new UnmarshallException("A stake defined in the param XML file reference a relation (" + stk.getRelationName() + ") which is not defined in the org XML file");
                }
                throw new UnmarshallException("A stake defined in the param XML file reference an actor (" + stk.getActorName() + ") which is not defined in the org XML file");
            }
            org.setStakes(stakes);
            ParametersSetImpl paramUnmarshalled = new ParametersSetImpl(param.getName(), org);
            param = null;
            return paramUnmarshalled;
        }
        catch (JiBXException e) {
            throw new UnmarshallException("<JiBXException> : An exception in the JiBX lib occured:\n" + e.getMessage(), (Exception)((Object)e));
        }
        catch (FileNotFoundException e) {
            throw new UnmarshallException("<FileNotFoundException> : An exception occured trying to find the org or param file:\n" + e.getMessage(), e);
        }
    }
}

