/*
 * Decompiled with CFR 0.152.
 */
package input.unmarshalling;

import input.unmarshalling.ErrorHandlerImpl;
import input.unmarshalling.ResolverDTD;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ValidatorXML {
    private String xmlFilename;
    private String dtdFilename;
    private ErrorHandlerImpl errorHandler;
    private boolean isXmlValid;

    public ValidatorXML(String xmlFilename_) throws IOException {
        block5: {
            this.xmlFilename = xmlFilename_;
            File xmlFile = new File(this.xmlFilename);
            try {
                DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                domFactory.setValidating(true);
                DocumentBuilder parser = domFactory.newDocumentBuilder();
                this.errorHandler = new ErrorHandlerImpl(this.xmlFilename);
                parser.setErrorHandler(this.errorHandler);
                parser.setEntityResolver(new ResolverDTD());
                try {
                    Document xmlDoc = parser.parse(xmlFile);
                    this.dtdFilename = xmlDoc.getDoctype().getSystemId();
                    if (this.errorHandler.isExceptions()) {
                        this.isXmlValid = false;
                        break block5;
                    }
                    this.isXmlValid = true;
                }
                catch (SAXException e) {
                    e.printStackTrace();
                    this.isXmlValid = false;
                    this.dtdFilename = "";
                }
            }
            catch (ParserConfigurationException e) {
                System.err.println("The configuration of the DOM parser to validate the document is wrong");
                e.printStackTrace(new PrintStream(System.err));
            }
        }
    }

    public ErrorHandlerImpl getErrorHandler() {
        return this.errorHandler;
    }

    public boolean isValid() {
        return this.isXmlValid;
    }

    public String toString() {
        String strFileValid = "The file \"" + this.xmlFilename + "\" with the DTD \"" + this.dtdFilename + "\" is ";
        strFileValid = this.isValid() ? String.valueOf(strFileValid) + "valid" : String.valueOf(strFileValid) + "not valid";
        return strFileValid;
    }
}

