/*
 * Decompiled with CFR 0.152.
 */
package staticParameters;

import interpretFormula.InterpretationImpl;
import java.util.Collection;
import java.util.Vector;

public class MathLib {
    protected static final int NBDIGITS = 2;

    public static float functionValue(String f, float x) {
        try {
            double[] params = new double[]{x};
            InterpretationImpl interpret = new InterpretationImpl();
            double result = interpret.interpretFormula(f, params);
            float value = new Double(result).floatValue();
            return MathLib.keepNDigits(value, 2);
        }
        catch (Exception e) {
            System.err.println("functionValue_MathLib: " + e.getMessage());
            return 0.0f;
        }
    }

    public static float minFunctionValue(String f, float lowerBound, float upperBound, float step) {
        float min = MathLib.functionValue(f, lowerBound);
        float x = lowerBound + step;
        while (MathLib.keepNDigits(x, 2) <= upperBound) {
            float value = MathLib.functionValue(f, x);
            if (value < min) {
                min = value;
            }
            x += step;
        }
        return MathLib.keepNDigits(min, 2);
    }

    public static float maxFunctionValue(String f, float lowerBound, float upperBound, float step) {
        float max = MathLib.functionValue(f, lowerBound);
        float l = lowerBound + step;
        while (MathLib.keepNDigits(l, 2) <= upperBound) {
            float value = MathLib.functionValue(f, l);
            if (value > max) {
                max = value;
            }
            l += step;
        }
        return MathLib.keepNDigits(max, 2);
    }

    public static Vector<Float> indexMinFunctionValue(String f, float lowerBound, float upperBound, float step) {
        float indexMin = lowerBound;
        Vector<Float> results = new Vector<Float>();
        results.add(new Float(indexMin));
        float minCurrentValue = MathLib.functionValue(f, indexMin);
        float l = lowerBound + step;
        while (MathLib.keepNDigits(l, 2) <= upperBound) {
            float value = MathLib.functionValue(f, l);
            if (value < minCurrentValue) {
                minCurrentValue = value;
                results.removeAllElements();
                results.add(Float.valueOf(MathLib.keepNDigits(l, 2)));
            } else if (Double.compare(value, minCurrentValue) == 0) {
                results.add(Float.valueOf(MathLib.keepNDigits(l, 2)));
            }
            l += step;
        }
        return results;
    }

    public static Vector<Float> indexMaxFunctionValue(String f, float lowerBound, float upperBound, float step) {
        float indexMax = lowerBound;
        Vector<Float> results = new Vector<Float>();
        results.add(new Float(indexMax));
        float maxCurrentValue = MathLib.functionValue(f, indexMax);
        float l = lowerBound + step;
        while (MathLib.keepNDigits(l, 2) <= upperBound) {
            float value = MathLib.functionValue(f, l);
            if (value > maxCurrentValue) {
                maxCurrentValue = value;
                results.removeAllElements();
                results.add(Float.valueOf(MathLib.keepNDigits(l, 2)));
            } else if (Double.compare(value, maxCurrentValue) == 0) {
                results.add(Float.valueOf(MathLib.keepNDigits(l, 2)));
            }
            l += step;
        }
        return results;
    }

    public static float mean(Collection<Float> values) {
        float sum = 0.0f;
        for (Float value : values) {
            sum += value.floatValue();
        }
        return sum /= (float)values.size();
    }

    public static float variance(Collection<Float> values) {
        float sumGap = 0.0f;
        float mean = MathLib.mean(values);
        for (Float value : values) {
            float gap = Math.abs(value.floatValue() - mean);
            sumGap += gap;
        }
        return sumGap;
    }

    public static Collection<Float> intersection(Collection<Float> c1, Collection<Float> c2) {
        Vector<Float> result = new Vector<Float>();
        for (Float o1 : c1) {
            if (!c2.contains(o1) || result.contains(o1)) continue;
            result.add(o1);
        }
        return result;
    }

    public static Collection<Collection<Float>> allConcatenations(Collection<Float> c1, Collection<Float> c2) {
        Vector<Collection<Float>> result = new Vector<Collection<Float>>();
        for (Float f1 : c1) {
            for (Float f2 : c2) {
                Vector<Float> v = new Vector<Float>();
                v.add(f1);
                v.add(f2);
                result.add(v);
            }
        }
        return result;
    }

    public static Collection<Collection<Float>> allConcatenationsAux2(Collection<Float> c1, Collection<Float> c2) {
        Vector<Collection<Float>> result = new Vector<Collection<Float>>();
        if (c2.isEmpty()) {
            result.add(c1);
        } else {
            for (Float f2 : c2) {
                Vector<Float> v = new Vector<Float>(c1);
                v.add(f2);
                result.add(v);
            }
        }
        return result;
    }

    public static Collection<Collection<Float>> allConcatenationsAux(Collection<Collection<Float>> cc, Collection<Float> c) {
        Vector<Collection<Float>> result = new Vector<Collection<Float>>();
        if (cc.isEmpty()) {
            for (Float f : c) {
                Vector<Float> v = new Vector<Float>();
                v.add(f);
                result.add(v);
            }
        } else {
            for (Collection<Float> c1 : cc) {
                Collection<Collection<Float>> v = MathLib.allConcatenationsAux2(c1, c);
                result.addAll(v);
            }
        }
        return result;
    }

    public static Collection<Collection<Float>> allConcatenations(Collection<Collection<Float>> cc) {
        Collection<Collection<Float>> result = new Vector<Collection<Float>>();
        for (Collection<Float> c : cc) {
            result = MathLib.allConcatenationsAux(result, c);
        }
        return result;
    }

    public static float keepNDigits(float f, int nbDigitsToKeep) {
        if (nbDigitsToKeep == 2 && Math.abs(f) < 0.001f) {
            return 0.0f;
        }
        if (nbDigitsToKeep == 3 && Math.abs(f) < 1.0E-4f) {
            return 0.0f;
        }
        if (nbDigitsToKeep > 3 && Math.abs(f) < 1.0E-4f) {
            return 0.0f;
        }
        if (Float.toString(f).contains("E")) {
            return f;
        }
        String s = Float.toString(f);
        int indexPoint = s.indexOf(".");
        if (indexPoint != 0 && indexPoint + nbDigitsToKeep + 1 < s.length()) {
            s = s.substring(0, indexPoint + nbDigitsToKeep + 1);
        }
        return Float.parseFloat(s);
    }
}

