/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Color;
import java.awt.Component;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorBlindColorScheme;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.theme.SubstanceComplexTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceColorUtilities {
    public static Color getTopBorderColor(ColorScheme scheme1, ColorScheme scheme2, double cycleCoef) {
        return SubstanceColorUtilities.getInterpolatedColor(scheme1.getUltraDarkColor(), scheme2.getUltraDarkColor(), cycleCoef);
    }

    public static Color getTopBorderColor(ColorScheme scheme, boolean isDark) {
        return isDark ? SubstanceColorUtilities.getInterpolatedColor(scheme.getExtraLightColor(), scheme.getForegroundColor(), 0.5) : scheme.getDarkColor();
    }

    public static Color getBottomBorderColor(ColorScheme scheme, boolean isDark) {
        return isDark ? SubstanceColorUtilities.getInterpolatedColor(scheme.getExtraLightColor(), scheme.getForegroundColor(), 0.8) : scheme.getMidColor();
    }

    public static Color getMidBorderColor(ColorScheme scheme1, ColorScheme scheme2, double cycleCoef) {
        return SubstanceColorUtilities.getInterpolatedColor(scheme1.getDarkColor(), scheme2.getDarkColor(), cycleCoef);
    }

    public static Color getBottomBorderColor(ColorScheme scheme1, ColorScheme scheme2, double cycleCoef) {
        Color c1 = SubstanceColorUtilities.getInterpolatedColor(scheme1.getDarkColor(), scheme1.getMidColor(), 0.5);
        Color c2 = SubstanceColorUtilities.getInterpolatedColor(scheme2.getDarkColor(), scheme2.getMidColor(), 0.5);
        return SubstanceColorUtilities.getInterpolatedColor(c1, c2, cycleCoef);
    }

    public static Color getTopFillColor(ColorScheme scheme1, ColorScheme scheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        if (!useCyclePosAsInterpolation) {
            Color c = SubstanceColorUtilities.getInterpolatedColor(scheme1.getDarkColor(), scheme1.getMidColor(), 0.4);
            return SubstanceColorUtilities.getInterpolatedColor(c, scheme2.getLightColor(), cycleCoef);
        }
        Color c1 = SubstanceColorUtilities.getInterpolatedColor(scheme1.getDarkColor(), scheme1.getMidColor(), 0.4);
        Color c2 = SubstanceColorUtilities.getInterpolatedColor(scheme2.getDarkColor(), scheme2.getMidColor(), 0.4);
        return SubstanceColorUtilities.getInterpolatedColor(c1, c2, cycleCoef);
    }

    public static Color getMidFillColor(ColorScheme scheme1, ColorScheme scheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        if (!useCyclePosAsInterpolation) {
            return SubstanceColorUtilities.getInterpolatedColor(scheme1.getMidColor(), scheme2.getLightColor(), cycleCoef);
        }
        return SubstanceColorUtilities.getInterpolatedColor(scheme1.getMidColor(), scheme2.getMidColor(), cycleCoef);
    }

    public static Color getBottomFillColor(ColorScheme scheme1, ColorScheme scheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        if (!useCyclePosAsInterpolation) {
            return SubstanceColorUtilities.getInterpolatedColor(scheme1.getUltraLightColor(), scheme2.getExtraLightColor(), cycleCoef);
        }
        return SubstanceColorUtilities.getInterpolatedColor(scheme1.getUltraLightColor(), scheme2.getUltraLightColor(), cycleCoef);
    }

    public static Color getTopShineColor(ColorScheme scheme1, ColorScheme scheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        return SubstanceColorUtilities.getBottomFillColor(scheme1, scheme2, cycleCoef, useCyclePosAsInterpolation);
    }

    public static Color getBottomShineColor(ColorScheme scheme1, ColorScheme scheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        if (!useCyclePosAsInterpolation) {
            return SubstanceColorUtilities.getInterpolatedColor(scheme1.getLightColor(), scheme2.getUltraLightColor(), cycleCoef);
        }
        return SubstanceColorUtilities.getInterpolatedColor(scheme1.getLightColor(), scheme2.getLightColor(), cycleCoef);
    }

    public static int getInterpolatedRGB(Color color1, Color color2, double color1Likeness) {
        int lr = color1.getRed();
        int lg = color1.getGreen();
        int lb = color1.getBlue();
        int la = color1.getAlpha();
        int dr = color2.getRed();
        int dg = color2.getGreen();
        int db = color2.getBlue();
        int da = color2.getAlpha();
        int r = (int)(color1Likeness * (double)lr + (1.0 - color1Likeness) * (double)dr);
        int g = (int)(color1Likeness * (double)lg + (1.0 - color1Likeness) * (double)dg);
        int b = (int)(color1Likeness * (double)lb + (1.0 - color1Likeness) * (double)db);
        int a = (int)(color1Likeness * (double)la + (1.0 - color1Likeness) * (double)da);
        r = Math.min(255, r);
        g = Math.min(255, g);
        b = Math.min(255, b);
        a = Math.min(255, a);
        r = Math.max(0, r);
        g = Math.max(0, g);
        b = Math.max(0, b);
        a = Math.max(0, a);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static Color getInterpolatedColor(Color color1, Color color2, double color1Likeness) {
        return new Color(SubstanceColorUtilities.getInterpolatedRGB(color1, color2, color1Likeness), true);
    }

    public static Color invertColor(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue(), color.getAlpha());
    }

    public static Color getBackgroundColor(SubstanceTheme theme) {
        if (theme instanceof SubstanceComplexTheme) {
            SubstanceComplexTheme sct = (SubstanceComplexTheme)theme;
            SubstanceTheme defTheme = sct.getDefaultTheme();
            switch (defTheme.getKind()) {
                case DARK: {
                    return defTheme.getColorScheme().getDarkColor().brighter();
                }
            }
            return defTheme.getColorScheme().getExtraLightColor();
        }
        switch (theme.getKind()) {
            case DARK: {
                return theme.getColorScheme().getDarkColor().brighter();
            }
        }
        return theme.getDefaultColorScheme().getExtraLightColor();
    }

    public static Color getDisabledForegroundColor(SubstanceTheme theme) {
        switch (theme.getKind()) {
            case DARK: {
                return SubstanceColorUtilities.getInterpolatedColor(theme.getDefaultColorScheme().getForegroundColor(), theme.getColorScheme().getDarkColor(), 0.45);
            }
        }
        return SubstanceColorUtilities.getInterpolatedColor(theme.getDefaultColorScheme().getMidColor(), theme.getDefaultColorScheme().getDarkColor(), 0.7);
    }

    public static Color getSelectionBackgroundColor(SubstanceTheme theme) {
        switch (theme.getKind()) {
            case DARK: {
                return theme.getHighlightTheme(null, ComponentState.ACTIVE).getColorScheme().getUltraLightColor().brighter().brighter();
            }
        }
        return theme.getHighlightTheme(null, ComponentState.ACTIVE).getColorScheme().getExtraLightColor();
    }

    public static Color getLineColor(SubstanceTheme theme) {
        switch (theme.getKind()) {
            case DARK: {
                return theme.getColorScheme().getUltraLightColor();
            }
        }
        return theme.getColorScheme().getMidColor();
    }

    public static Color getSelectionForegroundColor(SubstanceTheme theme) {
        switch (theme.getKind()) {
            case DARK: {
                return theme.getActiveTheme().getColorScheme().getDarkColor();
            }
        }
        return theme.getActiveTheme().getColorScheme().getUltraDarkColor();
    }

    public static Color getWatermarkStampColor() {
        return SubstanceColorUtilities.getWatermarkStampColor(SubstanceLookAndFeel.getTheme());
    }

    public static Color getWatermarkStampColor(SubstanceTheme theme) {
        return theme.getWatermarkTheme().getWatermarkStampColor();
    }

    public static Color getNegativeColor(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue(), color.getAlpha());
    }

    public static int getNegativeColor(int rgb) {
        int transp = rgb >>> 24 & 0xFF;
        int r = rgb >>> 16 & 0xFF;
        int g = rgb >>> 8 & 0xFF;
        int b = rgb >>> 0 & 0xFF;
        return transp << 24 | 255 - r << 16 | 255 - g << 8 | 255 - b;
    }

    public static Color getWatermarkLightColor() {
        return SubstanceColorUtilities.getWatermarkLightColor(1.0f);
    }

    public static Color getWatermarkLightColor(SubstanceTheme theme) {
        return SubstanceColorUtilities.getWatermarkLightColor(theme, 1.0f);
    }

    public static Color getWatermarkLightColor(float coef) {
        return SubstanceColorUtilities.getWatermarkLightColor(SubstanceLookAndFeel.getTheme(), coef);
    }

    public static Color getWatermarkLightColor(SubstanceTheme theme, float coef) {
        int alpha;
        SubstanceTheme watermarkTheme = theme.getWatermarkTheme();
        int n = alpha = SubstanceCoreUtilities.isThemeDark(watermarkTheme) ? (int)(coef * 100.0f) : (int)(coef * 255.0f);
        if (alpha > 255) {
            alpha = 255;
        }
        return SubstanceColorUtilities.getAlphaColor(watermarkTheme.getColorScheme().getLightColor(), alpha);
    }

    public static Color getWatermarkDarkColor() {
        return SubstanceColorUtilities.getWatermarkDarkColor(SubstanceLookAndFeel.getTheme());
    }

    public static Color getWatermarkDarkColor(SubstanceTheme theme) {
        SubstanceTheme watermarkTheme = theme.getWatermarkTheme();
        return SubstanceCoreUtilities.isThemeDark(watermarkTheme) ? SubstanceColorUtilities.getAlphaColor(watermarkTheme.getColorScheme().getUltraLightColor(), 128) : SubstanceColorUtilities.getAlphaColor(watermarkTheme.getColorScheme().getDarkColor(), 15);
    }

    public static Color getWatermarkStampColor(int alpha) {
        SubstanceTheme watermarkTheme = SubstanceLookAndFeel.getTheme().getWatermarkTheme();
        return SubstanceCoreUtilities.isThemeDark(watermarkTheme) ? SubstanceColorUtilities.getAlphaColor(watermarkTheme.getColorScheme().getUltraLightColor(), alpha) : SubstanceColorUtilities.getAlphaColor(watermarkTheme.getColorScheme().getDarkColor(), alpha);
    }

    public static Color getAlphaColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static Color getSaturatedColor(Color color, double factor) {
        float[] hsbvals = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbvals);
        float sat = hsbvals[1];
        sat = factor > 0.0 ? (sat += (float)factor * (1.0f - sat)) : (sat += (float)factor * sat);
        return new Color(Color.HSBtoRGB(hsbvals[0], sat, hsbvals[2]));
    }

    public static Color getHueShiftedColor(Color color, double hueShift) {
        float[] hsbvals = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbvals);
        float hue = hsbvals[0];
        hue = (float)((double)hue + hueShift);
        if ((double)hue < 0.0) {
            hue = (float)((double)hue + 1.0);
        }
        if ((double)hue > 1.0) {
            hue = (float)((double)hue - 1.0);
        }
        return new Color(Color.HSBtoRGB(hue, hsbvals[1], hsbvals[2]));
    }

    public static Color getForegroundColor(SubstanceTheme theme) {
        return theme.getColorScheme().getForegroundColor();
    }

    public static Color getMenuForegroundColor(SubstanceTheme theme) {
        return theme.getActiveTitlePaneTheme().getColorScheme().getForegroundColor();
    }

    public static Color getLighterColor(Color color, double diff) {
        int r = color.getRed() + (int)(diff * (double)(255 - color.getRed()));
        int g = color.getGreen() + (int)(diff * (double)(255 - color.getGreen()));
        int b = color.getBlue() + (int)(diff * (double)(255 - color.getBlue()));
        return new Color(r, g, b);
    }

    public static Color getDarkerColor(Color color, double diff) {
        int r = (int)((1.0 - diff) * (double)color.getRed());
        int g = (int)((1.0 - diff) * (double)color.getGreen());
        int b = (int)((1.0 - diff) * (double)color.getBlue());
        return new Color(r, g, b);
    }

    public static Color getColorBlindColor(Color orig, double[][] rgbToLms, ColorBlindColorScheme.BlindnessKind kind, double[][] lmsToRgb) {
        double r = orig.getRed();
        double g = orig.getGreen();
        double b = orig.getBlue();
        double[] rgbOrig = new double[]{r, g, b};
        double[] lms = SubstanceColorUtilities.mult3(rgbToLms, rgbOrig);
        double tmp = 0.0;
        double[] anchor = new double[]{0.08008, 0.1579, 0.5897, 0.1284, 0.2237, 0.3636, 0.9856, 0.7325, 0.001079, 0.0914, 0.007009, 0.0};
        double[] rgbAnchor = new double[]{rgbToLms[0][0] + rgbToLms[0][1] + rgbToLms[0][2], rgbToLms[1][0] + rgbToLms[1][1] + rgbToLms[1][2], rgbToLms[2][0] + rgbToLms[2][1] + rgbToLms[2][2]};
        switch (kind) {
            case PROTANOPIA: {
                double a1 = rgbAnchor[1] * anchor[8] - rgbAnchor[2] * anchor[7];
                double b1 = rgbAnchor[2] * anchor[6] - rgbAnchor[0] * anchor[8];
                double c1 = rgbAnchor[0] * anchor[7] - rgbAnchor[1] * anchor[6];
                double a2 = rgbAnchor[1] * anchor[2] - rgbAnchor[2] * anchor[1];
                double b2 = rgbAnchor[2] * anchor[0] - rgbAnchor[0] * anchor[2];
                double c2 = rgbAnchor[0] * anchor[1] - rgbAnchor[1] * anchor[0];
                double inflection = rgbAnchor[2] / rgbAnchor[1];
                tmp = lms[2] / lms[1];
                if (tmp < inflection) {
                    lms[0] = -(b1 * lms[1] + c1 * lms[2]) / a1;
                    break;
                }
                lms[0] = -(b2 * lms[1] + c2 * lms[2]) / a2;
                break;
            }
            case DEUTERANOPIA: {
                double a1 = rgbAnchor[1] * anchor[8] - rgbAnchor[2] * anchor[7];
                double b1 = rgbAnchor[2] * anchor[6] - rgbAnchor[0] * anchor[8];
                double c1 = rgbAnchor[0] * anchor[7] - rgbAnchor[1] * anchor[6];
                double a2 = rgbAnchor[1] * anchor[2] - rgbAnchor[2] * anchor[1];
                double b2 = rgbAnchor[2] * anchor[0] - rgbAnchor[0] * anchor[2];
                double c2 = rgbAnchor[0] * anchor[1] - rgbAnchor[1] * anchor[0];
                double inflection = rgbAnchor[2] / rgbAnchor[0];
                tmp = lms[2] / lms[0];
                if (tmp < inflection) {
                    lms[1] = -(a1 * lms[0] + c1 * lms[2]) / b1;
                    break;
                }
                lms[1] = -(a2 * lms[0] + c2 * lms[2]) / b2;
                break;
            }
            case TRITANOPIA: {
                double a1 = rgbAnchor[1] * anchor[11] - rgbAnchor[2] * anchor[10];
                double b1 = rgbAnchor[2] * anchor[9] - rgbAnchor[0] * anchor[11];
                double c1 = rgbAnchor[0] * anchor[10] - rgbAnchor[1] * anchor[9];
                double a2 = rgbAnchor[1] * anchor[5] - rgbAnchor[2] * anchor[4];
                double b2 = rgbAnchor[2] * anchor[3] - rgbAnchor[0] * anchor[5];
                double c2 = rgbAnchor[0] * anchor[4] - rgbAnchor[1] * anchor[3];
                double inflection = rgbAnchor[1] / rgbAnchor[0];
                tmp = lms[1] / lms[0];
                if (tmp < inflection) {
                    lms[2] = -(a1 * lms[0] + b1 * lms[1]) / c1;
                    break;
                }
                lms[2] = -(a2 * lms[0] + b2 * lms[1]) / c2;
                break;
            }
        }
        double[] rgbCb = SubstanceColorUtilities.mult3(lmsToRgb, lms);
        double nr = Math.min(255.0, Math.max(0.0, rgbCb[0]));
        double ng = Math.min(255.0, Math.max(0.0, rgbCb[1]));
        double nb = Math.min(255.0, Math.max(0.0, rgbCb[2]));
        return new Color((int)nr, (int)ng, (int)nb);
    }

    private static double[] mult3(double[][] matrix, double[] vector) {
        double[] res = new double[]{matrix[0][0] * vector[0] + matrix[0][1] * vector[1] + matrix[0][2] * vector[2], matrix[1][0] * vector[0] + matrix[1][1] * vector[1] + matrix[1][2] * vector[2], matrix[2][0] * vector[0] + matrix[2][1] * vector[1] + matrix[2][2] * vector[2]};
        return res;
    }

    public static int getColorBrightness(int rgb) {
        int oldR = rgb >>> 16 & 0xFF;
        int oldG = rgb >>> 8 & 0xFF;
        int oldB = rgb >>> 0 & 0xFF;
        return (222 * oldR + 707 * oldG + 71 * oldB) / 1000;
    }

    public static Color getFocusColor(Component comp) {
        SubstanceTheme activeTheme = SubstanceCoreUtilities.getActiveTheme(comp, true);
        Color color = SubstanceCoreUtilities.isThemeDark(SubstanceCoreUtilities.getActiveTheme(comp, true)) ? activeTheme.getColorScheme().getUltraDarkColor() : activeTheme.getColorScheme().getDarkColor();
        return color;
    }
}

