/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceBorder;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceMenu;
import org.jvnet.substance.button.SubstanceButtonShaper;
import org.jvnet.substance.color.BaseColorScheme;
import org.jvnet.substance.color.BottleGreenColorScheme;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.LightAquaColorScheme;
import org.jvnet.substance.color.SunfireRedColorScheme;
import org.jvnet.substance.color.SunsetColorScheme;
import org.jvnet.substance.combo.ComboPopupPrototypeCallback;
import org.jvnet.substance.combo.SubstanceComboBoxButton;
import org.jvnet.substance.painter.ControlBackgroundComposite;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.scroll.ScrollThumbGripPainter;
import org.jvnet.substance.scroll.SubstanceScrollButton;
import org.jvnet.substance.tabbed.TabCloseCallback;
import org.jvnet.substance.theme.SubstanceBlendBiTheme;
import org.jvnet.substance.theme.SubstanceInvertedTheme;
import org.jvnet.substance.theme.SubstanceMixTheme;
import org.jvnet.substance.theme.SubstanceNegatedTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.theme.ThemeInfo;
import org.jvnet.substance.title.SubstanceTitlePainter;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.MemoryAnalyzer;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceSpinnerButton;
import org.jvnet.substance.utils.SubstanceTitleButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstanceCoreUtilities {
    private static final String PREV_COMPONENT_STATE = "substancelaf.internal.prevComponentState";

    private SubstanceCoreUtilities() {
    }

    public static String clipString(FontMetrics metrics, int availableWidth, String fullText) {
        if (metrics.stringWidth(fullText) <= availableWidth) {
            return fullText;
        }
        String ellipses = "...";
        int ellipsesWidth = metrics.stringWidth(ellipses);
        if (ellipsesWidth > availableWidth) {
            return "";
        }
        String starter = "";
        String ender = "";
        int w = fullText.length();
        int w2 = w / 2 + w % 2;
        String prevTitle = "";
        for (int i = 0; i < w2; ++i) {
            String newTitle;
            String newStarter = starter + fullText.charAt(i);
            String newEnder = ender;
            if (w - i > w2) {
                newEnder = fullText.charAt(w - i - 1) + newEnder;
            }
            if (metrics.stringWidth(newTitle = newStarter + ellipses + newEnder) > availableWidth) {
                return prevTitle;
            }
            starter = newStarter;
            ender = newEnder;
            prevTitle = newTitle;
        }
        return fullText;
    }

    public static boolean hasIcon(AbstractButton button) {
        return button.getIcon() != null;
    }

    public static boolean hasText(AbstractButton button) {
        String text = button.getText();
        return text != null && text.length() > 0;
    }

    public static boolean isComboBoxButton(AbstractButton button) {
        Container parent = button.getParent();
        return parent != null && (parent instanceof JComboBox || parent.getParent() instanceof JComboBox);
    }

    public static boolean isScrollBarButton(AbstractButton button) {
        Container parent = button.getParent();
        return parent != null && (parent instanceof JScrollBar || parent.getParent() instanceof JScrollBar);
    }

    public static boolean isSpinnerButton(AbstractButton button) {
        Container parent = button.getParent();
        if (!(button instanceof SubstanceSpinnerButton)) {
            return false;
        }
        return parent != null && (parent instanceof JSpinner || parent.getParent() instanceof JSpinner);
    }

    public static boolean isToolBarButton(AbstractButton button) {
        if (button instanceof SubstanceComboBoxButton) {
            return false;
        }
        if (button instanceof SubstanceSpinnerButton) {
            return false;
        }
        Container parent = button.getParent();
        return parent != null && (parent instanceof JToolBar || parent.getParent() instanceof JToolBar);
    }

    public static boolean isScrollButton(JComponent comp) {
        return comp instanceof SubstanceScrollButton;
    }

    public static SubstanceTheme getTheme(Component component, boolean toReturnCurrent) {
        JComponent jcomp;
        Object controlThemeObj;
        Component comp;
        if (component != null && (comp = component) instanceof JComponent && (controlThemeObj = (jcomp = (JComponent)comp).getClientProperty("substancelaf.theme")) != null) {
            if (controlThemeObj instanceof String) {
                return SubstanceTheme.getTheme((String)controlThemeObj);
            }
            if (controlThemeObj instanceof ThemeInfo) {
                return SubstanceTheme.createInstance((ThemeInfo)controlThemeObj);
            }
            if (controlThemeObj instanceof SubstanceTheme) {
                return (SubstanceTheme)controlThemeObj;
            }
        }
        if (toReturnCurrent) {
            return SubstanceLookAndFeel.getTheme();
        }
        return null;
    }

    public static SubstanceTheme getTheme(Component component, Component parent, boolean toReturnCurrent) {
        SubstanceTheme compTheme = SubstanceCoreUtilities.getTheme(component, toReturnCurrent);
        if (compTheme != null) {
            return compTheme;
        }
        return SubstanceCoreUtilities.getTheme(parent, toReturnCurrent);
    }

    public static SubstanceTheme getActiveTheme(Component component, boolean toReturnCurrent) {
        SubstanceTheme componentTheme = SubstanceCoreUtilities.getTheme(component, toReturnCurrent);
        if (componentTheme == null) {
            return null;
        }
        return componentTheme.getActiveTheme();
    }

    public static SubstanceTheme getDefaultTheme(Component component, boolean toReturnCurrent) {
        return SubstanceCoreUtilities.getDefaultTheme(component, toReturnCurrent, false);
    }

    public static SubstanceTheme getDefaultTheme(Component component, boolean toReturnCurrent, boolean checkHierarchy) {
        if (component != null && SubstanceCoreUtilities.isControlAlwaysPaintedActive(component, checkHierarchy)) {
            return SubstanceCoreUtilities.getActiveTheme(component, toReturnCurrent);
        }
        SubstanceTheme theme = SubstanceCoreUtilities.getTheme(component, toReturnCurrent);
        if (theme != null) {
            return theme.getDefaultTheme();
        }
        return null;
    }

    public static SubstanceTheme getTheme(Component component, Component parent, ComponentState componentState, boolean toReturnCurrent) {
        SubstanceTheme compTheme = SubstanceCoreUtilities.getTheme(component, componentState, toReturnCurrent, false);
        if (compTheme != null) {
            return compTheme;
        }
        return SubstanceCoreUtilities.getTheme(parent, componentState, toReturnCurrent, false);
    }

    public static SubstanceTheme getTheme(Component component, ComponentState componentState, boolean toReturnCurrent, boolean checkHierarchy) {
        if (component != null && SubstanceCoreUtilities.isControlAlwaysPaintedActive(component, checkHierarchy)) {
            return SubstanceCoreUtilities.getActiveTheme(component, toReturnCurrent);
        }
        SubstanceTheme theme = SubstanceCoreUtilities.getTheme(component, toReturnCurrent);
        if (theme != null) {
            return theme.getTheme(component, componentState);
        }
        return null;
    }

    public static SubstanceTheme getHighlightTheme(Component component, ComponentState componentState, boolean toReturnCurrent, boolean checkHierarchy) {
        SubstanceTheme theme = SubstanceCoreUtilities.getTheme(component, toReturnCurrent);
        if (theme != null) {
            return theme.getHighlightTheme(component, componentState);
        }
        return null;
    }

    public static float getHighlightAlpha(Component component, ComponentState componentState, boolean toReturnCurrent) {
        SubstanceTheme theme = SubstanceCoreUtilities.getTheme(component, toReturnCurrent);
        if (theme != null) {
            return theme.getHighlightThemeAlpha(component, componentState);
        }
        return 0.0f;
    }

    public static SubstanceTheme getDisabledTheme(Component component, boolean toReturnCurrent) {
        SubstanceTheme theme = SubstanceCoreUtilities.getTheme(component, toReturnCurrent);
        if (theme != null) {
            return theme.getDisabledTheme();
        }
        return null;
    }

    public static ColorScheme getScheme(Component component, ComponentState componentState) {
        SubstanceTheme theme = SubstanceCoreUtilities.getTheme(component, componentState, true, false);
        if (theme != null) {
            return theme.getColorScheme();
        }
        return null;
    }

    public static ColorScheme getActiveScheme(Component component) {
        SubstanceTheme theme = SubstanceCoreUtilities.getActiveTheme(component, true);
        if (theme != null) {
            return theme.getColorScheme();
        }
        return null;
    }

    public static ColorScheme getDefaultScheme(Component component, boolean toReturnCurrent) {
        SubstanceTheme theme = SubstanceCoreUtilities.getDefaultTheme(component, toReturnCurrent);
        if (theme != null) {
            return theme.getColorScheme();
        }
        return null;
    }

    public static ColorScheme getDefaultScheme(Component component) {
        return SubstanceCoreUtilities.getDefaultScheme(component, true);
    }

    public static ColorScheme getDisabledScheme(Component component, boolean toReturnCurrent) {
        SubstanceTheme theme = SubstanceCoreUtilities.getDisabledTheme(component, toReturnCurrent);
        if (theme != null) {
            return theme.getColorScheme();
        }
        return null;
    }

    public static ColorScheme getDisabledScheme(Component component) {
        return SubstanceCoreUtilities.getDisabledScheme(component, true);
    }

    public static ColorScheme getActiveScheme(Component component, Component parent) {
        SubstanceTheme theme = SubstanceCoreUtilities.getTheme(component, parent, false);
        if (theme != null) {
            return theme.getActiveTheme().getColorScheme();
        }
        return SubstanceLookAndFeel.getActiveColorScheme();
    }

    public static ColorScheme getDefaultScheme(Component component, Component parent) {
        boolean isComponentAlwaysActive = SubstanceCoreUtilities.isControlAlwaysPaintedActive(component);
        boolean isParentAlwaysActive = SubstanceCoreUtilities.isControlAlwaysPaintedActive(parent);
        if (isComponentAlwaysActive || isParentAlwaysActive) {
            return SubstanceCoreUtilities.getActiveScheme(component, parent);
        }
        SubstanceTheme theme = SubstanceCoreUtilities.getTheme(component, parent, false);
        if (theme != null) {
            return theme.getDefaultTheme().getColorScheme();
        }
        return SubstanceLookAndFeel.getDefaultColorScheme();
    }

    public static ColorScheme getDisabledScheme(Component component, Component parent) {
        SubstanceTheme theme = SubstanceCoreUtilities.getTheme(component, parent, false);
        if (theme != null) {
            return theme.getDisabledTheme().getColorScheme();
        }
        return SubstanceLookAndFeel.getDisabledColorScheme();
    }

    public static boolean isControlAlwaysPaintedActive(Component comp) {
        return SubstanceCoreUtilities.isControlAlwaysPaintedActive(comp, false);
    }

    public static boolean isControlAlwaysPaintedActive(Component comp, boolean checkHierarchy) {
        if (!checkHierarchy) {
            JComponent jcomp;
            Object componentProp;
            if (comp instanceof JComponent && (componentProp = (jcomp = (JComponent)comp).getClientProperty("substancelaf.paintactive")) != null) {
                if (Boolean.TRUE.equals(componentProp)) {
                    return true;
                }
                if (Boolean.FALSE.equals(componentProp)) {
                    return false;
                }
            }
        } else {
            for (Component c = comp; c != null; c = c.getParent()) {
                JComponent jcomp;
                Object componentProp;
                if (!(c instanceof JComponent) || (componentProp = (jcomp = (JComponent)c).getClientProperty("substancelaf.paintactive")) == null) continue;
                if (Boolean.TRUE.equals(componentProp)) {
                    return true;
                }
                if (!Boolean.FALSE.equals(componentProp)) continue;
                return false;
            }
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.paintactive"));
    }

    public static boolean isButtonNeverPainted(AbstractButton button) {
        for (Container c = button; c != null; c = c.getParent()) {
            JComponent jc;
            Object prop;
            if (!(c instanceof JComponent) || (prop = (jc = (JComponent)c).getClientProperty("substancelaf.buttonpaintnever")) == null) continue;
            if (Boolean.TRUE.equals(prop)) {
                return true;
            }
            if (!Boolean.FALSE.equals(prop)) continue;
            return false;
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.buttonpaintnever"));
    }

    public static SubstanceConstants.FocusKind getFocusKind(Component component) {
        while (component != null) {
            JComponent jcomp;
            Object jcompFocusKind;
            if (component instanceof JComponent && (jcompFocusKind = (jcomp = (JComponent)component).getClientProperty("substancelaf.focusKind")) instanceof SubstanceConstants.FocusKind) {
                return (SubstanceConstants.FocusKind)((Object)jcompFocusKind);
            }
            component = component.getParent();
        }
        Object globalFocusKind = UIManager.get("substancelaf.focusKind");
        if (globalFocusKind instanceof SubstanceConstants.FocusKind) {
            return (SubstanceConstants.FocusKind)((Object)globalFocusKind);
        }
        return SubstanceConstants.FocusKind.ALL_INNER;
    }

    public static SubstanceConstants.TabTextAlignmentKind getTabTextAlignmentKind(JTabbedPane tabPane) {
        Object jcompAlignmentKind = tabPane.getClientProperty("substancelaf.tabbedpanetextAlignmentKind");
        if (jcompAlignmentKind instanceof SubstanceConstants.TabTextAlignmentKind) {
            return (SubstanceConstants.TabTextAlignmentKind)((Object)jcompAlignmentKind);
        }
        Object globalAlignmentKind = UIManager.get("substancelaf.tabbedpanetextAlignmentKind");
        if (globalAlignmentKind instanceof SubstanceConstants.TabTextAlignmentKind) {
            return (SubstanceConstants.TabTextAlignmentKind)((Object)globalAlignmentKind);
        }
        return SubstanceConstants.TabTextAlignmentKind.DEFAULT;
    }

    public static boolean toDrawWatermark(Component component) {
        while (component != null) {
            if (component instanceof JComponent) {
                JComponent jcomp = (JComponent)component;
                Object obj = jcomp.getClientProperty("substancelaf.watermark.toignore");
                if (Boolean.TRUE.equals(obj)) {
                    return false;
                }
                if (Boolean.FALSE.equals(obj)) {
                    return true;
                }
            }
            component = component.getParent();
        }
        Object obj = UIManager.get("substancelaf.watermark.toignore");
        return !Boolean.TRUE.equals(obj);
    }

    public static boolean toBleedWatermark(Component component) {
        if (component instanceof JComponent) {
            JComponent jcomp = (JComponent)component;
            Object obj = jcomp.getClientProperty("substancelaf.watermark.tobleed");
            if (Boolean.TRUE.equals(obj)) {
                return true;
            }
            if (Boolean.FALSE.equals(obj)) {
                return false;
            }
        }
        return SubstanceLookAndFeel.toBleedWatermark();
    }

    public static SubstanceButtonShaper getButtonShaper(AbstractButton button) {
        SubstanceButtonShaper shaper = null;
        for (Container c = button; c != null; c = c.getParent()) {
            JComponent jcomp;
            Object customShaper;
            if (!(c instanceof JComponent) || (customShaper = (jcomp = (JComponent)c).getClientProperty("substancelaf.buttonShaper")) == null) continue;
            if (customShaper instanceof SubstanceButtonShaper) {
                return (SubstanceButtonShaper)customShaper;
            }
            if (!(customShaper instanceof String)) continue;
            try {
                shaper = (SubstanceButtonShaper)Class.forName((String)customShaper).newInstance();
            }
            catch (Exception exc) {
                shaper = null;
            }
            if (shaper == null) continue;
            return shaper;
        }
        if (shaper == null) {
            shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
        }
        return shaper;
    }

    public static SubstanceGradientPainter getGradientPainter(JComponent comp) {
        SubstanceGradientPainter painter = SubstanceLookAndFeel.getCurrentGradientPainter();
        Object customPainter = comp.getClientProperty("substancelaf.gradientPainter");
        if (customPainter != null) {
            if (customPainter instanceof SubstanceGradientPainter) {
                return (SubstanceGradientPainter)customPainter;
            }
            try {
                painter = (SubstanceGradientPainter)Class.forName((String)customPainter).newInstance();
            }
            catch (Exception exc) {
                painter = SubstanceLookAndFeel.getCurrentGradientPainter();
            }
        }
        return painter;
    }

    public static boolean isTabModified(Component tabComponent) {
        boolean isWindowModified = false;
        Component comp = tabComponent;
        if (comp instanceof JComponent) {
            JComponent jc = (JComponent)comp;
            isWindowModified = Boolean.TRUE.equals(jc.getClientProperty("windowModified"));
        }
        return isWindowModified;
    }

    public static boolean isRootPaneModified(JRootPane rootPane) {
        return Boolean.TRUE.equals(rootPane.getClientProperty("windowModified"));
    }

    public static boolean isInternalFrameModified(JInternalFrame internalFrame) {
        Object frameProp = internalFrame.getClientProperty("windowModified");
        if (Boolean.TRUE.equals(frameProp)) {
            return true;
        }
        if (Boolean.FALSE.equals(frameProp)) {
            return false;
        }
        return Boolean.TRUE.equals(internalFrame.getRootPane().getClientProperty("windowModified"));
    }

    public static SubstanceConstants.TabAnimationKind getTabAnimationKind(Component tabComponent) {
        JComponent jc;
        Object animObj;
        Component comp = tabComponent;
        if (comp instanceof JComponent && (animObj = (jc = (JComponent)comp).getClientProperty("substancelaf.tabbedpanetabAnimationKind")) instanceof SubstanceConstants.TabAnimationKind) {
            return (SubstanceConstants.TabAnimationKind)((Object)animObj);
        }
        return null;
    }

    public static ControlBackgroundComposite getControlBackgroundComposite(Component component) {
        for (Component c = component; c != null; c = c.getParent()) {
            JComponent jc;
            Object objProp;
            if (!(c instanceof JComponent) || !((objProp = (jc = (JComponent)c).getClientProperty("substancelaf.backgroundComposite")) instanceof ControlBackgroundComposite)) continue;
            return (ControlBackgroundComposite)objProp;
        }
        Object globalProp = UIManager.get("substancelaf.backgroundComposite");
        if (globalProp instanceof ControlBackgroundComposite) {
            return (ControlBackgroundComposite)globalProp;
        }
        return SubstanceLookAndFeel.getBackgroundComposite(component);
    }

    public static boolean hasCloseButton(JTabbedPane tabbedPane, int tabIndex) {
        Object tabProp;
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return false;
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent) {
            Object compProp = ((JComponent)tabComponent).getClientProperty("substancelaf.tabbedpanehasclosebuttons");
            if (Boolean.TRUE.equals(compProp)) {
                return true;
            }
            if (Boolean.FALSE.equals(compProp)) {
                return false;
            }
        }
        if (Boolean.TRUE.equals(tabProp = tabbedPane.getClientProperty("substancelaf.tabbedpanehasclosebuttons"))) {
            return true;
        }
        if (Boolean.FALSE.equals(tabProp)) {
            return false;
        }
        return UIManager.getBoolean("substancelaf.tabbedpanehasclosebuttons");
    }

    public static int getCloseButtonSize(JTabbedPane tabbedPane, int tabIndex) {
        Object compProp;
        if (!SubstanceCoreUtilities.hasCloseButton(tabbedPane, tabIndex)) {
            return 0;
        }
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return SubstanceSizeUtils.getTabCloseIconSize();
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent && (compProp = ((JComponent)tabComponent).getClientProperty("substancelaf.tabbedpaneclosebuttonssize")) instanceof Integer) {
            return (Integer)compProp;
        }
        Object tabProp = tabbedPane.getClientProperty("substancelaf.tabbedpaneclosebuttonssize");
        if (tabProp instanceof Integer) {
            return (Integer)tabProp;
        }
        Object globalProp = UIManager.get("substancelaf.tabbedpaneclosebuttonssize");
        if (globalProp instanceof Integer) {
            return (Integer)globalProp;
        }
        return SubstanceSizeUtils.getTabCloseIconSize();
    }

    public static boolean toLayoutVertically(JTabbedPane tabbedPane) {
        int tabPlacement = tabbedPane.getTabPlacement();
        if (tabPlacement == 1 || tabPlacement == 3) {
            return false;
        }
        Object tabProp = tabbedPane.getClientProperty("substancelaf.tabbedpaneverticalOrientation");
        if (Boolean.TRUE.equals(tabProp)) {
            return true;
        }
        if (Boolean.FALSE.equals(tabProp)) {
            return false;
        }
        return UIManager.getBoolean("substancelaf.tabbedpaneverticalOrientation");
    }

    public static boolean toShowIconUnrotated(JTabbedPane tabbedPane, int tabIndex) {
        Object tabProp;
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return false;
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent) {
            Object compProp = ((JComponent)tabComponent).getClientProperty("substancelaf.tabbedpaneverticalOrientationRotateIcons");
            if (Boolean.TRUE.equals(compProp)) {
                return true;
            }
            if (Boolean.FALSE.equals(compProp)) {
                return false;
            }
        }
        if (Boolean.TRUE.equals(tabProp = tabbedPane.getClientProperty("substancelaf.tabbedpaneverticalOrientationRotateIcons"))) {
            return true;
        }
        if (Boolean.FALSE.equals(tabProp)) {
            return false;
        }
        return UIManager.getBoolean("substancelaf.tabbedpaneverticalOrientationRotateIcons");
    }

    public static boolean toAnimateCloseIconOfModifiedTab(JTabbedPane tabbedPane, int tabIndex) {
        Object tabProp;
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return false;
        }
        if (!SubstanceCoreUtilities.hasCloseButton(tabbedPane, tabIndex)) {
            return false;
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent) {
            Object compProp = ((JComponent)tabComponent).getClientProperty("substancelaf.tabbedpaneclosebuttonsmodifiedanimation");
            if (Boolean.TRUE.equals(compProp)) {
                return true;
            }
            if (Boolean.FALSE.equals(compProp)) {
                return false;
            }
        }
        if (Boolean.TRUE.equals(tabProp = tabbedPane.getClientProperty("substancelaf.tabbedpaneclosebuttonsmodifiedanimation"))) {
            return true;
        }
        if (Boolean.FALSE.equals(tabProp)) {
            return false;
        }
        return UIManager.getBoolean("substancelaf.tabbedpaneclosebuttonsmodifiedanimation");
    }

    public static BufferedImage getBlankImage(int width, int height) {
        if (MemoryAnalyzer.isRunning() && (width >= 100 || height >= 100)) {
            try {
                throw new Exception();
            }
            catch (Exception exc) {
                StringBuffer sb = new StringBuffer();
                StackTraceElement[] stack = exc.getStackTrace();
                int count = 0;
                for (StackTraceElement stackEntry : stack) {
                    if (count++ > 8) break;
                    sb.append(stackEntry.getClassName() + ".");
                    sb.append(stackEntry.getMethodName() + " [");
                    sb.append(stackEntry.getLineNumber() + "]");
                    sb.append("\n");
                }
                MemoryAnalyzer.enqueueUsage("Blank " + width + "*" + height + "\n" + sb.toString());
            }
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setColor(new Color(0, 0, 0, 0));
        graphics.setComposite(AlphaComposite.Src);
        graphics.fillRect(0, 0, width, height);
        graphics.dispose();
        return image;
    }

    public static boolean hasNoMinSizeProperty(AbstractButton button) {
        Object noMinSizeProperty = button.getClientProperty("substancelaf.buttonnominsize");
        if (Boolean.TRUE.equals(noMinSizeProperty)) {
            return true;
        }
        if (Boolean.FALSE.equals(noMinSizeProperty)) {
            return false;
        }
        Container parent = button.getParent();
        if (parent instanceof JComponent) {
            noMinSizeProperty = ((JComponent)parent).getClientProperty("substancelaf.buttonnominsize");
            if (Boolean.TRUE.equals(noMinSizeProperty)) {
                return true;
            }
            if (Boolean.FALSE.equals(noMinSizeProperty)) {
                return false;
            }
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.buttonnominsize"));
    }

    public static boolean hasFlatProperty(Component comp) {
        Container parent;
        Object flatProperty;
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            flatProperty = jcomp.getClientProperty("substancelaf.componentFlat");
            if (Boolean.TRUE.equals(flatProperty)) {
                return true;
            }
            if (Boolean.FALSE.equals(flatProperty)) {
                return false;
            }
        }
        if ((parent = comp.getParent()) instanceof JComponent) {
            flatProperty = ((JComponent)parent).getClientProperty("substancelaf.componentFlat");
            if (Boolean.TRUE.equals(flatProperty)) {
                return true;
            }
            if (Boolean.FALSE.equals(flatProperty)) {
                return false;
            }
        }
        return false;
    }

    public static int getPopupFlyoutOrientation(JComboBox combobox) {
        Object comboProperty = combobox.getClientProperty("substancelaf.comboboxpopupFlyoutOrientation");
        if (comboProperty instanceof Integer) {
            return (Integer)comboProperty;
        }
        Object globalProperty = UIManager.get("substancelaf.comboboxpopupFlyoutOrientation");
        if (globalProperty instanceof Integer) {
            return (Integer)globalProperty;
        }
        return 5;
    }

    public static void makeNonOpaque(Component comp, Map<Component, Boolean> opaquenessSnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            opaquenessSnapshot.put(comp, jcomp.isOpaque());
            jcomp.setOpaque(false);
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                SubstanceCoreUtilities.makeNonOpaque(cont.getComponent(i), opaquenessSnapshot);
            }
        }
    }

    public static void restoreOpaque(Component comp, Map<Component, Boolean> opaquenessSnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            if (opaquenessSnapshot.containsKey(comp)) {
                jcomp.setOpaque(opaquenessSnapshot.get(comp));
            } else {
                jcomp.setOpaque(true);
            }
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                SubstanceCoreUtilities.restoreOpaque(cont.getComponent(i), opaquenessSnapshot);
            }
        }
    }

    public static void makeNonDoubleBuffered(Component comp, Map<Component, Boolean> dbSnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            dbSnapshot.put(comp, jcomp.isDoubleBuffered());
            jcomp.setDoubleBuffered(false);
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                SubstanceCoreUtilities.makeNonDoubleBuffered(cont.getComponent(i), dbSnapshot);
            }
        }
    }

    public static void restoreDoubleBuffered(Component comp, Map<Component, Boolean> dbSnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            if (dbSnapshot.containsKey(comp)) {
                jcomp.setDoubleBuffered(dbSnapshot.get(comp));
            } else {
                jcomp.setOpaque(true);
            }
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                SubstanceCoreUtilities.restoreDoubleBuffered(cont.getComponent(i), dbSnapshot);
            }
        }
    }

    public static BufferedImage createCompatibleImage(BufferedImage image) {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        BufferedImage compatibleImage = c.createCompatibleImage(image.getWidth(), image.getHeight());
        Graphics g = compatibleImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return compatibleImage;
    }

    public static boolean isToolbarButtonFlat(AbstractButton button) {
        JToolBar toolbar = null;
        for (Container comp = button; comp != null; comp = comp.getParent()) {
            if (!(comp instanceof JToolBar)) continue;
            toolbar = (JToolBar)comp;
            break;
        }
        if (toolbar == null) {
            return false;
        }
        return SubstanceCoreUtilities.isToolbarButtonFlat(button, toolbar);
    }

    public static boolean isToolbarButtonFlat(AbstractButton button, JToolBar toolbar) {
        Object isFlatProperty = button.getClientProperty("substancelaf.toolbarButtonFlat");
        if (Boolean.TRUE.equals(isFlatProperty)) {
            return true;
        }
        if (Boolean.FALSE.equals(isFlatProperty)) {
            return false;
        }
        isFlatProperty = toolbar.getClientProperty("substancelaf.toolbarButtonFlat");
        if (Boolean.TRUE.equals(isFlatProperty)) {
            return true;
        }
        if (Boolean.FALSE.equals(isFlatProperty)) {
            return false;
        }
        return !Boolean.FALSE.equals(UIManager.get("substancelaf.toolbarButtonFlat"));
    }

    public static boolean useThemedDefaultIcon(AbstractButton button) {
        if (button != null) {
            Object useThemedDefaultIconProperty = button.getClientProperty("substancelaf.useThemedDefaultIcons");
            if (Boolean.TRUE.equals(useThemedDefaultIconProperty)) {
                return true;
            }
            if (Boolean.FALSE.equals(useThemedDefaultIconProperty)) {
                return false;
            }
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.useThemedDefaultIcons"));
    }

    public static TabCloseCallback getTabCloseCallback(MouseEvent me, JTabbedPane tabbedPane, int tabIndex) {
        Object compProp;
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return null;
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent && (compProp = ((JComponent)tabComponent).getClientProperty("substancelaf.tabbedpanecloseCallback")) instanceof TabCloseCallback) {
            return (TabCloseCallback)compProp;
        }
        Object tabProp = tabbedPane.getClientProperty("substancelaf.tabbedpanecloseCallback");
        if (tabProp instanceof TabCloseCallback) {
            return (TabCloseCallback)tabProp;
        }
        Object globProp = UIManager.get("substancelaf.tabbedpanecloseCallback");
        if (globProp instanceof TabCloseCallback) {
            return (TabCloseCallback)globProp;
        }
        return null;
    }

    public static BufferedImage blendImagesHorizontal(BufferedImage imageLeft, BufferedImage imageRight, double start, double end) {
        int width = imageLeft.getWidth();
        if (width != imageRight.getWidth()) {
            throw new IllegalArgumentException("Widths are not the same: " + imageLeft.getWidth() + " and " + imageRight.getWidth());
        }
        int height = imageLeft.getHeight();
        if (height != imageRight.getHeight()) {
            throw new IllegalArgumentException("Heights are not the same: " + imageLeft.getHeight() + " and " + imageRight.getHeight());
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        int endX = (int)(end * (double)width);
        int startX = (int)(start * (double)width);
        int rampWidth = endX - startX;
        if (rampWidth == 0) {
            graphics.drawImage(imageLeft, 0, 0, startX, height, 0, 0, startX, height, null);
            graphics.drawImage(imageRight, startX, 0, width, height, startX, 0, width, height, null);
        } else {
            BufferedImage rampRight = SubstanceCoreUtilities.getBlankImage(rampWidth, height);
            Graphics2D rampRightG = (Graphics2D)rampRight.getGraphics();
            rampRightG.setPaint(new GradientPaint(new Point(0, 0), new Color(0, 0, 0, 255), new Point(rampWidth, 0), new Color(0, 0, 0, 0)));
            rampRightG.fillRect(0, 0, rampWidth, height);
            BufferedImage tempRight = SubstanceCoreUtilities.getBlankImage(width - startX, height);
            Graphics2D tempRightG = (Graphics2D)tempRight.getGraphics();
            tempRightG.drawImage(imageRight, 0, 0, width - startX, height, startX, 0, width, height, null);
            tempRightG.setComposite(AlphaComposite.DstOut);
            tempRightG.drawImage((Image)rampRight, 0, 0, null);
            tempRightG.setComposite(AlphaComposite.SrcOver);
            graphics.drawImage((Image)imageLeft, 0, 0, null);
            graphics.drawImage((Image)tempRight, startX, 0, null);
        }
        graphics.dispose();
        return result;
    }

    public static BufferedImage blendImagesVertical(BufferedImage imageTop, BufferedImage imageBottom, double start, double end) {
        int width = imageTop.getWidth();
        if (width != imageBottom.getWidth()) {
            throw new IllegalArgumentException("Widths are not the same: " + imageTop.getWidth() + " and " + imageBottom.getWidth());
        }
        int height = imageTop.getHeight();
        if (height != imageBottom.getHeight()) {
            throw new IllegalArgumentException("Heights are not the same: " + imageTop.getHeight() + " and " + imageBottom.getHeight());
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        int endY = (int)(end * (double)height);
        int startY = (int)(start * (double)height);
        int rampHeight = endY - startY;
        if (rampHeight == 0) {
            graphics.drawImage(imageTop, 0, 0, width, startY, 0, 0, width, startY, null);
            graphics.drawImage(imageBottom, 0, startY, width, height, 0, startY, width, height, null);
        } else {
            BufferedImage rampBottom = SubstanceCoreUtilities.getBlankImage(width, rampHeight);
            Graphics2D rampBottomG = (Graphics2D)rampBottom.getGraphics();
            rampBottomG.setPaint(new GradientPaint(new Point(0, 0), new Color(0, 0, 0, 255), new Point(0, rampHeight), new Color(0, 0, 0, 0)));
            rampBottomG.fillRect(0, 0, width, rampHeight);
            BufferedImage tempBottom = SubstanceCoreUtilities.getBlankImage(width, height - startY);
            Graphics2D tempBottomG = (Graphics2D)tempBottom.getGraphics();
            tempBottomG.drawImage(imageBottom, 0, 0, width, height - startY, 0, startY, width, height, null);
            tempBottomG.setComposite(AlphaComposite.DstOut);
            tempBottomG.drawImage((Image)rampBottom, 0, 0, null);
            tempBottomG.setComposite(AlphaComposite.SrcOver);
            graphics.drawImage((Image)imageTop, 0, 0, null);
            graphics.drawImage((Image)tempBottom, 0, startY, null);
        }
        graphics.dispose();
        return result;
    }

    public static String getSchemeId(ColorScheme colorScheme) {
        if (colorScheme instanceof BaseColorScheme) {
            BaseColorScheme base = (BaseColorScheme)colorScheme;
            return base.getId();
        }
        return colorScheme.getClass().getName();
    }

    public static ColorScheme getOptionPaneColorScheme(int messageType, ColorScheme mainScheme) {
        if (!SubstanceLookAndFeel.isToUseConstantThemesOnDialogs()) {
            return mainScheme;
        }
        switch (messageType) {
            case 1: {
                return new BottleGreenColorScheme();
            }
            case 3: {
                return new LightAquaColorScheme();
            }
            case 2: {
                return new SunsetColorScheme();
            }
            case 0: {
                return new SunfireRedColorScheme();
            }
        }
        return null;
    }

    public static boolean isThemeDark(SubstanceTheme theme) {
        if (theme instanceof SubstanceInvertedTheme) {
            return !SubstanceCoreUtilities.isThemeDark(((SubstanceInvertedTheme)theme).getOriginalTheme());
        }
        if (theme instanceof SubstanceNegatedTheme) {
            return SubstanceCoreUtilities.isThemeDark(((SubstanceNegatedTheme)theme).getOriginalTheme());
        }
        if (theme instanceof SubstanceMixTheme) {
            SubstanceMixTheme mix = (SubstanceMixTheme)theme;
            for (SubstanceTheme mixCompTheme : mix.getOriginalThemes()) {
                if (!SubstanceCoreUtilities.isThemeDark(mixCompTheme)) continue;
                return true;
            }
            return false;
        }
        if (theme instanceof SubstanceBlendBiTheme) {
            SubstanceBlendBiTheme blend = (SubstanceBlendBiTheme)theme;
            return SubstanceCoreUtilities.isThemeDark(blend.getOriginalFirstTheme()) || SubstanceCoreUtilities.isThemeDark(blend.getOriginalSecondTheme());
        }
        return theme.getKind() == SubstanceTheme.ThemeKind.DARK;
    }

    public static SubstanceTheme getComponentTheme(JComponent component, ComponentState.ColorSchemeKind colorSchemeKind) {
        return SubstanceCoreUtilities.getComponentTheme(component, colorSchemeKind, false);
    }

    public static SubstanceTheme getComponentTheme(JComponent component, ComponentState.ColorSchemeKind colorSchemeKind, boolean checkHierarchy) {
        if (colorSchemeKind == ComponentState.ColorSchemeKind.DISABLED) {
            return SubstanceCoreUtilities.getDisabledTheme(component, true);
        }
        if (colorSchemeKind == ComponentState.ColorSchemeKind.CURRENT) {
            return SubstanceCoreUtilities.getActiveTheme(component, true);
        }
        return SubstanceCoreUtilities.getDefaultTheme(component, true, checkHierarchy);
    }

    public static Object getComboPopupPrototypeDisplayValue(JComboBox combo) {
        Object objProp = combo.getClientProperty("substancelaf.comboPopupPrototype");
        if (objProp == null) {
            objProp = UIManager.get("substancelaf.comboPopupPrototype");
        }
        if (objProp == null) {
            return null;
        }
        if (objProp instanceof ComboPopupPrototypeCallback) {
            ComboPopupPrototypeCallback callback = (ComboPopupPrototypeCallback)objProp;
            return callback.getPopupPrototypeDisplayValue(combo);
        }
        return objProp;
    }

    public static SubstanceTitlePainter getTitlePainter(JRootPane rp) {
        if (rp != null) {
            Object custObj = rp.getClientProperty("substancelaf.titlePainter");
            if (custObj instanceof String) {
                String custStr = (String)custObj;
                try {
                    Class<?> cl = Class.forName(custStr);
                    Object custInst = cl.newInstance();
                    if (custInst instanceof SubstanceTitlePainter) {
                        return (SubstanceTitlePainter)custInst;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (custObj instanceof SubstanceTitlePainter) {
                return (SubstanceTitlePainter)custObj;
            }
        }
        return SubstanceLookAndFeel.getCurrentTitlePainter();
    }

    public static SubstanceTitlePainter getTitlePainter(JInternalFrame jif) {
        Object custObj = jif.getClientProperty("substancelaf.titlePainter");
        if (custObj instanceof String) {
            String custStr = (String)custObj;
            try {
                Class<?> cl = Class.forName(custStr);
                Object custInst = cl.newInstance();
                if (custInst instanceof SubstanceTitlePainter) {
                    return (SubstanceTitlePainter)custInst;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (custObj instanceof SubstanceTitlePainter) {
            return (SubstanceTitlePainter)custObj;
        }
        return SubstanceLookAndFeel.getCurrentTitlePainter();
    }

    public static SubstanceConstants.ScrollPaneButtonPolicyKind getScrollPaneButtonsPolicyKind(JScrollBar scrollBar) {
        Object jspKind;
        Container parent = scrollBar.getParent();
        if (parent instanceof JScrollPane && (jspKind = ((JScrollPane)parent).getClientProperty("substancelaf.scrollPaneButtonsPolicy")) instanceof SubstanceConstants.ScrollPaneButtonPolicyKind) {
            return (SubstanceConstants.ScrollPaneButtonPolicyKind)((Object)jspKind);
        }
        Object globalJspKind = UIManager.get("substancelaf.scrollPaneButtonsPolicy");
        if (globalJspKind instanceof SubstanceConstants.ScrollPaneButtonPolicyKind) {
            return (SubstanceConstants.ScrollPaneButtonPolicyKind)((Object)globalJspKind);
        }
        return SubstanceConstants.ScrollPaneButtonPolicyKind.OPPOSITE;
    }

    public static Set<SubstanceConstants.Side> getSides(AbstractButton button, String propertyName) {
        Object prop = button.getClientProperty(propertyName);
        if (prop instanceof Set) {
            return (Set)prop;
        }
        HashSet<SubstanceConstants.Side> result = new HashSet<SubstanceConstants.Side>();
        if (prop != null) {
            Object[] clientSides;
            if (prop instanceof String) {
                result.add(SubstanceConstants.Side.valueOf((String)prop));
            }
            if (prop instanceof String[]) {
                for (String side : clientSides = (String[])prop) {
                    result.add(SubstanceConstants.Side.valueOf(side));
                }
            }
            if (prop instanceof SubstanceConstants.Side) {
                result.add((SubstanceConstants.Side)((Object)prop));
            }
            if (prop instanceof SubstanceConstants.Side[]) {
                for (String side : clientSides = (SubstanceConstants.Side[])prop) {
                    result.add((SubstanceConstants.Side)((Object)side));
                }
            }
        }
        return result;
    }

    public static float getToolbarButtonCornerRadius(AbstractButton button, Insets insets) {
        JToolBar toolbar = null;
        for (Container c = button.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof JToolBar)) continue;
            toolbar = (JToolBar)c;
            break;
        }
        if (toolbar == null) {
            return 2.0f;
        }
        int width = button.getWidth();
        int height = button.getHeight();
        if (insets != null) {
            width -= insets.left + insets.right;
            height -= insets.top + insets.bottom;
        }
        float maxRadius = width > height ? (float)height / 2.0f : (float)width / 2.0f;
        Object buttonProp = button.getClientProperty("substancelaf.cornerRadius");
        if (buttonProp instanceof Float) {
            return Math.min(maxRadius, ((Float)buttonProp).floatValue());
        }
        Object toolbarProp = toolbar.getClientProperty("substancelaf.cornerRadius");
        if (toolbarProp instanceof Float) {
            return Math.min(maxRadius, ((Float)toolbarProp).floatValue());
        }
        Object globalProp = UIManager.get("substancelaf.cornerRadius");
        if (globalProp instanceof Float) {
            return Math.min(maxRadius, ((Float)globalProp).floatValue());
        }
        return 2.0f;
    }

    public static int getEchoPerChar(JPasswordField jpf) {
        int result;
        Object obj = jpf.getClientProperty("substancelaf.passwordEchoPerChar");
        if (obj != null && obj instanceof Integer && (result = ((Integer)obj).intValue()) >= 1) {
            return result;
        }
        obj = UIManager.get("substancelaf.passwordEchoPerChar");
        if (obj != null && obj instanceof Integer && (result = ((Integer)obj).intValue()) >= 1) {
            return result;
        }
        return 1;
    }

    public static BufferedImage createClipImage(Shape s, int width, int height) {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        BufferedImage img = c.createCompatibleImage(width, height, 3);
        Graphics2D g2 = img.createGraphics();
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, width, height);
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fill(s);
        g2.dispose();
        return img;
    }

    public static boolean canBePinned(Component comp) {
        for (Component c = comp; c != null; c = c.getParent()) {
            JComponent jcomp;
            Object componentProp;
            if (!(c instanceof JComponent) || (componentProp = (jcomp = (JComponent)c).getClientProperty("substancelaf.canBePinned")) == null) continue;
            if (Boolean.TRUE.equals(componentProp)) {
                return true;
            }
            if (!Boolean.FALSE.equals(componentProp)) continue;
            return false;
        }
        return !Boolean.FALSE.equals(UIManager.get("substancelaf.canBePinned"));
    }

    public static boolean isPermanentlyPinned(Component comp) {
        JComponent jcomp;
        Object componentProp;
        if (comp instanceof JComponent && (componentProp = (jcomp = (JComponent)comp).getClientProperty("substancelaf.permanentlyPinned")) != null) {
            if (Boolean.TRUE.equals(componentProp)) {
                return true;
            }
            if (Boolean.FALSE.equals(componentProp)) {
                return false;
            }
        }
        return false;
    }

    public static Color getMarkColor(SubstanceTheme theme, boolean isEnabled) {
        ColorScheme scheme = theme.getColorScheme();
        if (SubstanceCoreUtilities.isThemeDark(theme)) {
            return SubstanceColorUtilities.getInterpolatedColor(scheme.getForegroundColor(), scheme.getUltraLightColor(), 0.7);
        }
        Color color1 = isEnabled ? scheme.getUltraDarkColor() : scheme.getUltraDarkColor();
        Color color2 = isEnabled ? scheme.getDarkColor() : scheme.getLightColor();
        return SubstanceColorUtilities.getInterpolatedColor(color1, color2, 0.9);
    }

    public static boolean hasOverlayProperty(Component component) {
        if (component instanceof JComponent) {
            Object flatProperty = ((JComponent)component).getClientProperty("substancelaf.overlay");
            if (Boolean.TRUE.equals(flatProperty)) {
                return true;
            }
            if (Boolean.FALSE.equals(flatProperty)) {
                return false;
            }
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.overlay"));
    }

    public static boolean toShowExtraElements(Component component) {
        for (Component c = component; c != null; c = c.getParent()) {
            JComponent jcomp;
            Object componentProp;
            if (!(c instanceof JComponent) || (componentProp = (jcomp = (JComponent)c).getClientProperty("substancelaf.noExtraElements")) == null) continue;
            if (Boolean.TRUE.equals(componentProp)) {
                return false;
            }
            if (!Boolean.FALSE.equals(componentProp)) continue;
            return true;
        }
        return SubstanceLookAndFeel.toShowExtraElements();
    }

    public static ScrollThumbGripPainter getThumbGripPainter(JScrollBar scrollBar) {
        for (Container c = scrollBar; c != null; c = c.getParent()) {
            JComponent jcomp;
            Object jcompSetting;
            if (!(c instanceof JComponent) || !((jcompSetting = (jcomp = (JComponent)c).getClientProperty("substancelaf.scrollBarGripPainter")) instanceof ScrollThumbGripPainter)) continue;
            return (ScrollThumbGripPainter)jcompSetting;
        }
        Object globalSetting = UIManager.get("substancelaf.scrollBarGripPainter");
        if (globalSetting instanceof ScrollThumbGripPainter) {
            return (ScrollThumbGripPainter)globalSetting;
        }
        return null;
    }

    public static boolean hasSubstanceBorder(JComponent c) {
        CompoundBorder cb;
        if (c == null) {
            return false;
        }
        Border border = c.getBorder();
        if (border instanceof SubstanceBorder) {
            return true;
        }
        return border instanceof CompoundBorder && (cb = (CompoundBorder)border).getOutsideBorder() instanceof SubstanceBorder;
    }

    public static Icon getIcon(AbstractButton b, boolean ignoreRolloverSetting) {
        Icon icon = b.getIcon();
        if (icon == null) {
            return null;
        }
        ButtonModel model = b.getModel();
        if (SubstanceCoreUtilities.useThemedDefaultIcon(b)) {
            boolean useThemedVersion;
            boolean bl = useThemedVersion = !model.isArmed() && !model.isPressed() && !model.isSelected();
            if (!ignoreRolloverSetting) {
                boolean bl2 = useThemedVersion = useThemedVersion && !model.isRollover();
            }
            if (useThemedVersion) {
                icon = new ImageIcon(SubstanceImageCreator.getThemeImage(icon, SubstanceCoreUtilities.getDefaultTheme(b, true), false));
            }
        }
        Icon tmpIcon = null;
        if (icon != null) {
            if (!model.isEnabled()) {
                tmpIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                tmpIcon = b.getPressedIcon();
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                tmpIcon = model.isSelected() ? b.getRolloverSelectedIcon() : b.getRolloverIcon();
            } else if (model.isSelected()) {
                tmpIcon = b.getSelectedIcon();
            }
            if (tmpIcon != null) {
                icon = tmpIcon;
            }
        }
        return icon;
    }

    public static SubstanceConstants.MenuGutterFillKind getMenuGutterFillKind() {
        Object globalSetting = UIManager.get("substancelaf.menuGutterFillKind");
        if (globalSetting instanceof SubstanceConstants.MenuGutterFillKind) {
            return (SubstanceConstants.MenuGutterFillKind)((Object)globalSetting);
        }
        return SubstanceConstants.MenuGutterFillKind.HARD;
    }

    public static Container getHeaderParent(Component c) {
        for (Container comp = c.getParent(); comp != null; comp = comp.getParent()) {
            if (comp instanceof JToolBar) {
                return (JToolBar)comp;
            }
            if (!(comp instanceof JMenuBar)) continue;
            return (JMenuBar)comp;
        }
        return c.getParent();
    }

    public static boolean isInHeader(Component c) {
        for (Container comp = c.getParent(); comp != null; comp = comp.getParent()) {
            if (comp instanceof JToolBar) {
                return true;
            }
            if (!(comp instanceof JMenuBar)) continue;
            return true;
        }
        return false;
    }

    public static void paintText(Graphics g, AbstractButton button, Rectangle textRect, String text, int textShiftOffset, String propertyPrefix) {
        ButtonModel model = button.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemonicIndex = button.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            g.setColor(button.getForeground());
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x + textShiftOffset, textRect.y + fm.getAscent() + textShiftOffset);
        } else {
            g.setColor(UIManager.getColor(propertyPrefix + "disabledText"));
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    public static void paintFocus(Graphics g, Component mainComp, Component focusedComp, Rectangle textRect, float maxAlphaCoef, int extraPadding) {
        FadeTracker fadeTracker = FadeTracker.getInstance();
        SubstanceConstants.FocusKind focusKind = SubstanceCoreUtilities.getFocusKind(mainComp);
        if (focusKind == SubstanceConstants.FocusKind.NONE && !fadeTracker.isTracked(focusedComp, FadeTracker.FadeKind.FOCUS)) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float alpha = 1.0f;
        if (fadeTracker.isTracked(focusedComp, FadeTracker.FadeKind.FOCUS)) {
            alpha = fadeTracker.getFade10(focusedComp, FadeTracker.FadeKind.FOCUS) / 10.0f;
        }
        graphics.setComposite(TransitionLayout.getAlphaComposite(mainComp, alpha *= maxAlphaCoef));
        Color color = SubstanceColorUtilities.getFocusColor(mainComp);
        graphics.setColor(color);
        focusKind.paintFocus(mainComp, focusedComp, graphics, textRect, extraPadding);
        graphics.dispose();
    }

    public static void paintFocus(Graphics g, Component mainComp, Component focusedComp, Rectangle textRect) {
        SubstanceCoreUtilities.paintFocus(g, mainComp, focusedComp, textRect, 1.0f, 0);
    }

    public static void paintSeparator(Graphics2D graphics, ColorScheme colorScheme, boolean isDark, int width, int height, int orientation) {
        Color back;
        Color foreLight = isDark ? colorScheme.getLightColor() : SubstanceColorUtilities.getInterpolatedColor(colorScheme.getLightColor(), colorScheme.getDarkColor(), 0.8);
        Color foreDark = isDark ? colorScheme.getExtraLightColor() : SubstanceColorUtilities.getInterpolatedColor(colorScheme.getMidColor(), colorScheme.getDarkColor(), 0.4);
        Color color = back = isDark ? colorScheme.getDarkColor() : colorScheme.getUltraLightColor();
        if (orientation == 1) {
            graphics.translate(Math.max(0, width / 2 - 1), 0);
            graphics.setPaint(new GradientPaint(0.0f, 0.0f, SubstanceColorUtilities.getAlphaColor(foreLight, 32), 0.0f, height / 2, SubstanceColorUtilities.getAlphaColor(foreDark, 240)));
            graphics.drawLine(0, 0, 0, height / 2);
            graphics.setPaint(new GradientPaint(0.0f, height / 2, SubstanceColorUtilities.getAlphaColor(foreDark, 240), 0.0f, height, SubstanceColorUtilities.getAlphaColor(foreLight, 32)));
            graphics.drawLine(0, height / 2, 0, height);
            graphics.setPaint(new GradientPaint(1.0f, 0.0f, SubstanceColorUtilities.getAlphaColor(back, 32), 1.0f, height / 2, SubstanceColorUtilities.getAlphaColor(back, 196)));
            graphics.drawLine(1, 0, 1, height / 2);
            graphics.setPaint(new GradientPaint(1.0f, height / 2, SubstanceColorUtilities.getAlphaColor(back, 196), 1.0f, height, SubstanceColorUtilities.getAlphaColor(back, 32)));
            graphics.drawLine(1, height / 2, 1, height);
        } else {
            graphics.translate(0, Math.max(0, height / 2 - 1));
            graphics.setPaint(new GradientPaint(0.0f, 0.0f, SubstanceColorUtilities.getAlphaColor(foreLight, 32), width / 2, 0.0f, SubstanceColorUtilities.getAlphaColor(foreDark, 240)));
            graphics.drawLine(0, 0, width / 2, 0);
            graphics.setPaint(new GradientPaint(width / 2, 0.0f, SubstanceColorUtilities.getAlphaColor(foreDark, 240), width, 0.0f, SubstanceColorUtilities.getAlphaColor(foreLight, 32)));
            graphics.drawLine(width / 2, 0, width, 0);
            graphics.setPaint(new GradientPaint(0.0f, 1.0f, SubstanceColorUtilities.getAlphaColor(back, 32), width / 2, 1.0f, SubstanceColorUtilities.getAlphaColor(back, 196)));
            graphics.drawLine(0, 1, width / 2, 1);
            graphics.setPaint(new GradientPaint(width / 2, 1.0f, SubstanceColorUtilities.getAlphaColor(back, 196), width, 1.0f, SubstanceColorUtilities.getAlphaColor(back, 32)));
            graphics.drawLine(width / 2, 1, width, 1);
        }
    }

    public static BufferedImage blur(BufferedImage src, int shadowSize) {
        int argb;
        int b;
        int v;
        int r;
        int a;
        int b2;
        int v2;
        int r2;
        int a2;
        int argb2;
        int historyIdx;
        int bSum;
        int vSum;
        int rSum;
        int aSum;
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int dstWidth = srcWidth + shadowSize;
        int dstHeight = srcHeight + shadowSize;
        BufferedImage dst = new BufferedImage(dstWidth, dstHeight, 2);
        int left = shadowSize - 1 >> 1;
        int right = shadowSize - left;
        int xStop = dstWidth - right;
        int yStop = dstHeight - right;
        Graphics2D g = dst.createGraphics();
        g.drawImage((Image)src, left, left, null);
        g.dispose();
        int[] aHistory = new int[shadowSize];
        int[] rHistory = new int[shadowSize];
        int[] vHistory = new int[shadowSize];
        int[] bHistory = new int[shadowSize];
        float hSumDivider = 1.0f / (float)shadowSize;
        float vSumDivider = 1.0f / (float)shadowSize;
        for (int y = left; y < yStop; ++y) {
            aSum = 0;
            rSum = 0;
            vSum = 0;
            bSum = 0;
            for (historyIdx = 0; historyIdx < left; ++historyIdx) {
                aHistory[historyIdx] = 0;
                rHistory[historyIdx] = 0;
                vHistory[historyIdx] = 0;
                bHistory[historyIdx] = 0;
            }
            int x = 0;
            while (x < right) {
                argb2 = dst.getRGB(x, y);
                a2 = argb2 >>> 24;
                r2 = (argb2 & 0xFF0000) >>> 16;
                v2 = (argb2 & 0xFF00) >>> 8;
                b2 = argb2 & 0xFF;
                aHistory[historyIdx] = a2;
                rHistory[historyIdx] = r2;
                vHistory[historyIdx] = v2;
                bHistory[historyIdx] = b2;
                aSum += a2;
                rSum += r2;
                vSum += v2;
                bSum += b2;
                ++x;
                ++historyIdx;
            }
            historyIdx = 0;
            for (x = 0; x < xStop; ++x) {
                a = (int)((float)aSum * hSumDivider);
                r = (int)((float)rSum * hSumDivider);
                v = (int)((float)vSum * hSumDivider);
                b = (int)((float)bSum * hSumDivider);
                dst.setRGB(x, y, a << 24 | r << 16 | v << 8 | b);
                aSum -= aHistory[historyIdx];
                rSum -= rHistory[historyIdx];
                vSum -= vHistory[historyIdx];
                bSum -= bHistory[historyIdx];
                argb = dst.getRGB(x + right, y);
                a = argb >>> 24;
                r = (argb & 0xFF0000) >>> 16;
                v = (argb & 0xFF00) >>> 8;
                b = argb & 0xFF;
                aHistory[historyIdx] = a;
                rHistory[historyIdx] = r;
                vHistory[historyIdx] = v;
                bHistory[historyIdx] = b;
                aSum += a;
                rSum += r;
                vSum += v;
                bSum += b;
                if (++historyIdx < shadowSize) continue;
                historyIdx -= shadowSize;
            }
            for (x = xStop; x < dstWidth; ++x) {
                a = (int)((float)aSum * hSumDivider);
                r = (int)((float)rSum * hSumDivider);
                v = (int)((float)vSum * hSumDivider);
                b = (int)((float)bSum * hSumDivider);
                dst.setRGB(x, y, a << 24 | r << 16 | v << 8 | b);
                aSum -= aHistory[historyIdx];
                rSum -= rHistory[historyIdx];
                vSum -= vHistory[historyIdx];
                bSum -= bHistory[historyIdx];
                if (++historyIdx < shadowSize) continue;
                historyIdx -= shadowSize;
            }
        }
        for (int x = 0; x < dstWidth; ++x) {
            aSum = 0;
            rSum = 0;
            vSum = 0;
            bSum = 0;
            for (historyIdx = 0; historyIdx < left; ++historyIdx) {
                aHistory[historyIdx] = 0;
                rHistory[historyIdx] = 0;
                vHistory[historyIdx] = 0;
                bHistory[historyIdx] = 0;
            }
            int y = 0;
            while (y < right) {
                argb2 = dst.getRGB(x, y);
                a2 = argb2 >>> 24;
                r2 = (argb2 & 0xFF0000) >>> 16;
                v2 = (argb2 & 0xFF00) >>> 8;
                b2 = argb2 & 0xFF;
                aHistory[historyIdx] = a2;
                rHistory[historyIdx] = r2;
                vHistory[historyIdx] = v2;
                bHistory[historyIdx] = b2;
                aSum += a2;
                rSum += r2;
                vSum += v2;
                bSum += b2;
                ++y;
                ++historyIdx;
            }
            historyIdx = 0;
            for (y = 0; y < yStop; ++y) {
                a = (int)((float)aSum * vSumDivider);
                r = (int)((float)rSum * vSumDivider);
                v = (int)((float)vSum * vSumDivider);
                b = (int)((float)bSum * vSumDivider);
                dst.setRGB(x, y, a << 24 | r << 16 | v << 8 | b);
                aSum -= aHistory[historyIdx];
                rSum -= rHistory[historyIdx];
                vSum -= vHistory[historyIdx];
                bSum -= bHistory[historyIdx];
                argb = dst.getRGB(x, y + right);
                a = argb >>> 24;
                r = (argb & 0xFF0000) >>> 16;
                v = (argb & 0xFF00) >>> 8;
                b = argb & 0xFF;
                aHistory[historyIdx] = a;
                rHistory[historyIdx] = r;
                vHistory[historyIdx] = v;
                bHistory[historyIdx] = b;
                aSum += a;
                rSum += r;
                vSum += v;
                bSum += b;
                if (++historyIdx < shadowSize) continue;
                historyIdx -= shadowSize;
            }
            for (y = yStop; y < dstHeight; ++y) {
                a = (int)((float)aSum * vSumDivider);
                r = (int)((float)rSum * vSumDivider);
                v = (int)((float)vSum * vSumDivider);
                b = (int)((float)bSum * vSumDivider);
                dst.setRGB(x, y, a << 24 | r << 16 | v << 8 | b);
                aSum -= aHistory[historyIdx];
                rSum -= rHistory[historyIdx];
                vSum -= vHistory[historyIdx];
                bSum -= bHistory[historyIdx];
                if (++historyIdx < shadowSize) continue;
                historyIdx -= shadowSize;
            }
        }
        return dst;
    }

    public static boolean isTitleCloseButton(AbstractButton ab) {
        return ab instanceof SubstanceTitleButton && Boolean.TRUE.equals(ab.getClientProperty("substancelaf.internal.isTitleCloseButton"));
    }

    public static void uninstallMenu(JMenuItem menuItem) {
        SubstanceMenu sMenu;
        ButtonUI menuItemUI;
        if (menuItem instanceof JMenu) {
            JMenu menu = (JMenu)menuItem;
            for (Component comp : menu.getMenuComponents()) {
                if (!(comp instanceof JMenuItem)) continue;
                SubstanceCoreUtilities.uninstallMenu((JMenuItem)comp);
            }
        }
        if ((menuItemUI = menuItem.getUI()) instanceof SubstanceMenu && (sMenu = (SubstanceMenu)((Object)menuItemUI)).getAssociatedMenuItem() != null) {
            menuItemUI.uninstallUI(menuItem);
        }
        for (ActionListener actionListener : menuItem.getActionListeners()) {
            menuItem.removeActionListener(actionListener);
        }
        menuItem.removeAll();
    }

    public static Icon getIcon(String iconResource) {
        URL iconUrl;
        ClassLoader cl = (ClassLoader)UIManager.get("ClassLoader");
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if ((iconUrl = cl.getResource(iconResource)) == null) {
            return null;
        }
        return new ImageIcon(iconUrl);
    }

    public static FadeTracker.FadeTrackerCallback getFadeCallback(AbstractButton button) {
        return SubstanceCoreUtilities.getFadeCallback(button, button.getModel());
    }

    public static FadeTracker.FadeTrackerCallback getFadeCallback(final JComponent component, final ButtonModel model) {
        if (SubstanceCoreUtilities.isScrollButton(component)) {
            return null;
        }
        FadeTracker.FadeTrackerCallback callback = new FadeTracker.FadeTrackerCallback(){

            public void fadeEnded(FadeTracker.FadeKind fadeKind) {
                component.putClientProperty(SubstanceCoreUtilities.PREV_COMPONENT_STATE, (Object)ComponentState.getState(model, component));
                component.repaint();
            }

            public void fadePerformed(FadeTracker.FadeKind fadeKind, float fadeCycle10) {
                component.repaint();
            }
        };
        return callback;
    }

    public static ComponentState getPrevComponentState(JComponent comp) {
        ComponentState result = (ComponentState)((Object)comp.getClientProperty(PREV_COMPONENT_STATE));
        if (result == null) {
            result = ComponentState.DEFAULT;
        }
        return result;
    }

    public static boolean hasPropertySetTo(Component comp, String propertyName, boolean expectedValue, boolean checkHierarchy) {
        Object globalProp;
        if (!checkHierarchy) {
            JComponent jcomp;
            Object componentProp;
            if (comp instanceof JComponent && (componentProp = (jcomp = (JComponent)comp).getClientProperty(propertyName)) != null && componentProp.equals(expectedValue)) {
                return true;
            }
        } else {
            for (Component c = comp; c != null; c = c.getParent()) {
                JComponent jcomp;
                Object componentProp;
                if (!(c instanceof JComponent) || (componentProp = (jcomp = (JComponent)c).getClientProperty(propertyName)) == null || !componentProp.equals(expectedValue)) continue;
                return true;
            }
        }
        if ((globalProp = UIManager.get(propertyName)) != null) {
            return globalProp.equals(expectedValue);
        }
        return false;
    }

    public static ResourceBundle getResourceBundle(JComponent jcomp) {
        if (LafWidgetUtilities.toIgnoreGlobalLocale(jcomp)) {
            return SubstanceLookAndFeel.getLabelBundle(jcomp.getLocale());
        }
        return SubstanceLookAndFeel.getLabelBundle();
    }
}

