/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.sourceforge.kga.Taxon;
import org.sourceforge.kga.plant.CompanionList;
import org.sourceforge.kga.plant.Lifetime;
import org.sourceforge.kga.plant.LightRequirement;
import org.sourceforge.kga.plant.NutritionalNeeds;
import org.sourceforge.kga.plant.RootDeepness;
import org.sourceforge.kga.plant.Tag;
import org.sourceforge.kga.plant.WeedControl;

public class Plant
extends Taxon {
    private static Logger log = Logger.getLogger(Plant.class.getName());
    private static Plant plantae = null;
    private Set<Tag> tags = new HashSet<Tag>();
    public Lifetime lifetime = null;
    NutritionalNeeds nutritionalNeeds = null;
    RootDeepness rootDeepness = null;
    WeedControl weedControl = null;
    LightRequirement lightRequirement = null;
    CompanionList companions = new CompanionList(this);

    public static Plant getKingdom() {
        if (plantae == null) {
            plantae = new Plant(Taxon.Type.KINGDOM, 0, "Plantae", null);
        }
        return plantae;
    }

    public Plant(int n) {
        super(n);
    }

    public Plant(Taxon.Type type, int n, String string, Plant plant) {
        super(type, n, string, plant);
        this.lifetime = new Lifetime(this);
    }

    public NutritionalNeeds getNutritionalNeeds() {
        return this.nutritionalNeeds == null && this.parent != null ? this.getParent().getNutritionalNeeds() : this.nutritionalNeeds;
    }

    public RootDeepness getRootDeepness() {
        return this.rootDeepness == null && this.parent != null ? this.getParent().getRootDeepness() : this.rootDeepness;
    }

    public WeedControl getWeedControl() {
        return this.weedControl == null && this.parent != null ? this.getParent().getWeedControl() : this.weedControl;
    }

    public LightRequirement getLightRequirement() {
        return this.lightRequirement == null && this.parent != null ? this.getParent().getLightRequirement() : this.lightRequirement;
    }

    public boolean hasNutritionalNeeds() {
        return this.nutritionalNeeds != null;
    }

    public boolean hasRootDeepness() {
        return this.rootDeepness != null;
    }

    public boolean hasWeedControl() {
        return this.weedControl != null;
    }

    public void setNutritionalNeeds(NutritionalNeeds nutritionalNeeds) {
        this.nutritionalNeeds = nutritionalNeeds;
    }

    public void setRootDeepness(RootDeepness rootDeepness) {
        this.rootDeepness = rootDeepness;
    }

    public void setWeedControl(WeedControl weedControl) {
        this.weedControl = weedControl;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public void addTag(Tag tag) {
        if (this.tags.contains(tag)) {
            return;
        }
        this.tags.add(tag);
        tag.addSpecies(this);
    }

    public void removeTag(Tag tag) {
        if (!this.tags.contains(tag)) {
            return;
        }
        this.tags.remove(tag);
        tag.removeSpecies(this);
    }

    public CompanionList getCompanions() {
        return this.companions;
    }

    public Plant getParent() {
        return (Plant)this.parent;
    }
}

