/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.io.InvalidFormatException;
import org.sourceforge.kga.translation.Translation;

public abstract class FileWithChanges {
    private static Logger log = Logger.getLogger(Garden.class.getName());
    File file;
    JFrame parent;
    protected FileNameExtensionFilter fileExtension;
    Preferences prefs = null;
    JMenu recentFilesMenu = new JMenu();
    boolean unsavedChanges = false;
    ArrayList<Listener> listeners = new ArrayList();

    public JMenu getRecentFilesMenu() {
        return this.recentFilesMenu;
    }

    public FileWithChanges(String string, String string2, String string3) {
        this.prefs = Preferences.userRoot().node(string);
        this.fileExtension = new FileNameExtensionFilter(string2, string3);
    }

    public boolean hasUnsavedChanges() {
        return this.unsavedChanges;
    }

    public boolean openLast() {
        String string = this.prefs.get("lastOpened", "");
        log.info("Last opened file is " + string);
        if (string.isEmpty()) {
            return false;
        }
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        this.open(file, null);
        return true;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    void callUnsavedChangesChanged() {
        for (Listener listener : this.listeners) {
            listener.unsavedChangesChanged();
        }
    }

    void callObjectChanged() {
        for (Listener listener : this.listeners) {
            listener.objectChanged();
        }
    }

    protected void setUnsavedChanges() {
        if (!this.unsavedChanges) {
            this.unsavedChanges = true;
            this.callUnsavedChangesChanged();
        }
    }

    protected void resetUnsavedChanges() {
        if (this.unsavedChanges) {
            this.unsavedChanges = false;
            this.callUnsavedChangesChanged();
        }
    }

    public void createNew() {
        log.info("FileWithChanged.createNew()");
        if (this.askToSave()) {
            this.createObjects();
            this.file = null;
            this.unsavedChanges = false;
            this.callObjectChanged();
        }
    }

    public void open() {
        String string = this.prefs.get("lastPath", "");
        log.info("lastPath=" + string);
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setFileFilter(this.fileExtension);
        if (jFileChooser.showOpenDialog(this.parent) != 0) {
            return;
        }
        this.open(jFileChooser.getSelectedFile(), null);
    }

    public void open(File file, InputStream inputStream) {
        if (!this.askToSave()) {
            return;
        }
        try {
            if (file != null) {
                log.info("Loading objects from " + file.getAbsolutePath());
                this.load(new FileInputStream(file));
                this.file = file;
                this.unsavedChanges = false;
                this.saveToPreferences();
            } else {
                log.info("Loading object from input stream");
                this.load(inputStream);
                this.file = null;
                this.unsavedChanges = true;
            }
        }
        catch (InvalidFormatException invalidFormatException) {
            Translation translation = Translation.getPreferred();
            JOptionPane.showMessageDialog(this.parent, translation.invalid_file_format(), translation.error_loading_file(), 0);
        }
        catch (Exception exception) {
            Translation translation = Translation.getPreferred();
            JOptionPane.showMessageDialog(this.parent, exception.toString(), translation.error_loading_file(), 0);
        }
        this.callObjectChanged();
    }

    public boolean askToSave() {
        if (!this.unsavedChanges) {
            return true;
        }
        int n = JOptionPane.showConfirmDialog(this.parent, Translation.getPreferred().do_you_want_to_save());
        if (n == 0) {
            this.save(false);
            return true;
        }
        return n == 1;
    }

    public void save(boolean bl) {
        Object object;
        if (this.file == null || bl) {
            String string = this.prefs.get("lastPath", "");
            object = new JFileChooser(string);
            ((JFileChooser)object).setFileFilter(this.fileExtension);
            if (((JFileChooser)object).showSaveDialog(this.parent) != 0) {
                return;
            }
            this.file = ((JFileChooser)object).getSelectedFile();
            String string2 = "." + this.fileExtension.getExtensions()[0];
            if (!this.file.getName().endsWith(string2)) {
                this.file = new File(this.file.getParent() + "/" + this.file.getName() + string2);
            }
            this.saveToPreferences();
        }
        try {
            this.saveToFile();
        }
        catch (Exception exception) {
            object = Translation.getPreferred();
            JOptionPane.showMessageDialog(this.parent, exception.toString(), ((Translation)object).error_saving_file(), 0);
        }
        this.unsavedChanges = false;
        this.callUnsavedChangesChanged();
    }

    protected abstract void createObjects();

    protected abstract void load(InputStream var1) throws Exception;

    protected abstract void saveToFile() throws Exception;

    public File getFile() {
        return this.file;
    }

    private void saveToPreferences() {
        log.info("Set last path to  " + this.file.getParent());
        this.prefs.put("lastPath", this.file.getParent());
        this.prefs.put("lastOpened", this.file.toString());
        this.prefs.node("recentFiles").put(Long.toString(new Date().getTime()), this.file.getAbsolutePath());
        this.loadRecentFileList();
    }

    public void loadRecentFileList() {
        Preferences preferences = this.prefs.node("recentFiles");
        try {
            int n;
            for (String string : preferences.keys()) {
                if (new File(preferences.get(string, "")).exists()) continue;
                preferences.remove(string);
            }
            String[] stringArray = preferences.keys();
            for (n = 0; n < stringArray.length; ++n) {
                int n2;
                for (n2 = n + 1; n2 < stringArray.length && preferences.get(stringArray[n], "").compareTo(preferences.get(stringArray[n2], "")) != 0; ++n2) {
                }
                if (n2 >= stringArray.length) continue;
                log.info("Deleting from recent file list " + preferences.get(stringArray[n], ""));
                preferences.remove(stringArray[n]);
            }
            stringArray = preferences.keys();
            for (n = 0; n < stringArray.length - 7; ++n) {
                preferences.remove(stringArray[n]);
            }
            this.recentFilesMenu.removeAll();
            for (String string : preferences.keys()) {
                final File file = new File(preferences.get(string, ""));
                if (!file.exists()) continue;
                JMenuItem jMenuItem = new JMenuItem(file.getAbsolutePath());
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        FileWithChanges.this.open(new File(file.getAbsolutePath()), null);
                    }
                });
                this.recentFilesMenu.insert(jMenuItem, 0);
            }
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    public static interface Listener {
        public void objectChanged();

        public void unsavedChangesChanged();
    }
}

