/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.PlantList;
import org.sourceforge.kga.SeedList;
import org.sourceforge.kga.TagList;
import org.sourceforge.kga.gui.desktop.EditableGarden;
import org.sourceforge.kga.gui.desktop.FileWithChanges;
import org.sourceforge.kga.gui.desktop.GardenFileWithChanges;
import org.sourceforge.kga.gui.desktop.GardenView;
import org.sourceforge.kga.gui.desktop.OperationMediator;
import org.sourceforge.kga.gui.desktop.SpeciesListPanel;
import org.sourceforge.kga.gui.desktop.Toolbox;
import org.sourceforge.kga.gui.desktop.actions.About;
import org.sourceforge.kga.gui.desktop.actions.CheckForUpdate;
import org.sourceforge.kga.gui.desktop.actions.Contact;
import org.sourceforge.kga.gui.desktop.actions.DeleteYear;
import org.sourceforge.kga.gui.desktop.actions.EditTranslation;
import org.sourceforge.kga.gui.desktop.actions.Exit;
import org.sourceforge.kga.gui.desktop.actions.Export;
import org.sourceforge.kga.gui.desktop.actions.GardenStatistics;
import org.sourceforge.kga.gui.desktop.actions.Language;
import org.sourceforge.kga.gui.desktop.actions.NewGarden;
import org.sourceforge.kga.gui.desktop.actions.NewYear;
import org.sourceforge.kga.gui.desktop.actions.Open;
import org.sourceforge.kga.gui.desktop.actions.OpenHelp;
import org.sourceforge.kga.gui.desktop.actions.Print;
import org.sourceforge.kga.gui.desktop.actions.PrintSetup;
import org.sourceforge.kga.gui.desktop.actions.Review;
import org.sourceforge.kga.gui.desktop.actions.Save;
import org.sourceforge.kga.gui.desktop.actions.SaveAs;
import org.sourceforge.kga.gui.desktop.actions.SeedManager;
import org.sourceforge.kga.gui.desktop.actions.ShowAnExample;
import org.sourceforge.kga.gui.desktop.actions.ShowAnotherExample;
import org.sourceforge.kga.gui.desktop.actions.SpeciesProperties;
import org.sourceforge.kga.gui.desktop.actions.Tags;
import org.sourceforge.kga.gui.desktop.actions.UploadToWebVersion;
import org.sourceforge.kga.gui.desktop.actions.Zoom;
import org.sourceforge.kga.gui.desktop.actions.importData.ImportCsv;
import org.sourceforge.kga.io.SeedListFormatV1;
import org.sourceforge.kga.io.SerializableGarden;
import org.sourceforge.kga.plant.Tag;
import org.sourceforge.kga.plant.TagInGarden;
import org.sourceforge.kga.rules.Rule;
import org.sourceforge.kga.translation.Translation;
import org.sourceforge.kga.wrappers.Image;

public class Gui
extends JFrame
implements FileWithChanges.Listener {
    private static Logger log = Logger.getLogger(Garden.class.getName());
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_GRID_SIDE = 48;
    public static final Dimension DEFAULT_GRID_DIMENSION = new Dimension(48, 48);
    public static final int SEEDLISTPANEL_WIDTH = 150;
    JMenu fileMenu;
    private JTabbedPane tabbedPaneOfYears = new JTabbedPane();
    private SpeciesListPanel speciesListPanel;
    private GardenFileWithChanges gardenFile = new GardenFileWithChanges();
    private Toolbox toolbox;
    private OperationMediator operationMediator;

    public Gui() {
        super("Kitchen garden aid");
        this.setBounds(30, 30, 800, 400);
        Gui.makeWindowBoundsPersistent(this, "Gui", true);
        Translation translation = Translation.getPreferred();
        this.gardenFile.addListener(this);
        Rule.GOOD = Image.getFromResources("good.png");
        Rule.BAD = Image.getFromResources("bad.png");
        Rule.EQUAL = Image.getFromResources("equal.png");
        Rule.GOOD_ARROWS[0][0] = Image.getFromResources("good_arrow_nw.png");
        Rule.GOOD_ARROWS[0][1] = Image.getFromResources("good_arrow_n.png");
        Rule.GOOD_ARROWS[0][2] = Image.getFromResources("good_arrow_ne.png");
        Rule.GOOD_ARROWS[1][0] = Image.getFromResources("good_arrow_w.png");
        Rule.GOOD_ARROWS[1][2] = Image.getFromResources("good_arrow_e.png");
        Rule.GOOD_ARROWS[2][0] = Image.getFromResources("good_arrow_sw.png");
        Rule.GOOD_ARROWS[2][1] = Image.getFromResources("good_arrow_s.png");
        Rule.GOOD_ARROWS[2][2] = Image.getFromResources("good_arrow_se.png");
        Rule.BAD_ARROWS[0][0] = Image.getFromResources("bad_arrow_nw.png");
        Rule.BAD_ARROWS[0][1] = Image.getFromResources("bad_arrow_n.png");
        Rule.BAD_ARROWS[0][2] = Image.getFromResources("bad_arrow_ne.png");
        Rule.BAD_ARROWS[1][0] = Image.getFromResources("bad_arrow_w.png");
        Rule.BAD_ARROWS[1][2] = Image.getFromResources("bad_arrow_e.png");
        Rule.BAD_ARROWS[2][0] = Image.getFromResources("bad_arrow_sw.png");
        Rule.BAD_ARROWS[2][1] = Image.getFromResources("bad_arrow_s.png");
        Rule.BAD_ARROWS[2][2] = Image.getFromResources("bad_arrow_se.png");
        String string = "resources/species.xml";
        InputStream inputStream = PlantList.class.getResourceAsStream("/" + string);
        if (inputStream == null && new File(string).exists()) {
            try {
                inputStream = new FileInputStream(new File(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        if (inputStream == null) {
            log.severe("Can not find species.xml");
        } else {
            PlantList.initialize(inputStream);
        }
        this.setDefaultCloseOperation(0);
        this.setLayout(new BorderLayout(10, 10));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                boolean bl = Gui.this.gardenFile.askToSave();
                Gui.this.saveSelectedFilters();
                Gui.this.askForReview();
                if (bl) {
                    System.exit(0);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "West");
        this.toolbox = new Toolbox();
        jPanel.add((Component)this.toolbox, "North");
        this.speciesListPanel = new SpeciesListPanel();
        jPanel.add((Component)this.speciesListPanel, "Center");
        this.operationMediator = new OperationMediator(this.toolbox, this.speciesListPanel);
        JMenuBar jMenuBar = new JMenuBar();
        this.fileMenu = new JMenu(translation.file());
        jMenuBar.add(this.fileMenu);
        this.fileMenu.add(new JMenuItem(new NewGarden(this)));
        this.fileMenu.add(new JMenuItem(new Open(this)));
        this.fileMenu.add(new JMenuItem(new Save(this)));
        this.fileMenu.add(new JMenuItem(new SaveAs(this)));
        this.fileMenu.addSeparator();
        this.fileMenu.add(new JMenuItem(new Export(this)));
        this.fileMenu.add(new JMenuItem(new Print(this)));
        this.fileMenu.add(new JMenuItem(new PrintSetup(this)));
        this.fileMenu.addSeparator();
        this.fileMenu.add(new JMenuItem(new Exit(this)));
        JMenu jMenu = new JMenu(translation.garden());
        jMenuBar.add(jMenu);
        jMenu.add(new JMenuItem(new NewYear(this)));
        jMenu.add(new JMenuItem(new DeleteYear(this, this.tabbedPaneOfYears)));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(new Zoom(this)));
        jMenu.add(new JMenuItem(new GardenStatistics(this)));
        SeedManager seedManager = new SeedManager(this);
        JMenu jMenu2 = new JMenu(translation.species());
        jMenuBar.add(jMenu2);
        jMenu2.add(new JMenuItem(new SpeciesProperties(this)));
        jMenu2.add(new JMenuItem(new Tags(this)));
        jMenu2.add(new JMenuItem(seedManager));
        jMenu2.add(new JMenuItem(new ImportCsv(this)));
        JMenu jMenu3 = new JMenu(translation.action_help());
        jMenu3.add(new JMenuItem(new OpenHelp(this)));
        jMenu3.add(new JMenuItem(new ShowAnExample(this)));
        jMenu3.add(new JMenuItem(new ShowAnotherExample(this)));
        jMenu3.add(new JMenuItem(new Contact(this)));
        jMenu3.add(new JMenuItem(new About(this)));
        jMenu3.addSeparator();
        jMenu3.add(new JMenuItem(new CheckForUpdate(this)));
        jMenu3.add(new JMenuItem(new Review(this)));
        jMenu3.add(new JMenuItem(new EditTranslation(this)));
        jMenu3.add(new JMenuItem(new UploadToWebVersion(this)));
        jMenu3.addSeparator();
        jMenu3.add(new JMenuItem(new Language(this)));
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
        this.getContentPane().add((Component)this.tabbedPaneOfYears, "Center");
        this.parseParameters(seedManager);
        this.gardenFile.loadRecentFileList();
        JMenu jMenu4 = this.gardenFile.getRecentFilesMenu();
        jMenu4.setText(translation.recent_files());
        if (jMenu4.getItemCount() != 0) {
            this.fileMenu.insert(jMenu4, 4);
        }
        if (!this.gardenFile.openLast()) {
            this.gardenFile.createNew();
        }
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/gui");
        String string2 = preferences.get("selectedFamily", "");
        log.info("Selected family " + string2);
        try {
            this.speciesListPanel.setSelectedFamily(PlantList.getResources().getPlant(Integer.parseInt(string2)));
        }
        catch (Exception exception) {
            log.warning(exception.toString());
        }
        String string3 = preferences.get("selectedTag", "");
        log.info("Selected tag " + string3);
        try {
            this.speciesListPanel.setSelectedTag(TagList.getInstance().getTagByName(string3));
        }
        catch (Exception exception) {
            log.warning(exception.toString());
        }
        this.setIconImage(PlantList.getResources().getPlant(40).getImage().get());
        this.setVisible(true);
        this.requestFocusInWindow();
        if (translation.hasMissingTranslations() && preferences.get("lastEditedLanguage", "").compareTo(translation.getLanguage()) != 0) {
            preferences.put("lastEditedLanguage", translation.getLanguage());
            int n = JOptionPane.showConfirmDialog(null, translation.update_missing_translations(), Translation.getPreferred().missing_translations(), 0);
            if (n == 0) {
                EditTranslation editTranslation = new EditTranslation(this);
                editTranslation.actionPerformed(new ActionEvent(this, 0, ""));
            }
        }
    }

    private void saveSelectedFilters() {
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/gui");
        Plant plant = this.speciesListPanel.getSelectedFamily();
        if (plant == null) {
            log.info("No family selected");
        } else {
            log.info("Selected family " + Integer.toString(plant.getId()) + " " + plant.getName());
        }
        preferences.put("selectedFamily", plant == null ? "0" : Integer.toString(plant.getId()));
        Tag tag = this.speciesListPanel.getSelectedTag();
        if (tag == null) {
            log.info("No tag selected");
        } else {
            log.info("Selected tag " + tag.getName());
        }
        preferences.put("selectedTag", tag == null ? "" : tag.getName());
    }

    public void askForReview() {
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/gui");
        if (!preferences.getBoolean("askReview", true)) {
            return;
        }
        Translation translation = Translation.getPreferred();
        int n = JOptionPane.showConfirmDialog(null, translation.ask_review(), translation.action_review(), 1);
        if (n == 2) {
            return;
        }
        preferences.putBoolean("askReview", false);
        if (n == 0) {
            Review.openPage();
        }
    }

    public void addYearTab(Integer n) {
        int n2;
        for (n2 = 0; n2 < this.tabbedPaneOfYears.getTabCount() && this.tabbedPaneOfYears.getTitleAt(n2).compareTo(n.toString()) <= 0; ++n2) {
        }
        JScrollPane jScrollPane = new GardenView(this.gardenFile.getGarden(), n).getScrollPane();
        this.tabbedPaneOfYears.insertTab(n.toString(), null, jScrollPane, null, n2);
        this.tabbedPaneOfYears.setSelectedComponent(jScrollPane);
    }

    public GardenFileWithChanges getGarden() {
        return this.gardenFile;
    }

    public GardenView getGardenView(int n) {
        for (int i = 0; i < this.tabbedPaneOfYears.getTabCount(); ++i) {
            JScrollPane jScrollPane = (JScrollPane)this.tabbedPaneOfYears.getComponentAt(i);
            GardenView gardenView = (GardenView)jScrollPane.getViewport().getView();
            if ((n != 0 || i != this.tabbedPaneOfYears.getSelectedIndex()) && gardenView.getYear() != n) continue;
            return gardenView;
        }
        return null;
    }

    public void resetGui() {
        this.saveSelectedFilters();
        Gui.persistWindowBounds(this, "Gui", true);
        Gui gui = new Gui();
        gui.gardenFile = this.gardenFile;
        gui.objectChanged();
        this.dispose();
    }

    @Override
    public void objectChanged() {
        log.info("Gui.objectChanged()");
        JMenu jMenu = this.gardenFile.getRecentFilesMenu();
        if (jMenu.getParent() == null && jMenu.getItemCount() != 0) {
            this.fileMenu.insert(jMenu, 4);
        }
        this.titleChanged();
        this.tabbedPaneOfYears.removeAll();
        log.info("Tab count is " + this.tabbedPaneOfYears.getTabCount());
        EditableGarden editableGarden = this.gardenFile.getGarden();
        for (Integer n : editableGarden.getYears()) {
            log.info("Adding " + n + " to tabbed pane");
            this.addYearTab(n);
        }
        if (this.tabbedPaneOfYears.getTabCount() == 0) {
            this.addYearTab(Calendar.getInstance().get(1));
        }
        TagInGarden.getInstance().setGarden(editableGarden);
        this.operationMediator.setGarden(editableGarden);
    }

    @Override
    public void unsavedChangesChanged() {
        this.titleChanged();
    }

    private void titleChanged() {
        String string = this.gardenFile.getFile() != null ? "Kitchen garden aid - " + this.gardenFile.getFile().toString() : "Kitchen garden aid - new file";
        if (this.gardenFile.hasUnsavedChanges()) {
            string = string + " *";
        }
        this.setTitle(string);
    }

    public static void makeWindowBoundsPersistent(Window window, final String string, final boolean bl) {
        int n;
        int n2;
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/gui");
        log.info("Restoring bounds for " + string);
        int n3 = Math.max(0, preferences.getInt(string + ".x", Integer.MAX_VALUE));
        int n4 = Math.max(0, preferences.getInt(string + ".y", Integer.MAX_VALUE));
        if (bl) {
            n2 = Math.max(300, preferences.getInt(string + ".w", Integer.MAX_VALUE));
            n = Math.max(300, preferences.getInt(string + ".h", Integer.MAX_VALUE));
        } else {
            n2 = window.getSize().width;
            n = window.getSize().height;
        }
        if (n3 != Integer.MAX_VALUE && n4 != Integer.MAX_VALUE && n2 != Integer.MAX_VALUE && n != Integer.MAX_VALUE) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            if (n3 + n2 >= dimension.width) {
                n3 = dimension.width - n2;
            }
            if (n4 + n >= dimension.height) {
                n4 = dimension.height - n;
            }
            if (bl) {
                log.info("Bounds " + Integer.toString(n3) + " " + Integer.toString(n4) + " " + Integer.toString(n2) + " " + Integer.toString(n));
                window.setBounds(n3, n4, n2, n);
            } else {
                log.info("Location " + Integer.toString(n3) + " " + Integer.toString(n4));
                window.setLocation(n3, n4);
            }
        }
        window.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                Gui.persistWindowBounds(componentEvent.getComponent(), string, bl);
            }
        });
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Gui.persistWindowBounds(windowEvent.getComponent(), string, bl);
            }
        });
    }

    private static void persistWindowBounds(Component component, String string, boolean bl) {
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/gui");
        preferences.putInt(string + ".x", component.getLocation().x);
        preferences.putInt(string + ".y", component.getLocation().y);
        if (bl) {
            log.info("Saving bounds for " + string + " " + Integer.toString(component.getLocation().x) + " " + Integer.toString(component.getLocation().y) + " " + Integer.toString(component.getSize().width) + " " + Integer.toString(component.getSize().height));
            preferences.putInt(string + ".w", component.getSize().width);
            preferences.putInt(string + ".h", component.getSize().height);
        } else {
            log.info("Saving location for " + string + " " + Integer.toString(component.getLocation().x) + " " + Integer.toString(component.getLocation().y));
        }
    }

    private void parseParameters(final SeedManager seedManager) {
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/gui");
        String string = preferences.get("parameter", "");
        if (string.isEmpty()) {
            return;
        }
        Garden garden = new Garden();
        try {
            SerializableGarden.load(garden, new FileInputStream(string));
            log.info("Setting current opened garden to " + string);
            preferences.put("lastOpened", string);
        }
        catch (Exception exception) {
            SeedList seedList = new SeedList();
            SeedList seedList2 = new SeedList();
            SeedListFormatV1 seedListFormatV1 = new SeedListFormatV1();
            try {
                seedListFormatV1.load(seedList, seedList2, new FileInputStream(string));
                log.info("Setting current opened seed file to " + string);
                preferences.node("seedManager").put("lastOpened", string);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        seedManager.actionPerformed(new ActionEvent(this, 1001, ""));
                    }
                });
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
    }
}

