/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.gui.desktop.EditableGarden;
import org.sourceforge.kga.gui.desktop.EditableGardenObserver;
import org.sourceforge.kga.gui.desktop.PlantListPanelListener;
import org.sourceforge.kga.gui.desktop.SpeciesListPanel;
import org.sourceforge.kga.gui.desktop.Toolbox;

public class OperationMediator
implements AWTEventListener,
Toolbox.Listener,
EditableGardenObserver,
PlantListPanelListener {
    private static Logger log = Logger.getLogger(Garden.class.getName());
    Toolbox toolbox;
    SpeciesListPanel speciesListPanel;
    EditableGarden garden;
    boolean handlingEvents = false;

    public OperationMediator(Toolbox toolbox, SpeciesListPanel speciesListPanel) {
        this.toolbox = toolbox;
        this.speciesListPanel = speciesListPanel;
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        toolbox.setListener(this);
        speciesListPanel.addListener(this);
    }

    public void setGarden(EditableGarden editableGarden) {
        if (this.garden != null) {
            this.garden.removeObserver(this);
        }
        this.garden = editableGarden;
        this.garden.addObserver(this);
        this.handlingEvents = true;
        ArrayList<Plant> arrayList = this.speciesListPanel.getSelectedSpecies();
        editableGarden.setSelectedPlant(arrayList.size() > 0 ? arrayList.get(0) : null);
        this.handlingEvents = false;
    }

    @Override
    public void gardenChanged(EditableGarden editableGarden) {
    }

    @Override
    public void zoomFactorChanged(EditableGarden editableGarden) {
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (this.handlingEvents || this.garden == null) {
            return;
        }
        this.handlingEvents = true;
        KeyEvent keyEvent = (KeyEvent)aWTEvent;
        if (keyEvent.isControlDown()) {
            this.garden.setOperation(EditableGarden.Operation.PickPlant);
            this.toolbox.setOperation(EditableGarden.Operation.PickPlant);
        } else if (keyEvent.isShiftDown()) {
            this.garden.setOperation(EditableGarden.Operation.DeletePlant);
            this.toolbox.setOperation(EditableGarden.Operation.DeletePlant);
        } else if (keyEvent.getID() == 402) {
            this.garden.setOperation(EditableGarden.Operation.AddPlant);
            this.toolbox.setOperation(EditableGarden.Operation.AddPlant);
        }
        this.handlingEvents = false;
    }

    @Override
    public void operationChanged(EditableGarden.Operation operation) {
        if (this.handlingEvents || this.garden == null) {
            return;
        }
        this.handlingEvents = true;
        if (operation == null) {
            this.garden.setSelectedPlant(null);
            this.garden.setOperation(EditableGarden.Operation.AddPlant);
            this.speciesListPanel.unselectAll();
        } else {
            this.garden.setOperation(operation);
        }
        this.handlingEvents = false;
    }

    @Override
    public void operationChanged(EditableGarden editableGarden) {
        if (this.handlingEvents || this.garden == null) {
            return;
        }
        this.handlingEvents = true;
        this.toolbox.setOperation(editableGarden.getOperation());
        this.handlingEvents = false;
    }

    @Override
    public void previewSpeciesChanged(EditableGarden editableGarden, Plant plant) {
        if (this.handlingEvents || this.garden == null) {
            return;
        }
        this.handlingEvents = true;
        this.speciesListPanel.setSelectedSpecies(plant);
        this.toolbox.setSelectedPlant(plant);
        this.handlingEvents = false;
    }

    @Override
    public void selectedPlantChanged(Plant plant) {
        if (this.handlingEvents || this.garden == null) {
            return;
        }
        this.handlingEvents = true;
        this.garden.setSelectedPlant(plant);
        this.garden.setOperation(EditableGarden.Operation.AddPlant);
        this.toolbox.setSelectedPlant(plant);
        this.toolbox.setOperation(EditableGarden.Operation.AddPlant);
        this.handlingEvents = false;
    }
}

