/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop.actions;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URI;
import java.util.Date;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.gui.desktop.Gui;
import org.sourceforge.kga.gui.desktop.actions.KgaAction;
import org.sourceforge.kga.translation.Translation;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class CheckForUpdate
extends KgaAction
implements ItemListener {
    private static Logger log = Logger.getLogger(Garden.class.getName());
    static String rssFeed = "https://sourceforge.net/api/file/index/project-id/290359/mtime/desc/limit/20/rss";

    public CheckForUpdate(Gui gui) {
        super(gui, Translation.getPreferred().action_check_for_update());
    }

    private static String getStringFromDoc(Document document) {
        try {
            DOMSource dOMSource = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(dOMSource, streamResult);
            stringWriter.flush();
            return stringWriter.toString();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
            return null;
        }
    }

    public static void GetLatestVersion(StringBuffer stringBuffer, StringBuffer stringBuffer2) throws Exception {
        log.info("Get latest version from " + rssFeed);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(rssFeed);
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("channel");
        if (nodeList.getLength() != 1) {
            throw new Exception("Can not parse RSS document from sourceforge: channel ( expected: 1; found: " + Integer.toString(nodeList.getLength()) + " )");
        }
        Element element2 = (Element)nodeList.item(0);
        NodeList nodeList2 = element2.getElementsByTagName("item");
        if (nodeList2.getLength() == 0) {
            throw new Exception("Can not parse RSS document from sourceforge: item");
        }
        Element element3 = (Element)nodeList2.item(0);
        NodeList nodeList3 = element3.getElementsByTagName("title");
        if (nodeList3.getLength() != 1) {
            throw new Exception("Can not parse RSS document from sourceforge: title");
        }
        Element element4 = (Element)nodeList3.item(0);
        NodeList nodeList4 = element3.getElementsByTagName("link");
        if (nodeList4.getLength() != 1) {
            throw new Exception("Can not parse RSS document from sourceforge: link");
        }
        Element element5 = (Element)nodeList4.item(0);
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/check_for_update");
        Date date = new Date();
        preferences.putLong("time", date.getTime());
        log.info("Set last check time " + date.toString());
        stringBuffer.replace(0, stringBuffer.length(), ((CDATASection)element4.getFirstChild()).getData());
        stringBuffer2.replace(0, stringBuffer.length(), ((Text)element5.getFirstChild()).getNodeValue());
    }

    public static boolean AutomaticallyCheck() {
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/check_for_update");
        if (!preferences.getBoolean("automatically", true)) {
            log.info("Automatically check for new version is disabled by user");
            return false;
        }
        Date date = new Date();
        Date date2 = new Date(preferences.getLong("time", 0L));
        log.info("Last check time " + date2.toString());
        if (date2.getTime() + 2592000000L > date.getTime()) {
            log.info("Don't check earlier than 30 days");
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        Object object;
        Serializable serializable2;
        Translation translation = Translation.getPreferred();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><h1>Kitchen garden aid</h1><br/>");
        JButton jButton = null;
        try {
            serializable2 = new StringBuffer();
            object = new StringBuffer();
            CheckForUpdate.GetLatestVersion((StringBuffer)serializable2, (StringBuffer)object);
            serializable = new URI(((StringBuffer)object).toString());
            if (((StringBuffer)serializable2).indexOf("1.8.2") == -1) {
                stringBuilder.append("<b>" + translation.new_version_available() + ":</b>" + serializable2);
                jButton = new JButton(translation.go_to_download());
                jButton.addActionListener(new ActionListener((URI)serializable){
                    final /* synthetic */ URI val$uri;
                    {
                        this.val$uri = uRI;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (Desktop.isDesktopSupported()) {
                            Desktop desktop = Desktop.getDesktop();
                            try {
                                desktop.browse(this.val$uri);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                });
            } else {
                stringBuilder.append("<b>" + translation.no_new_version_available() + ":</b>" + serializable2);
            }
        }
        catch (Exception exception) {
            stringBuilder.append(exception.toString());
        }
        serializable2 = new JLabel(stringBuilder.toString());
        ((JComponent)serializable2).setFont(new Font(((Component)serializable2).getFont().getName(), 0, ((Component)serializable2).getFont().getSize()));
        object = Preferences.userRoot().node("/org/sourceforge/kga/check_for_update");
        serializable = new JCheckBox(translation.automatically_check(), ((Preferences)object).getBoolean("automatically", true));
        ((AbstractButton)serializable).addItemListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.add((Component)serializable2);
        if (jButton != null) {
            jPanel.add(jButton);
        }
        jPanel.add((Component)serializable);
        JDialog jDialog = new JOptionPane(jPanel).createDialog(translation.action_check_for_update());
        jDialog.setVisible(true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/check_for_update");
        preferences.putBoolean("automatically", itemEvent.getStateChange() == 1);
    }
}

