/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop.actions;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.sourceforge.kga.gui.desktop.Gui;
import org.sourceforge.kga.gui.desktop.actions.KgaAction;
import org.sourceforge.kga.translation.Translation;

public class Export
extends KgaAction {
    private static Logger log = Logger.getLogger(Export.class.getName());

    public Export(Gui gui) {
        super(gui, Translation.getPreferred().action_export());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setAcceptAllFileFilterUsed(false);
        String[] stringArray = ImageIO.getWriterFormatNames();
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        for (String object2 : stringArray) {
            if (!object2.toUpperCase().equals(object2)) continue;
            stringArray2[n++] = object2;
        }
        for (String string : stringArray) {
            int n2;
            if (string.toUpperCase() == string) continue;
            for (n2 = 0; n2 < n && !stringArray2[n2].equals(string.toUpperCase()); ++n2) {
            }
            if (n2 != n) continue;
            stringArray2[n++] = string;
        }
        for (String string : stringArray2) {
            if (string == null) continue;
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(string, string);
            jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
        }
        if (jFileChooser.showSaveDialog(this.getGui()) != 0) {
            log.info("Export canceled");
            return;
        }
        Object object3 = jFileChooser.getSelectedFile();
        String string = ((FileNameExtensionFilter)jFileChooser.getFileFilter()).getExtensions()[0];
        if (!((File)object3).getName().endsWith(string)) {
            object3 = new File(((File)object3).getParent(), ((File)object3).getName() + "." + string);
        }
        log.info("Export into format " + string + " to " + ((File)object3).getPath());
        BufferedImage bufferedImage = this.getGardenView(0).getBufferedImage();
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        bufferedImage2.getGraphics().drawImage(bufferedImage, 0, 0, Color.WHITE, null);
        try {
            ImageIO.write((RenderedImage)bufferedImage2, string, (File)object3);
            log.info("Export succeed");
        }
        catch (IOException iOException) {
            Translation translation = Translation.getPreferred();
            JOptionPane.showMessageDialog(this.getGui(), iOException.toString(), translation.error_saving_file(), 0);
        }
    }
}

