/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.PlantComparatorByName;
import org.sourceforge.kga.Point;
import org.sourceforge.kga.SpeciesComparatorByFrequency;
import org.sourceforge.kga.gui.desktop.Gui;
import org.sourceforge.kga.gui.desktop.PlantLabel;
import org.sourceforge.kga.gui.desktop.actions.KgaAction;
import org.sourceforge.kga.rules.Hint;
import org.sourceforge.kga.rules.HintList;
import org.sourceforge.kga.rules.Rule;
import org.sourceforge.kga.translation.Translation;

public class GardenStatistics
extends KgaAction {
    private static final long serialVersionUID = 1L;
    Map<Integer, Integer> hintsGood;
    Map<Integer, Integer> hintsBad;
    Map<Integer, Map<Plant, Integer>> frequency;
    Set<Integer> yearsSet;
    Set<Plant> plantSet;
    Map<Plant, Integer> totalYears;
    Map<Plant, Integer> totalSquares;
    JToggleButton currentSortButton;
    Map<JToggleButton, Comparator<Plant>> sortButtons;
    JScrollPane scrollPane;
    Dimension statisticsCellSize;
    private static Icon iconAscending = UIManager.getIcon("Table.ascendingSortIcon");
    private static Icon iconDescending = UIManager.getIcon("Table.descendingSortIcon");

    public GardenStatistics(Gui gui) {
        super(gui, Translation.getPreferred().action_garden_statistics());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JToggleButton) {
            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
            if (this.currentSortButton == jToggleButton) {
                if (this.currentSortButton.getIcon() == iconAscending) {
                    this.currentSortButton.setIcon(iconDescending);
                } else {
                    this.currentSortButton.setIcon(iconAscending);
                }
                this.currentSortButton.setSelected(true);
            } else {
                this.currentSortButton.setIcon(iconAscending);
                this.currentSortButton.setSelected(false);
                this.currentSortButton = jToggleButton;
                this.currentSortButton.setSelected(true);
            }
            Comparator<Plant> comparator = this.sortButtons.get(this.currentSortButton);
            if (comparator instanceof SpeciesComparatorByFrequency) {
                ((SpeciesComparatorByFrequency)comparator).setAscending(this.currentSortButton.getIcon() == iconAscending);
            } else if (this.currentSortButton.getIcon() == iconDescending) {
                comparator = Collections.reverseOrder(comparator);
            }
            ArrayList<Plant> arrayList = new ArrayList<Plant>();
            arrayList.addAll(this.plantSet);
            this.plantSet = new TreeSet<Plant>(comparator);
            this.plantSet.addAll(arrayList);
            this.fillStatisticsTable();
            return;
        }
        this.hintsGood = new TreeMap<Integer, Integer>();
        this.hintsBad = new TreeMap<Integer, Integer>();
        this.frequency = new TreeMap<Integer, Map<Plant, Integer>>();
        this.plantSet = new TreeSet<Plant>(new PlantComparatorByName());
        this.totalYears = new HashMap<Plant, Integer>();
        this.totalSquares = new HashMap<Plant, Integer>();
        this.sortButtons = new HashMap<JToggleButton, Comparator<Plant>>();
        this.computeStatistics();
        this.displayStatistics();
    }

    /*
     * WARNING - void declaration
     */
    private void computeStatistics() {
        for (Map.Entry<Integer, HashMap<Point, List<Plant>>> object : this.getGarden().getAllSquares().entrySet()) {
            int n = object.getKey();
            this.hintsGood.put(n, 0);
            this.hintsBad.put(n, 0);
            Map.Entry<Integer, Map<Plant, Integer>> entry = new HashMap();
            this.frequency.put(n, (Map<Plant, Integer>)((Object)entry));
            for (Map.Entry entry2 : object.getValue().entrySet()) {
                HintList hintList = Rule.getHints(this.getGarden(), n, (Point)entry2.getKey(), false);
                this.hintsGood.put(n, this.hintsGood.get(n) + hintList.getValue(Hint.Value.GOOD));
                this.hintsBad.put(n, this.hintsBad.get(n) + hintList.getValue(Hint.Value.BAD));
                for (Plant plant : (List)entry2.getValue()) {
                    if (plant.isItem()) continue;
                    Integer n2 = (Integer)entry.get(plant);
                    if (n2 == null) {
                        n2 = 0;
                    }
                    entry.put((Integer)((Object)plant), (Map<Plant, Integer>)(n2 + 1));
                }
            }
        }
        for (Map.Entry<Integer, Map<Object, Object>> entry : this.frequency.entrySet()) {
            this.plantSet.addAll(entry.getValue().keySet());
        }
        this.yearsSet = this.frequency.keySet();
        for (Plant plant : this.plantSet) {
            for (Map.Entry<Integer, Map<Plant, Integer>> entry : this.frequency.entrySet()) {
                void var6_19;
                void var6_15;
                Integer n = (Integer)((Map)entry.getValue()).get(plant);
                if (n == null) continue;
                Integer n3 = this.totalYears.get(plant);
                if (n3 == null) {
                    Integer n4 = 0;
                }
                Integer n5 = var6_15.intValue() + 1;
                this.totalYears.put(plant, n5);
                Integer n6 = this.totalSquares.get(plant);
                if (n6 == null) {
                    Integer n7 = 0;
                }
                this.totalSquares.put(plant, var6_19.intValue() + n);
            }
        }
    }

    private JToggleButton createSortButton(Comparator<Plant> comparator) {
        JToggleButton jToggleButton = new JToggleButton();
        jToggleButton.setIcon(iconAscending);
        jToggleButton.setPreferredSize(new Dimension(iconAscending.getIconWidth() + 20, iconAscending.getIconHeight()));
        jToggleButton.addActionListener(this);
        this.sortButtons.put(jToggleButton, comparator);
        return jToggleButton;
    }

    private void displayStatistics() {
        JLabel jLabel;
        Serializable serializable3;
        Serializable serializable22;
        Translation translation = Translation.getPreferred();
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.fill = 1;
        for (Serializable serializable22 : this.yearsSet) {
            gridBagConstraints.gridx = 0;
            for (Serializable serializable3 : new Integer[]{serializable22, this.hintsGood.get(serializable22), this.hintsBad.get(serializable22), this.hintsGood.get(serializable22) - this.hintsBad.get(serializable22)}) {
                jLabel = new JLabel(serializable3.toString());
                jLabel.setHorizontalAlignment(11);
                jLabel.setBorder(PlantLabel.defaultBorder);
                jPanel.add((Component)jLabel, gridBagConstraints);
                ++gridBagConstraints.gridx;
            }
            jPanel.add((Component)this.createSortButton(new SpeciesComparatorByFrequency(this.frequency.get(serializable22))), gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        jLabel = new JLabel(translation.total_years());
        jLabel.setBorder(PlantLabel.defaultBorder);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.createSortButton(new SpeciesComparatorByFrequency(this.totalYears)), gridBagConstraints);
        jLabel = new JLabel(translation.total_squares());
        jLabel.setBorder(PlantLabel.defaultBorder);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.createSortButton(new SpeciesComparatorByFrequency(this.totalSquares)), gridBagConstraints);
        JPanel jPanel2 = this.createSpeciesPanel();
        this.statisticsCellSize = new Dimension(jPanel2.getLayout().minimumLayoutSize((Container)jPanel2).width / this.plantSet.size(), gridBagLayout.minimumLayoutSize((Container)jPanel).height / (this.yearsSet.size() + 2));
        serializable22 = new GridBagLayout();
        JPanel jPanel3 = new JPanel((LayoutManager)((Object)serializable22));
        jLabel = new JLabel(" ");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        jPanel3.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(translation.year());
        jLabel.setBorder(PlantLabel.defaultBorder);
        jLabel.setHorizontalAlignment(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        jPanel3.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel();
        jLabel.setIcon(new ImageIcon(Rule.GOOD.get()));
        jLabel.setBorder(PlantLabel.defaultBorder);
        jLabel.setHorizontalAlignment(0);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel();
        jLabel.setIcon(new ImageIcon(Rule.BAD.get()));
        jLabel.setBorder(PlantLabel.defaultBorder);
        jLabel.setHorizontalAlignment(0);
        gridBagConstraints.gridx = 2;
        jPanel3.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel("=");
        jLabel.setBorder(PlantLabel.defaultBorder);
        jLabel.setHorizontalAlignment(0);
        gridBagConstraints.gridx = 3;
        jPanel3.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        this.currentSortButton = this.createSortButton(new PlantComparatorByName());
        this.currentSortButton.setSelected(true);
        jPanel3.add((Component)this.currentSortButton, gridBagConstraints);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setRowHeaderView(jPanel);
        this.scrollPane.setCorner("UPPER_LEFT_CORNER", jPanel3);
        Dimension dimension = jPanel2.getLayout().minimumLayoutSize(jPanel2);
        Dimension dimension2 = gridBagLayout.minimumLayoutSize(jPanel);
        serializable3 = this.scrollPane.getBorder().getBorderInsets(this.scrollPane);
        this.scrollPane.setPreferredSize(new Dimension(Math.min(800, dimension.width + dimension2.width + this.scrollPane.getVerticalScrollBar().getMaximumSize().width + ((Insets)serializable3).left + ((Insets)serializable3).right), Math.min(600, dimension.height + dimension2.height + this.scrollPane.getHorizontalScrollBar().getMaximumSize().height) + ((Insets)serializable3).top + ((Insets)serializable3).bottom));
        this.fillStatisticsTable();
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(this.statisticsCellSize.width / 3);
        JDialog jDialog = new JOptionPane(this.scrollPane).createDialog(translation.action_garden_statistics());
        Gui.makeWindowBoundsPersistent(jDialog, "GardenStatistics", false);
        jDialog.setVisible(true);
    }

    JPanel createSpeciesPanel() {
        GridLayout gridLayout = new GridLayout(1, this.plantSet.size());
        JPanel jPanel = new JPanel(gridLayout);
        for (Plant plant : this.plantSet) {
            jPanel.add(new PlantLabel(plant));
        }
        return jPanel;
    }

    void fillStatisticsTable() {
        JLabel jLabel;
        JPanel jPanel = this.createSpeciesPanel();
        JPanel jPanel2 = new JPanel(new GridLayout(this.yearsSet.size() + 2, this.plantSet.size()));
        for (Map.Entry<Integer, Map<Plant, Integer>> object : this.frequency.entrySet()) {
            for (Plant plant : this.plantSet) {
                Integer n = object.getValue().get(plant);
                jLabel = new JLabel(n == null ? "" : n.toString());
                jLabel.setPreferredSize(this.statisticsCellSize);
                jLabel.setHorizontalAlignment(11);
                jLabel.setBorder(PlantLabel.defaultBorder);
                jPanel2.add(jLabel);
            }
        }
        for (Plant plant : this.plantSet) {
            jLabel = new JLabel(this.totalYears.get(plant).toString());
            jLabel.setPreferredSize(this.statisticsCellSize);
            jLabel.setHorizontalAlignment(11);
            jLabel.setBorder(PlantLabel.defaultBorder);
            jPanel2.add(jLabel);
        }
        for (Plant plant : this.plantSet) {
            jLabel = new JLabel(this.totalSquares.get(plant).toString());
            jLabel.setPreferredSize(this.statisticsCellSize);
            jLabel.setHorizontalAlignment(11);
            jLabel.setBorder(PlantLabel.defaultBorder);
            jPanel2.add(jLabel);
        }
        this.scrollPane.setViewportView(jPanel2);
        this.scrollPane.setColumnHeaderView(jPanel);
    }
}

