/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractCellEditor;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.SeedList;
import org.sourceforge.kga.gui.desktop.FileWithChanges;
import org.sourceforge.kga.gui.desktop.Gui;
import org.sourceforge.kga.gui.desktop.PlantComboBox;
import org.sourceforge.kga.gui.desktop.PlantComponent;
import org.sourceforge.kga.gui.desktop.SeedFileWithChanges;
import org.sourceforge.kga.gui.desktop.actions.KgaAction;
import org.sourceforge.kga.gui.desktop.actions.SeedManagerAutogenerate;
import org.sourceforge.kga.gui.desktop.actions.SeedManagerPrintPreview;
import org.sourceforge.kga.plant.TagInInventory;
import org.sourceforge.kga.translation.Translation;

public class SeedManager
extends KgaAction
implements FileWithChanges.Listener {
    private static Logger log = Logger.getLogger(Garden.class.getName());
    private static final long serialVersionUID = 1L;
    JDialog dialog;
    JTextField textDate = new JTextField();
    LocalDate workingDate;
    SeedFileWithChanges seedFile = new SeedFileWithChanges();
    JToggleButton buttonDateList = new JToggleButton();
    JButton buttonNow = new JButton();
    JButton buttonDelete = new JButton();
    JButton buttonMove = new JButton();
    JButton buttonCopy = new JButton();
    JTable tableInventory = new JTable();
    JTable tableShoppingList = new JTable();
    JLabel labelInventory = new JLabel();
    JLabel labelShoppingList = new JLabel();
    JMenu fileMenu = new JMenu();
    JMenuItem menuNew = new JMenuItem();
    JMenuItem menuOpen = new JMenuItem();
    JMenuItem menuSave = new JMenuItem();
    JMenuItem menuSaveAs = new JMenuItem();
    JMenuItem menuPrint = new JMenuItem();
    JMenu toolsMenu = new JMenu();
    JMenuItem menuOptions = new JMenuItem();
    JMenu menuAutogenerate = new JMenu();
    JMenuItem menuAutogenerateFromGarden = new JMenuItem();
    JMenuItem menuAutogenerateFromInventory = new JMenuItem();
    JComboBox<LocalDate> comboValidFromDates = new JComboBox();
    DateTimeFormatter dateFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM);
    boolean inventorySelected = false;
    TreeSet<LocalDate> validFromDates = new TreeSet();
    boolean[] viewColumns = new boolean[]{true, true, true, true, false, false};

    public SeedManager(Gui gui) {
        super(gui, Translation.getPreferred().action_seed_manager());
        TagInInventory.getInstance().setSeedFile(this.seedFile);
        this.seedFile.addListener(this);
        this.createComponents();
        this.workingDate = LocalDate.now();
        this.textDate.setText(this.workingDate.format(this.dateFormatter));
        this.seedFile.setDate(this.workingDate);
        if (this.seedFile.getSeedInventory() == null && !this.seedFile.openLast()) {
            this.seedFile.createNew();
        }
    }

    private void dateChangedFromComboBox() {
        this.workingDate = (LocalDate)this.comboValidFromDates.getSelectedItem();
        this.seedFile.setDate(this.workingDate);
        this.textDate.removeActionListener(this);
        this.textDate.setText(this.workingDate.format(this.dateFormatter));
        this.textDate.addActionListener(this);
    }

    private void dateChangedFromTextBox() {
        try {
            this.workingDate = LocalDate.parse(this.textDate.getText(), this.dateFormatter);
        }
        catch (DateTimeParseException dateTimeParseException) {
            JOptionPane.showMessageDialog(null, "Invalid date " + this.textDate.getText());
        }
        this.seedFile.setDate(this.workingDate);
        this.textDate.removeActionListener(this);
        this.textDate.setText(this.workingDate.format(this.dateFormatter));
        this.textDate.addActionListener(this);
        LocalDate localDate = this.validFromDates.floor(this.workingDate);
        if (localDate == null && this.validFromDates.size() > 0) {
            localDate = this.validFromDates.first();
        }
        this.comboValidFromDates.removeActionListener(this);
        this.comboValidFromDates.setSelectedItem(localDate);
        this.comboValidFromDates.addActionListener(this);
    }

    ArrayList<SeedList.Entry> getSelectedEntries() {
        JTable jTable = this.inventorySelected ? this.tableInventory : this.tableShoppingList;
        SeedList seedList = this.inventorySelected ? this.seedFile.getSeedInventory() : this.seedFile.getSeedShoppingList();
        ArrayList<SeedList.Entry> arrayList = new ArrayList<SeedList.Entry>();
        for (int n : jTable.getSelectedRows()) {
            if (n >= seedList.size()) continue;
            arrayList.add(seedList.get(n));
        }
        return arrayList;
    }

    private void stopEditing() {
        if (this.tableInventory.isEditing()) {
            this.tableInventory.getCellEditor().cancelCellEditing();
        }
        if (this.tableShoppingList.isEditing()) {
            this.tableShoppingList.getCellEditor().cancelCellEditing();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Translation translation = Translation.getPreferred();
        if (actionEvent.getSource() == this.menuNew) {
            this.seedFile.createNew();
        } else if (actionEvent.getSource() == this.menuOpen) {
            this.seedFile.open();
        } else if (actionEvent.getSource() == this.menuSave) {
            this.seedFile.save(false);
        } else if (actionEvent.getSource() == this.menuSaveAs) {
            this.seedFile.save(true);
        } else if (actionEvent.getSource() == this.menuPrint) {
            SeedManagerPrintPreview seedManagerPrintPreview = new SeedManagerPrintPreview(this.dialog, this.seedFile, this.workingDate);
            seedManagerPrintPreview.actionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.menuOptions) {
            this.showOptions();
        } else if (actionEvent.getSource() == this.menuAutogenerateFromGarden) {
            SeedManagerAutogenerate seedManagerAutogenerate = new SeedManagerAutogenerate(this.dialog, this.seedFile, this.workingDate);
            if (seedManagerAutogenerate.fromGarden(this.getGarden()) == 0) {
                seedManagerAutogenerate.actionPerformed(actionEvent);
            }
        } else if (actionEvent.getSource() == this.menuAutogenerateFromInventory) {
            SeedManagerAutogenerate seedManagerAutogenerate = new SeedManagerAutogenerate(this.dialog, this.seedFile, this.workingDate);
            if (seedManagerAutogenerate.fromInventory() == 0) {
                seedManagerAutogenerate.actionPerformed(actionEvent);
            }
        } else if (actionEvent.getSource() == this.textDate) {
            this.dateChangedFromTextBox();
        } else if (actionEvent.getSource() == this.comboValidFromDates) {
            this.dateChangedFromComboBox();
        } else if (actionEvent.getSource() == this.buttonDelete) {
            this.stopEditing();
            ArrayList<SeedList.Entry> arrayList = this.getSelectedEntries();
            SeedList seedList = this.inventorySelected ? this.seedFile.getSeedInventory() : this.seedFile.getSeedShoppingList();
            for (SeedList.Entry entry : arrayList) {
                seedList.remove(entry, this.workingDate);
            }
        } else if (actionEvent.getSource() == this.buttonMove) {
            this.stopEditing();
            ArrayList<SeedList.Entry> arrayList = this.getSelectedEntries();
            SeedList seedList = this.inventorySelected ? this.seedFile.getSeedInventory() : this.seedFile.getSeedShoppingList();
            SeedList seedList2 = !this.inventorySelected ? this.seedFile.getSeedInventory() : this.seedFile.getSeedShoppingList();
            for (SeedList.Entry entry : arrayList) {
                seedList2.add(entry.getPlant(), entry.getVariety(), entry.getQuantity(), entry.getComment(), this.workingDate, null);
                seedList.remove(entry, this.workingDate);
            }
        } else if (actionEvent.getSource() == this.buttonCopy) {
            ArrayList<SeedList.Entry> arrayList = this.getSelectedEntries();
            SeedList seedList = !this.inventorySelected ? this.seedFile.getSeedInventory() : this.seedFile.getSeedShoppingList();
            for (SeedList.Entry entry : arrayList) {
                seedList.add(entry.getPlant(), entry.getVariety(), entry.getQuantity(), entry.getComment(), this.workingDate, null);
            }
        } else {
            this.workingDate = LocalDate.now();
            this.textDate.setText(this.workingDate.format(this.dateFormatter));
            this.seedFile.setDate(this.workingDate);
            this.buttonNow.setText(translation.now());
            this.buttonDateList.setText(this.buttonDateList.isSelected() ? translation.changes_date() : translation.working_date());
            this.buttonDelete.setText(translation.delete());
            this.buttonMove.setText(translation.move());
            this.buttonCopy.setText(translation.copy());
            this.fileMenu.setText(translation.file());
            this.menuNew.setText(translation.action_new_seed_list());
            this.menuOpen.setText(translation.action_open());
            this.menuSave.setText(translation.action_save());
            this.menuSaveAs.setText(translation.action_save_as());
            this.menuPrint.setText(translation.action_print());
            this.toolsMenu.setText(translation.seed_manager_tools());
            this.menuOptions.setText(translation.seed_manager_options());
            this.menuAutogenerate.setText(translation.seed_manager_autogenerate());
            this.menuAutogenerateFromGarden.setText(translation.seed_manager_from_garden());
            this.menuAutogenerateFromInventory.setText(translation.seed_manager_from_inventory());
            this.labelInventory.setText(translation.seed_manager_inventory());
            this.labelShoppingList.setText(translation.seed_manager_shopping_list());
            JMenu jMenu = this.seedFile.getRecentFilesMenu();
            jMenu.setText(translation.recent_files());
            if (jMenu.getParent() == null && jMenu.getItemCount() != 0) {
                this.fileMenu.insert(jMenu, 4);
            }
            this.dialog.setVisible(true);
        }
    }

    private void createComponents() {
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/gui/seedManager");
        this.viewColumns[1] = preferences.getBoolean("viewVariety", true);
        this.viewColumns[2] = preferences.getBoolean("viewQuantity", true);
        this.viewColumns[3] = preferences.getBoolean("viewComment", true);
        this.viewColumns[4] = preferences.getBoolean("viewValidFrom", false);
        this.viewColumns[5] = preferences.getBoolean("viewValidTo", false);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.textDate.addActionListener(this);
        this.textDate.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                SeedManager.this.dateChangedFromTextBox();
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }
        });
        this.buttonDateList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SeedManager.this.comboValidFromDates.setVisible(SeedManager.this.buttonDateList.isSelected());
                SeedManager.this.textDate.setVisible(!SeedManager.this.buttonDateList.isSelected());
                if (SeedManager.this.buttonDateList.isSelected()) {
                    SeedManager.this.dateChangedFromComboBox();
                } else {
                    SeedManager.this.dateChangedFromTextBox();
                }
                Translation translation = Translation.getPreferred();
                SeedManager.this.buttonDateList.setText(SeedManager.this.buttonDateList.isSelected() ? translation.changes_date() : translation.working_date());
            }
        });
        this.comboValidFromDates.setVisible(false);
        this.comboValidFromDates.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                LocalDate localDate = (LocalDate)object;
                String string = localDate == null ? null : localDate.format(SeedManager.this.dateFormatter);
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        });
        this.buttonNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SeedManager.this.buttonDateList.setSelected(false);
                SeedManager.this.comboValidFromDates.setVisible(SeedManager.this.buttonDateList.isSelected());
                SeedManager.this.textDate.setVisible(!SeedManager.this.buttonDateList.isSelected());
                SeedManager.this.textDate.setText(LocalDate.now().format(SeedManager.this.dateFormatter));
                SeedManager.this.dateChangedFromTextBox();
            }
        });
        this.comboValidFromDates.addActionListener(this);
        jPanel.add(this.buttonDateList);
        jPanel.add(this.comboValidFromDates);
        jPanel.add(this.textDate);
        jPanel.add(this.buttonNow);
        JScrollPane jScrollPane = new JScrollPane(this.tableInventory);
        JScrollPane jScrollPane2 = new JScrollPane(this.tableShoppingList);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.labelInventory, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this.labelShoppingList, "North");
        jPanel3.add((Component)jScrollPane2, "Center");
        JPanel jPanel4 = new JPanel(new GridLayout());
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel, "North");
        jPanel5.add((Component)jPanel4, "Center");
        this.buttonDelete.addActionListener(this);
        this.buttonMove.addActionListener(this);
        this.buttonCopy.addActionListener(this);
        this.tableInventory.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SeedManager.this.inventorySelected = true;
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.tableShoppingList.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SeedManager.this.inventorySelected = false;
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.fileMenu.add(this.menuNew);
        this.fileMenu.add(this.menuOpen);
        this.fileMenu.add(this.menuSave);
        this.fileMenu.add(this.menuSaveAs);
        this.fileMenu.add(this.menuPrint);
        this.menuNew.addActionListener(this);
        this.menuOpen.addActionListener(this);
        this.menuSave.addActionListener(this);
        this.menuSaveAs.addActionListener(this);
        this.menuPrint.addActionListener(this);
        this.toolsMenu.add(this.menuOptions);
        this.toolsMenu.add(this.menuAutogenerate);
        this.menuAutogenerate.add(this.menuAutogenerateFromGarden);
        this.menuAutogenerate.add(this.menuAutogenerateFromInventory);
        this.menuOptions.addActionListener(this);
        this.menuAutogenerateFromGarden.addActionListener(this);
        this.menuAutogenerateFromInventory.addActionListener(this);
        this.dialog = new JOptionPane(jPanel5, -1, 0, null, new JButton[]{this.buttonDelete, this.buttonMove, this.buttonCopy}).createDialog(Translation.getPreferred().action_seed_manager());
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.fileMenu);
        jMenuBar.add(this.toolsMenu);
        this.dialog.setJMenuBar(jMenuBar);
        this.dialog.setResizable(true);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SeedManager.this.dialog.setDefaultCloseOperation(SeedManager.this.seedFile.askToSave() ? 1 : 0);
            }
        });
        Gui.makeWindowBoundsPersistent(this.dialog, "SeedManager", true);
    }

    void loadValidFromDates() {
        TreeSet<LocalDate> treeSet = new TreeSet<LocalDate>();
        treeSet.addAll(this.seedFile.getSeedInventory().getValidFromDates());
        treeSet.addAll(this.seedFile.getSeedShoppingList().getValidFromDates());
        if (!treeSet.equals(this.validFromDates)) {
            this.validFromDates = treeSet;
            this.comboValidFromDates.setModel(new DefaultComboBoxModel<LocalDate>(this.validFromDates.toArray(new LocalDate[0])));
            if (!this.comboValidFromDates.isVisible()) {
                this.dateChangedFromTextBox();
            }
        }
    }

    @Override
    public void objectChanged() {
        JMenu jMenu = this.seedFile.getRecentFilesMenu();
        if (jMenu.getParent() == null && jMenu.getItemCount() != 0) {
            this.fileMenu.insert(jMenu, 4);
        }
        this.titleChanged();
        this.tableInventory.setModel(new SeedListTableModel(this.seedFile.getSeedInventory()));
        this.tableShoppingList.setModel(new SeedListTableModel(this.seedFile.getSeedShoppingList()));
        this.loadValidFromDates();
        this.tableInventory.setDefaultRenderer(SeedList.Entry.PlantOrUnregistered.class, new PlantColumnRenderer());
        this.tableInventory.setDefaultRenderer(SeedList.Entry.Quantity.class, new QuantityColumnRenderer());
        this.tableInventory.setDefaultRenderer(LocalDate.class, new LocalDateRenderer());
        this.tableInventory.setDefaultEditor(SeedList.Entry.PlantOrUnregistered.class, new DefaultCellEditor(new PlantComboBox()));
        this.tableInventory.setDefaultEditor(SeedList.Entry.Quantity.class, new QuantityTextField());
        this.tableInventory.setAutoResizeMode(3);
        this.tableShoppingList.setDefaultRenderer(SeedList.Entry.PlantOrUnregistered.class, new PlantColumnRenderer());
        this.tableShoppingList.setDefaultRenderer(SeedList.Entry.Quantity.class, new QuantityColumnRenderer());
        this.tableShoppingList.setDefaultRenderer(LocalDate.class, new LocalDateRenderer());
        this.tableShoppingList.setDefaultEditor(SeedList.Entry.PlantOrUnregistered.class, new DefaultCellEditor(new PlantComboBox()));
        this.tableShoppingList.setDefaultEditor(SeedList.Entry.Quantity.class, new QuantityTextField());
        this.tableShoppingList.setAutoResizeMode(3);
    }

    @Override
    public void unsavedChangesChanged() {
        this.titleChanged();
    }

    private void titleChanged() {
        Translation translation = Translation.getPreferred();
        String string = this.seedFile.getFile() != null ? translation.action_seed_manager() + " - " + this.seedFile.getFile().toString() : translation.action_seed_manager() + " - new file";
        if (this.seedFile.hasUnsavedChanges()) {
            string = string + " *";
        }
        this.dialog.setTitle(string);
    }

    private void showOptions() {
        Translation translation = Translation.getPreferred();
        JCheckBox jCheckBox = new JCheckBox(translation.seed_manager_view_variety(), this.viewColumns[1]);
        JCheckBox jCheckBox2 = new JCheckBox(translation.seed_manager_view_quantity(), this.viewColumns[2]);
        JCheckBox jCheckBox3 = new JCheckBox(translation.seed_manager_view_comment(), this.viewColumns[3]);
        JCheckBox jCheckBox4 = new JCheckBox(translation.seed_manager_view_valid_from(), this.viewColumns[4]);
        JCheckBox jCheckBox5 = new JCheckBox(translation.seed_manager_view_valid_to(), this.viewColumns[5]);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jCheckBox);
        jPanel.add(jCheckBox2);
        jPanel.add(jCheckBox3);
        jPanel.add(jCheckBox4);
        jPanel.add(jCheckBox5);
        int n = JOptionPane.showConfirmDialog(this.dialog, jPanel, translation.seed_manager_options(), 2, -1);
        if (n == 0) {
            this.viewColumns[1] = jCheckBox.isSelected();
            this.viewColumns[2] = jCheckBox2.isSelected();
            this.viewColumns[3] = jCheckBox3.isSelected();
            this.viewColumns[4] = jCheckBox4.isSelected();
            this.viewColumns[5] = jCheckBox5.isSelected();
            Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/gui/seedManager");
            preferences.putBoolean("viewVariety", this.viewColumns[1]);
            preferences.putBoolean("viewQuantity", this.viewColumns[2]);
            preferences.putBoolean("viewComment", this.viewColumns[3]);
            preferences.putBoolean("viewValidFrom", this.viewColumns[4]);
            preferences.putBoolean("viewValidTo", this.viewColumns[5]);
            this.objectChanged();
        }
    }

    class LocalDateRenderer
    extends DefaultTableCellRenderer {
        @Override
        public void setValue(Object object) {
            this.setText(object == null ? "" : ((LocalDate)object).format(SeedManager.this.dateFormatter));
        }
    }

    public class QuantityTextField
    extends AbstractCellEditor
    implements TableCellEditor {
        JPanel panel = new JPanel(new GridLayout());
        JTextField textQuantity = new JTextField();
        JComboBox<String> comboUnit = new JComboBox();

        public QuantityTextField() {
            for (String string : SeedList.getUnits()) {
                this.comboUnit.addItem(string);
            }
            this.comboUnit.setEditable(true);
            this.comboUnit.getEditor().getEditorComponent().setPreferredSize(new Dimension(1, 1));
            this.panel.add(this.textQuantity);
            this.panel.add(this.comboUnit);
        }

        @Override
        public boolean stopCellEditing() {
            try {
                if (!this.textQuantity.getText().isEmpty() && !this.textQuantity.getText().equals("0")) {
                    Double.parseDouble(this.textQuantity.getText());
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(null, "Invalid quantity " + this.textQuantity.getText());
                return false;
            }
            return super.stopCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            SeedList.Entry.Quantity quantity = null;
            try {
                if (!this.textQuantity.getText().isEmpty() && !this.textQuantity.getText().equals("0")) {
                    quantity = new SeedList.Entry.Quantity();
                    quantity.quantity = Double.parseDouble(this.textQuantity.getText());
                    quantity.unit = this.comboUnit.getEditor().getItem() == null ? "" : this.comboUnit.getEditor().getItem().toString();
                }
            }
            catch (NumberFormatException numberFormatException) {
                quantity = null;
            }
            return quantity;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            SeedList.Entry.Quantity quantity = (SeedList.Entry.Quantity)object;
            if (quantity != null) {
                this.textQuantity.setText(Double.toString(quantity.quantity));
                if (quantity.unit != null) {
                    this.comboUnit.setSelectedItem(quantity.unit);
                }
            } else {
                this.textQuantity.setText("");
                this.comboUnit.setSelectedItem("");
            }
            return this.panel;
        }
    }

    public class QuantityColumnRenderer
    extends DefaultTableCellRenderer {
        public QuantityColumnRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        protected void setValue(Object object) {
            SeedList.Entry.Quantity quantity = (SeedList.Entry.Quantity)object;
            if (quantity == null) {
                super.setValue(null);
            } else {
                super.setValue(Double.toString(quantity.quantity) + " " + quantity.unit);
            }
        }
    }

    public class PlantColumnRenderer
    extends PlantComponent
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public PlantColumnRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            SeedListTableModel seedListTableModel = (SeedListTableModel)jTable.getModel();
            if (n == seedListTableModel.getRowCount() - 1) {
                this.setIcon(null);
                this.setText(null);
                this.setToolTipText(null);
            } else {
                SeedList.Entry.PlantOrUnregistered plantOrUnregistered = (SeedList.Entry.PlantOrUnregistered)seedListTableModel.getValueAt(n, n2);
                if (plantOrUnregistered.plant != null) {
                    this.setPlant(plantOrUnregistered.plant);
                } else {
                    this.setIcon(null);
                    this.setText(plantOrUnregistered.unregisteredPlant);
                    this.setToolTipText(null);
                }
            }
            return this;
        }
    }

    public class SeedListTableModel
    extends AbstractTableModel
    implements SeedList.Listener {
        SeedList seedList;

        public SeedListTableModel(SeedList seedList) {
            this.seedList = seedList;
            seedList.addListener(this);
        }

        @Override
        public void viewChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public void listChanged() {
            this.fireTableDataChanged();
            SeedManager.this.loadValidFromDates();
        }

        @Override
        public int getRowCount() {
            return this.seedList.size() + 1;
        }

        @Override
        public int getColumnCount() {
            int n = 0;
            for (int i = 0; i < SeedManager.this.viewColumns.length; ++i) {
                if (!SeedManager.this.viewColumns[i]) continue;
                ++n;
            }
            return n;
        }

        public int convertColumn(int n) {
            int n2 = 0;
            while (n != 0 && ++n2 < SeedManager.this.viewColumns.length) {
                if (!SeedManager.this.viewColumns[n2]) continue;
                --n;
            }
            return n2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n == this.seedList.size()) {
                if (n2 == 0) {
                    return new SeedList.Entry.PlantOrUnregistered("");
                }
                return null;
            }
            SeedList.Entry entry = this.seedList.get(n);
            switch (this.convertColumn(n2)) {
                case 0: {
                    return entry.getPlant();
                }
                case 1: {
                    return entry.getVariety();
                }
                case 2: {
                    return entry.getQuantity();
                }
                case 3: {
                    return entry.getComment();
                }
                case 4: {
                    return entry.getValidFrom();
                }
                case 5: {
                    return entry.getValidTo();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            switch (this.convertColumn(n2)) {
                case 0: {
                    SeedList.Entry.PlantOrUnregistered plantOrUnregistered = (SeedList.Entry.PlantOrUnregistered)object;
                    if (plantOrUnregistered.plant != null) {
                        this.seedList.add(plantOrUnregistered.plant, SeedManager.this.workingDate);
                        break;
                    }
                    if (plantOrUnregistered.unregisteredPlant.isEmpty()) break;
                    this.seedList.add(plantOrUnregistered.unregisteredPlant, SeedManager.this.workingDate);
                    break;
                }
                case 1: {
                    SeedList.Entry entry = this.seedList.get(n);
                    this.seedList.setVariety(entry, object.toString(), SeedManager.this.workingDate);
                    break;
                }
                case 2: {
                    SeedList.Entry entry = this.seedList.get(n);
                    this.seedList.setQuantity(entry, (SeedList.Entry.Quantity)object, SeedManager.this.workingDate);
                    break;
                }
                case 3: {
                    SeedList.Entry entry = this.seedList.get(n);
                    this.seedList.setComment(entry, object.toString(), SeedManager.this.workingDate);
                }
            }
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int n) {
            Translation translation = Translation.getPreferred();
            switch (this.convertColumn(n)) {
                case 0: {
                    return translation.name();
                }
                case 1: {
                    return translation.variety();
                }
                case 2: {
                    return translation.quantity();
                }
                case 3: {
                    return translation.comment();
                }
                case 4: {
                    return translation.valid_from();
                }
                case 5: {
                    return translation.valid_to();
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (this.convertColumn(n)) {
                case 0: {
                    return SeedList.Entry.PlantOrUnregistered.class;
                }
                case 1: 
                case 3: {
                    return String.class;
                }
                case 2: {
                    return SeedList.Entry.Quantity.class;
                }
                case 4: 
                case 5: {
                    return LocalDate.class;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n < this.seedList.size()) {
                n2 = this.convertColumn(n2);
                SeedList.Entry entry = this.seedList.get(n);
                if (n2 == 1 && entry.getValidFrom().equals(SeedManager.this.workingDate)) {
                    return true;
                }
                if (n2 == 2) {
                    return true;
                }
                if (n2 == 3 && entry.getValidFrom().equals(SeedManager.this.workingDate)) {
                    return true;
                }
            } else if (n == this.seedList.size() && n2 == 0) {
                return true;
            }
            return false;
        }
    }
}

