/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.PlantComparatorByName;
import org.sourceforge.kga.PlantList;
import org.sourceforge.kga.TagList;
import org.sourceforge.kga.TagListener;
import org.sourceforge.kga.gui.desktop.Gui;
import org.sourceforge.kga.gui.desktop.PlantLabel;
import org.sourceforge.kga.gui.desktop.TagItem;
import org.sourceforge.kga.gui.desktop.actions.EditTag;
import org.sourceforge.kga.gui.desktop.actions.KgaAction;
import org.sourceforge.kga.plant.Tag;
import org.sourceforge.kga.translation.Translation;

public class Tags
extends KgaAction
implements ActionListener,
ListSelectionListener {
    private static Logger log = Logger.getLogger(PlantList.class.getName());
    private static final long serialVersionUID = 1L;
    private static final int speciesPanelWidth = PlantLabel.getDefaultSize().width * 8;
    private static final int SPECIES_PER_ROW = 7;
    private static final int SPECIES_PER_COLUMN = 4;
    JDialog tagsDialog;
    JList<TagItem> tagsList;
    JPanel panelSpecies;
    JButton buttonAdd = new JButton(Translation.getPreferred().add());
    JButton buttonRemove = new JButton(Translation.getPreferred().remove());
    JButton buttonModify = new JButton(Translation.getPreferred().modify());
    EditTag editTag = new EditTag(this.getGui());

    public Tags(Gui gui) {
        super(gui, Translation.getPreferred().action_tags());
        this.buttonAdd.addActionListener(this);
        this.buttonModify.addActionListener(this);
        this.buttonRemove.addActionListener(this);
    }

    private void buttonAddAction(ActionEvent actionEvent) {
        this.editTag.editTag(null);
        if (this.editTag.getTag() != null) {
            TagList.getInstance().addTag(this.editTag.getTag());
            TagListModel tagListModel = new TagListModel();
            this.tagsList.setModel(tagListModel);
            this.tagsList.setSelectedValue(tagListModel.find(this.editTag.getTag()), true);
        }
    }

    private void buttonModifyAction(ActionEvent actionEvent) {
        TagItem tagItem = this.tagsList.getSelectedValue();
        if (tagItem != null) {
            Tag tag = tagItem.tag;
            this.editTag.editTag(tag);
            if (this.editTag.getTag() != null) {
                TagListModel tagListModel = new TagListModel();
                TagList.getInstance().changeTag(tag, this.editTag.getTag().getName(), this.editTag.getTag().getSpecies());
                this.tagsList.setModel(tagListModel);
                this.tagsList.setSelectedValue(tagListModel.find(tag), true);
            }
        }
    }

    private void buttonRemoveAction(ActionEvent actionEvent) {
        TagItem tagItem = this.tagsList.getSelectedValue();
        if (tagItem != null) {
            Tag tag = tagItem.tag;
            Translation translation = Translation.getPreferred();
            if (JOptionPane.showConfirmDialog(null, translation.tag_delete_confirmation(), translation.tag_delete(), 0) == 0) {
                int n;
                TagListModel tagListModel = new TagListModel();
                TagList.getInstance().deleteTag(tag);
                this.tagsList.setModel(tagListModel);
                for (n = this.tagsList.getSelectedIndex(); n >= tagListModel.getSize(); --n) {
                }
                if (n >= 0) {
                    this.tagsList.setSelectedIndex(n);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.buttonAdd) {
            this.buttonAddAction(actionEvent);
            return;
        }
        if (actionEvent.getSource() == this.buttonModify) {
            this.buttonModifyAction(actionEvent);
            return;
        }
        if (actionEvent.getSource() == this.buttonRemove) {
            this.buttonRemoveAction(actionEvent);
            return;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        TagListModel tagListModel = new TagListModel();
        this.tagsList = new JList<TagItem>(tagListModel);
        this.tagsList.setSelectionMode(0);
        this.tagsList.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.tagsList);
        jScrollPane.setPreferredSize(new Dimension(speciesPanelWidth / 3, PlantLabel.getDefaultSize().height * 4));
        jPanel.add((Component)jScrollPane, "West");
        this.panelSpecies = new JPanel();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.panelSpecies, "North");
        JScrollPane jScrollPane2 = new JScrollPane(jPanel2);
        jScrollPane2.setBorder(null);
        jScrollPane2.setViewportBorder(null);
        jScrollPane2.getVerticalScrollBar().setUnitIncrement(8);
        jScrollPane2.getViewport().setPreferredSize(new Dimension(speciesPanelWidth, PlantLabel.getDefaultSize().height * 4));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1));
        jPanel3.setBorder(PlantLabel.defaultBorder);
        jPanel3.add((Component)jScrollPane2, "Center");
        jPanel.add(jPanel3);
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/gui/seedManager");
        String string = preferences.get("lastSelectedTag", "");
        int n = 0;
        for (int i = 0; i < tagListModel.getSize(); ++i) {
            if (tagListModel.getElementAt((int)i).tag.getName().compareTo(string) != 0) continue;
            n = i;
            break;
        }
        if (this.tagsList.getModel().getSize() > 0) {
            this.tagsList.setSelectedIndex(n);
        }
        this.tagsDialog = new JOptionPane(jPanel, -1, 0, null, new JButton[]{this.buttonAdd, this.buttonModify, this.buttonRemove}).createDialog(Translation.getPreferred().action_tags());
        Gui.makeWindowBoundsPersistent(this.tagsDialog, "Tags", false);
        this.tagsDialog.setVisible(true);
        preferences.put("lastSelectedTag", this.tagsList.getSelectedValue().tag.getName());
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.panelSpecies.removeAll();
        boolean bl = this.tagsList.getSelectedIndex() != -1;
        this.buttonRemove.setEnabled(bl);
        this.buttonModify.setEnabled(bl);
        int n = 0;
        if (bl) {
            Tag tag = this.tagsList.getSelectedValue().tag;
            TreeSet<Plant> treeSet = new TreeSet<Plant>(new PlantComparatorByName());
            treeSet.addAll(tag.getSpecies());
            for (Plant plant : treeSet) {
                PlantLabel plantLabel = new PlantLabel(plant);
                n = Math.max(n, plantLabel.getComputedWidth());
                this.panelSpecies.add(plantLabel);
            }
        }
        int n2 = 7;
        while (n2 * n > speciesPanelWidth) {
            --n2;
        }
        this.panelSpecies.setLayout(new GridLayout(0, n2));
        this.panelSpecies.revalidate();
        this.panelSpecies.repaint();
    }

    class TagListModel
    extends AbstractListModel<TagItem>
    implements TagListener {
        ArrayList<TagItem> tags;

        public TagListModel() {
            TagList.getInstance().addListener(this);
            this.tagChanged(null);
        }

        @Override
        public int getSize() {
            return TagList.getInstance().getTags().size();
        }

        @Override
        public TagItem getElementAt(int n) {
            return this.tags.get(n);
        }

        TagItem find(Tag tag) {
            for (TagItem tagItem : this.tags) {
                if (tagItem.tag != tag) continue;
                return tagItem;
            }
            return null;
        }

        @Override
        public void tagAdded(Tag tag) {
            this.tagChanged(tag);
        }

        @Override
        public void tagDeleted(Tag tag) {
            this.tagChanged(tag);
        }

        @Override
        public void tagChanged(Tag tag) {
            this.tags = new ArrayList();
            for (Tag tag2 : TagList.getInstance().getTags()) {
                this.tags.add(new TagItem(tag2));
            }
            Collections.sort(this.tags, new Comparator<TagItem>(){

                @Override
                public int compare(TagItem tagItem, TagItem tagItem2) {
                    Translation translation = Translation.getPreferred();
                    return translation.getCollator().compare(tagItem.tag.getName(), tagItem2.tag.getName());
                }
            });
        }
    }
}

