/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop.actions.importData;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.PlantList;
import org.sourceforge.kga.gui.desktop.Gui;
import org.sourceforge.kga.gui.desktop.actions.KgaAction;
import org.sourceforge.kga.gui.desktop.actions.importData.CsvParser;
import org.sourceforge.kga.gui.desktop.actions.importData.CsvRenderer;
import org.sourceforge.kga.gui.desktop.actions.importData.SearchAndReplace;
import org.sourceforge.kga.gui.desktop.actions.importData.TagTableModel;
import org.sourceforge.kga.translation.Translation;

public class ImportCsv
extends KgaAction
implements ListSelectionListener {
    Translation t = Translation.getPreferred();
    private static Logger log = Logger.getLogger(Garden.class.getName());
    JDialog dialog = null;
    SearchAndReplace searchAndReplace;
    JTable tableSources = new JTable();
    JTable tableTags = new JTable();
    JTable tableTaggedPlants = new JTable();
    JTable tableData = new JTable();
    File currentFile;
    CsvParser csv;
    JButton buttonSearch = new JButton(Translation.getPreferred().search());
    JButton buttonOpen = new JButton(Translation.getPreferred().action_open());
    JButton buttonSave = new JButton(Translation.getPreferred().action_save());
    JButton buttonImportCsv = new JButton(Translation.getPreferred().import_csv());
    JButton buttonImportAll = new JButton("Import all");

    public ImportCsv(Gui gui) {
        super(gui, Translation.getPreferred().import_csv());
        this.buttonSave.addActionListener(this);
        this.buttonImportCsv.addActionListener(this);
        this.buttonSearch.addActionListener(this);
        this.buttonOpen.addActionListener(this);
        this.buttonImportAll.addActionListener(this);
        this.searchAndReplace = new SearchAndReplace(this.tableData);
    }

    private void buttonOpenAction() {
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/gui");
        String string = preferences.get("lastPathImportCsv", "");
        log.info("lastPath=" + string);
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setFileFilter(new FileNameExtensionFilter("CSV", "csv"));
        jFileChooser.setFileFilter(new FileNameExtensionFilter("TXT", "txt"));
        if (jFileChooser.showOpenDialog(this.dialog) != 0) {
            return;
        }
        this.currentFile = jFileChooser.getSelectedFile();
        preferences.put("lastPathImportCsv", this.currentFile.getParent());
        this.loadCsvFile(this.currentFile);
    }

    private void loadCsvFile(File file) {
        this.currentFile = file;
        this.csv = new CsvParser();
        try {
            this.csv.loadFile(this.currentFile);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.toString());
            return;
        }
        this.tableData.setModel(this.csv.getDataTableModel());
        this.tableData.setDefaultRenderer(String.class, new CsvRenderer(this.csv));
        this.tableSources.setModel(this.csv.getSourceTableModel());
        this.tableTags.setModel(this.csv.getTagTableModel());
        this.tableTags.getSelectionModel().addListSelectionListener(this);
        this.tableTaggedPlants.setModel(this.csv.getTaggedPlantsTableModel());
    }

    private void buttonSearchAction() {
        JDialog jDialog = this.searchAndReplace.getDialog();
        Gui.makeWindowBoundsPersistent(jDialog, this.t.import_csv(), false);
        jDialog.setVisible(true);
    }

    private void buttonSaveAction() {
        JFileChooser jFileChooser = new JFileChooser(this.currentFile);
        jFileChooser.setFileFilter(new FileNameExtensionFilter("CSV", "csv"));
        jFileChooser.setFileFilter(new FileNameExtensionFilter("TXT", "txt"));
        jFileChooser.setSelectedFile(this.currentFile);
        if (jFileChooser.showSaveDialog(this.dialog) != 0) {
            return;
        }
        this.csv.save(jFileChooser.getSelectedFile());
    }

    private void displayErrors(StringBuilder stringBuilder) {
        if (stringBuilder.length() == 0) {
            return;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String object2 : stringBuilder.toString().split("\n")) {
            treeSet.add(object2);
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        for (String string : treeSet) {
            stringBuilder2.append(string).append("\n");
        }
        JTextArea jTextArea = new JTextArea(stringBuilder2.toString());
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        JDialog jDialog = new JOptionPane(jScrollPane).createDialog(this.t.error_saving_file());
        jDialog.setSize(400, 500);
        jDialog.setVisible(true);
    }

    private void buttonImportAction() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.csv != null) {
            this.csv.importData(stringBuilder);
        }
        this.displayErrors(stringBuilder);
        this.buttonSaveSpeciesAction();
    }

    private void buttonImportAllAction() {
        StringBuilder stringBuilder = new StringBuilder();
        this.loadCsvFile(new File("d:\\tmp\\kga\\resources\\import\\companions1.txt"));
        this.csv.importData(stringBuilder);
        this.loadCsvFile(new File("d:\\tmp\\kga\\resources\\import\\companions2.txt"));
        this.csv.importData(stringBuilder);
        this.loadCsvFile(new File("d:\\tmp\\kga\\resources\\import\\companions3.txt"));
        this.csv.importData(stringBuilder);
        this.loadCsvFile(new File("d:\\tmp\\kga\\resources\\import\\companions4.txt"));
        this.csv.importData(stringBuilder);
        this.loadCsvFile(new File("d:\\tmp\\kga\\resources\\import\\companions5.txt"));
        this.csv.importData(stringBuilder);
        this.loadCsvFile(new File("d:\\tmp\\kga\\resources\\import\\companions6.txt"));
        this.csv.importData(stringBuilder);
        this.buttonSaveSpeciesAction();
        for (Plant plant : PlantList.getResources().getPlants()) {
            plant.getCompanions().logConflicts(stringBuilder);
        }
        this.displayErrors(stringBuilder);
    }

    private void buttonSaveSpeciesAction() {
        Preferences preferences = Preferences.userRoot().node("/org/sourceforge/kga/gui");
        String string = preferences.get("lastSpeciesFilePath", "");
        JFileChooser jFileChooser = new JFileChooser(string);
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Species", "xml");
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        if (jFileChooser.showSaveDialog(this.getGui()) != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (!file.getName().endsWith(".xml")) {
            file = new File(file.getParent() + "/" + file.getName() + ".xml");
        }
        preferences.put("lastSpeciesFilePath", file.getParent());
        log.info("Set last path to  " + file.getParent());
        try {
            PlantList.serializableSpecies.saveToFile(file);
        }
        catch (Exception exception) {
            Translation translation = Translation.getPreferred();
            JOptionPane.showMessageDialog(this.getGui(), exception.toString(), translation.error_saving_file(), 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2 = object = actionEvent == null ? null : actionEvent.getSource();
        if (object == this.buttonOpen) {
            this.buttonOpenAction();
            return;
        }
        if (object == this.buttonSearch) {
            this.buttonSearchAction();
            return;
        }
        if (object == this.buttonSave) {
            this.buttonSaveAction();
            return;
        }
        if (object == this.buttonImportCsv) {
            this.buttonImportAction();
            return;
        }
        if (object == this.buttonImportAll) {
            this.buttonImportAllAction();
            return;
        }
        JScrollPane jScrollPane = new JScrollPane(this.tableSources);
        JScrollPane jScrollPane2 = new JScrollPane(this.tableTags);
        JScrollPane jScrollPane3 = new JScrollPane(this.tableTaggedPlants);
        JScrollPane jScrollPane4 = new JScrollPane(this.tableData);
        jScrollPane.setPreferredSize(new Dimension(0, 100));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.setPreferredSize(new Dimension(0, 100));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        jPanel2.setPreferredSize(new Dimension(700, 550));
        jPanel2.add(jScrollPane);
        jPanel.add(jScrollPane2);
        jPanel.add(jScrollPane3);
        jPanel2.add(jPanel);
        jPanel2.add(jScrollPane4);
        this.dialog = new JOptionPane(jPanel2, -1, 0, null, new JButton[]{this.buttonImportAll, this.buttonImportCsv, this.buttonSave, this.buttonOpen, this.buttonSearch}).createDialog(this.t.import_csv());
        Gui.makeWindowBoundsPersistent(this.dialog, this.t.import_csv(), false);
        this.dialog.setVisible(true);
        this.getGui().resetGui();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = 0;
        int n2 = 0;
        if (this.tableTags.getSelectionModel() == null || this.tableTags.getColumnModel().getSelectionModel() == null) {
            return;
        }
        n = this.tableTags.getSelectionModel().getLeadSelectionIndex();
        n2 = this.tableTags.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        TagTableModel tagTableModel = this.csv.getTagTableModel();
        if (n < 0 || n > tagTableModel.getRowCount() || n2 < 0 || n2 > tagTableModel.getColumnCount()) {
            return;
        }
        String string = (String)tagTableModel.getValueAt(n, n2);
        log.info("Tag selected: " + string);
        this.csv.getTaggedPlantsTableModel().setTag(string);
    }
}

