/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.gui.desktop.actions.importData;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.sourceforge.kga.gui.desktop.actions.importData.DataTableModel;
import org.sourceforge.kga.translation.Translation;

public class SearchAndReplace
implements DocumentListener,
ActionListener,
ListSelectionListener {
    Translation t = Translation.getPreferred();
    DataTableModel csvModel;
    JButton buttonSearchNext = new JButton(this.t.search());
    JButton buttonReplace = new JButton(this.t.replace());
    JButton buttonReplaceAll = new JButton(this.t.replace_all());
    JCheckBox checkSearchWholeText = new JCheckBox(this.t.search_whole_text());
    JCheckBox checkSearchCaseInsensitive = new JCheckBox(this.t.search_case_insensitive());
    JCheckBox checkSearchReverse = new JCheckBox(this.t.search_direction_reverse());
    JCheckBox checkSearchByColumn = new JCheckBox(this.t.search_direction_by_column());
    JTextField textSearch = new JTextField();
    JTextField textReplace = new JTextField();
    JTable table;
    JDialog searchDialog;

    public SearchAndReplace(JTable jTable) {
        this.table = jTable;
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(this.t.search());
        JLabel jLabel2 = new JLabel(this.t.replace());
        this.buttonSearchNext.addActionListener(this);
        this.buttonReplace.addActionListener(this);
        this.buttonReplaceAll.addActionListener(this);
        this.buttonReplace.setEnabled(false);
        this.textSearch.getDocument().addDocumentListener(this);
        this.checkSearchWholeText.addActionListener(this);
        this.checkSearchCaseInsensitive.addActionListener(this);
        jTable.getSelectionModel().addListSelectionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.textSearch, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.textReplace, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.checkSearchWholeText, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.checkSearchCaseInsensitive, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.checkSearchReverse, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        jPanel.add((Component)this.checkSearchByColumn, gridBagConstraints);
        this.searchDialog = new JOptionPane(jPanel, -1, 0, null, new JButton[]{this.buttonSearchNext, this.buttonReplace, this.buttonReplaceAll}).createDialog(this.t.search());
    }

    public JDialog getDialog() {
        this.csvModel = (DataTableModel)this.table.getModel();
        return this.searchDialog;
    }

    private void checkReplaceButton() {
        if (this.csvModel == null || this.textSearch.getText().isEmpty()) {
            this.buttonReplace.setEnabled(false);
            return;
        }
        int n = 0;
        int n2 = 0;
        if (this.table.getSelectionModel() != null && this.table.getColumnModel().getSelectionModel() != null) {
            n = this.table.getSelectionModel().getLeadSelectionIndex();
            n2 = this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (n < 0 || n > this.csvModel.getRowCount() || n2 < 0 || n2 > this.csvModel.getColumnCount()) {
                this.buttonReplace.setEnabled(false);
                return;
            }
            this.buttonReplace.setEnabled(this.checkValue((String)this.csvModel.getValueAt(n, n2), this.textSearch.getText()) != -1);
        }
    }

    int checkValue(String string, String string2) {
        if (this.checkSearchCaseInsensitive.isSelected()) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        if (this.checkSearchWholeText.isSelected()) {
            return string.compareTo(string2) == 0 ? 0 : -1;
        }
        return string.indexOf(string2);
    }

    boolean searchNextCell() {
        if (this.csvModel == null) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        if (this.table.getSelectionModel() != null && this.table.getColumnModel().getSelectionModel() != null) {
            n = this.table.getSelectionModel().getLeadSelectionIndex();
            n2 = this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (n < 0 || n > this.csvModel.getRowCount()) {
                n = 0;
            }
            if (n2 < 0 || n2 > this.csvModel.getColumnCount()) {
                n2 = 0;
            }
        }
        int n3 = n;
        int n4 = n2;
        do {
            if (this.checkSearchReverse.isSelected()) {
                if (this.checkSearchByColumn.isSelected()) {
                    if (--n3 < 0) {
                        n3 = this.csvModel.getRowCount() - 1;
                        if (--n4 < 0) {
                            n4 = this.csvModel.getColumnCount() - 1;
                        }
                    }
                } else if (--n4 < 0) {
                    n4 = this.csvModel.getColumnCount() - 1;
                    if (--n3 < 0) {
                        n3 = this.csvModel.getRowCount() - 1;
                    }
                }
            } else if (this.checkSearchByColumn.isSelected()) {
                if (++n3 >= this.csvModel.getRowCount()) {
                    n3 = 0;
                    if (++n4 >= this.csvModel.getColumnCount()) {
                        n4 = 0;
                    }
                }
            } else if (++n4 >= this.csvModel.getColumnCount()) {
                n4 = 0;
                if (++n3 >= this.csvModel.getRowCount()) {
                    n3 = 0;
                }
            }
            if (this.checkValue((String)this.csvModel.getValueAt(n3, n4), this.textSearch.getText()) == -1) continue;
            this.table.changeSelection(n3, n4, false, false);
            return true;
        } while (n3 != n || n4 != n2);
        return false;
    }

    private void replaceValueAt(int n, int n2) {
        String string = (String)this.csvModel.getValueAt(n, n2);
        int n3 = this.checkValue(string, this.textSearch.getText());
        if (n3 != -1) {
            String string2 = string.substring(0, n3) + this.textReplace.getText() + string.substring(n3 + this.textSearch.getText().length());
            this.csvModel.setValueAt(string2, n, n2);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2 = object = actionEvent == null ? null : actionEvent.getSource();
        if (object == this.buttonSearchNext) {
            if (!this.searchNextCell()) {
                JOptionPane.showMessageDialog(null, Translation.getPreferred().nothing_found());
            }
        } else if (object == this.buttonReplace) {
            int n = this.table.getSelectionModel().getLeadSelectionIndex();
            int n2 = this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            this.replaceValueAt(n, n2);
            if (!this.searchNextCell()) {
                JOptionPane.showMessageDialog(null, Translation.getPreferred().nothing_found());
            }
        } else if (object == this.buttonReplaceAll) {
            for (int i = 0; i < this.csvModel.getRowCount(); ++i) {
                for (int j = 0; j < this.csvModel.getColumnCount(); ++j) {
                    this.replaceValueAt(i, j);
                }
            }
        } else if (object == this.textSearch || object == this.checkSearchWholeText || object == this.checkSearchCaseInsensitive) {
            this.valueChanged(null);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.checkReplaceButton();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkReplaceButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkReplaceButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkReplaceButton();
    }
}

