/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.PlantList;
import org.sourceforge.kga.Point;
import org.sourceforge.kga.io.GardenFormat;
import org.sourceforge.kga.io.InvalidFormatException;

class GardenFormatV1
implements GardenFormat {
    private static Logger log = Logger.getLogger(Garden.class.getName());
    private static final int FIELD_START = 438351867;
    private static final int FIELD_SQUARE = 869725394;
    private static final int FIELD_ADDRESS = 495410209;
    private static final int KGA_FILE_VERSION = 1;

    GardenFormatV1() {
    }

    @Override
    public void load(Garden garden, InputStream inputStream) throws IOException, InvalidFormatException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        if (dataInputStream.readInt() != 438351867) {
            throw new InvalidFormatException();
        }
        if (dataInputStream.readInt() != 1) {
            throw new InvalidFormatException();
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4;
            try {
                n4 = dataInputStream.readInt();
            }
            catch (EOFException eOFException) {
                log.info("Reading complete");
                break;
            }
            if (n4 == 869725394) {
                n = dataInputStream.readInt();
                n2 = dataInputStream.readInt();
                n3 = dataInputStream.readInt();
                continue;
            }
            if (n4 != 495410209) continue;
            int n5 = dataInputStream.readInt();
            if (n5 == 117 || n5 == 119) {
                n5 = 116;
            }
            garden.addPlant(n, new Point(n2, n3), PlantList.getResources().getPlant(n5));
        }
        log.info("Garden loaded");
    }

    @Override
    public void save(Garden garden, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(438351867);
        dataOutputStream.writeInt(1);
        for (Map.Entry<Integer, HashMap<Point, List<Plant>>> entry : garden.getAllSquares().entrySet()) {
            for (Map.Entry<Point, List<Plant>> entry2 : entry.getValue().entrySet()) {
                if (entry2.getValue().size() == 0) continue;
                dataOutputStream.writeInt(869725394);
                dataOutputStream.writeInt(entry.getKey());
                dataOutputStream.writeInt(entry2.getKey().x);
                dataOutputStream.writeInt(entry2.getKey().y);
                for (Plant plant : entry2.getValue()) {
                    dataOutputStream.writeInt(495410209);
                    dataOutputStream.writeInt(plant.getId());
                }
            }
        }
    }
}

