/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.kga.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.sourceforge.kga.Garden;
import org.sourceforge.kga.Plant;
import org.sourceforge.kga.PlantList;
import org.sourceforge.kga.Point;
import org.sourceforge.kga.Taxon;
import org.sourceforge.kga.io.GardenFormat;
import org.sourceforge.kga.io.InvalidFormatException;
import org.sourceforge.kga.wrappers.XmlException;
import org.sourceforge.kga.wrappers.XmlReader;
import org.sourceforge.kga.wrappers.XmlWriter;

public class GardenFormatXmlV2
implements GardenFormat {
    private static Logger log = Logger.getLogger(Garden.class.getName());
    private static final int KGA_FILE_VERSION = 2;
    public static final String namespace = "org:sourceforge:kga:garden";

    @Override
    public void load(Garden garden, InputStream inputStream) throws IOException, InvalidFormatException {
        try {
            int n;
            XmlReader xmlReader = new XmlReader(inputStream);
            while (xmlReader.hasNext() && xmlReader.next() != 1) {
            }
            if (xmlReader.getLocalName().compareTo("garden") != 0) {
                throw new InvalidFormatException();
            }
            String string = xmlReader.getAttributeValue("", "version");
            if (Integer.parseInt(string) != 2) {
                throw new InvalidFormatException();
            }
            int n2 = 0;
            int n3 = 0;
            while (xmlReader.hasNext() && (n = xmlReader.next()) != 8) {
                String string2;
                if (n == 1) {
                    ++n3;
                } else if (n == 2) {
                    --n3;
                }
                if (n == 2 && xmlReader.getLocalName().compareTo("year") == 0 && n3 == 1) {
                    n2 = 0;
                    continue;
                }
                if (n != 1) continue;
                if (n3 == 1 && xmlReader.getLocalName().compareTo("year") == 0) {
                    n2 = Integer.parseInt(xmlReader.getAttributeValue("", "value"));
                    continue;
                }
                if (n2 == 0 || n3 != 2) continue;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                if (xmlReader.getLocalName().compareTo("rectangle") == 0) {
                    n4 = Integer.parseInt(xmlReader.getAttributeValue("", "x"));
                    n5 = Integer.parseInt(xmlReader.getAttributeValue("", "y"));
                    n6 = Integer.parseInt(xmlReader.getAttributeValue("", "w"));
                    n7 = Integer.parseInt(xmlReader.getAttributeValue("", "h"));
                } else {
                    if (xmlReader.getLocalName().compareTo("cell") != 0) continue;
                    n4 = Integer.parseInt(xmlReader.getAttributeValue("", "x"));
                    n5 = Integer.parseInt(xmlReader.getAttributeValue("", "y"));
                    n6 = 1;
                    n7 = 1;
                }
                if ((string2 = xmlReader.getAttributeValue("", "species")).length() == 0) continue;
                for (String string3 : string2.split(";")) {
                    for (int i = 0; i < n6; ++i) {
                        for (int j = 0; j < n7; ++j) {
                            int n8 = Integer.parseInt(string3);
                            Point point = new Point(n4 + i, n5 + j);
                            garden.addPlant(n2, point, PlantList.getResources().getPlant(n8));
                        }
                    }
                }
            }
        }
        catch (XmlException xmlException) {
            throw new IOException(xmlException);
        }
        log.info("Garden loaded");
    }

    boolean equalPlantList(List<Plant> list, List<Plant> list2) {
        if (list == null || list2 == null) {
            return false;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        for (Plant plant : list) {
            if (list2.contains(plant)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void save(Garden garden, DataOutputStream dataOutputStream) throws IOException {
        try {
            XmlWriter xmlWriter = new XmlWriter(dataOutputStream, "UTF-8", "1.0");
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeStartElement("garden");
            xmlWriter.setDefaultNamespace(namespace);
            xmlWriter.writeDefaultNamespace(namespace);
            xmlWriter.writeAttribute("version", Integer.toString(2));
            for (Integer n : garden.getAllSquares().keySet()) {
                xmlWriter.writeCharacters("\n    ");
                xmlWriter.writeStartElement("year");
                xmlWriter.writeAttribute("value", n.toString());
                TreeSet<Point> treeSet = new TreeSet<Point>(new Comparator<Point>(){

                    @Override
                    public int compare(Point point, Point point2) {
                        if (point.y < point2.y) {
                            return -1;
                        }
                        if (point.y > point2.y) {
                            return 1;
                        }
                        return point.x < point2.x ? -1 : (point.x > point2.x ? 1 : 0);
                    }
                });
                treeSet.addAll(garden.getAllSquares().get(n).keySet());
                while (!treeSet.isEmpty()) {
                    Object object;
                    Object object2;
                    Object object3;
                    Point point = treeSet.pollFirst();
                    List<Plant> list = garden.getPlants(n, point);
                    treeSet.remove(point);
                    int n2 = 1;
                    int n3 = 1;
                    while (treeSet.contains(object3 = new Point(point.x + n2, point.y)) && this.equalPlantList((List<Plant>)(object2 = garden.getPlants(n, (Point)object3)), list)) {
                        treeSet.remove(object3);
                        ++n2;
                    }
                    while (true) {
                        int n4;
                        boolean bl = true;
                        for (n4 = 0; n4 < n2; ++n4) {
                            object = new Point(point.x + n4, point.y + n3);
                            if (!treeSet.contains(object)) {
                                bl = false;
                                break;
                            }
                            List<Plant> list2 = garden.getPlants(n, (Point)object);
                            if (this.equalPlantList(list2, list)) continue;
                            bl = false;
                            break;
                        }
                        if (!bl) break;
                        for (n4 = 0; n4 < n2; ++n4) {
                            treeSet.remove(new Point(point.x + n4, point.y + n3));
                        }
                        ++n3;
                    }
                    object3 = new StringBuilder();
                    object2 = list.iterator();
                    while (object2.hasNext()) {
                        object = (Plant)object2.next();
                        if (((StringBuilder)object3).length() != 0) {
                            ((StringBuilder)object3).append(";");
                        }
                        ((StringBuilder)object3).append(((Taxon)object).getId());
                    }
                    if (((StringBuilder)object3).length() == 0) continue;
                    xmlWriter.writeCharacters("\n        ");
                    if (n2 == 1 && n3 == 1) {
                        xmlWriter.writeEmptyElement("cell");
                    } else {
                        xmlWriter.writeEmptyElement("rectangle");
                    }
                    xmlWriter.writeAttribute("x", Integer.toString(point.x));
                    xmlWriter.writeAttribute("y", Integer.toString(point.y));
                    if (n2 != 1 || n3 != 1) {
                        xmlWriter.writeAttribute("w", Integer.toString(n2));
                        xmlWriter.writeAttribute("h", Integer.toString(n3));
                    }
                    xmlWriter.writeAttribute("species", ((StringBuilder)object3).toString());
                }
                xmlWriter.writeCharacters("\n    ");
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeEndElement();
            xmlWriter.flush();
            xmlWriter.close();
        }
        catch (XmlException xmlException) {
            throw new IOException(xmlException);
        }
    }
}

